{

              
            
               ͻ ͻ ͻ    ͻ ͻ
                    ˼ ͹ ͼ ͹     ͻ
                   ͼ          ͼ ͼ  v1.14

  The Universal Multimedia Interface For BBS Software
  Copyright 1995-1997 * Larry L. Athey * BBS Utiliteez Software


  Information Regarding MAX Graphics:
  
  Notice is hereby given that the MAXscript/MAXcontrol/MAXcolor language,
  and MAXterm are products of BBS Utiliteez Software and are protected by
  US copyrights listed with the US Library Of Congress (1996)....

  No changes, additions, subtractions, or other modifications shall be made
  to MAXscript/MAXcontrol/MAXcolor language or the MAX Graphics development
  kit without express written permission from Larry L. Athey, BBS Utiliteez
  Software, Alliance, Nebraska, USA....

  The MAXscript/MAXcontrol/MAXcolor language may be used in any BBS or Door
  software 100% royalty free. You are also allowed to implement full local
  graphics viewing in any BBS or Door software 100% royalty free. However,
  any program that uses the MAXscript/MAXcontrol/MAXcolor language *MUST*
  bear the MAX Graphics/BBS Utiliteez Software copyright notice....


  Example: MAX Graphics and the MAXscript/MAXcontrol/MAXcolor language is
           Copyright 1995-1997 * Larry L. Athey * BBS Utiliteez Software



  This is the main graphics interface unit. This unit requires you to have
  a copy of the ULTRABGI.ZIP development kit installed in your Pascal BGI
  utilities directory. This unit is required for displaying MAX graphics
  locally in any MAX compatible door/utility you write. Some procedures
  in here may be what you consider to be redundant, but they are in here
  mainly for ease of use. It's easier to call one command rather than a
  whole bunch of them isn't it?                                               }

{$A+,B-,D+,E+,F+,G+,I-,L+,N-,O+,P-,Q-,R-,S-,T-,V+,X+}
UNIT SVGAUNIT;

INTERFACE

USES _EXIT;

{----------------------------------------------------------------------------}
TYPE SVGA_Color_Scheme = RECORD {Record for the SVGA color scheme.           }
     Win1Back,                  {Window type 1 background.                   }
     Win4Back,                  {Window type 4 background.                   }
     Win1High,                  {Window type 1 highlight.                    }
     Win4High,                  {Window type 4 highlight.                    }
     Win1Low,                   {Window type 1 lowlight.                     }
     Win4Low,                   {Window type 4 lowlight.                     }
     Win1Frame1,                {Window type 1 frame high.                   }
     Win1Frame2,                {Window type 1 frame low.                    }
     Win4Frame,                 {Window type 4 frame.                        }
     ActiveHdr,                 {Color for active window headers.            }
     InactiveHdr,               {Color for inactive window headers.          }
     HdrTitle,                  {Window header title color.                  }
     ButtonFrame,               {Button frame color.                         }
     ButtonFace,                {Button background.                          }
     ButtonHigh,                {Button highlight.                           }
     ButtonLow,                 {Button lowlight.                            }
     ButtonHot,                 {Button hotkey color.                        }
     ButtonText,                {Button title color.                         }
     FrameLow,                  {Frame lowlight.                             }
     FrameHigh,                 {Frame highlight.                            }
     BoxBack,                   {Raised/Lowered box background.              }
     BoxHigh,                   {Raised/Lowered box highlight.               }
     BoxLow,                    {Raised/Lowered box lowlight.                }
     FieldTextHigh,             {Active entry field text color.              }
     FieldTextLow,              {Inactive entry field text color.            }
     FieldBack,                 {Entry field background.                     }
     FieldHigh,                 {Active entry field highlight.               }
     FieldFrame,                {Frame color of all entry fields.            }
     QuoteColor,                {Color for BBS message quotes.               }
     MsgColor,                  {Color for BBS message text.                 }
     TearColor,                 {Color for BBS message tear lines.           }
     FlagColor,                 {Color for BBS message flags.                }
     MsgIDcolor,                {Color for BBS message ID info.              }
     TextBack,                  {Background color for reader/editor/picklist.}
     PickHighBack,              {Picklist item highlight background color.   }
     PickHighFore,              {Picklist item highlight foreground color.   }
     ScreenColor : BYTE;        {Screen background color.                    }
     END;
{----------------------------------------------------------------------------}
TYPE WindowRecord = RECORD      {Record for window settings.                 }
     WindowSize   : BYTE;       {The window size in Bytes.                   }
     X1,Y1,X2,Y2  : WORD;       {Window coordinates.                         }
     WType        : BYTE;       {Window type.                                }
     SType        : BYTE;       {Window save method.                         }
     Title        : STRING;     {Window title.                               }
     END;
{----------------------------------------------------------------------------}
TYPE ButtonRecord = RECORD      {Record for button settings.                 }
     ButtonType   : BYTE;       {1-Standard, 2-Radio, 3-Click Zone, 4-User   }
     X,Y,Width    : WORD;       {Button X/Y coordinates and width.           }
     Height       : WORD;       {Button height in pixels                     }
     Title        : STRING[30]; {Button title.                               }
     Return       : BYTE;       {Return code (ie: Ordinal Char Value).       }
     Holdable     : BOOLEAN;    {Is the button holdable?                     }
     HasIcon      : BOOLEAN;    {Is there an icon on the button?             }
     Icon         : BYTE;       {16x16 icon record location.                 }
     IX,IY        : WORD;       {Icon X/Y coordinates.                       }
     END;
{----------------------------------------------------------------------------}
TYPE Button_Ext   = RECORD      {Record for the button hotkey extensions.    }
     ButStr       : STRING[20]; {Button hotkey extension string.             }
     END;
{----------------------------------------------------------------------------}
TYPE FieldRecord  = RECORD      {Record for entry field settings.            }
     X,Y          : WORD;       {Field X/Y coordinates.                      }
     Text         : STRING;     {Entry field text.                           }
     EType        : BYTE;       {Entry field type.                           }
     ELength      : BYTE;       {Character width of entry field.             }
     CursorPos    : BYTE;       {Entry field cursor position.                }
     Active       : BOOLEAN;    {Is this the currently selected field?       }
     Width        : WORD;       {Entry field pixel width.                    }
     END;
{----------------------------------------------------------------------------}
TYPE Pick_List    = ARRAY[1..800] OF STRING[80];
{^ This is the array in memory that holds the text for picklist items.       }
{----------------------------------------------------------------------------}
TYPE Pick_Info    = RECORD      {Record for the picklist settings.           }
     Active       : BOOLEAN;    {Has the picklist been activated?            }
     Running      : BOOLEAN;    {Is the picklist running?                    }
     X,Y          : WORD;       {Picklist X/Y coordinates.                   }
     Top          : WORD;       {Default selected item at the top of the list.}
     NumItems     : WORD;       {Total number of items in the picklist.      }
     ItemsOnScrn  : WORD;       {Number of items displayed on the screen.    }
     Current      : WORD;       {The currently selected picklist item.       }
     MaxChars     : BYTE;       {Character width of the picklist.            }
     Locator      : WORD;       {For future development.                     }
     Item         : ARRAY[1..30] OF WORD;{Item index in the picklist window. }
     Width        : WORD;       {The right most location of the picklist.    }
     Bottom       : WORD;       {The bottom most location of the picklist.   }
     END;
{----------------------------------------------------------------------------}
TYPE PalScroller = RECORD       {Record for the color palette scroller.      }
     Active      : BOOLEAN;     {Has the palette scroller been activated?    }
     X,Y         : WORD;        {X/Y coordinates of the palette scroller.    }
     Top         : BYTE;        {Color value of the top scroller element.    }
     Current     : BYTE;        {The currently selected palette color.       }
     Item        : ARRAY[1..16] OF WORD;{Item index in the palette scroller. }
     Width       : WORD;        {The right most location of the scroller.    }
     Bottom      : WORD;        {The bottom most location of the scroller.   }
     END;
{----------------------------------------------------------------------------}
TYPE Text_Buffer  = ARRAY[1..400] OF STRING[79];
{^ This is the text buffer for the text editor and text reader.              }
{----------------------------------------------------------------------------}
TYPE Text_Reader  = RECORD      {The record for the text reader settings.    }
     X,Y          : WORD;       {Text reader X/Y coordinates.                }
     Row          : WORD;       {Current text line Y coordinate.             }
     Col          : WORD;       {Current text line X coordinate.             }
     Lines        : INTEGER;    {How many lines of text in the buffer.       }
     Last         : INTEGER;    {The last text line written to the screen.   }
     Active       : BOOLEAN;    {Has the text reader been activated?         }
     Running      : BOOLEAN;    {Is the text reader running?                 }
     END;
{----------------------------------------------------------------------------}
TYPE Text_Editor  = RECORD      {Record for the text editor settings.        }
     Row          : WORD;       {Text editor row location.                   }
     Active       : BOOLEAN;    {Has the text editor been activated?         }
     Running      : BOOLEAN;    {Is the text editor running?                 }
     Done         : BOOLEAN;    {Has the user pressed ^Q or ^Z [Y/N]         }
     END;
{----------------------------------------------------------------------------}
TYPE Icon_Flips = RECORD        {Record for the flipping icons.              }
     X,Y        : WORD;         {Icon X,Y coordinate.                        }
     Icon       : Array[1..4] OF BYTE; {Icon library record positions.       }
     Size       : BYTE;         {Icon size: 1=16, 2=30, 3=60 pixels.         }
     END;
{----------------------------------------------------------------------------}
TYPE Text_Window = RECORD       {Record for the text view window coordinates.}
     X1          : WORD;        {Text view window upper left X coordinate.   }
     Y1          : WORD;        {Text view window upper left Y coordinate.   }
     X2          : WORD;        {Text view window columns.                   }
     Y2          : WORD;        {Text view window rows.                      }
     Active      : BOOLEAN;     {Is the text view window active? [Y/N]       }
     END;
{----------------------------------------------------------------------------}
CONST
  BBSmessages     : BOOLEAN = FALSE;{Translate BBS message text lines?       }
  FPtr            : POINTER = NIL;  {Pointer to the external GEM font file.  }
VAR
  C               : SVGA_Color_Scheme;           {The color scheme record variable.}
  WRec            : WindowRecord;                {The window record variable.}
  Buttons         : ARRAY[1..30] OF ButtonRecord;{The button record variable.}
  BExt            : ARRAY[1..30] OF Button_Ext;  {The button extension record variable.}
  Fields          : ARRAY[1..30] OF FieldRecord; {The fields record variable.}
  PickList        : ^Pick_List;                  {The picklist text variable.}
  PickInfo        : Pick_Info;                   {The picklist record variable.}
  Scroller        : PalScroller;                 {The scroller record variable.}
  TBuff           : ^Text_Buffer;                {The text buffer variable.  }
  TextReader      : Text_Reader;                 {The text reader record variable.}
  TextEditor      : Text_Editor;                 {The text editor record variable.}
  IconFlip        : ARRAY[1..30] OF Icon_Flips;  {The icon flip record variable.}
  TvWin           : Text_Window;                 {The text view window record variable.}
  WinTag          : CHAR;       {Identifier tag for screen save files.       }
  MC              : CHAR;       {Character returned by mouse handler.        }
  AltKey          : BOOLEAN;    {Was the last MC keypress an ALT key? [Y/N]  }
  SVGAmode        : BOOLEAN;    {Are we in SVGA mode? [Y/N]                  }
  ConvertIt       : BOOLEAN;    {Convert color codes? [Y/N]                  }
  LastPressed     : BYTE;       {The number of the last button pressed.      }
  NFlips          : BYTE;       {The total number of flipping icons.         }
  NFields         : BYTE;       {The total number of fields in a window.     }
  NButtons        : BYTE;       {The total number of buttons in a window.    }
  FieldNum        : BYTE;       {The currently selected field number.        }
  WindowNumber    : BYTE;       {The currently active window number.         }
  IconLib16       : STRING[80]; {File name of the 16x16 icon library file.   }
  IconLib30       : STRING[80]; {File name of the 30x30 icon library file.   }
  IconLib60       : STRING[80]; {File name of the 60x60 icon library file.   }
  EditorFile      : STRING[80]; {Default file name for text editor saving.   }

{}
PROCEDURE FireUpBgiGui;
{^ Initializes the graphics interface unit. This must be the first thing
   called in your program.}
PROCEDURE ShutDownBgiGui; Far;
{^ Shuts down the graphics interface unit and returns to text mode.}
PROCEDURE LoadUserFont(FFile : STRING);
{^ Loads an external GEM font file into memory.}
PROCEDURE CvtTokens(InStr : STRING ; Font : BYTE);
{^ Outputs text with no MOVETO(X,Y) and translates inline color tokens.}
PROCEDURE OutText_XY(X,Y,FG,Font : WORD ; Txt : STRING);
{^ This procedure plots text at specific X/Y coordinates in FG color.
   The procedure uses specific linked fonts: 1 - 5x8 bitmapped font.
                                             2 - GEM "System" font.
                                             3 - 8x14 ROM resident font.
                                             4 - External GEM font.}
PROCEDURE ShadowText(X,Y,FG,SH,Font : WORD ; Txt : STRING);
{^ Same as above except the text is shadowed with this procedure.}
PROCEDURE RaisedBox(X1,Y1,X2,Y2 : WORD);
{^ Draws a rectangle on the screen that appears to be raised.}
PROCEDURE LoweredBox(X1,Y1,X2,Y2 : WORD);
{^ Draws a rectangle on the screen that appears to be lowered.}
PROCEDURE FrameHigh(X1,Y1,X2,Y2 : WORD);
{^ Draws a highlighted rectangle on the screen.}
PROCEDURE FrameLow(X1,Y1,X2,Y2 : WORD);
{^ Draws a lowlighted rectangle on the screen.}
PROCEDURE PutIcon16(X,Y,I : WORD);
PROCEDURE PutIcon30(X,Y,I : WORD);
PROCEDURE PutIcon60(X,Y,I : WORD);
{^ The above procedures plot an icon on the screen at X/Y coordinates.
   PutIcon16 plots a 16x16 pixel icon and PutIcon30 plots a 30x30 pixel
   icon and PutIcon60 plots a 60x60 pixel icon. "I" is the icon record
   location in the icon library file (Zero Based).}
PROCEDURE AnimateIcon(XStart,YStart,XEnd,YEnd,Speed : INTEGER ; IconSize,Icon : BYTE);
{^ This procedure animates a 16,30, or 60 pixel icon from XStart/YStart to
   XEnd/YEnd. "Speed" is the number of milliseconds between icon plots.
   "IconSize" determines whether the icon is a 16,30, or 60 pixel icon
   (1=16p, 2=30p, 3=60p) and "Icon" is the icon's record position in the
   current icon library.}
PROCEDURE Flip_Icon(X,Y : WORD ; Icon1,Icon2,Icon3,Icon4,ISize : BYTE);
{^ Plots 4 icons of the same size at X/Y coordinates. As your program
   cycles through the mouse loop, icons will be drawn over top of each
   other creating an "Animated" appearance. This is useful for flipping
   or spinning small images.
   Icon1,Icon2,Icon3,Icon4 are the icons library record position.
   ISize is the icon size as follows: 1 = 16x16
                                      2 = 30x30
                                      3 = 60x60 }
PROCEDURE Draw_Line(X1,Y1,X2,Y2,FG : WORD);
{^ Draws a line from X1,Y1 to X2,Y2 in FG color.}
PROCEDURE Draw_Window(X1,Y1,X2,Y2,WType,SType : WORD ; Title : STRING);
{^ Draws a window at X1,Y1,X2,Y2 coordinates. The 4 types of windows are:
   1 - Standard Block (Similar to MS-Windows 3.XX or OS/2)
   2 - Invisible (Used for saving screen regions).
   3 - Flat Panel (A window with no title header).
   4 - Transparent (Similar to looking through a window screen).
   5 - Standard Panel (Similar to Windows 95)

   There are also three types of screen save methods used with windows:
   1 - Clip just the region of the screen the window occupies (64K Max!).
   2 - Clear the screen region with the current background color.
   3 - Save the entire 640x480 screen to disk.}
PROCEDURE Kill_Window;
{^ Kills the last window and reloads the previous one.}
PROCEDURE Draw_Button(X,Y,Width : WORD ; Return : BYTE ; HasIcon : BOOLEAN ; Icon : BYTE ; Title : STRING);
{^ Plots a button at X/Y coordinates. "Width" is the pixel width of the
   button. "Return" is the ordinal value of the character the button is
   suppose to represent. "HasIcon" determines if a 16x16 icon is to be
   drawn on the button. "Icon" is the record position of the IconLib16
   icon file that you want to draw on the button (30 buttons max).}
PROCEDURE Radio_Button(X,Y : WORD ; Return : BYTE);
{^ Draws a round button at X/Y coordinates. "Return" is the ordinal value
   of the character that the button is suppose to represent.}
PROCEDURE Click_Zone(X,Y,Width,Height : WORD ; Return : BYTE);
{^ Similar to the Draw_Button procedure except all this does is draw a
   frame on the screen that presses and releases. This is handy if you
   want to make an entire zone on the screen act like a button. "Return"
   is the ordinal value of the character that the zone is to represent.}
PROCEDURE User_Button(X,Y,Width,Height : WORD ; Return : BYTE);
{^ This works exactly like Click_Zone except this procedure draws an
   actual button using the same color as C.ButtonFace.}
PROCEDURE New_TextEditor(Row : WORD);
{^ Initializes the text editor at Row ###.}
PROCEDURE RunTextEditor;
{^ Runs the text file editor after it has been initialized. Your text can be
   loaded from and saved to the "EditorFile" variable.}
PROCEDURE New_TextReader(X,Y : WORD);
{^ Initalizes the text file reader.}
PROCEDURE ShowTextPage;
{^ Runs the text file reader after it has been initialized. The default text
   file name is stored in the "EditorFile" variable.}
PROCEDURE FillTextBuffer(F : STRING);
{^ This is used to load a text file into the text buffer for the text editor
   or text reader. You need to call New_TextEditor or New_TextReader first or
   the file will not be loaded.}
PROCEDURE New_PickList(X,Y,OnScreen,MaxChars : WORD);
{^ Initializes a picklist at X/Y coordinates. "OnScreen" determines how many
   items are to be displayed on the screen (30 Max). "MaxChars" is how wide
   the picklist is (Character width, 79 characters max).}
PROCEDURE Palette_Scroller(X,Y : WORD);
{^ Plots the color palette scroller at X/Y coordinates.}
PROCEDURE SetUp_Scroller;
{^ Any time your change the currently selected color in the palette scroller
   from an external process, Set the Scroller.Current and Scroller.Top to the
   same value and call this procedure.}
PROCEDURE AddTo_PickList(InString : STRING);
{^ Adds an item to the picklist (800 items max).}
PROCEDURE SetUp_PickList;
{^ Runs the picklist after it has been initialized and stuffed with items.}
PROCEDURE Reset_PickList(Item : WORD);
{^ Resets the picklist highlight bar to a specific item number. You first
   issue this command and then issue the SetUp_PickList command.}
PROCEDURE Entry_Field(X,Y,EType,ELength : WORD ; Stuff : STRING);
{^ Plots an entry field on the screen. There are 6 entry field types:
   0 - Normal String, all characters accepted.
   1 - Numeric String, only numeric characters accepted.
   2 - Proper String, used for getting names.
   3 - Date String, only accepts characters associated with dates.
   4 - Phone Number, only accepts characters associated with phone numbers.
   5 - Upper Case, capitalizes all characters.
   Your text is returned through the Fields[##].Text variable (30 fields Max).}
PROCEDURE ChangeField(Number : WORD);
{^ Changes the active field to field number ##.}
PROCEDURE RedrawField;
{^ Redraws the field selected by ChangeField.}
PROCEDURE Show_Mem;
{^ Shows the current amount of free memory in the lower right of the screen.}
PROCEDURE HideMouse;
{^ Hides the mouse cursor.}
PROCEDURE ShowMouse;
{^ Shows the mouse cursor.}
PROCEDURE InitPalette;
{^ Intializes the SVGA color palette. Most times you won't need to call this
   procedure directly since it is called in the FireUpBgiGui. You may call
   this after returning from text mode.}
PROCEDURE ClearKeyBuffer;
{^ Clears the keyboard buffer.}
FUNCTION  MouseHandler(DoKeys : BOOLEAN) : BYTE;
{^ The meat and potatos of the GUI. It ain't pretty, but it works. This will
   return the number of the button pressed or the corresponding key press
   associated with a button.}
PROCEDURE ResetGraphics;
{^ This procedure lets you reset the graphics kit to its default settings
   at any point in time.}
PROCEDURE Put_Image(X1,Y1 : WORD ; ImageFile : STRING);
{^ Reads a PCX file from disk and displays it at X1/Y1 coordinates.
   Since MAX Graphics is a 256 color SVGA interface, only 256 color
   image files are supported. You may need to convert your images
   to the MAX 256 color palette format before they will display.}

{}

IMPLEMENTATION

USES GRAPH, {*}WRMODE, {*}BGIDRIV, {*}VESACHK, {*}GEMFONTU,
     {*}MOUSE, CRT, DOS, DOORKIT2;

{Units marked with an asterisk are from the ULTRABGI.ZIP development kit.    }

CONST
  TopScreen     = 7;
  WWrap         = 79;
  ScrLines      : WORD = 17;
  ScrSize       : WORD = 23;
  ScrollSiz     : WORD = 13;
  Insert_Mode   : BOOLEAN = TRUE;
  Max_Msg_Lines : WORD = 400;

VAR
  Key           : CHAR;
  Par           : STRING;
  LineNum       : WORD;
  LineCnt       : WORD;
  Where_X       : WORD;
  Where_Y       : WORD;
  xx,yy         : WORD;
  TopLine       : INTEGER;
  CLine         : INTEGER;
  CCol          : INTEGER;
  PhyLine       : ARRAY[1..17] OF STRING[81];
  PLeft         : INTEGER;
  HelpOn        : BOOLEAN;
  FlipCounter   : BYTE;
  IconCounter   : BYTE;

{}
PROCEDURE FireUpBgiGui;
BEGIN
  FileMode := 66;
  CLRSCR;
  IF NOT IsVesa THEN BEGIN
    WRITELN('Sorry, a VESA BIOS could not be detected on your video card nor could a VESA');
    WRITELN('driver TSR be found in memory. Please load the VESA driver program that came');
    WRITELN('with your computer or video card and try running this program again.');
    WRITELN;
    WRITELN('Minimum system requirements for this program are:');
    WRITELN;
    WRITELN('VESA Compatible Super VGA video card capable of 640x480x256 resolution');
    WRITELN('Minimum of 512K of video RAM  (1 Meg of video RAM or more recommended)');
    WRITELN('MicroSoft compatible mouse (Optional)');
    WRITELN;
    WRITE('Press Any Key To Continue....');
    READKEY;
    ErrorLog('No VESA BIOS Detected!',9,TRUE);
  END;
  InitBGI256;
  InitPalette;
  SETFILLSTYLE(6,C.ScreenColor);
  BAR(0,0,639,479);
  SETCOLOR(0); RECTANGLE(0,0,639,479);
  InitMouse;
  IF MouseInstalled THEN BEGIN
    SetPixelToMickey(6,10);
    UseSimMouse := TRUE;
    MouseColor  := (15);
    SetMouseArea(0,0,639,479);
    SetMousePosition(PutMx(GETMAXX SHR 1),PutMy(GETMAXY SHR 1));
    MouseGraphicCursor(MouseStandard);
    Show_Mouse;
  END;
  SVGAmode := TRUE;
END;
{}
PROCEDURE ShutDownBgiGui;
BEGIN
  HideMouse;
  IF WindowNumber > 1 THEN REPEAT Kill_Window UNTIL WindowNumber = 1;
  UnloadGemFont(FPtr);
  CLOSEGRAPH;
  SVGAmode := FALSE;
END;
{}
PROCEDURE LoadUserFont(FFile : STRING);
VAR
  Leading   : WORD;
  ErrorCode : WORD;
BEGIN
  UnloadGemFont(FPtr);
  IF FExist(FFile) THEN FPtr := LoadGemFont(FFile,Leading,ErrorCode);
END;
{}
FUNCTION GoodColor(TempStr : STRING ; ChangeColor : BOOLEAN) : BOOLEAN;
VAR
  FG : BYTE;
BEGIN
  FG := 50;
  IF TempStr = '{0}'  THEN FG := 0;
  IF TempStr = '{1}'  THEN FG := 1;
  IF TempStr = '{2}'  THEN FG := 2;
  IF TempStr = '{3}'  THEN FG := 3;
  IF TempStr = '{4}'  THEN FG := 4;
  IF TempStr = '{5}'  THEN FG := 5;
  IF TempStr = '{6}'  THEN FG := 6;
  IF TempStr = '{7}'  THEN FG := 7;
  IF TempStr = '{8}'  THEN FG := 8;
  IF TempStr = '{9}'  THEN FG := 9;
  IF TempStr = '{10}' THEN FG := 10;
  IF TempStr = '{11}' THEN FG := 11;
  IF TempStr = '{12}' THEN FG := 12;
  IF TempStr = '{13}' THEN FG := 13;
  IF TempStr = '{14}' THEN FG := 14;
  IF TempStr = '{15}' THEN FG := 15;
  IF TempStr = '{16}' THEN FG := 16;
  IF TempStr = '{17}' THEN FG := 17;
  IF TempStr = '{18}' THEN FG := 18;
  IF TempStr = '{19}' THEN FG := 19;
  IF TempStr = '{20}' THEN FG := 20;
  IF TempStr = '{21}' THEN FG := 21;
  IF TempStr = '{22}' THEN FG := 22;
  IF TempStr = '{23}' THEN FG := 23;
  IF TempStr = '{24}' THEN FG := 24;
  IF TempStr = '{25}' THEN FG := 25;
  IF TempStr = '{26}' THEN FG := 26;
  IF TempStr = '{27}' THEN FG := 27;
  IF TempStr = '{28}' THEN FG := 28;
  IF TempStr = '{29}' THEN FG := 29;
  IF TempStr = '{30}' THEN FG := 30;
  IF TempStr = '{31}' THEN FG := 31;
  IF FG <> 50 THEN BEGIN
    IF FG > 15 THEN DEC(FG,16);
    IF ChangeColor THEN SetColor(FG);
    GoodColor := TRUE;
  END ELSE GoodColor := FALSE;
END;
{}
FUNCTION StripTokens(InStr : STRING) : STRING;
VAR
  Loop : BYTE;
  Cvt  : BOOLEAN;
  Temp : STRING;
  Hold : STRING;
BEGIN
  Cvt  := FALSE;
  Temp := '';
  Hold := '';
  FOR Loop := 1 TO LENGTH(InStr) DO BEGIN
    IF InStr[Loop] = '{' THEN Cvt := TRUE;
    IF Cvt THEN Temp := Temp + InStr[Loop] ELSE Hold := Hold + InStr[Loop];
    IF ((Cvt) AND (InStr[Loop] = '}')) OR (Loop = LENGTH(InStr)) THEN BEGIN
      IF NOT GoodColor(Temp,FALSE) THEN Hold := Hold + Temp;
      Cvt := FALSE;
      Temp := '';
    END;
  END;
  StripTokens := Hold;
END;
{}
PROCEDURE CvtTokens(InStr : STRING ; Font : BYTE);
VAR
  Loop : BYTE;
  Cvt  : BOOLEAN;
  Temp : STRING;
BEGIN
  Cvt  := FALSE;
  Temp := '';
  FOR Loop := 1 TO LENGTH(InStr) DO BEGIN
    IF InStr[Loop] = '{' THEN Cvt := TRUE;
    IF NOT Cvt THEN CASE Font OF
      1 : OutGemText(BPtr,InStr[Loop]);
      2 : OutGemText(GPtr,InStr[Loop]);
      3 : OutGemText(RPtr,InStr[Loop]);
      4 : IF FPtr <> NIL THEN OutGemText(FPtr,InStr[Loop]);
    END;
    IF Cvt THEN Temp := Temp + InStr[Loop];
    IF (Cvt) AND (InStr[Loop] = '}') THEN BEGIN
      IF NOT GoodColor(Temp,TRUE) THEN CASE Font OF
        1 : OutGemText(BPtr,Temp);
        2 : OutGemText(GPtr,Temp);
        3 : OutGemText(RPtr,Temp);
        4 : IF FPtr <> NIL THEN OutGemText(FPtr,Temp);
      END;
      Cvt := FALSE;
      Temp := '';
    END;
  END;
END;
{}
PROCEDURE OutText_XY(X,Y,FG,Font : WORD ; Txt : STRING);
BEGIN
  IF FG <> GETCOLOR THEN SETCOLOR(FG);
  MOVETO(X,Y);
  IF ConvertIt THEN CvtTokens(Txt,Font) ELSE CASE Font OF
    1 : OutGemText(BPtr,Txt);
    2 : OutGemText(GPtr,Txt);
    3 : OutGemText(RPtr,Txt);
    4 : IF FPtr <> NIL THEN OutGemText(FPtr,Txt);
  END;
END;
{}
PROCEDURE ShadowText(X,Y,FG,SH,Font : WORD ; Txt : STRING);
BEGIN
  IF SH <> GETCOLOR THEN SETCOLOR(SH);
  IF ConvertIt THEN BEGIN
    CASE Font OF
      1 : OutGemTextXY(BPtr,X + 1,Y + 1,StripTokens(Txt));
      2 : OutGemTextXY(GPtr,X + 1,Y + 1,StripTokens(Txt));
      3 : OutGemTextXY(RPtr,X + 1,Y + 1,StripTokens(Txt));
      4 : IF FPtr <> NIL THEN OutGemTextXY(FPtr,X + 1,Y + 1,StripTokens(Txt));
    END;
  END ELSE CASE Font OF
    1 : OutGemTextXY(BPtr,X + 1,Y + 1,Txt);
    2 : OutGemTextXY(GPtr,X + 1,Y + 1,Txt);
    3 : OutGemTextXY(RPtr,X + 1,Y + 1,Txt);
    4 : IF FPtr <> NIL THEN OutGemTextXY(FPtr,X + 1,Y + 1,Txt);
  END;
  IF FG <> GETCOLOR THEN SETCOLOR(FG);
  MOVETO(X,Y);
  IF ConvertIt THEN CvtTokens(Txt,Font) ELSE CASE Font OF
    1 : OutGemText(BPtr,Txt);
    2 : OutGemText(GPtr,Txt);
    3 : OutGemText(RPtr,Txt);
    4 : IF FPtr <> NIL THEN OutGemText(FPtr,Txt);
  END;
END;
{}
PROCEDURE RaisedBox(X1,Y1,X2,Y2 : WORD);
BEGIN
  SETFILLSTYLE(1,C.BoxBack); BAR(X1,Y1,X2,Y2);
  SETCOLOR(C.ButtonFrame); RECTANGLE(X1,Y1,X2,Y2);
  Draw_Line(X1 + 1,Y2 - 1,X1 + 1,Y1 + 1,C.BoxHigh);
  Draw_Line(X1 + 1,Y1 + 1,X2 - 1,Y1 + 1,C.BoxHigh);
  Draw_Line(X2 - 1,Y1 + 2,X2 - 1,Y2 - 1,C.BoxLow);
  Draw_Line(X2 - 1,Y2 - 1,X1 + 2,Y2 - 1,C.BoxLow);
END;
{}
PROCEDURE LoweredBox(X1,Y1,X2,Y2 : WORD);
BEGIN
  SETFILLSTYLE(1,C.BoxBack); BAR(X1,Y1,X2,Y2);
  SETCOLOR(C.ButtonFrame); RECTANGLE(X1,Y1,X2,Y2);
  Draw_Line(X1 + 1,Y2 - 1,X1 + 1,Y1 + 1,C.BoxLow);
  Draw_Line(X1 + 1,Y1 + 1,X2 - 1,Y1 + 1,C.BoxLow);
  Draw_Line(X2 - 1,Y1 + 2,X2 - 1,Y2 - 1,C.BoxHigh);
  Draw_Line(X2 - 1,Y2 - 1,X1 + 2,Y2 - 1,C.BoxHigh);
END;
{}
PROCEDURE FrameHigh(X1,Y1,X2,Y2 : WORD);
BEGIN
  Draw_Line(X2,Y1,X2,Y2,C.FrameLow);
  Draw_Line(X2,Y2,X1,Y2,C.FrameLow);
  Draw_Line(X1,Y2,X1,Y1,C.FrameHigh);
  Draw_Line(X1,Y1,X2,Y1,C.FrameHigh);
END;
{}
PROCEDURE FrameLow(X1,Y1,X2,Y2 : WORD);
BEGIN
  Draw_Line(X2,Y1,X2,Y2,C.FrameHigh);
  Draw_Line(X2,Y2,X1,Y2,C.FrameHigh);
  Draw_Line(X1,Y2,X1,Y1,C.FrameLow);
  Draw_Line(X1,Y1,X2,Y1,C.FrameLow);
END;
{}
PROCEDURE WindowHeader(Title : STRING ; Active : BOOLEAN);
BEGIN
  IF (WRec.WType = 2) OR (WRec.WType = 3) THEN EXIT;
  IF Active THEN BEGIN
    IF (WRec.WType = 4) OR (WRec.WType = 5) THEN BEGIN
      SETFILLSTYLE(1,C.ActiveHdr); BAR(WRec.X1 + 5,WRec.Y1 + 5,WRec.X2 - 5,WRec.Y1 + 23);
      OutText_XY(Wrec.X1 + 9,WRec.Y1 + 7,C.HdrTitle,2,Title);
    END ELSE BEGIN
      SETFILLSTYLE(1,C.ActiveHdr); BAR(WRec.X1 + 4,WRec.Y1 + 4,WRec.X2 - 4,WRec.Y1 + 22);
      Draw_Line(WRec.X1 + 4,WRec.Y1 + 23,WRec.X2 - 4,WRec.Y1 + 23,C.FrameHigh);
      OutText_XY(Wrec.X1 + 9,WRec.Y1 + 6,C.HdrTitle,2,Title);
    END;
  END ELSE BEGIN
    IF (WRec.WType = 4) OR (WRec.WType = 5) THEN BEGIN
      SETFILLSTYLE(1,C.InactiveHdr); BAR(WRec.X1 + 5,WRec.Y1 + 5,WRec.X2 - 5,WRec.Y1 + 23);
      OutText_XY(WRec.X1 + 9,WRec.Y1 + 7,7,2,Title);
    END ELSE BEGIN
      SETFILLSTYLE(1,C.InactiveHdr); BAR(WRec.X1 + 4,WRec.Y1 + 4,WRec.X2 - 4,WRec.Y1 + 22);
      Draw_Line(WRec.X1 + 4,WRec.Y1 + 23,WRec.X2 - 4,WRec.Y1 + 23,C.TextBack);
      OutText_XY(WRec.X1 + 9,WRec.Y1 + 6,7,2,Title);
    END;
  END;
END;
{}
PROCEDURE PutIcon16(X,Y,I : WORD);
TYPE Icon16x16 = RECORD
     Matrix    : ARRAY[1..16,1..16] OF BYTE;
     END;
VAR
  L1,L2 : BYTE;
  X2    : WORD;
  I16   : Icon16x16;
  Dat16 : FILE OF Icon16x16;
PROCEDURE Icon16Error;
BEGIN
  SETCOLOR(15);
  RECTANGLE(X,Y,X+15,Y+15);
  OutText_XY(X+5,Y+5,14,1,'Icon Not Found');
END;
BEGIN
  IF NOT FExist(IconLib16) THEN BEGIN
    Icon16Error;
    EXIT;
  END;
  IF POS('.001',IconLib16) < 1 THEN BEGIN
    Icon16Error;
    EXIT;
  END;
  ASSIGN(Dat16,IconLib16);
  RESET(Dat16);
  IF I > (FILESIZE(Dat16)-1) THEN BEGIN
    CLOSE(Dat16);
    Icon16Error;
    EXIT;
  END;
  SEEK(Dat16,I);
  READ(Dat16,I16);
  CLOSE(Dat16);
  X2 := X;
  FOR L1 := 1 TO 16 DO BEGIN
    FOR L2 := 1 TO 16 DO BEGIN
      IF I16.Matrix[L2,L1] < 255 THEN PUTPIXEL(X2,Y,I16.Matrix[L2,L1]);
      INC(X2);
    END;
    X2 := X;
    INC(Y);
  END;
END;
{}
PROCEDURE PutIcon30(X,Y,I : WORD);
TYPE Icon30x30 = RECORD
     Matrix    : ARRAY[1..30,1..30] OF BYTE;
     END;
VAR
  L1,L2 : BYTE;
  X2    : WORD;
  I30   : Icon30x30;
  Dat30 : FILE OF Icon30x30;
PROCEDURE Icon30Error;
BEGIN
  SETCOLOR(15);
  RECTANGLE(X,Y,X+29,Y+29);
  OutText_XY(X+5,Y+5,14,1,'Icon Not Found');
END;
BEGIN
  IF NOT FExist(IconLib30) THEN BEGIN
    Icon30Error;
    EXIT;
  END;
  IF POS('.002',IconLib30) < 1 THEN BEGIN
    Icon30Error;
    EXIT;
  END;
  ASSIGN(Dat30,IconLib30);
  RESET(Dat30);
  IF I > (FILESIZE(Dat30)-1) THEN BEGIN
    CLOSE(Dat30);
    Icon30Error;
    EXIT;
  END;
  SEEK(Dat30,I);
  READ(Dat30,I30);
  CLOSE(Dat30);
  X2 := X;
  FOR L1 := 1 TO 30 DO BEGIN
    FOR L2 := 1 TO 30 DO BEGIN
      IF I30.Matrix[L2,L1] < 255 THEN PUTPIXEL(X2,Y,I30.Matrix[L2,L1]);
      INC(X2);
    END;
    X2 := X;
    INC(Y);
  END;
END;
{}
PROCEDURE PutIcon60(X,Y,I : WORD);
TYPE Icon60x60 = RECORD
     Matrix    : ARRAY[1..60,1..60] OF BYTE;
     END;
VAR
  L1,L2 : BYTE;
  X2    : WORD;
  I60   : Icon60x60;
  Dat60 : FILE OF Icon60x60;
PROCEDURE Icon60Error;
BEGIN
  SETCOLOR(15);
  RECTANGLE(X,Y,X+59,Y+59);
  OutText_XY(X+5,Y+5,14,1,'Icon Library Not Found');
END;
BEGIN
  IF NOT FExist(IconLib60) THEN BEGIN
    Icon60Error;
    EXIT;
  END;
  IF POS('.003',IconLib60) < 1 THEN BEGIN
    Icon60Error;
    EXIT;
  END;
  ASSIGN(Dat60,IconLib60);
  RESET(Dat60);
  IF I > (FILESIZE(Dat60)-1) THEN BEGIN
    CLOSE(Dat60);
    Icon60Error;
    EXIT;
  END;
  SEEK(Dat60,I);
  READ(Dat60,I60);
  CLOSE(Dat60);
  X2 := X;
  FOR L1 := 1 TO 60 DO BEGIN
    FOR L2 := 1 TO 60 DO BEGIN
      IF I60.Matrix[L2,L1] < 255 THEN PUTPIXEL(X2,Y,I60.Matrix[L2,L1]);
      INC(X2);
    END;
    X2 := X;
    INC(Y);
  END;
END;
{}
PROCEDURE AnimateIcon(XStart,YStart,XEnd,YEnd,Speed : INTEGER ; IconSize,Icon : BYTE);
CONST
  BPtr : POINTER = NIL;
  IPtr : POINTER = NIL;
VAR
  BSize : WORD;
PROCEDURE PlotIt(X1,Y1,X2,Y2 : INTEGER);
VAR
  LgDelta,ShDelta,LgStep,ShStep,Cycle : INTEGER;
PROCEDURE Switch(VAR First, Second : INTEGER);
VAR
  Temp : INTEGER;
BEGIN
  Temp   := First;
  First  := Second;
  Second := Temp;
END;
PROCEDURE DoTheIcon;
BEGIN
  CASE IconSize OF
    1 : GETIMAGE(X1,Y1,X1+15,Y1+15,BPtr^);
    2 : GETIMAGE(X1,Y1,X1+29,Y1+29,BPtr^);
    3 : GETIMAGE(X1,Y1,X1+59,Y1+59,BPtr^);
  END;
  PUTIMAGE(X1,Y1,IPtr^,NormalPut);
  IF Speed <> 0 THEN DELAY(Speed);
  PUTIMAGE(X1,Y1,BPtr^,NormalPut);
END;
BEGIN
  LgDelta := X2 - X1;
  ShDelta := Y2 - Y1;
  IF LgDelta < 0 THEN BEGIN
    LgDelta := - LgDelta;
    LgStep  := - 1;
  END ELSE LgStep := 1;
  IF ShDelta < 0 THEN BEGIN
    ShDelta := - ShDelta;
    ShStep  := - 1;
  END ELSE ShStep := 1;
  IF LgDelta > ShDelta THEN BEGIN
    Cycle := LgDelta SHR 1; { LgDelta / 2 }
    WHILE X1 <> X2 DO BEGIN
      DoTheIcon;
      INC(X1,LgStep);
      INC(Cycle, ShDelta);
      IF Cycle > LgDelta THEN BEGIN
        INC(Y1,ShStep);
        DEC(Cycle,LgDelta);
      END;
    END;
  END ELSE BEGIN
    Cycle := ShDelta SHR 1; { ShDelta / 2 }
    Switch(LgDelta, ShDelta);
    Switch(LgStep, ShStep);
    WHILE Y1 <> Y2 DO BEGIN
      DoTheIcon;
      INC(Y1,LgStep);
      INC(Cycle,ShDelta);
      IF Cycle > LgDelta THEN BEGIN
        INC(X1,ShStep);
        DEC(Cycle,LgDelta);
      END;
    END;
  END;
END;
BEGIN
  HideMouse;
  CASE IconSize OF
    1 : BEGIN
          BSize := IMAGESIZE(XStart,YStart,XStart+15,YStart+15);
          GETMEM(IPtr,BSize);
          GETMEM(BPtr,BSize);
          GETIMAGE(XStart,YStart,XStart+15,YStart+15,BPtr^);
          PutIcon16(XStart,YStart,Icon);
          GETIMAGE(XStart,YStart,XStart+15,YStart+15,IPtr^);
          PUTIMAGE(XStart,YStart,BPtr^,NormalPut);
        END;
    2 : BEGIN
          BSize := IMAGESIZE(XStart,YStart,XStart+29,YStart+29);
          GETMEM(IPtr,BSize);
          GETMEM(BPtr,BSize);
          GETIMAGE(XStart,YStart,XStart+29,YStart+29,BPtr^);
          PutIcon30(XStart,YStart,Icon);
          GETIMAGE(XStart,YStart,XStart+29,YStart+29,IPtr^);
          PUTIMAGE(XStart,YStart,BPtr^,NormalPut);
        END;
    3 : BEGIN
          BSize := IMAGESIZE(XStart,YStart,XStart+59,YStart+59);
          GETMEM(IPtr,BSize);
          GETMEM(BPtr,BSize);
          GETIMAGE(XStart,YStart,XStart+59,YStart+59,IPtr^);
          PutIcon60(XStart,YStart,Icon);
          GETIMAGE(XStart,YStart,XStart+59,YStart+59,IPtr^);
          PUTIMAGE(XStart,YStart,BPtr^,NormalPut);
        END;
  END;
  PlotIt(XStart,YStart,XEnd,YEnd);
  IF IPtr <> NIL THEN FREEMEM(IPtr,BSize);
  IF BPtr <> NIL THEN FREEMEM(BPtr,BSize);
  CASE IconSize OF
    1 : PutIcon16(XEnd,YEnd,Icon);
    2 : PutIcon30(XEnd,YEnd,Icon);
    3 : PutIcon60(XEnd,YEnd,Icon);
  END;
  ShowMouse;
END;
{}
PROCEDURE Flip_Icon(X,Y : WORD ; Icon1,Icon2,Icon3,Icon4,ISize : BYTE);
BEGIN
  IF ISize > 3 THEN ISize := 2;
  INC(NFlips);
  IconFlip[NFlips].X       := X;
  IconFlip[NFlips].Y       := Y;
  IconFlip[NFlips].Icon[1] := Icon1;
  IconFlip[NFlips].Icon[2] := Icon2;
  IconFlip[NFlips].Icon[3] := Icon3;
  IconFlip[NFlips].Icon[4] := Icon4;
  IconFlip[NFlips].Size    := ISize;
  CASE ISize OF
    1 : PutIcon16(X,Y,Icon1);
    2 : PutIcon30(X,Y,Icon1);
    3 : PutIcon60(X,Y,Icon1);
  END;
END;
{}
PROCEDURE SaveLastWindow;
VAR
  FFile : FILE;
BEGIN
  WindowHeader(WRec.Title,FALSE);
  ASSIGN(FFile,WinTag+WinTag+'SAV'+WinTag+WinTag+'.' + IntToStr(WindowNumber));
  REWRITE(FFile,1);
  BLOCKWRITE(FFile,NFlips,SIZEOF(NFlips));
  BLOCKWRITE(FFile,Buttons,SIZEOF(Buttons));
  BLOCKWRITE(FFile,BExt,SIZEOF(BExt));
  BLOCKWRITE(FFile,Fields,SIZEOF(Fields));
  BLOCKWRITE(FFile,PickInfo,SIZEOF(PickInfo));
  BLOCKWRITE(FFile,WRec,SIZEOF(WRec));
  BLOCKWRITE(FFile,NFields,SIZEOF(NFields));
  BLOCKWRITE(FFile,NButtons,SIZEOF(NButtons));
  BLOCKWRITE(FFile,FieldNum,SIZEOF(FieldNum));
  BLOCKWRITE(FFile,TextReader,SIZEOF(TextReader));
  BLOCKWRITE(FFile,TextEditor,SIZEOF(TextEditor));
  BLOCKWRITE(FFile,TvWin,SIZEOF(TvWin));
  BLOCKWRITE(FFile,IconFlip,SIZEOF(IconFlip));
  BLOCKWRITE(FFile,Scroller,SIZEOF(Scroller));
  IF PickInfo.Active THEN BLOCKWRITE(FFile,PickList^,SIZEOF(PickList^));
  IF TextReader.Active THEN BLOCKWRITE(FFile,TBuff^,SIZEOF(TBuff^));
  IF TextEditor.Active THEN BLOCKWRITE(FFile,TBuff^,SIZEOF(TBuff^));
  CLOSE(FFile);
  NFlips      := 0;
  NButtons    := 0;
  NFields     := 0;
  FieldNum    := 0;
  LastPressed := 0;
  IconCounter := 1;
  IF PickInfo.Active THEN DISPOSE(PickList);
  IF TextReader.Active THEN DISPOSE(TBuff);
  IF TextEditor.Active THEN DISPOSE(TBuff);
  FILLCHAR(WRec,SIZEOF(WRec),0);
  FILLCHAR(PickInfo,SIZEOF(PickInfo),0);
  FILLCHAR(Buttons,SIZEOF(Buttons),0);
  FILLCHAR(BExt,SIZEOF(BExt),0);
  FILLCHAR(Fields,SIZEOF(Fields),0);
  FILLCHAR(TextReader,SIZEOF(TextReader),0);
  FILLCHAR(TextEditor,SIZEOF(TextEditor),0);
  FILLCHAR(TvWin,SIZEOF(TvWin),0);
  FILLCHAR(IconFlip,SIZEOF(IconFlip),0);
  FILLCHAR(Scroller,SIZEOF(Scroller),0);
END;
{}
PROCEDURE LoadLastWindow;
VAR
  FFile : FILE;
BEGIN
  FieldNum := 0;
  ASSIGN(FFile,WinTag+WinTag+'SAV'+WinTag+WinTag+'.' + IntToStr(WindowNumber));
  RESET(FFile,1);
  BLOCKREAD(FFile,NFlips,SIZEOF(NFlips));
  BLOCKREAD(FFile,Buttons,SIZEOF(Buttons));
  BLOCKREAD(FFile,BExt,SIZEOF(BExt));
  BLOCKREAD(FFile,Fields,SIZEOF(Fields));
  BLOCKREAD(FFile,PickInfo,SIZEOF(PickInfo));
  BLOCKREAD(FFile,WRec,SIZEOF(WRec));
  BLOCKREAD(FFile,NFields,SIZEOF(NFields));
  BLOCKREAD(FFile,NButtons,SIZEOF(NButtons));
  BLOCKREAD(FFile,FieldNum,SIZEOF(FieldNum));
  BLOCKREAD(FFile,TextReader,SIZEOF(TextReader));
  BLOCKREAD(FFile,TextEditor,SIZEOF(TextEditor));
  BLOCKREAD(FFile,TvWin,SIZEOF(TvWin));
  BLOCKREAD(FFile,IconFlip,SIZEOF(IconFlip));
  BLOCKREAD(FFile,Scroller,SIZEOF(Scroller));
  IF PickInfo.Active THEN BEGIN
    NEW(PickList);
    BLOCKREAD(FFile,PickList^,SIZEOF(PickList^));
  END;
  IF TextReader.Active THEN BEGIN
    NEW(TBuff);
    BLOCKREAD(FFile,TBuff^,SIZEOF(TBuff^));
  END;
  IF TextEditor.Active THEN BEGIN
    NEW(TBuff);
    BLOCKREAD(FFile,TBuff^,SIZEOF(TBuff^));
  END;
  CLOSE(FFile);
  ERASE(FFile);
  LastPressed := 0;
  WindowHeader(WRec.Title,TRUE);
END;
{}
PROCEDURE Save_SVGA_Screen;
VAR
  ISize   : WORD;
  IPtr    : POINTER;
  CapFile : FILE;
BEGIN
  {Screen Regions:  }
  {-----------------}
  {1 - 0,0,639,100  }
  {2 - 0,101,639,201}
  {3 - 0,202,639,302}
  {4 - 0,303,639,403}
  {5 - 0,404,639,479}
  NEW(IPtr);
  ASSIGN(CapFile,WinTag + 'SCR' + IntToStr(WindowNumber) + WinTag + '.SAV');
  REWRITE(CapFile,1);
  {---------------------------------- 1 }
  ISize := IMAGESIZE(0,0,639,100);
  GETMEM(IPtr,ISize);
  FREEMEM(IPtr,ISize);
  GETIMAGE(0,0,639,100,IPtr^);
  BLOCKWRITE(CapFile,IPtr^,ISize);
  {---------------------------------- 2 }
  ISize := IMAGESIZE(0,101,639,201);
  GETMEM(IPtr,ISize);
  FREEMEM(IPtr,ISize);
  GETIMAGE(0,101,639,201,IPtr^);
  BLOCKWRITE(CapFile,IPtr^,ISize);
  {---------------------------------- 3 }
  ISize := IMAGESIZE(0,202,639,302);
  GETMEM(IPtr,ISize);
  FREEMEM(IPtr,ISize);
  GETIMAGE(0,202,639,302,IPtr^);
  BLOCKWRITE(CapFile,IPtr^,ISize);
  {---------------------------------- 4 }
  ISize := IMAGESIZE(0,303,639,403);
  GETMEM(IPtr,ISize);
  FREEMEM(IPtr,ISize);
  GETIMAGE(0,303,639,403,IPtr^);
  BLOCKWRITE(CapFile,IPtr^,ISize);
  {---------------------------------- 5 }
  ISize := IMAGESIZE(0,404,639,479);
  GETMEM(IPtr,ISize);
  FREEMEM(IPtr,ISize);
  GETIMAGE(0,404,639,479,IPtr^);
  BLOCKWRITE(CapFile,IPtr^,ISize);
  {-------------------------------------}
  CLOSE(CapFile);
  DISPOSE(IPtr);
END;
{}
PROCEDURE Restore_SVGA_Screen;
VAR
  ISize   : WORD;
  IPtr    : POINTER;
  CapFile : FILE;
BEGIN
  {Screen Regions:  }
  {-----------------}
  {1 - 0,0,639,100  }
  {2 - 0,101,639,201}
  {3 - 0,202,639,302}
  {4 - 0,303,639,403}
  {5 - 0,404,639,479}
  NEW(IPtr);
  ASSIGN(CapFile,WinTag + 'SCR' + IntToStr(WindowNumber) + WinTag + '.SAV');
  RESET(CapFile,1);
  {---------------------------------- 1 }
  ISize := IMAGESIZE(0,0,639,100);
  GETMEM(IPtr,ISize);
  FREEMEM(IPtr,ISize);
  BLOCKREAD(CapFile,IPtr^,ISize);
  PUTIMAGE(0,0,IPtr^,NormalPut);
  {---------------------------------- 2 }
  ISize := IMAGESIZE(0,101,639,201);
  GETMEM(IPtr,ISize);
  FREEMEM(IPtr,ISize);
  BLOCKREAD(CapFile,IPtr^,ISize);
  PUTIMAGE(0,101,IPtr^,NormalPut);
  {---------------------------------- 3 }
  ISize := IMAGESIZE(0,202,639,302);
  GETMEM(IPtr,ISize);
  FREEMEM(IPtr,ISize);
  BLOCKREAD(CapFile,IPtr^,ISize);
  PUTIMAGE(0,202,IPtr^,NormalPut);
  {---------------------------------- 4 }
  ISize := IMAGESIZE(0,303,639,403);
  GETMEM(IPtr,ISize);
  FREEMEM(IPtr,ISize);
  BLOCKREAD(CapFile,IPtr^,ISize);
  PUTIMAGE(0,303,IPtr^,NormalPut);
  {---------------------------------- 5 }
  ISize := IMAGESIZE(0,404,639,479);
  GETMEM(IPtr,ISize);
  FREEMEM(IPtr,ISize);
  BLOCKREAD(CapFile,IPtr^,ISize);
  PUTIMAGE(0,404,IPtr^,NormalPut);
  {-------------------------------------}
  CLOSE(CapFile);
  ERASE(CapFile);
  DISPOSE(IPtr);
END;
{}
PROCEDURE SaveImage(X1,Y1,X2,Y2 : WORD);
VAR
  ISize   : WORD;
  IPtr    : POINTER;
  CapFile : FILE;
  Result  : INTEGER;
BEGIN
  NEW(IPtr);
  ISize := IMAGESIZE(X1,Y1,X2 + 2,Y2 + 2);
  WRec.WindowSize := ISize;
  IF ISize = 0 THEN BEGIN
    CLOSEGRAPH;
    CLRSCR;
    WRITE('Error, Image Size Too Big To Save! - Must Be Less Than 64K!');
    READKEY;
    HALT;
  END;
  GETMEM(IPtr,ISize);
  FREEMEM(IPtr,ISize);
  GETIMAGE(X1,Y1,X2 + 2,Y2 + 2,IPtr^);
  ASSIGN(CapFile,'$SCR' + IntToStr(WindowNumber) + '$.SAV');
  REWRITE(CapFile,ISize);
  BLOCKWRITE(CapFile,IPtr^,ISize,Result);
  CLOSE(CapFile);
  DISPOSE(IPtr);
END;
{}
PROCEDURE Kill_Window;
VAR
  ISize   : WORD;
  IPtr    : POINTER;
  CapFile : FILE;
  Result  : INTEGER;
BEGIN
  IF WindowNumber = 1 THEN EXIT;
  IF PickInfo.Active THEN DISPOSE(PickList);
  IF TextReader.Active THEN DISPOSE(TBuff);
  IF TextEditor.Active THEN DISPOSE(TBuff);
  HideMouse;
  DEC(WindowNumber);
  IF WRec.SType = 1 THEN BEGIN
    NEW(IPtr);
    ISize := WRec.WindowSize;
    GETMEM(IPtr,ISize);
    FREEMEM(IPtr,ISize);
    ASSIGN(CapFile,'$SCR' + IntToStr(WindowNumber) + '$.SAV');
    RESET(CapFile,ISize);
    SEEK(CapFile,0);
    BLOCKREAD(CapFile,IPtr^,ISize,Result);
    CLOSE(CapFile);
    ERASE(CapFile);
    PUTIMAGE(WRec.X1,WRec.Y1,IPtr^,NormalPut);
    DISPOSE(IPtr);
  END;
  IF WRec.SType = 2 THEN BEGIN
    SETFILLSTYLE(6,C.ScreenColor);
    BAR(WRec.X1,WRec.Y1,WRec.X2 + 2,WRec.Y2 + 2);
  END;
  IF WRec.SType = 3 THEN Restore_SVGA_Screen;
  LoadLastWindow;
  ShowMouse;
END;
{}
PROCEDURE Draw_Line(X1,Y1,X2,Y2,FG : WORD);
BEGIN
  SETLINESTYLE(SolidLn,0,1);
  IF FG <> GETCOLOR THEN SETCOLOR(FG);
  LINE(X1,Y1,X2,Y2);
END;
{}
PROCEDURE Draw_Window(X1,Y1,X2,Y2,WType,SType : WORD ; Title : STRING);
VAR
  Loop,X : INTEGER;
BEGIN
  IF WType > 5 THEN WType := 1;
  IF SType > 3 THEN SType := 3;
  IF WindowNumber <> 0 THEN BEGIN
    SaveLastWindow;
    IF SType = 1 THEN SaveImage(X1,Y1,X2,Y2);
    IF SType = 3 THEN Save_SVGA_Screen;
  END;
  INC(WindowNumber);
  WRec.Title := Title;
  WRec.X1    := X1;
  WRec.Y1    := Y1;
  WRec.X2    := X2;
  WRec.Y2    := Y2;
  WRec.WType := WType;
  WRec.SType := SType;
  IF WType = 1 THEN BEGIN
    SETFILLSTYLE(1,C.Win1Back); BAR(X1,Y1,X2,Y2);
    SETCOLOR(C.Win1High); RECTANGLE(X1,Y1,X2,Y2);
    SETCOLOR(C.Win1Low);  RECTANGLE(X1 + 3,Y1 + 3,X2 - 3,Y2 - 3);
    SETCOLOR(0); SETLINESTYLE(SolidLn,0,3);
    LINE(X2 + 2,Y2 + 1,X1 + 5,Y2 + 1);
    LINE(X2 + 1,Y1 + 5,X2 + 1,Y2);
    Draw_Line(X1 + 1,Y2,X2,Y2,C.Win1Frame2);
    Draw_Line(X2,Y1 + 1,X2,Y2,C.Win1Frame2);
    SETFILLSTYLE(1,C.ActiveHdr); BAR(X1 + 4,Y1 + 4,X2 - 4,Y1 + 22);
    Draw_Line(X1 + 4,Y1 + 23,X2 - 4,Y1 + 23,C.Win1Frame1);
    OutText_XY(X1 + 9,Y1 + 6,C.HdrTitle,2,Title);
    Draw_Line(X1 + 4,Y2 - 3,X2 - 3,Y2 - 3,C.Win1High);
    Draw_Line(X2 - 3,Y1 + 4,X2 - 3,Y2 - 3,C.Win1High);
  END;
  IF WType = 3 THEN RaisedBox(X1,Y1,X2,Y2);
  IF WType = 4 THEN BEGIN
    SETCOLOR(C.Win4Frame); RECTANGLE(X1,Y1,X2,Y2);
    SETCOLOR(C.Win4Low); RECTANGLE(X1 + 1,Y1 + 1,X2 - 1,Y2 - 1);
    Draw_Line(X1 + 1,Y2 - 1,X1 + 1,Y1 + 1,C.Win4High);
    Draw_Line(X1 + 1,Y1 + 1,X2 - 1,Y1 + 1,C.Win4High);
    FOR Loop := (Y1 + 2) TO (Y2 - 2) DO BEGIN
      IF ODD(Loop) THEN FOR X := (X1 + 2) TO (X2 - 2) DO IF ODD(X) THEN PUTPIXEL(X,Loop,C.Win4Back);
      IF NOT ODD(Loop) THEN FOR X := (X1 + 2) TO (X2 - 2) DO IF NOT ODD(X) THEN PUTPIXEL(X,Loop,C.Win4Back);
    END;
    SETFILLSTYLE(1,C.ActiveHdr); BAR(X1 + 5,Y1 + 5,X2 - 5,Y1 + 23);
    SETCOLOR(C.Win4Back); RECTANGLE(X1 + 4,Y1 + 4,X2 - 4,Y1 + 24);
    Draw_Line(X1 + 4,Y1 + 24,X2 - 4,Y1 + 24,C.Win4High);
    Draw_Line(X2 - 4,Y1 + 24,X2 - 4,Y1 + 5,C.Win4High);
    OutText_XY(X1 + 9,Y1 + 7,C.HdrTitle,2,Title);
    SETFILLSTYLE(1,0); BAR(X1 + 5,Y2 + 1,X2 + 2,Y2 + 2); BAR(X2 + 1,Y2,X2 + 2,Y1 + 5);
  END;
  IF WType = 5 THEN BEGIN
    SETFILLSTYLE(1,C.Win1Back); BAR(X1,Y1,X2,Y2);
    SETCOLOR(C.Win1Low); RECTANGLE(X1,Y1,X2,Y2);
    SETCOLOR(C.Win1Frame2); RECTANGLE(X1 + 1,Y1 + 1,X2 - 1,Y2 - 1);
    Draw_Line(X1 + 1,Y2 - 1,X1 + 1,Y1 + 1,C.Win1High);
    Draw_Line(X1 + 1,Y1 + 1,X2 - 1,Y1 + 1,C.Win1High);
    SETFILLSTYLE(1,C.ActiveHdr); BAR(X1 + 5,Y1 + 5,X2 - 5,Y1 + 23);
    SETCOLOR(C.Win1Low); RECTANGLE(X1 + 4,Y1 + 4,X2 - 4,Y1 + 24);
    Draw_Line(X1 + 4,Y1 + 24,X2 - 4,Y1 + 24,C.Win1High);
    Draw_Line(X2 - 4,Y1 + 24,X2 - 4,Y1 + 5,C.Win1High);
    OutText_XY(X1 + 9,Y1 + 7,C.HdrTitle,2,Title);
    SETFILLSTYLE(1,0); BAR(X1 + 5,Y2 + 1,X2 + 2,Y2 + 2); BAR(X2 + 1,Y2,X2 + 2,Y1 + 5);
  END;
END;
{}
PROCEDURE Draw_Button(X,Y,Width : WORD ; Return : BYTE ; HasIcon : BOOLEAN ; Icon : BYTE ; Title : STRING);
BEGIN
  LastPressed := 0;
  INC(NButtons);
  Buttons[NButtons].ButtonType := 1;
  Buttons[NButtons].X          := X;
  Buttons[NButtons].Y          := Y;
  Buttons[NButtons].Width      := Width;
  Buttons[NButtons].Height     := 20;
  Buttons[NButtons].Return     := Return;
  Buttons[NButtons].Title      := Title;
  Buttons[NButtons].Holdable   := TRUE;
  Buttons[NButtons].HasIcon    := HasIcon;
  Buttons[NButtons].Icon       := Icon;
  Buttons[NButtons].IX         := (X + Width) - 18;
  Buttons[NButtons].IY         := Y + 2;
  BExt[NButtons].ButStr        := #0;
  SETFILLSTYLE(1,C.ButtonFace);
  BAR(X,Y,X + Width,Y + 20);
  SETCOLOR(C.ButtonFrame); RECTANGLE(X,Y,X + Width,Y + 20);
  Draw_Line(X + 1,Y + 19,X + 1,Y + 1,C.ButtonHigh);
  Draw_Line(X + 1,Y + 1,X + 1 + (Width - 2),Y + 1,C.ButtonHigh);
  Draw_Line(X + (Width - 1),Y + 2,X + (Width - 1),Y + 19,C.ButtonLow);
  Draw_Line(X + (Width - 1),Y + 19,X + 2,Y + 19,C.ButtonLow);
  OutText_XY(X + 6,Y + 3,C.ButtonText,2,Title);
  OutText_XY(X + 6,Y + 3,C.ButtonHot,2,COPY(Title,1,1));
  IF HasIcon THEN PutIcon16(Buttons[NButtons].IX,Buttons[NButtons].IY,Icon);
END;
{}
PROCEDURE Radio_Button(X,Y : WORD ; Return : BYTE);
BEGIN
  LastPressed := 0;
  INC(NButtons);
  Buttons[NButtons].ButtonType := 2;
  Buttons[NButtons].X          := X;
  Buttons[NButtons].Y          := Y;
  Buttons[NButtons].Width      := 14;
  Buttons[NButtons].Height     := 14;
  Buttons[NButtons].Return     := Return;
  Buttons[NButtons].Title      := '';
  Buttons[NButtons].Holdable   := TRUE;
  Buttons[NButtons].HasIcon    := False;
  Buttons[NButtons].Icon       := 0;
  Buttons[NButtons].IX         := 0;
  Buttons[NButtons].IY         := 0;
  BExt[NButtons].ButStr        := #0;
  PutIcon16(X,Y,98);
END;
{}
PROCEDURE Click_Zone(X,Y,Width,Height : WORD ; Return : BYTE);
BEGIN
  LastPressed := 0;
  INC(NButtons);
  Buttons[NButtons].ButtonType := 3;
  Buttons[NButtons].X          := X;
  Buttons[NButtons].Y          := Y;
  Buttons[NButtons].Width      := Width-1;
  Buttons[NButtons].Height     := Height-1;
  Buttons[NButtons].Return     := Return;
  Buttons[NButtons].Title      := '';
  Buttons[NButtons].Holdable   := TRUE;
  Buttons[NButtons].HasIcon    := False;
  Buttons[NButtons].Icon       := 0;
  Buttons[NButtons].IX         := 0;
  Buttons[NButtons].IY         := 0;
  BExt[NButtons].ButStr        := #0;
  SetColor(C.ButtonFrame);
  Rectangle(X,Y,X+(Width-1),Y+(Height-1));
  FrameHigh(X+1,Y+1,X+(Width-2),Y+(Height-2));
END;
{}
PROCEDURE User_Button(X,Y,Width,Height : WORD ; Return : BYTE);
BEGIN
  LastPressed := 0;
  INC(NButtons);
  Buttons[NButtons].ButtonType := 4;
  Buttons[NButtons].X          := X;
  Buttons[NButtons].Y          := Y;
  Buttons[NButtons].Width      := Width-1;
  Buttons[NButtons].Height     := Height-1;
  Buttons[NButtons].Return     := Return;
  Buttons[NButtons].Title      := '';
  Buttons[NButtons].Holdable   := TRUE;
  Buttons[NButtons].HasIcon    := False;
  Buttons[NButtons].Icon       := 0;
  Buttons[NButtons].IX         := 0;
  Buttons[NButtons].IY         := 0;
  BExt[NButtons].ButStr        := #0;
  SetFillStyle(1,C.ButtonFace);
  Bar(X,Y,X+(Width-1),Y+(Height-1));
  SetColor(C.ButtonFrame);
  Rectangle(X,Y,X+(Width-1),Y+(Height-1));
  FrameHigh(X+1,Y+1,X+(Width-2),Y+(Height-2));
END;
{}
PROCEDURE FillTextBuffer(F : STRING);
VAR
  Count : INTEGER;
  Txt   : TEXT;
BEGIN
  Count := 0;
  IF (NOT FExist(F)) OR (TBuff = NIL) THEN EXIT;
  ASSIGN(Txt,F);
  RESET(Txt);
  WHILE (NOT EOF(Txt)) AND (Count <= 399) DO BEGIN
    INC(Count);
    READLN(Txt,TBuff^[Count]);
  END;
  IF Count > 399 THEN Count := 399;
  IF TextReader.Active THEN TextReader.Lines := Count;
  CLOSE(Txt);
END;
{}
PROCEDURE New_TextEditor(Row : WORD);
BEGIN
  NEW(TBuff);
  FILLCHAR(TBuff^,SIZEOF(TBuff^),0);
  TextEditor.Row     := Row;
  TextEditor.Active  := TRUE;
  TextEditor.Running := FALSE;
  TextEditor.Done    := FALSE;
  SETFILLSTYLE(1,C.TextBack); BAR(0,Row,639,Row + 362);
  SETCOLOR(0); RECTANGLE(0,Row,639,Row + 362);
END;
{}
PROCEDURE RunTextEditor;
{-----------------------Make Some TDK SVGA Equivalents----------------------}
PROCEDURE Set_Color(FG,BG : BYTE);
BEGIN
  IF FG <> GETCOLOR THEN SETCOLOR(FG);
  SETFILLSTYLE(1,BG);
END;

PROCEDURE PlaceCursor;
BEGIN
  xx := GETX;
  yy := GETY;
  OutText_XY(xx,yy+2,15,3,'_');
  MOVETO(xx,yy);
END;

PROCEDURE EraseCursor;
BEGIN
  OutText_XY(xx,yy+2,C.TextBack,3,'_');
  MOVETO(xx,yy);
END;

PROCEDURE sWrite(St : STRING);
VAR
  Len : WORD;
BEGIN
  Len := LENGTH(St) * 8 - 1;
  BAR((Where_X*8)-5,(Where_Y*14)+TextEditor.Row,((Where_X*8)+Len)-5,(Where_Y*14)+13+TextEditor.Row);
  OutGEMtext(RPtr,St);
  INC(Where_X,LENGTH(St));
END;

PROCEDURE OutTxt(FG,BG : BYTE ; St : STRING);
BEGIN
  Set_Color(FG,BG);
  sWrite(St);
END;

PROCEDURE sGotoXY(X,Y : WORD);
BEGIN
  Where_X := X;
  Where_Y := Y;
  MOVETO((X*8)-5,(Y*14)+TextEditor.Row);
END;

PROCEDURE sClrScr;
BEGIN
  SETFILLSTYLE(1,C.TextBack); BAR(1,TextEditor.Row+1,638,TextEditor.Row + 361);
  SETCOLOR(0); RECTANGLE(0,TextEditor.Row,639,TextEditor.Row + 362);
  Where_X := 1;
  Where_Y := 1;
  sGotoXY(Where_X,Where_Y);
END;

PROCEDURE sClrEol;
BEGIN
  SETFILLSTYLE(1,C.TextBack);
  BAR((Where_X*8)-5,(Where_Y*14)+TextEditor.Row,638,(Where_Y*14)+13+TextEditor.Row);
END;
{---------------------------------------------------------------------------}

PROCEDURE Insert_Line(Contents : STRING);
VAR
  I : INTEGER;
BEGIN
  FOR I := Max_Msg_Lines DOWNTO CLine + 1 DO TBuff^[I] := TBuff^[I - 1];
  TBuff^[CLine] := Contents;
  IF CLine < LineCnt THEN INC(LineCnt);
  IF CLine > LineCnt THEN LineCnt := CLine;
END;

PROCEDURE Delete_Line;
VAR
  I : INTEGER;
BEGIN
  FOR I := CLine TO Max_Msg_Lines DO TBuff^[I] := TBuff^[I + 1];
  TBuff^[Max_Msg_Lines] := '';
  IF (CLine <= LineCnt) AND (LineCnt > 1) THEN DEC(LineCnt);
END;

PROCEDURE Remove_Trailing;
BEGIN
  WHILE TBuff^[CLine][LENGTH(TBuff^[CLine])] = ' ' DO DELETE(TBuff^[CLine],LENGTH(TBuff^[CLine]),1);
END;

PROCEDURE Append_Space;
BEGIN
  TBuff^[CLine] := TBuff^[CLine] + ' ';
END;

FUNCTION Curlength : INTEGER;
BEGIN
  CurLength := LENGTH(TBuff^[CLine]);
END;

PROCEDURE Count_Lines;
BEGIN
  LineCnt := Max_Msg_Lines;
  WHILE (LineCnt > 1) AND (LENGTH(TBuff^[LineCnt]) = 0) DO DEC(LineCnt);
END;

FUNCTION Line_Boundry : BOOLEAN;
BEGIN
  Line_Boundry := (CCol = 1) OR (CCol > CurLength);
END;

FUNCTION CurChar : CHAR;
BEGIN
  IF CCol <= CurLength THEN CurChar := TBuff^[CLine][CCol] ELSE CurChar := ' ';
END;

FUNCTION Delimiter : BOOLEAN;
BEGIN
  CASE CurChar OF
    '0'..'9','a'..'z','A'..'Z','_' : Delimiter := FALSE;
    ELSE Delimiter := TRUE;
  END;
END;

FUNCTION LastChar : CHAR;
BEGIN
  IF CurLength = 0 THEN LastChar := ' ' ELSE LastChar := TBuff^[CLine][CurLength];
END;

PROCEDURE Reposition;
VAR
  Eol : INTEGER;
BEGIN
  Eol := CurLength + 1;
  IF CCol > Eol THEN CCol := Eol;
  Count_Lines;
  sGotoXY(CCol,CLine - TopLine + TopScreen);
END;

PROCEDURE Set_PhyLine;
BEGIN
  PhyLine[CLine - TopLine + 1] := TBuff^[CLine];
END;

PROCEDURE Update_Eol;
BEGIN
  Remove_Trailing;
  Reposition;
  sClrEol;
  Set_PhyLine;
END;

PROCEDURE Refresh_Screen;
VAR
  PLine  : INTEGER;
  PCol   : INTEGER;
  PhLine : INTEGER;
BEGIN
  IF (CLine >= Max_Msg_Lines) THEN CLine := Max_Msg_Lines;
  PLine := CLine;
  CLine := TopLine;
  PCol  := CCol;
  CCol  := 1;
  FOR CLine := TopLine TO TopLine + ScrLines - 1 DO BEGIN
    PhLine := CLine - TopLine + 1;
    IF CLine > Max_Msg_Lines THEN BEGIN
      Reposition;
      OutTxt(4,C.TextBack,'-- Message Limit --');
      PhyLine[PhLine] := '-- Message Limit --';
      sClrEol;
    END ELSE BEGIN
      IF TBuff^[CLine] <> PhyLine[PhLine] THEN BEGIN
        Reposition;
        Set_Color(C.MsgColor,C.TextBack);
        IF CurLength > 0 THEN sWrite(TBuff^[CLine]);
        IF CurLength < LENGTH(PhyLine[PhLine]) THEN sClrEol;
        Set_PhyLine;
      END;
    END;
  END;
  CCol  := PCol;
  CLine := PLine;
  Reposition;
END;

PROCEDURE Scroll_Screen(Lines : INTEGER);
BEGIN
  INC(Topline,Lines);
  IF (CLine < TopLine) OR (CLine >= TopLine + ScrLines) THEN TopLine := CLine - ScrLines DIV 2;
  IF TopLine < 1 THEN TopLine := 1 ELSE
  IF TopLine >= Max_Msg_Lines THEN DEC(Topline,ScrollSiz DIV 2);
  Refresh_Screen;
END;

PROCEDURE Cursor_Up;
BEGIN
  IF CLine > 1 THEN DEC(CLine);
  IF CLine < TopLine THEN Scroll_Screen( - ScrollSiz) ELSE Reposition;
END;

PROCEDURE Cursor_Down;
BEGIN
  INC(CLine);
  IF (CLine >= Max_Msg_Lines) THEN CLine := Max_Msg_Lines;
  IF (CLine - TopLine >= ScrLines) THEN Scroll_Screen(ScrollSiz) ELSE Reposition;
END;

PROCEDURE Cursor_EndLine;
BEGIN
  CCol := 79;
  Reposition;
END;

PROCEDURE Cursor_BegLine;
BEGIN
  CCol := 1;
  Reposition;
END;

PROCEDURE Cursor_Left;
BEGIN
  IF CCol = 1 THEN BEGIN
    Cursor_Up;
    Cursor_Endline;
  END ELSE BEGIN
    DEC(CCol);
    sGotoXY(Where_X - 1,Where_Y);
  END;
END;

PROCEDURE Cursor_Right;
BEGIN
  IF CCol > CurLength THEN BEGIN
    CCol := 1;
    Cursor_Down;
  END ELSE BEGIN
    Set_Color(C.MsgColor,C.TextBack);
    sWrite(CurChar);
    INC(CCol);
  END;
END;

PROCEDURE Cursor_WordRight;
BEGIN
  IF Delimiter THEN BEGIN
    REPEAT
      Cursor_Right;
      IF Line_Boundry THEN EXIT;
    UNTIL NOT Delimiter;
  END ELSE BEGIN
    REPEAT
      Cursor_Right;
      IF Line_Boundry THEN EXIT;
    UNTIL Delimiter;
    Cursor_WordRight;
  END;
END;

PROCEDURE Cursor_WordLeft;
BEGIN
  IF Delimiter THEN BEGIN
    REPEAT
      Cursor_Left;
      IF Line_Boundry THEN EXIT;
    UNTIL NOT Delimiter;
    REPEAT
      Cursor_Left;
      IF Line_Boundry THEN EXIT;
    UNTIL Delimiter;
    Cursor_Right;
  END ELSE BEGIN
    REPEAT
      Cursor_Left;
      IF Line_Boundry THEN EXIT;
    UNTIL Delimiter;
    Cursor_Wordleft;
  END;
END;

PROCEDURE Join_Lines;
BEGIN
  IF (CurLength + LENGTH(TBuff^[CLine + 1])) >= 79 THEN EXIT;
  IF (LastChar <> ' ') THEN Append_Space;
  TBuff^[CLine] := TBuff^[CLine] + TBuff^[CLine + 1];
  INC(CLine);
  Delete_Line;
  DEC(CLine);
  Refresh_Screen;
END;

PROCEDURE Split_Line;
VAR
  PCol : INTEGER;
BEGIN
  PCol := CCol;
  Remove_Trailing;
  Par := COPY(TBuff^[CLine],CCol,79);
  TBuff^[CLine][0] := CHR(CCol - 1);
  Update_Eol;
  CCol := 1;
  INC(CLine);
  Insert_Line(Par);
  IF CLine - TopLine > ScrLines - 2 THEN Scroll_Screen(ScrollSiz) ELSE Refresh_Screen;
  DEC(CLine);
  CCol := PCol;
END;

PROCEDURE Cursor_NewLine;
BEGIN
  IF Insert_Mode THEN Split_Line;
  CCol := 1;
  Cursor_Down;
END;

PROCEDURE Reformat_Paragraph;
BEGIN
  Remove_Trailing;
  CCol := CurLength;
  WHILE CurChar <> ' ' DO BEGIN
    REPEAT
      INC(CLine);
      Remove_Trailing;
      CCol := 1;
      WHILE CurChar <> ' ' DO INC(CCol);
      DEC(CLine);
      IF (CCol > 1) AND (CCol + CurLength < WWrap) THEN BEGIN
        IF CurLength > 0 THEN BEGIN
          CASE LastChar OF
            '.','?','!' : Append_Space;
          END;
          Append_Space;
        END;
        TBuff^[CLine] := TBuff^[CLine] + COPY(TBuff^[CLine + 1],1,CCol - 1);
        INC(CLine);
        WHILE (CurChar = ' ') AND (CCol <= CurLength) DO INC(CCol);
        DELETE(TBuff^[CLine],1,CCol - 1);
        IF CurLength = 0 THEN Delete_Line;
        DEC(CLine);
      END ELSE CCol := 0;
    UNTIL CCol = 0;
    INC(CLine);
    CCol := 1;
    Remove_Trailing;
  END;
END;

PROCEDURE Visual_Reformat;
VAR
  PLine : INTEGER;
BEGIN
  PLine := CLine;
  Reformat_Paragraph;
  WHILE (CurLength = 0) AND (CLine <= LineCnt) DO INC(CLine);
  WHILE CLine - TopLine > ScrLines - 2 DO BEGIN
    INC(TopLine,ScrollSiz);
    PLine := TopLine;
  END;
  Refresh_Screen;
END;

PROCEDURE Word_Wrap;
VAR
  PCol  : INTEGER;
  PLine : INTEGER;
BEGIN
  PCol  := CCol;
  PLine := CLine;
  CCol  := CurLength;
  IF CurChar = ' ' THEN BEGIN
    Cursor_NewLine;
    EXIT;
  END;
  WHILE (CCol > 0) AND (CurChar <> ' ') DO DEC(CCol);
  IF CCol = 0 THEN BEGIN
    CCol := 1;
    Cursor_Down;
    EXIT;
  END;
  Par := COPY(TBuff^[CLine],CCol + 1,79);
  TBuff^[CLine][0] := CHR(CCol);
  Update_Eol;
  INC(CLine);
  Insert_Line(Par);
  Reformat_Paragraph;
  CLine := PLine;
  IF PCol > CurLength THEN BEGIN
    CCol := PCol - CurLength - 1;
    Cursor_Down;
  END ELSE CCol := PCol;
  IF (CLine - TopLine >= ScrLines) THEN Scroll_Screen(ScrollSiz)
                                   ELSE Refresh_Screen;
END;

PROCEDURE Insert_Char(Ch : CHAR);
BEGIN
  IF CCol < CurLength THEN Remove_Trailing;
  IF (Insert_Mode AND (CurLength = WWrap)) OR (CCol > WWrap) THEN BEGIN
    IF (CCol <= WWrap) THEN
      Word_Wrap
    ELSE IF Ch = ' ' THEN BEGIN
      Cursor_NewLine;
      EXIT;
    END ELSE Word_Wrap;
  END;
  Count_Lines;
  IF Insert_Mode AND (CCol <= CurLength) THEN BEGIN
    INSERT(Ch,TBuff^[cline],ccol);
    Set_Color(C.MsgColor,C.TextBack);
    sWrite(COPY(TBuff^[CLine],CCol,79));
    INC(CCol);
    Reposition;
  END ELSE BEGIN
    WHILE CurLength < CCol DO Append_Space;
    TBuff^[CLine][CCol] := Ch;
    Cursor_Right;
  END;
  Set_Phyline;
END;

PROCEDURE Delete_Char;
BEGIN
  IF CCol > CurLength THEN Join_Lines ELSE
  IF CCol <= CurLength THEN BEGIN
    DELETE(TBuff^[CLine],CCol,1);
    Set_Color(C.MsgColor,C.TextBack);
    sWrite(COPY(TBuff^[CLine],CCol,79));
    sWrite(' ');
    Reposition;
    Set_Phyline;
  END;
END;

PROCEDURE Delete_WordRight;
BEGIN
  IF CurChar = ' ' THEN REPEAT
    Delete_Char;
  UNTIL (CurChar <> ' ') OR (CCol > CurLength) ELSE REPEAT
    Delete_Char;
  UNTIL Delimiter;
END;

PROCEDURE Cursor_Tab;
BEGIN
  REPEAT
    Insert_Char(' ');
  UNTIL (CCol MOD 8) = 0;
END;

PROCEDURE Page_Down;
BEGIN
  IF Topline + ScrLines < Max_Msg_Lines THEN BEGIN
    INC(CLine,ScrollSiz);
    Scroll_Screen(ScrollSiz);
  END;
END;

PROCEDURE Page_Up;
BEGIN
  IF TopLine > 1 THEN BEGIN
    DEC(CLine,ScrollSiz);
    IF CLine < 1 THEN Cline := 1;
    Scroll_Screen( - ScrollSiz);
  END;
END;

PROCEDURE Visual_Insert_Line;
BEGIN
  Insert_Line('');
  IF CLine - TopLine > ScrLines - 2 THEN Scroll_Screen(ScrollSiz)
                                    ELSE Refresh_Screen;
END;

PROCEDURE Visual_Delete_Line;
BEGIN
  Delete_Line;
  Refresh_Screen;
END;

PROCEDURE Display_Insert_Status;
BEGIN
  sGotoXY(61,3);
  sClrEol;
  IF Insert_Mode THEN BEGIN
    CvtTokens('{1}  {5}Insert Mode  {1}',3);
  END ELSE BEGIN
    CvtTokens('{1} {5}OverType Mode {1}',3);
  END;
END;

PROCEDURE Prepare_Screen;
VAR
  I : INTEGER;
BEGIN
  sClrScr;
  Linenum := 1;
  sGotoXY(1,1);
  FOR I := 1 TO 79 DO OutTxt(9,C.TextBack,'');
  sGotoXY(61,2);
  CvtTokens('{1}Ŀ',3);
  Display_Insert_Status;
  sGotoXY(61,4);
  CvtTokens('{1} ({4}Ctrl-K{1})={5}Help {1}',3);
  sGotoXY(61,5);
  CvtTokens('{1}({4}Ctrl-Z{1})={5}Save{1}',3);
  sGotoXY(1,6);
  FOR I := 1 TO 79 DO OutTxt(9,C.TextBack,'');
  FOR I := 1 TO Scrlines DO PhyLine[I] := '';
  sGotoXY(1,24);
  FOR I := 1 TO 79 DO OutTxt(9,C.TextBack,'');
  PLeft := - 1;
  Scroll_Screen(0);
END;

PROCEDURE ReDisplay;
BEGIN
  TopLine := CLine - ScrLines DIV 2;
  Prepare_Screen;
END;

PROCEDURE DispHelp;
BEGIN
  sGotoXY(1,scrsize - 7);
  sClrEol;
  CvtTokens('{1}͵{14}Cursor Movement{1}͵{14}Delete{1}͵{14}Miscellaneous{1}͸',3);
  sGotoXY(1,scrsize - 6);
  sClrEol;
  CvtTokens('{1} {4}^S {5}Crsr Left   {4}^D {5}Crsr Right  {1}  {4}^G {5}Delete      {1}   '+
            '{4}^B {5}Reformat Paragraph   {1}',3);
  sGotoXY(1,scrsize - 5);
  sClrEol;
  CvtTokens('{1} {4}^A {5}Word Left   {4}^F {5}Word Right  {1}  {4}^J {5}Join Lines  {1}   '+
            '{4}^V {5}OverType/Insert Mode {1}',3);
  sGotoXY(1,scrsize - 4);
  sClrEol;
  CvtTokens('{1} {4}^E {5}Crsr Up     {4}^X {5}Crsr Down   {1}  {4}^T {5}Delete Word {1}   '+
            '{4}^Q {5}Abort Message        {1}',3);
  sGotoXY(1,scrsize - 3);
  sClrEol;
  CvtTokens('{1} {4}^I {5}Tab         {4}^P {5}End         {1}  {4}^Y {5}Delete Line {1}   '+
            '{4}^Z {5}Save and Exit        {1}',3);
  sGotoXY(1,scrsize - 2);
  sClrEol;
  CvtTokens('{1}͵{14}Scrolling{1}͵{14}Import{1}͵',3);
  sGotoXY(1,scrsize - 1);
  sClrEol;
  CvtTokens('{1} {4}^R {5}Page Up     {4}^C {5}Page Down   {1}  {4}^U {5}Upload Text '+
            '{1}  {14}BBS Utiliteez Software!  {1}',3);
  sGotoXY(1,scrsize);
  sClrEol;
  CvtTokens('{1}',3);
END;

PROCEDURE DoHelp;
BEGIN
  HelpOn := NOT HelpOn;
  IF HelpOn THEN BEGIN
    Prepare_Screen;
    DispHelp;
    ScrLines := 17 - 8;
    ScrollSiz := 13 - 8;
    Scroll_Screen(0);
  END ELSE BEGIN
    sClrScr;
    ScrLines := 17;
    ScrollSiz := 13;
    Prepare_Screen;
  END;
END;

FUNCTION Visual_Edit : BOOLEAN;
VAR
  Key    : CHAR;
  I      : INTEGER;
  St     : STRING[79];
  F      : TEXT;
  ButNum : BYTE;
BEGIN
  LineCnt := 1;
  CLine   := LineCnt;
  CCol    := CurLength + 1;
  TopLine := 1;
  WHILE (CLine - TopLine) > (ScrollSiz + 3) DO INC(TopLine,ScrollSiz);
  Prepare_Screen;
  REPEAT
    PlaceCursor;
    Key := ReadKey;
    EraseCursor;
    TimeSlice;
    IF Key = #0 THEN BEGIN
      Key := ReadKey;
      CASE Key OF
        #71 : Key := ^L; {Home}
        #72 : Key := ^E; {UpArrow}
        #73 : Key := ^R; {PgUp}
        #75 : Key := ^S; {LeftArrow}
        #77 : Key := ^D; {RightArrow}
        #79 : Key := ^P; {End}
        #80 : Key := ^X; {DownArrow}
        #81 : Key := ^C; {PgDn}
        #82 : Key := ^V; {Ins}
        #83 : Key := ^G; {Del}
        #115: Key := ^A; {Ctrl-Left}
        #116: Key := ^F; {Ctlr-Right}
        #132: BEGIN      {Ctrl-PgUp}
                CLine := 1;
                Scroll_Screen(0);
                Key := #0;
              END;
        #118: BEGIN      {Ctrl-PgDn}
                CLine := LineCnt;
                Scroll_Screen(0);
                Key := #0;
              END;
        ELSE Key := #0;
      END;
    END;
    CASE Key OF
      ^A : Cursor_WordLeft;
      ^B : Visual_Reformat;
      ^C : Page_Down;
      ^D : Cursor_Right;
      ^E : Cursor_Up;
      ^F : Cursor_WordRight;
      ^G : Delete_Char;
      ^I : Cursor_Tab;
      ^J : Join_Lines;
      ^K : DoHelp;
      ^L : Cursor_BegLine;
      ^M : Cursor_NewLine;
      ^N : BEGIN
             Split_Line;
             Reposition;
           END;
      ^O : Redisplay;
      ^P : Cursor_EndLine;
      ^R : Page_Up;
      ^S : Cursor_Left;
      ^T : Delete_WordRight;
      ^V : BEGIN
             Insert_Mode := NOT Insert_Mode;
             Display_Insert_Status;
             Reposition;
           END;
      ^X : Cursor_Down;
      ^Y : Visual_Delete_Line;
      #$7f,
      ^H : BEGIN
             Cursor_Left;
             IF Insert_Mode THEN Delete_Char;
           END;
      ^U : BEGIN {Import text}
             Draw_Window(93,215,550,277,1,3,'Full Path And File Name To Import');
             Entry_Field(104,246,5,60,'');
             Draw_Button(484,246,55,24,TRUE,4,'Okay');
             ShowMouse;
             REPEAT ButNum := MouseHandler(TRUE) UNTIL ButNum <> 0;
             HideMouse;
             St := StripBoth(Fields[1].Text,' ');
             Kill_Window;
             IF (St <> '') AND (FExist(St)) THEN BEGIN
               ASSIGN(F,St);
               RESET(F);
               WHILE (NOT EOF(F)) AND (LineCnt < 400) DO BEGIN
                 INC(LineCnt);
                 READLN(F,St);
                 TBuff^[LineCnt] := St;
               END;
               CLOSE(F);
               Scroll_Screen(0);
             END;
             MOVETO(xx,yy);
           END;
      #27: ;
      #32..#255 : Insert_Char(Key);
    END;
  UNTIL (Key = ^Q) OR (Key = ^Z);
  IF Key = ^Q THEN Visual_Edit := FALSE ELSE Visual_Edit := TRUE;
  ConvertIt       := TRUE;
  TextEditor.Done := TRUE;
END;

VAR
  F : TEXT;
  N : WORD;
BEGIN
  HelpOn             := FALSE;
  TextEditor.Running := TRUE;
  IF NOT Visual_Edit THEN EXIT;
  Count_Lines;
  IF LineCnt <> 0 THEN BEGIN
    ASSIGN(F,EditorFile);
    REWRITE(F);
    FOR N := 1 TO LineCnt DO WRITELN(F,TBuff^[N]);
    CLOSE(F);
  END;
END;
{}
PROCEDURE New_TextReader(X,Y : WORD);
BEGIN
  NEW(TBuff);
  FILLCHAR(TBuff^,SIZEOF(TBuff^),0);
  TextReader.Active  := TRUE;
  TextReader.Running := FALSE;
  TextReader.Lines   := 0;
  TextReader.X       := X;
  TextReader.Y       := Y;
  TextReader.Row     := Y + 5;
  TextReader.Col     := X + 5;
  TextReader.Last    := 1;
  {Text Reader Field & Frame}
  SETFILLSTYLE(1,C.TextBack); BAR(X,Y,X + 639,Y + 334);
  SETCOLOR(0); RECTANGLE(X,Y,X + 639,Y + 334);
  Draw_Button(575,Y + 346,20,72,TRUE,31,'');
  Draw_Button(606,Y + 346,20,80,TRUE,32,'');
END;
{}
PROCEDURE ShowTextPage;
VAR
  Loop   : INTEGER;
  Mem    : INTEGER;
  Cnt    : INTEGER;
  Row    : WORD;
  Flags  : BOOLEAN;
  Color  : BYTE;
BEGIN
  SETFILLSTYLE(1,C.TextBack);
  Cnt := 0;
  Mem := TextReader.Last;
  TextReader.Running := TRUE;
  TextReader.Row     := TextReader.Y + 5;
  FOR Loop := Mem TO TextReader.Lines DO BEGIN
    INC(Cnt);
    Color := C.MsgColor;
    Flags := FALSE;
    IF BBSmessages THEN BEGIN
      IF POS(#16,TBuff^[Loop]) = 1 THEN Flags := TRUE;
      IF (POS(#1,TBuff^[Loop]) < 6) AND (POS(#1,TBuff^[Loop]) > 0) THEN Color := C.MsgIDcolor;
      IF (POS('@',TBuff^[Loop]) < 6) AND (POS('@',TBuff^[Loop]) > 0) THEN Color := C.MsgIDcolor;
      IF (POS('>',TBuff^[Loop]) < 6) AND (POS('>',TBuff^[Loop]) > 0) THEN Color := C.QuoteColor;
      IF (POS('--- ',TBuff^[Loop]) = 1) OR (POS(' * Origin:',TBuff^[Loop]) = 1) THEN Color := C.TearColor;
      IF POS('... ',TBuff^[Loop]) = 1 THEN Color := C.QuoteColor;
    END;
    BAR(TextReader.Col,TextReader.Row,638,TextReader.Row + 13);
    IF NOT Flags THEN OutText_XY(TextReader.Col,TextReader.Row,Color,3,TBuff^[Loop])
                 ELSE OutText_XY(TextReader.Col,TextReader.Row,C.FlagColor,3,TBuff^[Loop]);
    TextReader.Last := Loop;
    IF (Cnt = 25) AND (TextReader.Last < TextReader.Lines) THEN BEGIN
      INC(TextReader.Last);
      EXIT;
    END;
    IF TextReader.Last < TextReader.Lines THEN INC(TextReader.Row,13);
    IF Loop = TextReader.Lines THEN BEGIN
      Row := TextReader.Row + 14;
      FOR Loop := Cnt TO 25 DO BEGIN
        IF Row > (TextReader.Y + 325) THEN EXIT;
        BAR(TextReader.Col,Row,638,Row + 13);
        INC(Row,13);
      END;
    END;
  END;
END;
{}
(*Procedure DrawPickListLocator; {I'll do this later...Maybe...}
VAR
  Work      : Word;
  Percent   : Real;
  Pixels    : Word;
  YRelative : Word;
  Loop      : Word;
  X2,Y2     : Word;
  Temp      : String;
BEGIN
  IF PickInfo.NumItems > PickInfo.ItemsOnScrn THEN BEGIN
    Work             := PickInfo.NumItems-PickInfo.ItemsOnScrn;
    Percent          := (PickInfo.Top-1)/Work;
    Pixels           := PickInfo.ItemsOnScrn-2;
    YRelative        := Round(Pixels*Percent);
    IF YRelative      = 0 THEN YRelative := 1;
    PickInfo.Locator := PickInfo.Y+YRelative;
  END ELSE PickInfo.Locator := PickInfo.y+1;
  {Scroll Bar}
  {FOR Loop := PickInfo.y+1 TO PickInfo.y+PickInfo.ItemsOnScrn-2 DO
  FastWrite('',Loop,PickInfo.x+PickInfo.MaxChars+2,Colours.ScrollBars);
  FastWrite('',PickInfo.Locator,PickInfo.x+PickInfo.MaxChars+2,(Colours.LocatorBack*16)+Colours.LocatorFore);}
END; *)
{}
PROCEDURE SetUp_Scroller;
VAR
  C,Loop : BYTE;
  R      : INTEGER;
BEGIN
  R := Scroller.Y + 1;
  C := Scroller.Top;
  HideMouse;
  FOR Loop := 1 TO 16 DO BEGIN
    SETFILLSTYLE(1,C);
    BAR(Scroller.X+1,R,Scroller.X+9,R+8);
    IF C = Scroller.Current THEN BEGIN
      SETCOLOR(255);
      RECTANGLE(Scroller.X+2,R+1,Scroller.X+8,R+7);
    END;
    INC(C);
    INC(R,10);
  END;
  ShowMouse;
END;
{}
PROCEDURE Palette_Scroller(X,Y : WORD);
VAR
  Loop : BYTE;
BEGIN
  Scroller.Active  := TRUE;
  Scroller.X       := X;
  Scroller.Y       := Y+10;
  Scroller.Top     := 0;
  Scroller.Current := 0;
  Scroller.Width   := X+10;
  User_Button(X,Y,11,11,72);
  SetColor(0);
  INC(Y,10);
  FOR Loop := 1 TO 16 DO BEGIN
    RECTANGLE(X,Y,X+10,Y+10);
    Scroller.Item[Loop] := Y;
    INC(Y,10);
  END;
  Scroller.Bottom := Y;
  User_Button(X,Y,11,11,80);
  SetUp_Scroller;
END;
{}
PROCEDURE New_PickList(X,Y,OnScreen,MaxChars : WORD);
VAR
  Loop  : WORD;
  Temp  : STRING;
  X2,Y2 : WORD;
BEGIN
  IF MaxChars > 80 THEN MaxChars := 80;
  IF OnScreen > 30 THEN OnScreen := 30;
  NEW(PickList);
  PickInfo.Active      := TRUE;
  PickInfo.Running     := FALSE;
  PickInfo.X           := X;
  PickInfo.Y           := Y;
  PickInfo.Top         := 1;
  PickInfo.NumItems    := 0;
  PickInfo.ItemsOnScrn := OnScreen;
  PickInfo.Current     := 1;
  PickInfo.MaxChars    := MaxChars;
 {PickInfo.Locator     := PickInfo.Y+1;}
  {Play area}
  Temp := '';
  REPEAT Temp := Temp + ' ' UNTIL LENGTH(Temp) = MaxChars;
  SETFILLSTYLE(1,C.TextBack);
  SETCOLOR(C.ButtonFrame);
  Y2 := Y;
  X2 := X + GemTextWidth(BPtr,Temp) + 11;
  PickInfo.Width := X2;
  FOR Loop := 1 TO PickInfo.ItemsOnScrn DO BEGIN
    PickInfo.Item[Loop] := Y2;
    BAR(X,Y2,X + GemTextWidth(BPtr,Temp) + 10,Y2 + 12);
    INC(Y2,13);
  END;
  PickInfo.Bottom := Y2;
  {Pseudo Scroll Bar}
  Y2 := Y;
  FOR Loop := 1 TO PickInfo.ItemsOnScrn DO INC(Y2,13);
  RaisedBox(X2,Y - 1,X2 + 9,Y2);
  {Scroll Bar Buttons}
  Draw_Button(X2,Y - 1,9,72,FALSE,0,'');
  Draw_Button(X2,Y2 - 20,9,80,FALSE,0,'');
  SETCOLOR(0);
  RECTANGLE(X - 1,Y - 1,X2,Y2);
  {DrawPickListLocator;}
END;
{}
PROCEDURE AddTo_PickList(InString : STRING);
VAR
  Temp : STRING;
BEGIN
  FILLCHAR(Temp,SIZEOF(Temp),#32);
  MOVE(InString[1],Temp[1],LENGTH(InString));
  Temp[0] := CHR(PickInfo.MaxChars);
  IF PickInfo.NumItems < 800 THEN BEGIN
    INC(PickInfo.NumItems);
    PickList^[PickInfo.NumItems] := Temp;
  END;
END;
{}
PROCEDURE SetUp_PickList;
VAR
  Loop : WORD;
  Y    : WORD;
  Cnt  : WORD;
  X2   : WORD;
  Temp : STRING;
BEGIN
  Temp := '';
  PickInfo.Running := TRUE;
  REPEAT Temp := Temp + ' ' UNTIL LENGTH(Temp) = PickInfo.MaxChars;
  X2   := GemTextWidth(BPtr,Temp) + 10;
  Cnt  := PickInfo.Top;
  Y    := PickInfo.Y;
  FOR Loop := 1 TO PickInfo.ItemsOnScrn DO BEGIN
    IF Cnt <= PickInfo.NumItems THEN BEGIN
      IF Cnt  = PickInfo.Current THEN BEGIN
        SETFILLSTYLE(1,C.PickHighBack); BAR(PickInfo.X,Y,PickInfo.X + X2,Y + 12);
        OutText_XY(PickInfo.X + 6,Y + 3,C.PickHighFore,1,PickList^[Cnt])
      END ELSE BEGIN
        SETFILLSTYLE(1,C.TextBack); BAR(PickInfo.X,Y,PickInfo.X + X2,Y + 12);
        OutText_XY(PickInfo.X + 6,Y + 3,C.MsgColor,1,PickList^[Cnt]);
      END;
    END ELSE;
    INC(Y,13);
    INC(Cnt);
  END;
END;
{}
PROCEDURE Reset_PickList(Item : WORD);
BEGIN
  PickInfo.Current := Item;
  PickInfo.Top     := Item;
  IF PickInfo.Top > (PickInfo.NumItems - PickInfo.ItemsOnScrn) THEN DEC(PickInfo.Top,(PickInfo.ItemsOnScrn - 1));
  IF (PickInfo.Top < 0) OR (PickInfo.Top > 800) THEN PickInfo.Top := 1;
END;
{}
PROCEDURE Entry_Field(X,Y,EType,ELength : WORD ; Stuff : STRING);
VAR
  St : STRING;
  X2 : WORD;
BEGIN
  ConvertIt := FALSE;
  INC(NFields);
  Fields[NFields].Active := FALSE;
  IF NFields = 1 THEN BEGIN
    Fields[NFields].Active  := TRUE;
    FieldNum                := 1;
  END;
  Fields[NFields].X         := X;
  Fields[NFields].Y         := Y;
  Fields[NFields].Text      := Stuff;
  Fields[NFields].CursorPos := LENGTH(Stuff) + 1;
  Fields[NFields].EType     := EType;
  Fields[NFields].ELength   := ELength;
  SETFILLSTYLE(1,C.FieldBack);
  X2 := ELength * 6;
  Fields[NFields].Width := Fields[NFields].X + X2;
  BAR(X,Y,X + X2 + 12,Y + 20);
  SETCOLOR(C.FieldFrame); RECTANGLE(X,Y,X + X2 + 12,Y + 20);
  IF FieldNum = NFields THEN BEGIN
    SETCOLOR(C.FieldHigh);
    RECTANGLE(X + 1,Y + 1,X + X2 + 11,Y + 19);
  END;
  St := COPY(Stuff,1,ELength);
  IF FieldNum = NFields THEN BEGIN
    OutText_XY(X + 6,Y + 7,C.FieldTextHigh,1,St);
    OutText_XY(X + 6 + GemTextWidth(BPtr,St),Y + 9,C.FieldTextHigh,1,#95);
  END ELSE OutText_XY(X + 6,Y + 7,C.FieldTextLow,1,St);
  ConvertIt := TRUE;
END;
{}
PROCEDURE RedrawField;
VAR
  St,
  Temp : STRING;
  X2,
  Ch,
  Loop : WORD;
BEGIN
  ConvertIt := FALSE;
  HideMouse;
  SETFILLSTYLE(1,C.FieldBack);
  St   := '';
  Temp := '';
  REPEAT St := St + ' ' UNTIL LENGTH(St) = Fields[FieldNum].ELength;
  IF Fields[FieldNum].EType = 4 THEN FOR Loop := 1 TO LENGTH(Fields[FieldNum].Text) DO Temp := Temp + '*';
  X2 := 6;
  IF Fields[FieldNum].EType = 4 THEN
  FOR Loop := 1 TO (Fields[FieldNum].CursorPos - 1) DO INC(X2,GemTextWidth(BPtr,Temp[Loop])) ELSE
  FOR Loop := 1 TO (Fields[FieldNum].CursorPos - 1) DO INC(X2,GemTextWidth(BPtr,Fields[FieldNum].Text[Loop]));
  BAR(Fields[FieldNum].X + 5,Fields[FieldNum].Y + 3,Fields[FieldNum].X + GemTextWidth(BPtr,St) + 10,Fields[FieldNum].Y + 18);
  IF Fields[FieldNum].EType <> 4 THEN
  OutText_XY(Fields[FieldNum].X + 6,Fields[FieldNum].Y + 7,C.FieldTextHigh,1,Fields[FieldNum].Text) ELSE
  OutText_XY(Fields[FieldNum].X + 6,Fields[FieldNum].Y + 7,C.FieldTextHigh,1,Temp);
  OutText_XY(Fields[FieldNum].X + X2,Fields[FieldNum].Y + 9,C.FieldTextHigh,1,#95);
  ShowMouse;
  ConvertIt := TRUE;
END;
{}
PROCEDURE ChangeField(Number : WORD);
VAR
  St   : STRING;
  X2,
  Ch,
  Loop : WORD;
BEGIN
  IF NFields <= 1 THEN EXIT;
  ConvertIt := FALSE;
  HideMouse;
  Fields[FieldNum].Active := FALSE;
  SETFILLSTYLE(1,C.FieldBack);
  St := '';
  REPEAT St := St + ' ' UNTIL LENGTH(St) = Fields[FieldNum].ELength;
  BAR(Fields[FieldNum].X,Fields[FieldNum].Y,Fields[FieldNum].X + GemTextWidth(BPtr,St) + 12,Fields[FieldNum].Y + 20);
  SETCOLOR(C.FieldFrame);
  RECTANGLE(Fields[FieldNum].X,Fields[FieldNum].Y,Fields[FieldNum].X + GemTextWidth(BPtr,St) + 12,Fields[FieldNum].Y + 20);
  IF Fields[FieldNum].EType = 4 THEN BEGIN
    St := '';
    FOR LOOP := 1 TO LENGTH(Fields[FieldNum].Text) DO St := St + '*';
    OutText_XY(Fields[FieldNum].X+6,Fields[FieldNum].Y+7,C.FieldTextLow,1,St);
  END ELSE OutText_XY(Fields[FieldNum].X+6,Fields[FieldNum].Y+7,C.FieldTextLow,1,Fields[FieldNum].Text);
  FieldNum := Number;
  Fields[FieldNum].Active := TRUE;
  St := '';
  REPEAT St := St + ' ' UNTIL LENGTH(St) = Fields[FieldNum].ELength;
  BAR(Fields[FieldNum].X,Fields[FieldNum].Y,Fields[FieldNum].X + GemTextWidth(BPtr,St) + 12,Fields[FieldNum].Y + 20);
  SETCOLOR(C.FieldFrame);
  RECTANGLE(Fields[FieldNum].X,Fields[FieldNum].Y,Fields[FieldNum].X + GemTextWidth(BPtr,St) + 12,Fields[FieldNum].Y + 20);
  SETCOLOR(C.FieldHigh);
  RECTANGLE(Fields[FieldNum].X+1,Fields[FieldNum].Y+1,Fields[FieldNum].X+GemTextWidth(BPtr,St)+11,Fields[FieldNum].Y+19);
  IF Fields[FieldNum].EType = 4 THEN BEGIN
    St := '';
    FOR LOOP := 1 TO LENGTH(Fields[FieldNum].Text) DO St := St + '*';
    OutText_XY(Fields[FieldNum].X+6,Fields[FieldNum].Y+7,C.FieldTextHigh,1,St);
  END ELSE OutText_XY(Fields[FieldNum].X+6,Fields[FieldNum].Y+7,C.FieldTextHigh,1,Fields[FieldNum].Text);
  X2 := 6;
  FOR Loop := 1 TO (Fields[FieldNum].CursorPos - 1) DO BEGIN
    IF Fields[FieldNum].EType = 4 THEN Ch := GemTextWidth(BPtr,St[Loop])
                                  ELSE Ch := GemTextWidth(BPtr,Fields[FieldNum].Text[Loop]);
    INC(X2,Ch);
  END;
  OutText_XY(Fields[FieldNum].X+X2,Fields[FieldNum].Y+9,C.FieldTextHigh,1,#95);
  ShowMouse;
  ConvertIt := TRUE;
END;
{}
PROCEDURE PressButton(Num : BYTE);
BEGIN
  HideMouse;
  IF Buttons[Num].ButtonType = 1 THEN BEGIN
  SETFILLSTYLE(1,C.ButtonFace);
  BAR(Buttons[Num].X,Buttons[Num].Y,Buttons[Num].X + Buttons[Num].Width,Buttons[Num].Y + 20);
  SETCOLOR(C.ButtonFrame); RECTANGLE(Buttons[Num].X,Buttons[Num].Y,Buttons[Num].X + Buttons[Num].Width,Buttons[Num].Y + 20);
  Draw_Line(Buttons[Num].X + 1,Buttons[Num].Y + 19,Buttons[Num].X + 1,Buttons[Num].Y + 1,C.ButtonLow);
  Draw_Line(Buttons[Num].X + 1,Buttons[Num].Y + 1,Buttons[Num].X + 1 + (Buttons[Num].Width-2),Buttons[Num].Y + 1,C.ButtonLow);
  Draw_Line(Buttons[Num].X + (Buttons[Num].Width - 1),Buttons[Num].Y + 2,
            Buttons[Num].X + (Buttons[Num].Width - 1),Buttons[Num].Y + 19,C.ButtonHigh);
  Draw_Line(Buttons[Num].X + (Buttons[Num].Width - 1),Buttons[Num].Y + 19,
            Buttons[Num].X + 2,Buttons[Num].Y + 19,C.ButtonHigh);
  OutText_XY(Buttons[Num].X + 7,Buttons[Num].Y + 4,C.ButtonText,2,Buttons[Num].Title);
  OutText_XY(Buttons[Num].X + 7,Buttons[Num].Y + 4,C.ButtonHot,2,COPY(Buttons[Num].Title,1,1));
  IF Buttons[Num].HasIcon THEN PutIcon16(Buttons[Num].IX + 1,Buttons[Num].IY + 1,Buttons[Num].Icon);
  END;
  IF Buttons[Num].ButtonType = 2 THEN PutIcon16(Buttons[Num].X,Buttons[Num].Y,99);
  IF Buttons[Num].ButtonType > 2 THEN FrameLow(Buttons[Num].X+1,
                                               Buttons[Num].Y+1,
                                               Buttons[Num].X+Buttons[Num].Width-1,
                                               Buttons[Num].Y+Buttons[Num].Height-1);
  ShowMouse;
END;
{}
PROCEDURE ReleaseButton(Num : BYTE);
BEGIN
  HideMouse;
  IF Buttons[Num].ButtonType = 1 THEN BEGIN
  SETFILLSTYLE(1,C.ButtonFace);
  BAR(Buttons[Num].X,Buttons[Num].Y,Buttons[Num].X + Buttons[Num].Width,Buttons[Num].Y + 20);
  SETCOLOR(C.ButtonFrame); RECTANGLE(Buttons[Num].X,Buttons[Num].Y,Buttons[Num].X + Buttons[Num].Width,Buttons[Num].Y + 20);
  Draw_Line(Buttons[Num].X + 1,Buttons[Num].Y + 19,Buttons[Num].X + 1,Buttons[Num].Y + 1,C.ButtonHigh);
  Draw_Line(Buttons[Num].X + 1,Buttons[Num].Y + 1,Buttons[Num].X + 1 + (Buttons[Num].Width-2),Buttons[Num].Y + 1,C.ButtonHigh);
  Draw_Line(Buttons[Num].X + (Buttons[Num].Width - 1),Buttons[Num].Y + 2,
            Buttons[Num].X + (Buttons[Num].Width - 1),Buttons[Num].Y + 19,C.ButtonLow);
  Draw_Line(Buttons[Num].X + (Buttons[Num].Width - 1),Buttons[Num].Y + 19,
            Buttons[Num].X + 2,Buttons[Num].Y + 19,C.ButtonLow);
  OutText_XY(Buttons[Num].X + 6,Buttons[Num].Y + 3,C.ButtonText,2,Buttons[Num].Title);
  OutText_XY(Buttons[Num].X + 6,Buttons[Num].Y + 3,C.ButtonHot,2,COPY(Buttons[Num].Title,1,1));
  IF Buttons[Num].HasIcon THEN PutIcon16(Buttons[Num].IX,Buttons[Num].IY,Buttons[Num].Icon);
  END;
  IF Buttons[Num].ButtonType = 2 THEN PutIcon16(Buttons[Num].X,Buttons[Num].Y,98);
  IF Buttons[Num].ButtonType > 2 THEN FrameHigh(Buttons[Num].X+1,
                                                Buttons[Num].Y+1,
                                                Buttons[Num].X+Buttons[Num].Width-1,
                                                Buttons[Num].Y+Buttons[Num].Height-1);
  ShowMouse;
END;
{}
PROCEDURE ProcessButton(xx,yy : WORD);
VAR
  Loop  : WORD;
BEGIN
  {SWITCH ENTRY FIELDS WITH THE MOUSE}
  IF NFields <> 0 THEN BEGIN
    FOR Loop := 1 TO NFields DO BEGIN
      IF (xx >= Fields[Loop].X) AND
         (xx <= Fields[Loop].Width+12) AND
         (yy >= Fields[Loop].Y) AND
         (yy <= Fields[Loop].Y + 20) THEN BEGIN
        IF Loop <> FieldNum THEN BEGIN
          HideMouse;
          ChangeField(Loop);
          ShowMouse;
          EXIT;
        END;
      END;
    END;
  END;
  {IF THE USER IS ON THE BUTTON, THEN PUSH THE BUTTON IMAGE DOWN}
  IF (LastPressed = 0) AND (NButtons <> 0) THEN BEGIN
    FOR Loop := 1 TO NButtons DO BEGIN
      IF (xx >= Buttons[Loop].X) AND (xx <= Buttons[Loop].X + Buttons[Loop].Width) THEN BEGIN
        IF (yy >= Buttons[Loop].Y) AND (yy <= Buttons[Loop].Y + Buttons[Loop].Height) THEN BEGIN
          LastPressed := Loop;
          PressButton(LastPressed);
          EXIT;
        END;
      END;
    END;
  END ELSE IF (LastPressed <> 0) THEN BEGIN
  {IF THE USER MOVED OFF OF THE BUTTON, THEN POP THE BUTTON IMAGE BACK UP}
    IF (xx < Buttons[LastPressed].X) OR
       (xx > Buttons[LastPressed].X + Buttons[LastPressed].Width) OR
       (yy < Buttons[LastPressed].Y) OR
       (yy > Buttons[LastPressed].Y+Buttons[LastPressed].Height) THEN BEGIN
       ReleaseButton(LastPressed);
       LastPressed := 0;
    END;
  END;
END;
{}
PROCEDURE ScrollPickPgUp;
VAR
  Temp : INTEGER;
BEGIN
  IF PickInfo.NumItems < PickInfo.ItemsOnScrn THEN EXIT;
  IF (PickInfo.Top > 1) THEN BEGIN
    Temp := PickInfo.Top - PickInfo.ItemsOnScrn;
    IF Temp < 1 THEN Temp := 1;
    PickInfo.Top := Temp;
    IF (PickInfo.Current < PickInfo.Top) THEN PickInfo.Current := PickInfo.Top
      ELSE IF (PickInfo.Current > PickInfo.Top + PickInfo.ItemsOnScrn - 1)
      THEN PickInfo.Current := PickInfo.Top + PickInfo.ItemsOnScrn - 1;
      HideMouse;
      {DrawPickListLocator;}
      SetUp_PickList;
      ShowMouse;
  END ELSE IF (PickInfo.Current <> 1) THEN BEGIN
    PickInfo.Top := 1;
    PickInfo.Current := 1;
    HideMouse;
    {DrawPickListLocator;}
    SetUp_PickList;
    ShowMouse;
  END;
END;
{}
PROCEDURE ScrollPickPgDown;
VAR
  Temp : INTEGER;
BEGIN
  IF PickInfo.NumItems < PickInfo.ItemsOnScrn THEN EXIT;
  IF ((PickInfo.Top + PickInfo.ItemsOnScrn - 1 ) < PickInfo.NumItems) THEN BEGIN
    Temp := PickInfo.Top + PickInfo.ItemsOnScrn;
    IF (Temp > (PickInfo.NumItems - PickInfo.ItemsOnScrn + 1)) THEN Temp := PickInfo.NumItems - PickInfo.ItemsOnScrn + 1;
    PickInfo.Top := Temp;
    IF (PickInfo.Current < PickInfo.Top) THEN PickInfo.Current := PickInfo.Top
      ELSE IF (PickInfo.Current > PickInfo.Top + PickInfo.ItemsOnScrn - 1)
      THEN PickInfo.Current := PickInfo.Top + PickInfo.ItemsOnScrn - 1;
      HideMouse;
      {DrawPickListLocator;}
      SetUp_PickList;
      ShowMouse;
  END ELSE IF (PickInfo.Current <> PickInfo.NumItems) THEN BEGIN
    PickInfo.Top := PickInfo.NumItems - PickInfo.ItemsOnScrn + 1;
    PickInfo.Current := PickInfo.NumItems;
    HideMouse;
    {DrawPickListLocator;}
    SetUp_PickList;
    ShowMouse;
  END;
END;
{}
PROCEDURE ScrollPickUp;
BEGIN
  IF PickInfo.Current > 1 THEN BEGIN
    DEC(PickInfo.Current);
    IF (PickInfo.Top > PickInfo.Current) THEN DEC(PickInfo.Top);
    HideMouse;
    {DrawPickListLocator;}
    SetUp_PickList;
    ShowMouse;
  END;
END;
{}
PROCEDURE ScrollPickDown;
BEGIN
  IF PickInfo.Current < PickInfo.NumItems THEN BEGIN
    INC(PickInfo.Current);
    IF (PickInfo.Current > PickInfo.Top + PickInfo.ItemsOnScrn - 1) THEN INC(PickInfo.Top);
    HideMouse;
    {DrawPickListLocator;}
    SetUp_PickList;
    ShowMouse;
  END;
END;
{}
PROCEDURE ShowMouse;
BEGIN
  IF MouseInstalled THEN Show_Mouse; {Redundant}
END;
{}
PROCEDURE HideMouse;
BEGIN
  IF MouseInstalled THEN Hide_Mouse; {Redundant}
END;
{}
FUNCTION _Mid(InString : STRING ; Starting,Ending : BYTE) : STRING;
VAR
  NumberOfChars : BYTE;
BEGIN
  IF Ending >= Starting THEN BEGIN
    NumberOfChars := Ending - Starting + 1;
   _Mid := COPY(InString,Starting,NumberOfChars);
  END ELSE _Mid := '';
END;
{}
PROCEDURE ClearKeyBuffer;
BEGIN
  MemW[$0000 : $041C] := MemW[$0000 : $041A];
END;
{}
FUNCTION MouseHandler(DoKeys : BOOLEAN) : BYTE;
VAR
  W         : BYTE;
  xx        : INTEGER;
  yy        : INTEGER;
  TheOne    : WORD;
  DidAPress : BOOLEAN;
  ThePress  : BYTE;
  Loop      : WORD;
PROCEDURE HandleKeys;
VAR
  ThePos : BYTE;
LABEL DnArrow;
BEGIN
  MC := READKEY;
  IF NFields = 0 THEN BEGIN
    IF ORD(MC) = 0 THEN BEGIN
      AltKey := TRUE;
      MC     := READKEY;
      ClearKeyBuffer;
      IF (PickInfo.Active) OR (TextReader.Active) OR (Scroller.Active) THEN BEGIN
        CASE ORD(MC) OF
          72 : BEGIN {Up}
                 IF PickInfo.Active THEN ScrollPickUp;
                 IF TextReader.Active THEN BEGIN
                   DEC(TextReader.Last,26);
                   IF TextReader.Last < 1 THEN TextReader.Last := 1;
                   HideMouse;
                   ShowTextPage;
                   ShowMouse;
                 END;
                 IF Scroller.Active THEN BEGIN
                   IF Scroller.Top >= 1 THEN DEC(Scroller.Top);
                   SetUp_Scroller;
                 END;
               END;
          80 : BEGIN {Down}
                 IF Pickinfo.Active THEN ScrollPickDown;
                 IF (TextReader.Active) AND (TextReader.Last <= TextReader.Lines) THEN BEGIN
                   DEC(TextReader.Last,24);
                   HideMouse;
                   ShowTextPage;
                   ShowMouse;
                 END;
                 IF Scroller.Active THEN BEGIN
                   IF Scroller.Top <= 238 THEN INC(Scroller.Top);
                   SetUp_Scroller;
                 END;
               END;
          73 : BEGIN {PgUp}
                 IF PickInfo.Active THEN ScrollPickPgUp;
                 IF TextReader.Active THEN BEGIN
                   DEC(TextReader.Last,50);
                   IF TextReader.Last < 1 THEN TextReader.Last := 1;
                   HideMouse;
                   ShowTextPage;
                   ShowMouse;
                 END;
                 IF Scroller.Active THEN BEGIN
                   IF Scroller.Top >= 16 THEN DEC(Scroller.Top,16) ELSE Scroller.Top := 0;
                   SetUp_Scroller;
                 END;
               END;
          81 : BEGIN {PgDn}
                 IF PickInfo.Active THEN ScrollPickPgDown;
                 IF (TextReader.Active) AND (TextReader.Last < TextReader.Lines) THEN BEGIN
                   HideMouse;
                   ShowTextPage;
                   ShowMouse;
                 END;
                 IF Scroller.Active THEN BEGIN
                   IF Scroller.Top <= 222 THEN INC(Scroller.Top,16) ELSE Scroller.Top := 239;
                   SetUp_Scroller;
                 END;
               END;
         132 : BEGIN {CTRL+PgUp}
                 IF PickInfo.Active THEN BEGIN
                   IF (PickInfo.Current <> 1) THEN BEGIN
                     PickInfo.Top := 1;
                     PickInfo.Current := 1;
                     HideMouse;
                     {DrawPickListLocator;}
                     SetUp_PickList;
                     ShowMouse;
                   END;
                 END;
                 IF TextReader.Active THEN BEGIN
                   TextReader.Last := 1;
                   HideMouse;
                   ShowTextPage;
                   ShowMouse;
                 END;
                 IF Scroller.Active THEN BEGIN
                   Scroller.Top := 0;
                   SetUp_Scroller;
                 END;
               END;
         118 : BEGIN {CTRL+PgDn}
                 IF PickInfo.Active THEN BEGIN
                   IF (PickInfo.NumItems > PickInfo.ItemsOnScrn) THEN BEGIN
                     IF (PickInfo.Top <> PickInfo.NumItems - PickInfo.ItemsOnScrn + 1) THEN BEGIN
                       PickInfo.Top := PickInfo.NumItems - PickInfo.ItemsOnScrn + 1;
                       PickInfo.Current := PickInfo.NumItems;
                       HideMouse;
                       {DrawPickListLocator;}
                       SetUp_PickList;
                       ShowMouse;
                     END;
                   END;
                 END;
                 IF TextReader.Active THEN BEGIN
                   TextReader.Last := TextReader.Lines - 24;
                   IF TextReader.Last < 1 THEN TextReader.Last := 1;
                   HideMouse;
                   ShowTextPage;
                   ShowMouse;
                 END;
                 IF Scroller.Active THEN BEGIN
                   Scroller.Top := 239;
                   SetUp_Scroller;
                 END;
               END;
               ELSE BEGIN
                 DidAPress := TRUE;
                 ThePress  := ORD(MC);
               END;
        END;
      END ELSE BEGIN
        DidAPress := TRUE;
        ThePress  := ORD(MC);
      END;
    END;
    EXIT;
  END;
  HideMouse;
  CASE ORD(MC) OF
    13 : BEGIN
           MC := #80;
           AltKey := TRUE;
           GOTO DnArrow;
         END;
     0 : BEGIN
           AltKey := TRUE;
           MC     := READKEY;
           ClearKeyBuffer;
           CASE ORD(MC) OF
            15,72 : BEGIN {SHIFT TAB & UpArrow}
                      IF FieldNum = 1 THEN ChangeField(NFields) ELSE ChangeField(FieldNum - 1);
                    END;
             80   : BEGIN {DownArrow}
                      DnArrow :
                      IF FieldNum = NFields THEN ChangeField(1) ELSE ChangeField(FieldNum + 1);
                    END;
             71   : BEGIN {HOME}
                      IF Fields[FieldNum].CursorPos <> 1 THEN BEGIN
                        Fields[FieldNum].CursorPos := 1;
                        RedrawField;
                      END;
                    END;
             79   : BEGIN {END}
                      IF Fields[FieldNum].CursorPos <> LENGTH(Fields[FieldNum].Text) + 1 THEN BEGIN
                        Fields[FieldNum].CursorPos := LENGTH(Fields[FieldNum].Text) + 1;
                        RedrawField;
                      END;
                    END;
             75   : BEGIN {Left}
                      IF (Fields[FieldNum].CursorPos > 1) THEN BEGIN
                        DEC(Fields[FieldNum].CursorPos);
                        RedrawField;
                      END;
                    END;
             77   : BEGIN {Right}
                      IF (Fields[FieldNum].CursorPos < LENGTH(Fields[FieldNum].Text) + 1) THEN BEGIN
                        INC(Fields[FieldNum].CursorPos);
                        RedrawField;
                      END;
                    END;
             83   : BEGIN {DELETE}
                      ThePos := Fields[FieldNum].CursorPos;
                      IF (ThePos <= LENGTH(Fields[FieldNum].Text)) THEN BEGIN
                        Fields[FieldNum].Text := _Mid(Fields[FieldNum].Text,1,ThePos - 1) +
                        _Mid(Fields[FieldNum].Text,ThePos + 1,LENGTH(Fields[FieldNum].Text));
                        RedrawField;
                      END;
                    END;
                    ELSE BEGIN
                      DidAPress := TRUE;
                      ThePress  := ORD(MC);
                      AltKey    := TRUE;
                    END;
           END;
         END;
     8 : BEGIN {BACKSPACE}
           ThePos := Fields[FieldNum].CursorPos;
           IF ThePos > 1 THEN BEGIN
             Fields[FieldNum].Text := _Mid(Fields[FieldNum].Text,1,ThePos - 2) +
             _Mid(Fields[FieldNum].Text,ThePos,LENGTH(Fields[FieldNum].Text));
             DEC(Fields[FieldNum].CursorPos);
             RedrawField;
           END;
           MC := #255;
         END;
     9 : BEGIN {TAB}
           IF FieldNum = NFields THEN ChangeField(1) ELSE ChangeField(FieldNum + 1);
           MC := #255;
         END;
   127 : BEGIN {Ctrl-Backspace}
           Fields[FieldNum].Text := '';
           Fields[FieldNum].CursorPos := 1;
           RedrawField;
           MC := #255;
         END;
         ELSE BEGIN
           IF (ORD(MC) > 31) AND (ORD(MC) < 128) THEN BEGIN
             IF (LENGTH(Fields[FieldNum].Text) < Fields[FieldNum].ELength) THEN BEGIN
               CASE Fields[FieldNum].EType OF
                 4,  {4-Secret Input}
                 0 : {0-Plain String}
                     BEGIN
                       ThePos := Fields[FieldNum].CursorPos;
                       Fields[FieldNum].Text := _Mid(Fields[FieldNum].Text,1,ThePos - 1) + MC +
                      _Mid(Fields[FieldNum].Text,ThePos,LENGTH(Fields[FieldNum].Text));
                       INC(Fields[FieldNum].CursorPos);
                     END;
                 1 : BEGIN {1-Plain Numeric}
                       IF ((ORD(MC) > 47) AND (ORD(MC) < 58)) THEN BEGIN
                         ThePos := Fields[FieldNum].CursorPos;
                         Fields[FieldNum].Text := _Mid(Fields[FieldNum].Text,1,ThePos - 1) + MC +
                        _Mid(Fields[FieldNum].Text,ThePos,LENGTH(Fields[FieldNum].Text));
                         INC(Fields[FieldNum].CursorPos);
                       END;
                     END;
                 2 : BEGIN {2-Proper String}
                       ThePos := Fields[FieldNum].CursorPos;
                       IF ThePos = 1 THEN MC := UPCASE(MC) ELSE BEGIN
                         IF (ThePos <> 2) THEN BEGIN
                           IF Fields[FieldNum].Text[ThePos - 1] = ' ' THEN MC := UPCASE(MC);
                         END;
                       END;
                       Fields[FieldNum].Text := _Mid(Fields[FieldNum].Text,1,ThePos - 1) + MC +
                      _Mid(Fields[FieldNum].Text,ThePos,LENGTH(Fields[FieldNum].Text));
                       INC(Fields[FieldNum].CursorPos);
                     END;
                 3 : BEGIN {3-Date/Phone}
                       IF (((ORD(MC) > 47)AND(ORD(MC) < 58))OR(MC = '-') OR (MC = '/') OR (MC = '(') OR (MC = ')')) THEN BEGIN
                         ThePos := Fields[FieldNum].CursorPos;
                         Fields[FieldNum].Text := _Mid(Fields[FieldNum].Text,1,ThePos - 1) + MC +
                        _Mid(Fields[FieldNum].Text,ThePos,LENGTH(Fields[FieldNum].Text));
                         INC(Fields[FieldNum].CursorPos);
                       END;
                     END;
                 5 : BEGIN {5-Upper Case}
                       MC := UPCASE(MC);
                       ThePos := Fields[FieldNum].CursorPos;
                       Fields[FieldNum].Text := _Mid(Fields[FieldNum].Text,1,ThePos - 1) + MC +
                      _Mid(Fields[FieldNum].Text,ThePos,LENGTH(Fields[FieldNum].Text));
                       INC(Fields[FieldNum].CursorPos);
                     END;
               END;
               RedrawField;
             END;
             MC := #255;
           END ELSE BEGIN
             DidAPress := TRUE;
             ThePress  := ORD(MC);
           END;
         END;
  END;
  ShowMouse;
END;
{}
BEGIN
  TimeSlice;
  DidAPress := FALSE;
  AltKey    := FALSE;
  MC        := #255;
  IF NFlips > 0 THEN BEGIN
    INC(IconCounter);
    IF IconCounter > NFlips THEN BEGIN
      IconCounter := 1;
      INC(FlipCounter);
      IF FlipCounter > 4 THEN FlipCounter := 1;
    END;
    CASE IconFlip[IconCounter].Size OF
      1 : PutIcon16(IconFlip[IconCounter].X,IconFlip[IconCounter].Y,IconFlip[IconCounter].Icon[FlipCounter]);
      2 : PutIcon30(IconFlip[IconCounter].X,IconFlip[IconCounter].Y,IconFlip[IconCounter].Icon[FlipCounter]);
      3 : PutIcon60(IconFlip[IconCounter].X,IconFlip[IconCounter].Y,IconFlip[IconCounter].Icon[FlipCounter]);
    END;
  END;
  IF ((KEYPRESSED) AND (DoKeys)) THEN HandleKeys;
  IF DidAPress THEN BEGIN
    IF (NButtons <> 0) THEN BEGIN
      FOR Loop := 1 TO NButtons DO BEGIN
        IF Buttons[Loop].Return = ThePress THEN BEGIN
          LastPressed  := Loop;
          MouseHandler := Loop;
          EXIT;
        END;
      END;
    END;
  END;
  W := 0;
  ReadMouse;
  IF MousePress(MouseLeftButton,MouseClickButton) = 1 THEN BEGIN
    xx := GetMx(MouseX);
    yy := GetMy(MouseY);
    IF (LastPressed <> 0) AND (Buttons[LastPressed].Holdable) THEN BEGIN
      IF (xx < Buttons[LastPressed].X) OR
         (xx > Buttons[LastPressed].X + Buttons[LastPressed].Width) OR
         (yy < Buttons[LastPressed].y) OR
         (yy > Buttons[LastPressed].Y + Buttons[LastPressed].Height) THEN BEGIN
         ReleaseButton(LastPressed);
         LastPressed := 0;
      END ELSE BEGIN
        IF (PickInfo.Active) OR (TextReader.Active) OR (Scroller.Active) THEN BEGIN
          IF (xx < Buttons[1].X) OR
             (xx > Buttons[1].X + Buttons[1].Width) OR
             (yy < Buttons[1].Y) OR
             (yy > Buttons[1].Y + Buttons[1].Height) THEN BEGIN
             IF (LastPressed < 3) AND (LastPressed > 1) THEN BEGIN
               IF PickInfo.Active THEN ScrollPickDown;
               IF (TextReader.Active) AND (TextReader.Last <= TextReader.Lines) THEN BEGIN
                 DEC(TextReader.Last,24);
                 HideMouse;
                 ShowTextPage;
                 ShowMouse;
               END;
               IF Scroller.Active THEN BEGIN
                 IF Scroller.Top <= 238 THEN INC(Scroller.Top);
                 SetUp_Scroller;
               END;
               W := LastPressed;
             END;
          END ELSE IF (xx < Buttons[2].X) OR
             (xx > Buttons[2].X + Buttons[2].Width) OR
             (yy < Buttons[2].Y) OR
             (yy > Buttons[2].Y + Buttons[2].Height) THEN BEGIN
             IF LastPressed < 2 THEN BEGIN
               IF PickInfo.Active THEN ScrollPickUp;
               IF TextReader.Active THEN BEGIN
                 DEC(TextReader.Last,26);
                 IF TextReader.Last < 1 THEN TextReader.Last := 1;
                 HideMouse;
                 ShowTextPage;
                 ShowMouse;
               END;
               IF Scroller.Active THEN BEGIN
                 IF Scroller.Top >= 1 THEN DEC(Scroller.Top);
                 SetUp_Scroller;
               END;
               W := LastPressed;
             END;
          END;
        END;
      END;
    END ELSE BEGIN
      ProcessButton(xx,yy);
      IF PickInfo.Active THEN BEGIN
        IF (xx >= PickInfo.X) AND
          (xx <= PickInfo.Width) AND
          (yy >= PickInfo.Y) AND
          (yy <= PickInfo.Bottom) THEN BEGIN
          FOR Loop := 1 TO PickInfo.ItemsOnScrn DO BEGIN
            IF (yy >= PickInfo.Item[Loop]) AND (yy <= PickInfo.Item[Loop] + 12)
            THEN TheOne := PickInfo.Top + (Loop - 1);
          END;
          IF TheOne <> PickInfo.Current THEN BEGIN
            IF (TheOne >= PickInfo.Top) AND
              (TheOne <= (PickInfo.Top + PickInfo.ItemsOnScrn - 1)) THEN BEGIN
              IF TheOne <= PickInfo.NumItems THEN BEGIN
                PickInfo.Current := TheOne;
                HideMouse;
                SetUp_PickList;
                ShowMouse;
              END;
            END;
          END;
        END;
      END;
      IF Scroller.Active THEN BEGIN
        IF (xx >= Scroller.X) AND
          (xx <= Scroller.Width) AND
          (yy >= Scroller.Y) AND
          (yy <= Scroller.Bottom) THEN BEGIN
          FOR Loop := 1 TO 16 DO BEGIN
            IF (yy >= Scroller.Item[Loop]) AND (yy <= Scroller.Item[Loop] + 9) THEN BEGIN
              Scroller.Current := Scroller.Top + (Loop - 1);
              SetUp_Scroller;
            END;
          END;
        END;
      END;
    END;
  END ELSE BEGIN
    IF LastPressed <> 0 THEN BEGIN
      xx := GetMx(MouseX);
      yy := GetMy(MouseY);
      ReleaseButton(LastPressed);
      IF (xx < Buttons[LastPressed].X) OR
         (xx > Buttons[LastPressed].X + Buttons[LastPressed].Width) OR
         (yy < Buttons[LastPressed].Y) OR
         (yy > Buttons[LastPressed].Y + Buttons[LastPressed].Height) THEN W := 0 ELSE W := LastPressed;
         LastPressed := 0;
    END;
  END;
  MouseHandler := W;
END;
{}
PROCEDURE Show_Mem;
BEGIN
  SETFILLSTYLE(1,246); BAR(502,462,637,477);
  ShadowText(504,461,15,0,2,'Free Memory: ' + IntToStr(MEMAVAIL));
END;
{}
PROCEDURE InitPalette;
VAR
  P : RGBPaletteType;
  F : FILE OF RGBPaletteType;
BEGIN
  IF NOT FExist('PALETTE.DAT') THEN BEGIN
    ShutDownBgiGui;
    ErrorLog('CRITICAL ERROR: The File PALETTE.DAT is missing!',6,TRUE);
  END;
  ASSIGN(F,'PALETTE.DAT');
  RESET(F);
  READ(F,P);
  CLOSE(F);
  SetRGBblock(0,256,P);
END;
{}
PROCEDURE ResetGraphics;
BEGIN
  WITH C DO BEGIN
    Win1Back        := 243;
    Win4Back        := 233;
    Win1High        := 249;
    Win4High        := 244;
    Win1Low         := 233;
    Win4Low         := 234;
    Win1Frame1      := 247;
    Win1Frame2      := 237;
    Win4Frame       := 0;
    ActiveHdr       := 57;
    InactiveHdr     := 235;
    HdrTitle        := 15;
    ButtonFrame     := 0;
    ButtonFace      := 246;
    ButtonHigh      := 251;
    ButtonLow       := 238;
    ButtonHot       := 4;
    ButtonText      := 0;
    FrameHigh       := 249;
    FrameLow        := 237;
    BoxBack         := 246;
    BoxHigh         := 251;
    BoxLow          := 238;
    FieldTextHigh   := 15;
    FieldTextLow    := 165;
    FieldBack       := 1;
    FieldFrame      := 0;
    FieldHigh       := 9;
    QuoteColor      := 5;
    MsgColor        := 0;
    TearColor       := 1;
    FlagColor       := 4;
    MsgIDcolor      := 9;
    TextBack        := 247;
    PickHighFore    := 15;
    PickHighBack    := 1;
    ScreenColor     := 1;
  END;
  MouseGraphicCursor(MouseStandard);
  UnloadGemFont(FPtr);
  EditorFile        := 'TEXTFILE.TXT';
  IconLib16         := 'ICON_LIB.001';
  IconLib30         := 'ICON_LIB.002';
  IconLib60         := 'ICON_LIB.003';
  BBSmessages       := TRUE;
END;
{}
PROCEDURE Put_Image(X1,Y1 : WORD ; ImageFile : STRING);
CONST
  BufMax    = 4096 - 1;
  RLEcode   = 192; {C0h = 11000000}
TYPE
  tLine     = ARRAY[0..0] OF BYTE;
  tBuf      = ARRAY[0..BufMax] OF BYTE;
  tEGApal   = ARRAY[0..15] OF ARRAY[1..3] OF BYTE;
  tFiller   = ARRAY[0..52] OF BYTE;

  Max_Palette = RECORD
  Red         : BYTE;
  Green       : BYTE;
  Blue        : BYTE;
  END;

  PCXheader = RECORD
  Man       : BYTE;
  Ver       : BYTE;
  Encoding  : BYTE;
  Bpp       : BYTE;
  X1,Y1     : INTEGER;
  X2,Y2     : INTEGER;
  Xdpi      : INTEGER;
  Ydpi      : INTEGER;
  EGApal    : tEGApal;
  _Ignored_ : BYTE;
  Planes    : BYTE;
  Bpl       : INTEGER;
  PalType   : INTEGER;
  HScrMax   : INTEGER;
  VscrMax   : INTEGER;
  _Filler_  : tFiller;
  END;

VAR
  F         : FILE;
  R         : WORD;
  Buf       : ^tBuf;
  BufPos    : WORD;
  BufSize   : WORD;
  _Line     : ^tLine;
  Z         : INTEGER;
  LinePos   : INTEGER;
  LineSize  : INTEGER;
  CurLine   : INTEGER;
  Hdr       : PCXheader;
  Pal       : ARRAY[0..767] OF BYTE;
  NewPal    : ARRAY[0..255] OF BYTE;
  ThePal    : ARRAY[0..255] OF Max_Palette;
  ID,B      : BYTE;
{}
PROCEDURE AdjustPalette; {This procedure courtesy of Sean Price 1:205/46}
VAR
  F     : FILE OF Max_Palette;
  Color : BYTE;
  Red   : BYTE;
  Green : BYTE;
  Blue  : BYTE;
  A,
  Mavg,
  Pavg  : INTEGER;
  B,C,D : BYTE;
  Exact : BOOLEAN;
BEGIN
  B := 0;
  C := 0;
  ASSIGN(F,'PALETTE.DAT');
  RESET(F);
  FOR A := 0 TO 255 DO READ(F,ThePal[A]);
  CLOSE(F);
  FOR A := 0 TO 767 DO BEGIN
    INC(B);
    CASE B OF
      1 : Red   := Pal[A];
      2 : Green := Pal[A];
      3 : BEGIN
            Blue  := Pal[A];
            Exact := FALSE;
            FOR D := 0 TO 255 DO BEGIN
              IF (ThePal[D].Red = Red) AND 
                 (ThePal[D].Green = Green) AND 
                 (ThePal[D].Blue = Blue) THEN BEGIN
                NewPal[C] := D;
                Exact := TRUE;
                BREAK;
              END;
            END;
            IF NOT Exact THEN BEGIN {Feel free to optimize/perfect this!}
              Pavg := 999;  {prime old average with impossible value}
              FOR D := 0 TO 255 DO BEGIN
                Mavg := ABS(ThePal[D].Red - Red) +
                        ABS(ThePal[D].Green - Green) +
                        ABS(ThePal[D].Blue - Blue);   {get pallette average}
                IF (Mavg < Pavg) THEN BEGIN  {if closer than old average}
                  Pavg := Mavg;              {set old average to it}
                  NewPal[C] := D;            {set color index to new color}
                END;
              END;
            END;
            B := 0;
            INC(C);
          END;
    END;
  END;
END;
{}
FUNCTION DefaultHdrFunc : INTEGER;
BEGIN
  WITH Hdr DO IF (Man <> 10) OR
                 (Encoding <> 1) OR
                 (Bpp <> 8) OR
                 (Planes <> 1) THEN DefaultHdrFunc := 1
                               ELSE DefaultHdrFunc := 0;
END;
{}
FUNCTION NextByte : BYTE;
BEGIN
  IF BufPos < BufSize THEN BEGIN
    NextByte := Buf^[BufPos];
    INC(BufPos);
  END ELSE BEGIN
    BLOCKREAD(F,Buf^,SIZEOF(Buf^),R);
    BufSize  := R;
    BufPos   := 1;
    NextByte := Buf^[0];
  END;
END;
{}
BEGIN
  IF NOT FExist(ImageFile) THEN BEGIN
    ShadowText(X1+2,Y1+2,15,0,1,ImageFile+' Not Found!');
    EXIT;
  END;
  Buf   := NIL;
  _Line := NIL;
  FILLCHAR(Pal,768,0);
  ASSIGN(F,ImageFile);
  RESET(F,1);
  BLOCKREAD(F,Hdr,128,R);
  IF DefaultHdrFunc <> 0 THEN BEGIN
    ShadowText(X1+2,Y1+2,15,0,1,ImageFile+' Is An Invalid PCX!');
    CLOSE(F);
    EXIT;
  END;
  SEEK(F,FILESIZE(F) - 769);
  BLOCKREAD(F,ID,1,R);
  IF ID = 12 THEN BEGIN
    BLOCKREAD(F,Pal,768,R);
    FOR R := 0 TO 767 DO Pal[R] := Pal[R] SHR 2;
    AdjustPalette;
  END;
  SEEK(F,128);
  LineSize := Hdr.X2 - Hdr.X1 + 1;
  LinePos  := 0;
  CurLine  := 0;
  GETMEM(_Line,LineSize);
  NEW(Buf);
  BufPos   := 0;
  BufSize  := 0;
  REPEAT
    B := NextByte;
    IF B < RLEcode THEN BEGIN
      _Line^[LinePos] := B;
      INC(LinePos);
    END ELSE BEGIN
      FILLCHAR(_Line^[LinePos],B - RLEcode,NextByte);
      INC(LinePos,B - RLEcode);
    END;
    IF LinePos >= LineSize THEN BEGIN
      FOR Z := 0 TO (LineSize-1) DO PutPixel(Z+X1,CurLine+Y1,NewPal[_Line^[Z]]);
      LinePos := 0;
      INC(CurLine);
    END;
  UNTIL CurLine > Hdr.Y2 - Hdr.Y1;
  IF Buf <> NIL THEN DISPOSE(Buf);
  IF _Line <> NIL THEN FREEMEM(_Line,LineSize);
  CLOSE(F);
END;
{}
BEGIN
  FlipCounter := 1;
  ConvertIt   := TRUE;
  WinTag      := '!';
  DetectOS;
  ResetGraphics;
END.
