{

              
            
               ͻ ͻ ͻ    ͻ ͻ
                    ˼ ͹ ͼ ͹     ͻ
                   ͼ          ͼ ͼ  v1.14

  The Universal Multimedia Interface For BBS Software
  Copyright 1995-1997 * Larry L. Athey * BBS Utiliteez Software


  Information Regarding MAX Graphics:
  
  Notice is hereby given that the MAXscript/MAXcontrol/MAXcolor language,
  and MAXterm are products of BBS Utiliteez Software and are protected by
  US copyrights listed with the US Library Of Congress (1996)....

  No changes, additions, subtractions, or other modifications shall be made
  to MAXscript/MAXcontrol/MAXcolor language or the MAX Graphics development
  kit without express written permission from Larry L. Athey, BBS Utiliteez
  Software, Alliance, Nebraska, USA....

  The MAXscript/MAXcontrol/MAXcolor language may be used in any BBS or Door
  software 100% royalty free. You are also allowed to implement full local
  graphics viewing in any BBS or Door software 100% royalty free. However,
  any program that uses the MAXscript/MAXcontrol/MAXcolor language *MUST*
  bear the MAX Graphics/BBS Utiliteez Software copyright notice....


  Example: MAX Graphics and the MAXscript/MAXcontrol/MAXcolor language is
           Copyright 1995-1997 * Larry L. Athey * BBS Utiliteez Software



  This is the SVGA ANSI display unit. This unit is not meant for use with
  ANSI screen files over 25 lines even though it can handle them.  If you
  need to display large ANSI screen files, you would be smarter to return
  to text mode all together and use  ANSIUNIT.PAS to display them because
  of the slowness involved in displaying them in graphics mode.               }

{$A+,B-,D+,E+,F+,G+,I-,L+,N-,O+,P-,Q-,R-,S-,T-,V+,X+}
UNIT SVGAANSI;

INTERFACE

USES GRAPH, SVGAUNIT, {*}GEMFONTU, CRT, _EXIT;

{Units marked with an asterisk are from the ULTRABGI.ZIP development kit.     }

PROCEDURE Display_ANSI(Ch : CHAR);
{^ Processes a character from an ANSI or ASCII text string.}
PROCEDURE Display_ANSIstr(S : STRING);
{^ Processes an entire ANSI or ASCII text string.}
PROCEDURE Clr_Scr;
{^ Equivalent to ClrScr in text mode.}
PROCEDURE Clr_Eol;
{^ Equivalent to ClrEol in text mode.}
PROCEDURE PlaceCursor;
{^ Plots a bogus cursor on the screen (for visual reference only).}
PROCEDURE EraseCursor;
{^ Erases the bogus cursor.}
PROCEDURE ResetANSI;
{^ Resets all variables in this unit.}

VAR
  RowLimit  : BYTE;    {Maximum number of text rows to display}
  ColLimit  : BYTE;    {Maximum number of text columns to display}
  StartX    : INTEGER; {ANSI window upper left X SVGA coordinate}
  StartY    : INTEGER; {ANSI window upper left Y SVGA coordinate}
  Where_X   : BYTE;    {Equivalent to WhereY in text mode}
  Where_Y   : BYTE;    {Equivalent to WhereX in text mode}
  ANSI_FG   : INTEGER; {Stores current foreground color}
  ANSI_BG   : INTEGER; {Stores current background color}

IMPLEMENTATION

VAR
  ANSI_St   : STRING ; {Stores ANSI escape sequence if receiving ANSI}
  ANSI_SCPL : INTEGER; {Stores the saved cursor position line}
  ANSI_SCPC : INTEGER; {   "     "     "     "     "   column}
  ANSI_C,
  ANSI_I,
  ANSI_B,
  ANSI_R    : BOOLEAN; {Stores current attribute options}
  P,X,Y     : INTEGER; {Miscellaneous private variables}
  ChArray   : ARRAY[1..80,1..25] OF CHAR;
  FgArray   : ARRAY[1..80,1..25] OF BYTE;
  BgArray   : ARRAY[1..80,1..25] OF BYTE; {Arrays for scrolling the screen}

PROCEDURE Goto_XY(X1,Y1 : BYTE);
BEGIN
  Where_X := X1;
  Where_Y := Y1;
END;

PROCEDURE Clr_Scr;
VAR
  XX : BYTE;
BEGIN
  FILLCHAR(ChArray,SIZEOF(ChArray),0);
  FILLCHAR(FgArray,SIZEOF(FgArray),0);
  FILLCHAR(BgArray,SIZEOF(BgArray),0);
  Where_X := 1;
  Where_Y := 1;
  SETFILLSTYLE(1,ANSI_BG);
  BAR(StartX,StartY,(ColLimit*8)+StartX,(RowLimit*14)+StartY);
END;

PROCEDURE Clr_Eol;
VAR
  X,EndX,EndY : BYTE;
BEGIN
  FOR X := Where_X TO 80 DO BEGIN
    ChArray[X,Where_Y] := ' ';
    FgArray[X,Where_Y] := 0;
    BgArray[X,Where_Y] := 0;
  END;
  SETFILLSTYLE(1,ANSI_BG);
  BAR(((Where_X*8)+StartX)-8,((Where_Y*14)+StartY)-14,((ColLimit*8)+StartX)-8,((Where_Y*14)+(StartY+13))-14);
END;

PROCEDURE ScrollScreen;
VAR
  SX,SY : BYTE;
BEGIN
  FOR SY := 1 TO (Where_Y-1) DO BEGIN
    FOR SX := 1 TO 80 DO BEGIN
      ChArray[SX,SY] := ChArray[SX,SY+1];
      FgArray[SX,SY] := FgArray[SX,SY+1];
      BgArray[SX,SY] := BgArray[SX,SY+1];
    END;
  END;
  Clr_Eol;
  FOR SY := 1 TO (Where_Y-1) DO BEGIN
    FOR SX := 1 TO ColLimit DO BEGIN
      SETFILLSTYLE(1,BgArray[SX,SY]);
      BAR(((SX*8)+StartX)-8,((SY*14)+StartY)-14,((SX*8)+StartX+7)-8,((SY*14)+StartY+13)-14);
      OutText_XY(((SX*8)+StartX)-8,((SY*14)+StartY)-14,FgArray[SX,SY],3,ChArray[SX,SY]);
    END;
  END;
END;

PROCEDURE _Write(Ch : CHAR);
BEGIN
  SETFILLSTYLE(1,ANSI_BG);
  BAR(((Where_X*8)+StartX)-8,((Where_Y*14)+StartY)-14,((Where_X*8)+StartX+7)-8,((Where_Y*14)+StartY+13)-14);
  OutText_XY(((Where_X*8)+StartX)-8,((Where_Y*14)+StartY)-14,ANSI_FG,3,Ch);
  ChArray[Where_X,Where_Y] := Ch;
  FgArray[Where_X,Where_Y] := ANSI_FG;
  BgArray[Where_X,Where_Y] := ANSI_BG;
  INC(Where_X);
  IF Where_X > ColLimit THEN BEGIN
    Where_X := 1;
    IF Where_Y <= (RowLimit-1) THEN INC(Where_Y) ELSE ScrollScreen;
  END;
END;

PROCEDURE Tabulate;
VAR
  X : INTEGER;
BEGIN
  X := Where_X;
  IF X < ColLimit THEN REPEAT INC(X) UNTIL (X MOD 8) = 0;
  IF X = ColLimit THEN X := 1;
  Goto_XY(X,Where_Y);
  IF X = 1 THEN IF Where_Y <= (RowLimit-1) THEN INC(Where_Y) ELSE ScrollScreen;
END;

PROCEDURE BackSpace;
VAR
  X : INTEGER;
BEGIN
  IF Where_X > 1 THEN BEGIN
    Goto_XY(Where_X - 1,Where_Y);
    _Write(' ');
    Goto_XY(Where_X - 1,Where_Y);
  END ELSE IF Where_Y > 1 THEN BEGIN
    Goto_XY(ColLimit,Where_Y - 1);
    _Write(' ');
    Goto_XY(ColLimit,Where_Y - 1);
  END;
END;

PROCEDURE TTY(Ch : CHAR);
VAR
  X : INTEGER;
BEGIN
  IF ANSI_C THEN BEGIN
    IF ANSI_I THEN ANSI_FG := ANSI_FG OR 8;
    IF ANSI_B THEN BEGIN
      ANSI_BG := ANSI_BG + 8;
      IF ANSI_BG > 15 THEN DEC(ANSI_BG,15);
    END;
    IF ANSI_R THEN BEGIN
      X := ANSI_FG;
      ANSI_FG := ANSI_BG;
      ANSI_BG := X;
    END;
    ANSI_C := FALSE;
  END;
  CASE Ch OF
    ^G : BEGIN
           SOUND(2000);
           DELAY(100);
           NOSOUND;
         END;
    ^H : Backspace;
    ^I : Tabulate;
    ^J : BEGIN {#10}
          {Where_X := 1;
           IF Where_Y <= (RowLimit-1) THEN INC(Where_Y) ELSE ScrollScreen;}
         END;
    ^K : BEGIN
           Goto_XY(1,1);
         END;
    ^L : Clr_Scr;
    ^M : BEGIN {#13}
           Where_X := 1;
           IF Where_Y <= (RowLimit-1) THEN INC(Where_Y) ELSE ScrollScreen;
         END;
    ELSE _Write(Ch);
  END;
END;

PROCEDURE ANSIWrite(S : STRING);
VAR
  X : INTEGER;
BEGIN
  IF (POS('[255D',S) > 0) THEN EXIT;
  IF (POS('[?',S) > 0) THEN ANSI_FG := ANSI_BG;
  FOR X := 1 TO LENGTH(S) DO TTY(S[X]);
END;

FUNCTION Param(Ch : CHAR) : INTEGER;
VAR
  S    : STRING;
  X,XX : INTEGER;
  B    : BOOLEAN;
BEGIN
  B := FALSE;
  FOR X := 3 TO LENGTH(ANSI_St) DO IF ANSI_St[X] IN ['0'..'9'] THEN B := TRUE;
  IF NOT B THEN Param := - 1
  ELSE BEGIN
    S := '';
    X := 3;
    IF ANSI_St[3] = ';' THEN BEGIN
      Param := 0;
      DELETE(ANSI_St,3,1);
      EXIT;
    END;
    REPEAT
      S := S + ANSI_St[X];
      X := X + 1;
    UNTIL (NOT (ANSI_St[X] IN ['0'..'9'])) OR (LENGTH(S) > 2) OR (X > LENGTH(ANSI_St));
    IF LENGTH(S) > 2 THEN BEGIN
      ANSIWrite(ANSI_St + Ch);
      ANSI_St := '';
      Param := - 1;
      EXIT;
    END;
    DELETE(ANSI_St,3,LENGTH(S));
    IF ANSI_St[3] = ';' THEN DELETE(ANSI_St,3,1);
    VAL(S,X,XX);
    Param := X;
  END;
END;

PROCEDURE Display_ANSI(Ch : CHAR);
BEGIN
  IF (Ch <> #27) AND (ANSI_St = '') THEN BEGIN
    TTY(Ch);
    EXIT;
  END;
  IF Ch = #27 THEN BEGIN
    IF ANSI_St <> '' THEN BEGIN
      ANSIWrite(ANSI_St + #27);
      ANSI_St := '';
    END ELSE ANSI_St := #27;
    EXIT;
  END;
  IF ANSI_St = #27 THEN BEGIN
    IF Ch = '[' THEN ANSI_St := #27 + '['
    ELSE BEGIN
      ANSIWrite(ANSI_St + Ch);
      ANSI_St := '';
    END;
    EXIT;
  END;
  IF (Ch = '[') AND (ANSI_St <> '') THEN BEGIN
    ANSIWrite(ANSI_St + '[');
    ANSI_St := '';
    EXIT;
  END;
  IF NOT (Ch IN ['0'..'9',';','A'..'D','f','H','J','K','m','s','u']) THEN BEGIN
    ANSIWrite(ANSI_St + Ch);
    ANSI_St := '';
    EXIT;
  END;
  IF Ch IN ['A'..'D','f','H','J','K','m','s','u'] THEN BEGIN
    CASE Ch OF
    'A' : BEGIN
            P := Param(Ch);
            IF P = - 1 THEN p := 1;
            IF Where_Y - P < 1 THEN Goto_XY(Where_X,1)
            ELSE Goto_XY(Where_X,Where_Y - P);
          END;
    'B' : BEGIN
            P := Param(Ch);
            IF P = - 1 THEN P := 1;
            IF Where_Y + P > RowLimit THEN Goto_XY(Where_X,RowLimit)
            ELSE Goto_XY(Where_X,Where_Y + P);
          END;
    'C' : BEGIN
            P := Param(Ch);
            IF P = - 1 THEN P := 1;
            IF Where_X + P > ColLimit THEN Goto_XY(ColLimit,Where_Y)
            ELSE Goto_XY(Where_X + P,Where_Y);
          END;
    'D' : BEGIN
            P := Param(Ch);
            IF P = - 1 THEN P := 1;
            IF Where_X - P < 1 THEN Goto_XY(1,Where_Y)
            ELSE Goto_XY(Where_X - P,Where_Y);
          END;
    'H',
    'f' : BEGIN
            Y := Param(Ch);
            X := Param(Ch);
            IF Y < 1 THEN Y := 1;
            IF X < 1 THEN X := 1;
            IF (X > ColLimit) OR (X < 1) OR (Y > RowLimit) OR (Y < 1) THEN BEGIN
              ANSI_St := '';
              EXIT;
            END;
            Goto_XY(X,Y);
          END;
    'J' : BEGIN
            P := Param(Ch);
            IF P IN [0,1,2] THEN BEGIN
              ANSI_BG := 0;
              Clr_Scr;
            END;
          END;
    'K' : BEGIN
            ANSI_BG := 0;
            Clr_Eol;
          END;
    'm' : BEGIN
            IF ANSI_St = #27 + '[' THEN BEGIN
              ANSI_FG := 7;
              ANSI_BG := 0;
              ANSI_I  := FALSE;
              ANSI_B  := FALSE;
              ANSI_R  := FALSE;
            END;
            REPEAT
              P := Param(Ch);
              CASE P OF
               - 1 : ;
                 0 : BEGIN
                       ANSI_FG := 7;
                       ANSI_BG := 0;
                       ANSI_I  := FALSE;
                       ANSI_R  := FALSE;
                       ANSI_B  := FALSE;
                    END;
                1 : ANSI_I  := TRUE;
                5 : ANSI_B  := TRUE;
                7 : ANSI_R  := TRUE;
               30 : ANSI_FG := 0;
               31 : ANSI_FG := 4;
               32 : ANSI_FG := 2;
               33 : ANSI_FG := 6;
               34 : ANSI_FG := 1;
               35 : ANSI_FG := 5;
               36 : ANSI_FG := 3;
               37 : ANSI_FG := 7;
               40 : ANSI_BG := 0;
               41 : ANSI_BG := 4;
               42 : ANSI_BG := 2;
               43 : ANSI_BG := 6;
               44 : ANSI_BG := 1;
               45 : ANSI_BG := 5;
               46 : ANSI_BG := 3;
               47 : ANSI_BG := 7;
              END;
              IF ((P >= 30) AND (P <= 47)) OR (P = 1) OR (P = 5) OR (P = 7) THEN ANSI_C := TRUE;
            UNTIL P = - 1;
          END;
    's' : BEGIN
            ANSI_SCPL := Where_Y;
            ANSI_SCPC := Where_X;
          END;
    'u' : BEGIN
            IF ANSI_SCPL > - 1 THEN Goto_XY(ANSI_SCPC,ANSI_SCPL);
            ANSI_SCPL := - 1;
            ANSI_SCPC := - 1;
          END;
    END;
    ANSI_St := '';
    EXIT;
  END;
  IF Ch IN ['0'..'9',';'] THEN ANSI_St := ANSI_St + Ch;
  IF LENGTH(ANSI_St) > 50 THEN BEGIN
    ANSIWrite(ANSI_St);
    ANSI_St := '';
    EXIT;
  END;
END;

PROCEDURE Display_ANSIstr(S : STRING);
VAR
  Loop : BYTE;
BEGIN
  FOR Loop := 1 TO LENGTH(S) DO Display_ANSI(S[Loop]);
END;

PROCEDURE PlaceCursor;
BEGIN
  IF Where_X < 80 THEN OutText_XY(((Where_X*8)+StartX)-8,((Where_Y*14)+StartY)-14,15,3,'_');
END;

PROCEDURE EraseCursor;
BEGIN
  IF Where_X < 80 THEN OutText_XY(((Where_X*8)+StartX)-8,((Where_Y*14)+StartY)-14,ANSI_BG,3,'_');
END;

PROCEDURE ResetANSI;
BEGIN
  FOR X := 1 TO 80 DO BEGIN
    ChArray[X,RowLimit] := ' ';
    FgArray[X,RowLimit] := 0;
    BgArray[X,RowLimit] := 0;
  END;
  ANSI_St   := '';
  ANSI_SCPL := - 1;
  ANSI_SCPC := - 1;
  ANSI_FG   := 7;
  ANSI_BG   := 0;
  ANSI_C    := FALSE;
  ANSI_I    := FALSE;
  ANSI_B    := FALSE;
  ANSI_R    := FALSE;
  Where_X   := 1;
  Where_Y   := 1;
  RowLimit  := 25;
  ColLimit  := 80;
  StartX    := 1;
  StartY    := {63}21;
END;

BEGIN
  ResetANSI;
END.
