{

              
            
               ͻ ͻ ͻ    ͻ ͻ
                    ˼ ͹ ͼ ͹     ͻ
                   ͼ          ͼ ͼ  v1.15

  The Universal Multimedia Interface For BBS Software
  Copyright 1995-1997 * Larry L. Athey * BBS Utiliteez Software


  Information Regarding MAX Graphics:
  
  Notice is hereby given that the MAXscript/MAXcontrol/MAXcolor language,
  and MAXterm are products of BBS Utiliteez Software and are protected by
  US copyrights listed with the US Library Of Congress (1996)....

  No changes, additions, subtractions, or other modifications shall be made
  to MAXscript/MAXcontrol/MAXcolor language or the MAX Graphics development
  kit without express written permission from Larry L. Athey, BBS Utiliteez
  Software, Alliance, Nebraska, USA....

  The MAXscript/MAXcontrol/MAXcolor language may be used in any BBS or Door
  software 100% royalty free. You are also allowed to implement full local
  graphics viewing in any BBS or Door software 100% royalty free. However,
  any program that uses the MAXscript/MAXcontrol/MAXcolor language *MUST*
  bear the MAX Graphics/BBS Utiliteez Software copyright notice....


  Example: MAX Graphics and the MAXscript/MAXcontrol/MAXcolor language is
           Copyright 1995-1997 * Larry L. Athey * BBS Utiliteez Software

  }
{   Adjust your compiler directives as you see fit  }
{$A+,B-,D+,E+,F+,G+,I-,L+,N-,O+,P-,Q-,R-,S-,T-,V+,X+}
Program MAX_DOOR;

USES CRT, TDK_VARS, DOORKIT1, DOORKIT2, DOORKIT3, SVGADOOR, SVGAUNIT;

{NOTE: This example program is a MAX Graphics ONLY door.  This program is
       simply for demonstrating various techniques used when working with
       MAXterm in SVGA mode. See TEST.PAS for ANSI/ASCII door techniques,
       and SVGATEST.PAS for ANSI/ASCII/MAX techniques.

 ALSO: This door absolutely must be run using the /V parameter! There are
       no conditional branches in this program to revert to any ANSI/ASCII
       techniques....}

PROCEDURE FieldDemo;
VAR
  TFile    : TEXT;
  Name     : STRING[30];
  PassWord : STRING[30];
  Phone    : STRING[30];
  Field    : BYTE;
  Ch       : CHAR;
BEGIN
  Name     := '';
  PassWord := '';
  Phone    := '';
  SvgaShowScreen('BBS-UTIL.MAX');
  REPEAT Ch := SvgaReadKey UNTIL Ch = #24;
  {^ Also note that since this screen uses entry fields, the button on the
     screen the user clicks when they are done is an ALT key....}
  MaxCommand('Get_Field_Data()');
  IF FExist('FIELDS.'+IntToStr(DoorSys.Node)) THEN BEGIN
    Field := 0;
    ASSIGN(TFile,'FIELDS.'+IntToStr(DoorSys.Node));
    RESET(TFile);
    WHILE NOT EOF(TFile) DO BEGIN
      INC(Field);
      CASE Field OF
        1 : READLN(TFile,Name);
        2 : READLN(TFile,PassWord);
        3 : READLN(TFile,Phone);
      END;
    END;
    CLOSE(TFile);
    {^ For every field on the screen, your FIELDS.### text file will have
       an extra line whether the field is empty or not.}
  END;
  {As you can very well see below, you are by no means limited to having
   only one window on the screen at a time. Notice when the second window
   is displayed that the header on the previous window darkens to indicate
   that its functions are now no longer active....}
  MaxCommand('Hide_Mouse()');
  MaxCommand('Draw_Window(90,90,350,240,5,''Entry Field Results:'')');
  MaxCommand('Shadow_Text(110,135,15,0,1,''Field #1: '+Name+''')');
  MaxCommand('Shadow_Text(110,155,15,0,1,''Field #2: '+PassWord+''')');
  MaxCommand('Shadow_Text(110,175,15,0,1,''Field #3: '+Phone+''')');
  MaxCommand('Draw_Button(109,201,68,81,1,5,''Quit'')');{Note the normal key}
  MaxCommand('Show_Mouse()');
  SvgaReadKey;
END;

PROCEDURE ScreenDemo;
BEGIN
  SvgaShowScreen('WELCOME.MAX');
  SvgaReadKey;
  {^ This is about as basic as you can get. This simply displays a MAX
     screen file to the caller and waits for a keypress.}
END;

PROCEDURE AnimationDemo;
BEGIN
 {This procedure is actually just an example of sending another MAX screen
  without the use of a screen file. Notice that all of the commands below
  are in MAXcontrol format, this results in a significant speed increase
  on the remote side. This procedure will animate a bunch of icons around
  a small window in a clockwise fashion.}
  MaxCommand('');
  MaxCommand(#12);
  MaxCommand('~');
  MaxCommand('~189,165,441,287,1,''Welcome!''');
  MaxCommand('~305,226,195,191,4,1,10');
  MaxCommand('~305,226,195,206,4,1,10');
  MaxCommand('~305,226,195,221,4,1,10');
  MaxCommand('~305,226,195,236,4,1,10');
  MaxCommand('~305,226,195,251,4,1,10');
  MaxCommand('~305,226,195,266,4,1,10');
  MaxCommand('~305,226,210,266,4,1,10');
  MaxCommand('~305,226,225,266,4,1,10');
  MaxCommand('~305,226,240,266,4,1,10');
  MaxCommand('~305,226,255,266,4,1,10');
  MaxCommand('~305,226,270,266,4,1,10');
  MaxCommand('~305,226,285,266,4,1,10');
  MaxCommand('~305,226,300,266,4,1,10');
  MaxCommand('~305,226,315,266,4,1,10');
  MaxCommand('~305,226,330,266,4,1,10');
  MaxCommand('~305,226,345,266,4,1,10');
  MaxCommand('~305,226,360,266,4,1,10');
  MaxCommand('~305,226,375,266,4,1,10');
  MaxCommand('~305,226,390,266,4,1,10');
  MaxCommand('~305,226,405,266,4,1,10');
  MaxCommand('~305,226,420,266,4,1,10');
  MaxCommand('~305,226,420,251,4,1,10');
  MaxCommand('~305,226,420,236,4,1,10');
  MaxCommand('~305,226,420,221,4,1,10');
  MaxCommand('~305,226,420,206,4,1,10');
  MaxCommand('~305,226,420,191,4,1,10');
  MaxCommand('~305,226,405,191,4,1,10');
  MaxCommand('~305,226,390,191,4,1,10');
  MaxCommand('~305,226,375,191,4,1,10');
  MaxCommand('~305,226,360,191,4,1,10');
  MaxCommand('~305,226,345,191,4,1,10');
  MaxCommand('~305,226,330,191,4,1,10');
  MaxCommand('~305,226,315,191,4,1,10');
  MaxCommand('~305,226,300,191,4,1,10');
  MaxCommand('~305,226,285,191,4,1,10');
  MaxCommand('~305,226,270,191,4,1,10');
  MaxCommand('~305,226,255,191,4,1,10');
  MaxCommand('~305,226,240,191,4,1,10');
  MaxCommand('~305,226,225,191,4,1,10');
  MaxCommand('~305,226,210,191,4,1,10');
  MaxCommand('~238,214,15,0,2,''Welcome To MAX Graphics!''');
  MaxCommand('~218,229,15,0,2,''Copyright 1995-1997 Larry Athey''');
  MaxCommand('~252,244,15,0,2,''BBS Utiliteez Software''');
  MaxCommand('~211,207,209,59,13');
  MaxCommand('~');
  SvgaReadKey;
END;

PROCEDURE ReaderDemo1;
VAR
  Ch    : CHAR;
  St    : STRING[79];
  TFile : TEXT;
BEGIN
 {This demo is to show you how to use MAXterm's internal text file reader.
  This is especially handy if you are writing a BBS or a door that uses the
  actual text strings to determine the text color.}
  MaxCommand('');
  MaxCommand(#12);
  MaxCommand('Start_Screen()');
  MaxCommand('Draw_Window(1,21,639,80,1,''Text Reader Demo:'')');
  MaxCommand('Set_Fill_Style(1,1)');
  MaxCommand('Raised_Box(0,414,639,459)');
  MaxCommand('Set_Fill_Style(1,1)');
  MaxCommand('Bar(5,45,635,76)');
  MaxCommand('Shadow_Text(10,46,60,0,2,''From:'')');
  MaxCommand('Shadow_Text(26,60,60,0,2,''To:'')');
  MaxCommand('Shadow_Text(333,46,60,0,2,''Date/Time:'')');
  MaxCommand('Shadow_Text(349,60,60,0,2,''Subject:'')');
  MaxCommand('Shadow_Text(49,46,14,0,2,''Larry Athey'')');
  MaxCommand('Shadow_Text(49,60,14,0,2,''All'')');
  MaxCommand('Shadow_Text(400,46,14,0,2,''11/05/96 - 10:45am'')');
  MaxCommand('Shadow_Text(400,60,14,0,2,''TDK Update Information...'')');
 {------------------------------------------------------------------------}
  MaxCommand('Start_Text_File(''MSG.TXT'')');
  ASSIGN(TFile,'MESSAGE.TXT');
  RESET(TFile);
  WHILE NOT EOF(TFile) DO BEGIN
    READLN(TFile,St);
    MaxCommand('Put_Text_File('+#39+St+#39+')');
  END;
  CLOSE(TFile);
  MaxCommand('End_Text_File()');
 {------------------------------------------------------------------------}
 {^ Note the above sequence of MAX and Pascal commands must be used in this
    order at all costs. Say you are writing a BBS program and you are using
    the text reader for displaying messages. Well, you have to get the text
    from here to there before the caller can display it. What this does is
    read a text file from the hard drive and send it one character at a
    time to the remote and build that text file over there. After the file
    is finished, it can then be loaded into their text file reader....}
  MaxCommand('New_Text_Reader(80)');
  MaxCommand('Load_Text_File(''MSG.TXT'')');
 {Now that the text file has been created on the remote end, it can now be
  loaded into the text file reader....}
  MaxCommand('Show_Text_Page()');
  MaxCommand('Draw_Button(13,426,60,16,1,5,''Quit'')');
  MaxCommand('End_Screen()');
  REPEAT Ch := SvgaReadKey UNTIL Ch = #16;
  IF NOT Local THEN MaxCommand(#255#125#206#39+'MSG.TXT'+#39#255) ELSE FErase('MSG.TXT');
  {Since there is no reason for the caller to retain the MSG.TXT in their
   resource package, the above command simply tells MAXterm to delete the
   file \SESSION\MSG.TXT....}
END;

PROCEDURE ReaderDemo2;
BEGIN
 {This is another demo to show you how to dynamically display text files.
  Unlike the previous demo, the text strings have no effect on the color
  of the text. This is simply an SVGA text file display procedure built
  into TDK.}
  ShowTextFile('MESSAGE.TXT');
END;

PROCEDURE EditorDemo;
BEGIN
  IF Local THEN BEGIN
   {Here you see a conditional branch that determines how the commands
    should be processed. In the case of the text editor, if you were to
    run it locally and remotely at the same time, the remote caller would
    get stuck in their editor until you exited the one running locally.
    So this example shows you a different method of sending MAX commands
    to the remote caller.}
    MaxCommand('');
    MaxCommand(#12);
    MaxCommand('Start_Screen()');
    MaxCommand('Draw_Window(1,21,638,47,1,''Text Editor Demo:'')');
    MaxCommand('Editor_File(''TEXTFILE.TXT'')');
    MaxCommand('New_Text_Editor(47)');
    MaxCommand('Run_Text_Editor()');
    MaxCommand('End_Screen()');
  END ELSE BEGIN
    SendStr(#13#10);
    SendStr(#12#13#10);
    SendStr('Start_Screen()'+#13#10);
    {----------------------------------------------------------}
    REPEAT Kill_Window UNTIL WindowNumber = 1;
    Draw_Window(100,100,300,155,1,3,'Local Note:');
    ShadowText(110,130,14,0,2,'Running Remote Text Editor...');
    {Remember, these commands are in here because this door only
     runs in local SVGA mode. If you ever make calls to any of
     these procedures when not in graphics mode, you will crash
     your program and most likely lock up your computer. Graphics
     programming is _VERY_ unforgiving, so by all means, pay very
     close attention to what you are doing....That's easy huh?...}
    {----------------------------------------------------------}
    SendStr('Draw_Window(1,21,638,47,1,''Text Editor Demo:'')'+#13#10);
    SendStr('Editor_File(''TEXTFILE.TXT'')'+#13#10);
    SendStr('New_Text_Editor(47)'+#13#10);
    SendStr('Shadow_Text(241,438,14,0,2,''Press CTRL-V For Editor Help'')'+#13#10);
   {Before the Run_Text_Editor() command is issued, you can load a text file
    into the remote caller's editor using Load_Text_File('FILENAME.TXT')....
    This may be desirable if you have sent quoted message text to the caller.}
    SendStr('Run_Text_Editor()'+#13#10);
    SendStr('End_Screen()'+#13#10);
  END;
  IF NOT Local THEN SvgaReadKey;
  {^ When a caller exits the editor in MAXterm, it will send a #13 so the
     BBS or door will know they are finished....}
  MaxCommand('Get_Editor_Text()');
  ShowTextFile('EDITOR.'+IntToStr(DoorSys.Node));
END;

PROCEDURE QueryDemo;
BEGIN
  IF Local THEN BEGIN
    {Duh....How do query MAXterm when it's not running?}
  END ELSE BEGIN
    MaxCommand(#255#125#200#255);
    {^ Get user name and password stored in MAXterm}
    MaxCommand(#255#125#201#255);
    {^ Get remote resource list}
    MaxCommand(#255#125#205#255);
    {^ Get remote system information}
    AnsiWindow;
    ShowTextFile('USER.'+IntToStr(DoorSys.Node));
    {^ Show remote user name and password}
    ShowTextFile('RES.'+IntToStr(DoorSys.Node));
    {^ Show remote resource list}
    ShowTextFile('REMOTE.'+IntToStr(DoorSys.Node));
    {^ Show remote system information}
  END;
END;

PROCEDURE MainMenu;
{This procedure will show you how to send screens without the use of any
 external screen files. This will also demonstrate how to use PickLists.}
VAR
  Ch      : CHAR;
  TFile   : TEXT;
  St      : STRING[20];
  Func    : BYTE;
  MouseOn : BOOLEAN;
BEGIN
  REPEAT
    MaxCommand('');
    MaxCommand(#12);
    {^ Since MAXterm is in "ANSI Emulation Mode" we need to send this, if we
       don't, then MAXterm will interpret all commands as raw ASCII. Take a
       look at a RIP screen file some time. You will notice there is always
       a character #12 (or: ) on the first line. This is a command to tell
       RIPterm to clear the graphics window. In MAXterm it means to kill all
       active windows including the "ANSI Emulation" window.}
    MaxCommand('Start_Screen()');
    MaxCommand('Draw_Window(100,100,259,230,1,''Main Menu'')');
    MaxCommand('New_PickList(110,130,5,20)');
    MaxCommand('AddTo_PickList(''Entry Field Demo'')');
    MaxCommand('AddTo_PickList(''Display WELCOME.MAX'')');
    MaxCommand('AddTo_PickList(''Animated Icon Demo'')');
    MaxCommand('AddTo_PickList(''Text Reader Demo #1'')');
    MaxCommand('AddTo_PickList(''Text Reader Demo #2'')');
    MaxCommand('AddTo_PickList(''Text Editor Demo'')');
    MaxCommand('AddTo_PickList(''MAXterm Query Demo'')');
   {Simply add more picklist items here as needed...}

   {Notice that there are more items in the picklist than what appear on
    the screen. In theory, you could have a picklist with 800 items in it
    and only have 5 at any one time one the screen. The picklist simply
    allows you to scroll through the 800 items.}
    MaxCommand('SetUp_PickList()');
    MaxCommand('Draw_Button(109,201,68,16,1,5,''Quit'')');  {Note the ALT keys}
    MaxCommand('Draw_Button(182,201,68,31,1,4,''Select'')');{"    "     "    "}
    MaxCommand('End_Screen()');
    REPEAT Ch := SvgaReadKey UNTIL (Ch = #16) OR (Ch = #31);
    IF Ch = #31 THEN BEGIN
      MaxCommand('Get_Pick_Info()');
      IF FExist('PICKINFO.'+IntToStr(DoorSys.Node)) THEN BEGIN
        ASSIGN(TFile,'PICKINFO.'+IntToStr(DoorSys.Node));
        RESET(TFile);
        READLN(TFile,St);
        CLOSE(TFile);
        {^ The format of the PCIKINFO.### text file is:

           Line #1 - The selected picklist item number.
           Line #2 - The selected picklist item text.

           Since we aren't concerned with the picklist item text, we only
           need to read the first line and turn it into a numeric value..}
        Func := StrToInt(St);
        CASE Func OF
          1 : FieldDemo;
          2 : ScreenDemo;
          3 : AnimationDemo;
          4 : ReaderDemo1;
          5 : ReaderDemo2;
          6 : EditorDemo;
          7 : QueryDemo;
        END;
      END;
    END;
  UNTIL Ch = #16;
END;

{================================= Main Program =============================}

BEGIN
  {--------------------------------------------------------------------------}
  { This is all that is needed to initialize your door program...You may add }
  { more variable/constant modifications at your own discretion...           }
  {--------------------------------------------------------------------------}
  ProgramName := 'MAX_DOOR.EXE Version -9.02E+16';
  ProgramDesc := 'Example SVGA Door Program For "The DoorKit"';
  {--------------------------------------------------------------------------}
  { The following needs to be set if you intend to support local SVGA...     }
  {--------------------------------------------------------------------------}
  UseSVGA := TRUE;
  {--------------------------------------------------------------------------}
  { After you have made all of your variable/constant modifications, you can }
  { initialize or "Start Up" your door program...                            }
  {--------------------------------------------------------------------------}
  InitDoorKit;
  {--------------------------------------------------------------------------}
  { Sorry Bub....No ANSI/ASCII/AVATAR/RIP callers....Try again....           }
  {--------------------------------------------------------------------------}
  IF ((NOT Local) AND (Graphics <> MAX)) OR (NOT LocalSVGA) THEN BEGIN
    ShowProgramAd;
    sWriteln('');
    OutTxtL(12,0,'Sorry, this program requires you to be connected with MAXterm');
    OutTxtL(12,0,'running in full SVGA mode......Please call back using MAXterm');
    OutTxtL(12,0,'if you want to use this door.');
    sWriteln('');
    OutTxtL(2,0,'If this door is running in local mode, you must use the /V');
    OutTxtL(2,0,'and /L command line parameters for this door to run.......');
    sWriteln('');
    AnyKey;
    HALT;
  END;
  {--------------------------------------------------------------------------}
  { After the program starts we need to fire up the local SVGA graphics.     }
  {--------------------------------------------------------------------------}
  CheckVideoMode;
  {--------------------------------------------------------------------------}
  { Now we're ready to roll with our program...                              }
  {--------------------------------------------------------------------------}
  DoorSys.UpdateIdle := FALSE;
 {^ You definitely don't want this in every SVGA door you write. The only
    reason this is in here is because a lot of the routines demonstrated
    in this door are routines where the caller is inside of MAXterm's key
    handling routines where little or no keyboard output is sent back to
    the door/BBS. In most cases, you'll only want to disable this before
    the procedure is called, and then re-activate it when finished. When
    ever this is the case, the only thing you can monitor is carrier, all
    inactivity timeouts are undetectable.

    These are the only times you cannot monitor inactivity timeouts:

    In: PickLists
        Entry Fields
        Text Readers
        Text Editors}

  MainMenu;
END.
