
;BGI256.ASM
;Copyright 1991,1992,1993,1994,1995 Knight Software
;P.O. Box 22902, Milwaukie, OR 97269-2902
;BGI driver for Super VGA 256 color modes
;    History:
;       17 May 1991 - first release
;       10 Jun 1991 - Added ability to control pixel backgrounds
;       19 Aug 1992 - fixed windowing errors 
;       20 Aug 1992 - fixed VESA selection for Diamond Stealth
;                     which uses non-sequencial memory in 800x600
;       22 Nov 1992 - Adapted for protected mode operation
;	22 Dec 1992 - released working floodfill
;       30 Jan 1993 - corrected version 2 header (wasn't working with TP6)
;       17 Apr 1993 - added write after read for setpixel and setimage
;	28 Aug 1994 - added PutImage low-flicker animation
;	25 Nov 1994 - revised line draw routine
;       26 Dec 1994 - added virtual commands   
;       24 Jan 1995 - added vga palette load control
;       02 Feb 1995 - added test for defective vesa bios
;       21 May 1995 - added test for vesa bios info failure for mode 13h

;======================================================================

BGIVERSION EQU 3   ;select target BGI version 2 or 3

;======================================================================

     IF BGIVERSION LT 3
	DriverVersion EQU 205	;V2.05 for TP5-6 (real mode)
     ELSE
	DriverVersion EQU 305	;V3.05 for BP7 (real/prot mode)
     ENDIF


	INCLUDE	BGIMAC.INC	;include macros

;**********************************************************************
;Code segment *must* be first - only code and data segments allowed

_TEXT	SEGMENT PARA PUBLIC 'CODE'
     IF BGIVERSION LT 3
	ASSUME  DS:_TEXT, CS:_TEXT	;version 2 driver
     ELSE
	ASSUME  DS:_DATA, CS:_TEXT	;version 3 driver
     ENDIF
	BGI	BGI256		; Define the interface type
	;Warning: BGI macro *must* be first item in code segment

	INCLUDE	SBASE.INC       ; Include base interface code
	INCLUDE	SHARD.INC	; Include init/bank subroutines
	INCLUDE	SPIXEL.INC	; Include pixel subroutines
	INCLUDE SLINE.INC	; Include line subroutines
	INCLUDE SBIT.INC	; Include bitmap subroutines
	INCLUDE	SBLT.INC	; Include blt subroutines
	INCLUDE STEXT.INC	; Include text subroutines
	INCLUDE	SFLOOD.INC	; Include floodfill subroutines

	; <-- if you need your own additional custom code -->
	; <-- add it here as a custom include file.       -->


;------------------------------------------------------------
; <-- If you are creating your own custom driver, comment -->
; <-- out the hardware specific driver here and add your  -->   
; <-- own custom include file for you specific hardware.  -->

;hardware specific code - select one appropriate include file
;	INCLUDE V7INIT.INC	; Include V7 init subroutines
;	INCLUDE TRIDENT.INC	; Include Trident init subroutines
;	INCLUDE ET4K.INC	; Include ET4000 init subroutines
	INCLUDE SVESA.INC	; Include VESA init subroutines

;------------------------------------------------------------

     IF BGIVERSION GE 3
_TEXT	ENDS

;Note: Data segment *must* be after code segment (for protected mode)
_DATA	SEGMENT PARA PUBLIC 'DATA'	;declare the data segment
	ASSUME DS:_DATA, CS:Nothing
     ENDIF
 
	INCLUDE INITDATA.INC	; InitData *MUST* be first in data seg
	INCLUDE	SDATA.INC	; Include all data / variables
	INCLUDE	SPAL.INC	; Include default palette data

	; <-- if you need your own additional custom data space -->
	; <-- add it here as a custom include file.             -->

     IF BGIVERSION GE 3
_DATA	ENDS
     ELSE
_TEXT	ENDS
     ENDIF


;**********************************************************************

	END

