@Echo off
Rem Companion to R3 - manages configurations - duplicates file mgmt functions
set Conf=Standard
If exist c:\switches\expconf set Conf=Expanded
Set LOC=Menu
set Line=Line 3
Set Debug=Rem
Set Edit=Updated
If exist c:\switches\CfgChg set Edit=Changed
Cls
GoTo %LOC%

:Edit
    Q2 C:\Macros\r3cfg.bat

    Cls
    BatchMan CEcho Edit R3cfg menu displays?  (Y/N):
    Echo.
    BatchMan getkey 'ny'
    Echo.
    If ErrorLevel  2 GoTo  EditMenu
    If ErrorLevel  1 GoTo  Return
    GoTo %LOC%

  :EditMenu
    C:
    Cd \Macros\Screens
    Tdraw R3cfg

  :Return
    C:
    Cd \

:Menu
Cd \ra
Cls
%Debug% Echo Off
Type C:\Macros\Screens\R3cfg.%Mode%
BatchMan CEcho C %Cclr%h,           Current config: %Conf% (%Edit%)
BatchMan CEcho bh,  Current Line: %Line%
BatchMan CEcho C %Sclr%h,           SysOp Status: %SysOp%
BatchMan CEcho C Eh,    Your Choice:
Rem              jklmnop36789!@#$+\=/,'";:
Rem                  .    1    .    2    .    3    .    4
BatchMan getkey 'sxchu_gd-01245vizy]}abre@~&^fw.t?*[{()q'
Echo.

If ErrorLevel 39  GoTo  UnChange
If ErrorLevel 38  GoTo  SaveHidden
If ErrorLevel 37  GoTo  SaveVisible
If ErrorLevel 36  GoTo  EditHidden
If ErrorLevel 35  GoTo  EditVisible
If ErrorLevel 34  GoTo  EdCron
If ErrorLevel 33  GoTo  Help
If ErrorLevel 32  GoTo  TimeLimTbl
If ErrorLevel 31  GoTo  Compress
If ErrorLevel 30  GoTo  RAF
If ErrorLevel 29  GoTo  RagFac
If ErrorLevel 28  GoTo  RAFileUpdate
If ErrorLevel 27  GoTo  RAFileClean
If ErrorLevel 26  GoTo  RAFileSort
If ErrorLevel 25  GoTo  RAFileXport
If ErrorLevel 24  GoTo  FFixEdit
If ErrorLevel 23  GoTo  FFixRestore
If ErrorLevel 22  GoTo  FFixBU
If ErrorLevel 21  GoTo  Allfiles
If ErrorLevel 20  GoTo  RAmgrUpdate
If ErrorLevel 19  GoTo  RaMgr
If ErrorLevel 18  GoTo  SavCurStd  OK
If ErrorLevel 17  GoTo  Edit
If ErrorLevel 16  GoTo  SetHidden
If ErrorLevel 15  GoTo  SetVisible
If ErrorLevel 14  GoTo  Cfg5
If ErrorLevel 13  GoTo  Cfg4
If ErrorLevel 12  GoTo  Cfg2
If ErrorLevel 11  GoTo  Cfg1
If ErrorLevel 10  GoTo  CfgMain
If ErrorLevel  9  GoTo  Exit
If ErrorLevel  8  GoTo  DoBackup
If ErrorLevel  7  GoTo  RestorBackup
If ErrorLevel  6  GoTo  DebugToggle
If ErrorLevel  5  GoTo  Update
If ErrorLevel  4  GoTo  SaveCfg
If ErrorLevel  3  GoTo  EditCfg
If ErrorLevel  2  GoTo  Exp
If ErrorLevel  1  GoTo  Std

:EdCron
    Echo Editing the CRans scheduler datafile, CRansTAB
    Call edcron
    GoTo %LOC%

:EditCfg
    Echo Editing the %Conf% config.
    set Edit=Changed
    echo. > c:\switches\CfgChg
    raconfig
    GoTo %LOC%

:Exp
    %Debug% Echo On
    If exist c:\switches\expconf GoTo ExpAbort
    If "%Edit%" == "Updated" GoTo ExpSkip
    Echo Standard config is installed and has been changed.  Saving...
    Set LOC=ExpSkip
    GoTo SaveCfg

  :ExpAbort
    Set LOC=ExpSkip
    GoTo CfgAbort

  :ExpSkip
    Set LOC=Menu
    Echo Getting the Expanded config.
    copy c:\ra\util\files-x.ra c:\ra\files.ra > Nul
    if not exist c:\switches\expconf rename c:\switches\stdconf expconf
    set Edit=Updated
    Set Cclr=d
    set Conf=Expanded
    GoTo %LOC%

  :CfgAbort
    Echo You ALREADY have the %Conf% Config!
    Echo It's status is :%Edit%...    Get anyway?
    batchman getkey '-ny'
    If ErrorLevel 3 GoTo %LOC%
    Set LOC=Menu
    GoTo %LOC%

:Std
    %Debug% Echo On
    If exist c:\switches\stdconf GoTo StdAbort
    If "%Edit%" == "Updated" GoTo StdSkip
    Echo Expanded config is installed and has been changed.  Saving...
    Set LOC=StdSkip
    GoTo SaveCfg

  :StdAbort
    Set LOC=StdSkip
    GoTo CfgAbort

  :StdSkip
    Set LOC=Menu
    Echo Getting the Standard config.
    Echo Current configuration is Standard. > c:\switches\raconfig
    if not exist c:\switches\stdconf rename c:\switches\expconf stdconf
    copy c:\ra\util\files.std c:\ra\files.ra > Nul
    set Edit=Updated
    Set Cclr=5
    set Conf=Standard
    copy c:\ra\util\files.std c:\ra\files.ra > Nul
    GoTo %LOC%

:SaveCfg
    %Debug% Echo On
    Set Edit=Updated
    del c:\switches\CfgChg
    If exist c:\switches\expconf GoTo ExpSave
    Echo Saving Standard config.
    copy c:\ra\files.ra c:\ra\util\files.std > Nul
    GoTo %LOC%

  :ExpSave
    Echo Saving Expanded config.
    copy c:\ra\files.ra c:\ra\util\files-x.ra > Nul
    GoTo %LOC%

:SavCurStd
    Echo Saving current config to the Standard config.
    if not exist c:\switches\stdconf rename c:\switches\expconf stdconf
    set Conf=Standard
    GoTo SaveCfg

:Update
    %Debug% Echo On
    If "%Edit%" == "Updated" GoTo UpdSkip
    If exist c:\switches\stdconf GoTo Upd2Skip
    Echo Expanded config is installed and has been changed.  Saving...
    Set LOC=UpdSkip
    GoTo SaveCfg

  :Upd2Skip
    Echo Standard config and has been changed - saving...
    Set LOC=UpdSkip
    GoTo SaveCfg

  :UpdSkip
    Set LOC=Menu
    Echo Updating all lines and backups with Standard config. now...
    copy c:\ra\util\files.std c:\ra\files.ra > Nul
    copy c:\ra\files.ra c:\ra\util\files.bu  > Nul
    copy c:\ra\files.ra c:\ra\line1\files.ra > Nul
    copy c:\ra\files.ra c:\ra\line2\files.ra > Nul
    copy c:\ra\files.ra c:\ra\line3\files.ra > Nul
    copy c:\ra\files.ra c:\ra\line4\files.ra > Nul
    copy c:\ra\files.ra c:\ra\line5\files.ra > Nul
    set Conf=Standard
    GoTo %LOC%

:UnChange
    %Debug% Echo On
    Set Edit=Updated
    If exist c:\switches\CfgChg del c:\switches\CfgChg
    GoTo %LOC%

:CfgMain
    Echo Editing the Main config files.
    Cd \ra
    set Line=Main
    GoTo CfgSub

:Cfg1
    Echo Editing the config files for Line 1.
    Cd \ra\line1
    set Line=Line 1
    GoTo CfgSub

:Cfg2
    Echo Editing the config files for Line 2.
    Cd \ra\line2
    set Line=Line 2
    GoTo CfgSub

:Cfg4
    Echo Editing the config files for Line 4.
    Cd \ra\line4
    set Line=Line 4
    GoTo CfgSub

:Cfg5
    Echo Editing the config files for Line 5.
    Cd \ra\line5
    set Line=Line 5

  :CfgSub
    raconfig
    GoTo %LOC%

:RAmgr
    Echo Calling RaManager for file management.
    Call RAmgr /f
    GoTo %LOC%

:TimeLimTbl
    q2 c:\ra\1-time.lim
    GoTo %LOC%

:RAmgrUpdate
    Echo Calling RaManager for file management with update.
    Call RAmgr /a /f
    GoTo %LOC%

:RAFileXport
    Echo Calling RaFile for export of FILES.BBS files.
    Call RAFile Export 0
    GoTo %LOC%

:RAFileSort
    Echo Calling RaFile for export to do a global sort.
    Call RAFile Sort 0
    GoTo %LOC%

:RAFileUpdate
    Echo Calling RaFile for export to do a global update.
    Call RAFile Update 0
    GoTo %LOC%

:RAFileClean
    Echo Calling RaFile for export to do a global clean.
    Call RAFile Clean 0
    GoTo %LOC%

:Compress
    Echo About to compress the file listing database.
    Echo
    Echo ---ARE YOU SURE???
    BatchMan getkey 'yn'
    Echo.

    If ErrorLevel 2 GoTo %LOC%

    Call RAFile compress 0
    GoTo %LOC%

:FFixBU
    Echo Calling FFix to do a RAF dbase backup.
    Call FFix bu
	GoTo %LOC%

:FFixRestore
    Echo Calling FFix to do a RAF dbase restore.
    Call FFix r
	GoTo %LOC%

:FFixEdit
    Echo Editing FFix.
    Call FFix e
	GoTo %LOC%

:Allfiles
    Echo Generating the Allfiles and misc file lists.
    Call RAF x
	GoTo %LOC%

:RAF
    Echo Calling RAF...
    Call RAF
	GoTo %LOC%

:RagFac
    Echo Calling RAGRAC.
    Cd \RA\mc
    Echo Work on Original or Temp (copies of) files.ra?
    BatchMan Getkey 'to'
    If ErrorLevel 2 GoTo RagFac2
	Copy ..\Files.Ra .

    :RagFac2
    Call RagFac

    Echo Update/Skip?
    BatchMan Getkey 'su'

    If ErrorLevel 2 GoTo Update
	GoTo %LOC%

	:Update
    Copy Files.Ra \RA\Util\Files.Std
    Copy Files.Ra \RA\Util\Files.Bu
    Copy Files.Ra \RA\Files.Ra
    Copy Files.Ra \RA\Line1\Files.Ra
    Copy Files.Ra \RA\Line2\Files.Ra
    Copy Files.Ra \RA\Line3\Files.Ra
    Copy Files.Ra \RA\Line4\Files.Ra
    Copy Files.Ra \RA\Line5\Files.Ra
    GoTo %LOC%

:SetVisible
    Echo Setting the config for SysOp Visible.
    Set SysOp=Visible
    Set Sclr=c
    Call RaCfg y
    GoTo %LOC%

:SetHidden
    Echo Setting the config for SysOp Invisible.
    Set SysOp=Hidden
    Set Sclr=2
    Call RaCfg n
    GoTo %LOC%

:SaveVisible
    Echo Saving current config to SysOp Visible config.
    Call RaCfg sy
    GoTo %LOC%

:SaveHidden
    Echo Saving current config to SysOp Hidden config.
    Call RaCfg sn
    GoTo %LOC%

:EditVisible
    Echo Editing the config for SysOp Visible.
    Call RaCfg ey
    GoTo %LOC%

:EditHidden
    Echo Editing the config for SysOp Invisible.
    Call RaCfg en
    GoTo %LOC%

:DebugToggle
    If "%Debug%" == "Rem" GoTo DebugOn
    Set Debug=Rem
    Echo Off
    GoTo %LOC%

  :DebugOn
    Set Debug=
    Echo On
    GoTo %LOC%

:RestorBackup
   %Debug% Echo On
   set BUtype=bu
   If exist c:\switches\expconf Set BUtype=bux
   If exist c:\ra\util\files\%BUtype%-1 set BU=1
   If exist c:\ra\util\files\%BUtype%-2 set BU=2
   If exist c:\ra\util\files\%BUtype%-3 set BU=3
   If exist c:\ra\util\files\%BUtype%-4 set BU=4
   If exist c:\ra\util\files\%BUtype%-5 set BU=5
   Set CurBu=%BU%

  :RestorLoop
    Cls
    Echo.
    Echo.
    Echo.
    BatchMan CEcho Eh,                     --==  Backup Restore Ops  ==--
    Echo.
    Echo.
    BatchMan CEcho Bh,           (V)iew backup description     (E)dit backup note
    Echo.
    BatchMan CEcho Ah,           (R)estore backup              (L)ist Directory
    Echo.
    BatchMan CEcho 3h,           (1,2,3,4,5) Backup select     (-) Exits to menu
    Echo.
    Echo.
    BatchMan CEcho 6h,           Current %Conf% backup is #%CurBu%, Selected backup is #%BU%
    Echo.
    Echo.
    BatchMan CEcho C Fh,           Select operation:
    BatchMan getkey '12345-vrel'
    Echo.
    If ErrorLevel 10  GoTo ListDir
    If ErrorLevel  9  GoTo EditNote
    If ErrorLevel  8  GoTo Restore
    If ErrorLevel  7  GoTo ViewNote
    If ErrorLevel  6  GoTo %LOC%
    If ErrorLevel  5  GoTo Rest5
    If ErrorLevel  4  GoTo Rest4
    If ErrorLevel  3  GoTo Rest3
    If ErrorLevel  2  GoTo Rest2
    If ErrorLevel  1  GoTo Rest1
    GoTo RestorLoop

  :Rest5
    Set BU=5
    GoTo RestorLoop

  :Rest4
    Set BU=4
    GoTo RestorLoop

  :Rest3
    Set BU=3
    GoTo RestorLoop

  :Rest2
    Set BU=2
    GoTo RestorLoop

  :Rest1
    Set BU=1
    GoTo RestorLoop

  :ViewNote
    Type c:\ra\util\files\%BUtype%-Not%BU%
    pause
    GoTo RestorLoop

  :EditNote
    If exist c:\ra\util\files\%BUtype%-Not%BU% GoTo EdNoteSkip
      Tstamp "$c   --   " > c:\ra\util\files\%BUtype%-Not%BU%
      Echo %Conf% file area configuration backup #%BU%. >> c:\ra\util\files\%BUtype%-Not%BU%
      Echo. >> c:\ra\util\files\%BUtype%-Not%BU%
    :EdNoteSkip
      Q2 c:\ra\util\files\%BUtype%-Not%BU%
      GoTo RestorLoop

  :ListDir
    list c:\ra\util\files
    GoTo RestorLoop

  :Restore
    if "%BUtype" == "bux" GoTo ExpRestore
    :StdRestore
      Echo Restoring Standard config from backup #%BU%.
      copy c:\ra\util\files\files-%BU%.std c:\ra\util\files.std > Nul
      copy c:\ra\util\files\files.std c:\ra\files.ra > Nul
      GoTo RestorEnd

    :ExpRestore
      Echo Restoring Expanded config from backup #%BU%.
      copy c:\ra\util\files\filesx-%BU%.ra c:\ra\util\files-x.ra > Nul
      copy c:\ra\util\files\files-x.ra c:\ra\files.ra > Nul

    :RestorEnd
      If exist c:\switches\CfgChg Set Edit=Updated
      If exist c:\switches\CfgChg del c:\switches\CfgChg
      GoTo %LOC%

:DoBackup
    %Debug% Echo On
    set BUtype=bu
    If exist c:\switches\expconf Set BUtype=bux
    If exist c:\ra\util\files\%BUtype%-1 set BU=2
    If exist c:\ra\util\files\%BUtype%-2 set BU=3
    If exist c:\ra\util\files\%BUtype%-3 set BU=4
    If exist c:\ra\util\files\%BUtype%-4 set BU=5
    If exist c:\ra\util\files\%BUtype%-5 set BU=1

    Del c:\ra\util\files\%BUtype%-?
    Echo. > c:\ra\util\files\%BUtype%-%BU%

    Echo Backing up %Conf% file area config to backup #%BU%.
    Echo Now enter a description of this backup for later viewing...
    Pause
    Tstamp "$c   --   " > c:\ra\util\files\%BUtype%-Not%BU%
    Echo %Conf% file area configuration backup #%BU%. >> c:\ra\util\files\%BUtype%-Not%BU%
    Echo. >> c:\ra\util\files\%BUtype%-Not%BU%
    Q2 c:\ra\util\files\%BUtype%-Not%BU%

    if "%BUtype" == "bux" GoTo ExpBackup
    copy c:\ra\util\files.std c:\ra\util\files\files-%BU%.std > Nul
    GoTo %LOC%

  :ExpBackup
    copy c:\ra\util\files-x.ra c:\ra\util\files\filesx-%BU%.ra > Nul
    GoTo %LOC%

:Help
    Echo     The File Management sction is devoted to maintaining the line
    Echo config files and control files.  You cannot save the wrong config
    Echo to to disk - the program tracks which config is in use.
    Echo     Line Ops edits the individual line time limits, modem config,
    Echo and events IN the line directory.
    Echo     The SysOp section edits the CansFIG.RA files in storage, which
    Echo mainly have the SysOp visible/invisible settings.
    Echo     The Files section is a duplicate of what's found in R# (which
    Echo may have to be removed to make room for more appropriate commands
    Echo soon).  The perform normal file area maintenance operations.
	GoTo %LOC%

:Exit
Set BU=
Set LOC=Menu
