@Echo off
Rem Companion to R3 - manages time limits
Set LOC=Menu
Set Debug=Rem
If exist c:\switches\lim.xtr GoTo Xtr
If exist c:\switches\lim.wkn GoTo Wkn
If exist c:\switches\lim.red GoTo Red
If exist c:\switches\lim.1da GoTo 1da
If exist c:\switches\lim.dwn GoTo Dwn
Set Limits=Standard
rem Set Lim=std
    Set Lclr=a
GoTo FinalInit

:Xtr
    Set Limits=Extra
rem Set Lim=xtr
    Set Lclr=e
    GoTo FinalInit

:Wkn
    Set Limits=Weekend
rem Set Lim=wkn
    Set Lclr=d
    GoTo FinalInit

:Red
    Set Limits=Red Eye
rem Set Lim=red
    Set Lclr=c
    GoTo FinalInit

:1da
    Set Limits=Line 1 Day
rem Set Lim=1da
    Set Lclr=f
    GoTo FinalInit

:Dwn
    Set Limits=Line Down
rem Set Lim=dwn
    Set Lclr=3
    GoTo FinalInit

:FinalInit
rem Set LimDsp=%Limits%
Cls
GoTo %LOC%

:Edit
    Q2 C:\Macros\EdLim.bat

    Cls
    BatchMan CEcho Edit EdLim menu displays?  (Y/N):
    Echo.
    BatchMan getkey 'ny'
    Echo.
    If ErrorLevel  2 GoTo  EditMenu
    If ErrorLevel  1 GoTo  Return
    GoTo %LOC%

  :EditMenu
    C:
    Cd \Macros\Screens
    Tdraw EdLim

  :Return
    C:
    Cd \

:Menu
C:
Cd \ra\lim
Cls
%Debug% Echo Off
Type C:\Macros\Screens\EdLim.%Mode%
BatchMan CEcho C %Lclr%h,              Current Limits: %Limits%,
BatchMan CEcho %Sclr%h,   SysOp Status: %SysOp%
BatchMan CEcho C %Qclr%h,              Work Limits: %LimDsp%, 
BatchMan CEcho C Eh,%LineDsp%      Your Choice:
Rem                  .    1    .    2    .    3    .    4
BatchMan getkey 'sxwrloeahitjk/z-*012345_!nbpudc'
Rem              fmqy6789~@#$^&()=+\[]{}:;"',./?
Echo.

If ErrorLevel 31  GoTo  BBSConfig
If ErrorLevel 30  GoTo  DataFiles
If ErrorLevel 29  GoTo  Utilities
If ErrorLevel 28  GoTo  MasterControl
If ErrorLevel 27  GoTo  Bulletin
If ErrorLevel 26  GoTo  Note
If ErrorLevel 25  GoTo  Zap
If ErrorLevel 24  GoTo  Debug
If ErrorLevel 23  GoTo  Line5
If ErrorLevel 22  GoTo  Line4
If ErrorLevel 21  GoTo  Line3
If ErrorLevel 20  GoTo  Line2
If ErrorLevel 19  GoTo  Line1
If ErrorLevel 18  GoTo  Main
If ErrorLevel 17  GoTo  EdCron
If ErrorLevel 16  GoTo  Exit
If ErrorLevel 15  GoTo  Edit
If ErrorLevel 14  GoTo  LimBatHelp
If ErrorLevel 13  GoTo  RestoreBackup
If ErrorLevel 12  GoTo  Backup
If ErrorLevel 11  GoTo  TimeLimScreen
If ErrorLevel 10  GoTo  SetInstall
If ErrorLevel  9  GoTo  InstallLine
If ErrorLevel  8  GoTo  EdLimBat
If ErrorLevel  7  GoTo  EditSelected
If ErrorLevel  6  GoTo  EmergDowntime
If ErrorLevel  5  GoTo  Line1Day
If ErrorLevel  4  GoTo  RedEye
If ErrorLevel  3  GoTo  Weekend
If ErrorLevel  2  GoTo  Extra
If ErrorLevel  1  GoTo  Standard

:EdLimBat
    Q2 c:\macros\lim.bat
    GoTo %LOC%

:LimBatHelp
    Q2 c:\ra\help\limbat.hlp
    GoTo %LOC%

:EdCron
    Echo Editing the CRON scheduler datafile, CRONTAB
    Call edcron
    GoTo %LOC%

:EditSelected
    Echo                 Editing %LimDsp% time limits for Line %Dline%.
    cd \ra\lim\work
    copy \ra\lim\L%Dline%.%Lim% \ra\lim\work\limits.ra
    raconfig
    copy limits.ra \ra\lim\L%Dline%.%Lim%
    del limits.ra
    GoTo %LOC%

:SetInstall
    Echo                 Installing time limit set %LimDsp% to all lines.
    copy \ra\lim\L1.%Lim% \ra\Line1\limits.ra
    copy \ra\lim\L2.%Lim% \ra\Line2\limits.ra
    copy \ra\lim\L4.%Lim% \ra\Line4\limits.ra
    copy \ra\lim\L5.%Lim% \ra\Line5\limits.ra
    copy \ra\lim\L0.%Lim% \ra\limits.ra
    Set Limits=%LimDsp%
    echo The current time limits are: %Limits% > c:\switches\Time.asc
    del c:\switches\lim.*
    echo. > c:\switches\lim.%Lim%
    GoTo %LOC%

:InstallLine
    Echo                 Installing %LimDsp% limits for Line %Dline%.
    If not "%Dline%" == "0" copy \ra\lim\L%Dline%.%Lim% \ra\Line%Dline%\limits.ra
    If "%Dline%" == "0" copy \ra\lim\L%Dline%.%Lim% \ra\limits.ra
    GoTo %LOC%

:Standard
    Set Lim=std
    Set Qclr=a
    Set LimDsp=Standard
    GoTo LimSub

:Extra
    Set Lim=xtr
    Set Qclr=e
    Set LimDsp=Extra
    GoTo LimSub

:Weekend
    Set Lim=wkn
    Set Qclr=d
    Set LimDsp=Weekend
    GoTo LimSub

:RedEye
    Set Lim=red
    Set Qclr=c
    Set LimDsp=Red Eye
    GoTo LimSub

:Line1Day
    Set Lim=1da
    Set Qclr=f
    Set LimDsp=L1 Day
    GoTo LimSub

:EmergDownTime
    Set Lim=dwn
    Set Qclr=3
    Set LimDsp=Line Down

  :LimSub
    GoTo %LOC%
rem    del c:\switches\lim.*
rem    echo. > c:\switches\lim.%Lim%

:Main
    set LineDsp=Main RA
    set Dline=0
    GoTo LimSub

:Line1
    set LineDsp=Line 1
    set Dline=1
    GoTo LimSub

:Line2
    set LineDsp=Line 2
    set Dline=2
    GoTo LimSub

:Line3
    set LineDsp=Line 3
    set Dline=3
    GoTo LimSub

:Line4
    set LineDsp=Line 4
    set Dline=4
    GoTo LimSub

:Line5
    set LineDsp=Line 5
    set Dline=5
    GoTo LimSub

  :LimSub
    GoTo %LOC%

:TimeLimScreen
    q2 c:\ra\1-time.lim
    GoTo %LOC%

:Bulletin
    Call Bulletin
    GoTo %LOC%

:DataFiles
    Call DataFile
    GoTo %LOC%

:Note
    Call Note
    GoTo %LOC%

:Zap
    Call Zap m
    GoTo %LOC%


:BBSConfig
    Call R3Cfg
    GoTo %LOC%

:Utilities
    Call EdUtil
    GoTo %LOC%

:MasterControl
    Call MC x
    GoTo %LOC%

:Debug
    If "%Debug%" == "Rem" GoTo DebugOn
    Set Debug=Rem
    Echo Off
    GoTo %LOC%
  :DebugOn
    Set Debug=
    Echo On
    GoTo %LOC%

:RestoreBackup
    %Debug% Echo On
    If exist c:\ra\lim\bu\bu-1.%Lim% set BU=1
    If exist c:\ra\lim\bu\bu-2.%Lim% set BU=2
    If exist c:\ra\lim\bu\bu-3.%Lim% set BU=3
    If exist c:\ra\lim\bu\bu-4.%Lim% set BU=4
    If exist c:\ra\lim\bu\bu-5.%Lim% set BU=5
    Set CurBu=%BU%

  :RestorLoop
    Echo.
    Echo.
    BatchMan CEcho Eh,          --==  Back Restore Ops  ==--
    Echo.
    BatchMan CEcho Bh, (V)iew backup description     (E)dit backup note
    BatchMan CEcho Bh, (R)estore backup              (L)ist Directory
    BatchMan CEcho Bh, (1,2,3,4,5) Backup select     (-) Exits to menu
    Echo.
    BatchMan CEcho 3h, Current %LimDsp% backup is #%CurBu%, Selected backup is #%BU%
    BatchMan CEcho C Fh, Select operation:
    BatchMan getkey '12345-vrel'
    Echo.
    If ErrorLevel 10  GoTo ListDir
    If ErrorLevel  9  GoTo EditNote
    If ErrorLevel  8  GoTo Restore
    If ErrorLevel  7  GoTo ViewNote
    If ErrorLevel  6  GoTo %LOC%
    If ErrorLevel  5  GoTo Rest5
    If ErrorLevel  4  GoTo Rest4
    If ErrorLevel  3  GoTo Rest3
    If ErrorLevel  2  GoTo Rest2
    If ErrorLevel  1  GoTo Rest1
    GoTo RestorLoop

  :Rest5
    Set BU=5
    GoTo RestorLoop

  :Rest4
    Set BU=4
    GoTo RestorLoop

  :Rest3
    Set BU=3
    GoTo RestorLoop

  :Rest2
    Set BU=2
    GoTo RestorLoop

  :Rest1
    Set BU=1
    GoTo RestorLoop

  :ViewNote
rem    Type c:\ra\lim\bu\BU-Note%BU%.%Lim%
    For %%i in ( 1 2 3 4 5 ) do Type c:\ra\lim\bu\BU-Note%%i.%Lim%
    pause
    GoTo RestorLoop

  :EditNote
    If exist c:\ra\lim\bu\BU-Note%BU%.%Lim% GoTo EdNoteSkip
    Tstamp "$c   --   " > c:\ra\lim\bu\BU-Note%BU%.%Lim%
    Echo %LimDsp% limits backup #%BU%. >> c:\ra\lim\bu\BU-Note%BU%.%Lim%
    Echo. >> c:\ra\lim\bu\BU-Note%BU%.%Lim%
   :EdNoteSkip
    Q2 c:\ra\lim\bu\BU-Note%BU%.%Lim%
    GoTo RestorLoop

  :ListDir
    list c:\ra\lim\bu
    GoTo RestorLoop

    list c:\ra\lim\bu
  :Restore
    Echo Restoring %LimDsp% limits from backup #%BU%.
    copy \ra\lim\bu\l0-%BU%.%Lim% \ra\lim\L0.%Lim% >Nul
    copy \ra\lim\bu\l1-%BU%.%Lim% \ra\lim\L1.%Lim% >Nul
    copy \ra\lim\bu\l2-%BU%.%Lim% \ra\lim\L2.%Lim% >Nul
    copy \ra\lim\bu\l4-%BU%.%Lim% \ra\lim\L4.%Lim% >Nul
    copy \ra\lim\bu\l5-%BU%.%Lim% \ra\lim\L5.%Lim% >Nul
    GoTo %LOC%

:Backup
    %Debug% Echo On
    If exist c:\ra\lim\bu\bu-1.%Lim%  set BU=2
    If exist c:\ra\lim\bu\bu-2.%Lim%  set BU=3
    If exist c:\ra\lim\bu\bu-3.%Lim%  set BU=4
    If exist c:\ra\lim\bu\bu-4.%Lim%  set BU=5
    If exist c:\ra\lim\bu\bu-5.%Lim%  set BU=1
    Del c:\ra\lim\bu\bu-?.%Lim%
    Echo. > c:\ra\lim\bu\bu-%BU%.%Lim%
    Echo Backing up %LimDsp% limits to backup #%BU%.
    Echo Now enter a description of this backup for later reference...
    Pause
    Tstamp "$c   --   " > c:\ra\lim\bu\BU-Note%BU%.%Lim%
    Echo %LimDsp% limits backup #%BU%. >> c:\ra\lim\bu\BU-Note%BU%.%Lim%
    Echo. >> c:\ra\lim\bu\BU-Note%BU%.%Lim%
    Q2 c:\ra\lim\bu\BU-Note%BU%.%Lim%
    copy \ra\lim\L0.%Lim% c:\ra\lim\bu\l0-%BU%.%Lim% > Nul
    copy \ra\lim\L1.%Lim% c:\ra\lim\bu\l1-%BU%.%Lim% > Nul
    copy \ra\lim\L2.%Lim% c:\ra\lim\bu\l2-%BU%.%Lim% > Nul
    copy \ra\lim\L4.%Lim% c:\ra\lim\bu\l4-%BU%.%Lim% > Nul
    copy \ra\lim\L5.%Lim% c:\ra\lim\bu\l5-%BU%.%Lim% > Nul
    GoTo %LOC%

:Exit
Set BU=
Set LOC=Menu
