@Echo off
Rem This file manages the use of PKZIP to do backups.  You need to set
Rem BUdrv to some suitable hard drive.  It is the default storage dir.
Rem This demonstrates how you can parse for arguments in a batch file.

Set Tmp5=
Set BUdrv=P:
If "%1" == ""    GoTo SyntaxHelp
If "%1" == "-l"  GoTo Log
If "%1" == "-a"  GoTo ArgHelp
If "%1" == "-h"  GoTo Help

Set Drive=%BUdrv%\Backup
Set EXIT=F
Set Incr=F
Set Source=*.*
Set Temp=F
Set Excl=F
Set Exclude=
Set Tdrive=
Set Dest=
Set Skip=
Set Wait=
Set Recurse=-r -p

:Scan
    If "%1" == "" GoTo Run
    If not "%1" == "-w" GoTo ChkDrive
    Echo Startup delay specIfied:  Wait = %2.
    Set Wait=%2
    Shift
    Shift
    GoTo Scan

:ChkDrive
    If not "%1" == "-d" GoTo ChkIncremental
    Echo Target (storage) drive is: %2.
    Set Drive=%2
    Shift
    Shift
    GoTo Scan

:ChkIncremental
    If not "%1" == "-i" GoTo ChkTame
    Echo This will be an incremental backup.
    Set Incr=T
    Shift
    GoTo Scan

:ChkTame
    If not "%1" == "-n" GoTo ChkTemp
    Set Tame=%2
    If not "%Tame%" == "" Shift
    If "%Tame%" == "" Set Tame=c
    Echo Using Tame to give up processor cycles.  Tame arg = %Tame%
    Shift
    GoTo Scan

:ChkTemp
    If not "%1" == "-t" GoTo ChkExit
    Echo Using RamDrive for PKZIP temp files.
    Set Temp=T
    Set pktmp=r:\
    Set Tdrive=-br:
    Shift
    GoTo Scan

:ChkExit
    If not "%1" == "-c" GoTo ChkRecurse
    Echo Will close window on completion of backup.
    Set EXIT=T
    Shift
    GoTo Scan

:ChkRecurse
    If not "%1" == "-r" GoTo ChkExclude
    Echo Disabling automatic recursion of subdirectories.
    Set Recurse=
    Shift
    GoTo Scan

:ChkExclude
    If not "%1" == "-x" GoTo ChkSource
    Echo Excluding "%2" from the backup.
    Set Excl=T
    If not "%Exclude%" == "" Set Exclude=%Exclude% -x%2
    If "%Exclude%" == "" Set Exclude=-x%2
    Shift
    Shift
    GoTo Scan

:ChkSource
    If not "%1%" == "-s" GoTo ChkDest
    Echo Source path is: %2.
    Set Source=%2
    Shift
    Shift
    GoTo Scan

:ChkDest
    If "%Skip%" == "s" GoTo GetSource
    Echo Destination zip filename: %1.
    Set Dest=%1
    Set Skip=s
    Shift
    GoTo Scan

:GetSource
    Echo Source path is: %1.
    Set Source=%1
    Shift
    GoTo Scan

:Error
    Echo Error in switch parameter!  %1 %2
    Echo Backup failed - error detected or nothing to backup! >> %BUdrv%\backup\backup.log
    Tstamp "$c " >> %BUdrv%\backup\backup.log
    Echo Back up of %Source% finished. >> %BUdrv%\backup\backup.log
    Echo. >> %BUdrv%\backup\backup.log
    GoTo Exit

:Run
    If not "%Tame%" == "" call Tame-bbs %Tame% >Nul
    Echo.
    Echo Main Args:  Source = %Source%   Dest = %Dest%   Exclude = %Exclude%
    Echo 2nd Args:   Drive = %Drive%   Delay = %Wait%   Tame = %Tame%
    Echo Toggles:    Recurse = %Recurse%   Exit = %EXIT%   Incr. = %Incr%  Temp = %Temp%
    Echo.
    Cntdwn oq 05
    Echo ================================================================ >> %BUdrv%\backup\backup.log
    Tstamp "$c " >> %BUdrv%\backup\backup.log
    Echo Backing up %Source% to %Drive%\%Dest%. >> %BUdrv%\backup\backup.log
    If "%Excl%" == "T" Echo   Excluding %Exclude%  >> %BUdrv%\backup\backup.log
    Echo   Args:  Recurse: %Recurse%  Delay: %Wait%  Tame: %Tame%  Exit: %EXIT%  Incr: %Incr%  Temp:= %Temp% >> %BUdrv%\backup\backup.log
    If "%Skip%" == "" GoTo Error
    If not "%Wait%" == "" Echo Going into wait for %Wait% minutes.
    If not "%Wait%" == "" Cntdwn oq %Wait%
    If "%Incr%" == "T" GoTo Incremental
        @Echo on
        @Echo Doing a non-incremental backup of %Source% to %Drive%\%Dest%
        pkzip -ex -a+ %Exclude% %Recurse% %Drive%\%Dest% %Tdrive% %Source%
        @Echo off
        GoTo ExitLog

    :Incremental
        @Echo on
        @Echo Doing an incremental backup of %Source% to %Drive%\%Dest%.
        pkzip -i -ex %Exclude% %Recurse% %Drive%\%Dest% %Tdrive% %Source%
        @Echo off
        GoTo ExitLog

:Log
    Q2 %BUdrv%\backup\backup.log
    GoTo Exit2

:SyntaxHelp
    Echo.
    Echo Syntax:  bkup Dest
    Echo Syntax:  bkup [-i] [-t] [-c] [-x Excl] [-d Drive] [-w mm:ss] [-s Source] Dest
    Echo Syntax:  bkup -l    To do backup log management
    Echo Syntax:  bkup -h    For comprehensive help screens
    Echo Syntax:  bkup -a    For BKUP arguments help screen
    Echo.
    GoTo Exit2

:ArgHelp
    Echo.
    Echo.
    Echo Switch  Parameters          BKUP Command Line Argument Descriptions
    Echo     
    Echo  -d     Drive:[Path]  Which drive to put the zip on, defaults to %BUdrv%\Backup
    Echo  -s     Source Path   Backup path, including drive
    Echo  -w     MM:SS         Minutes and seconds to wait before starting
    Echo  -n     Arg to Tame   "Nice" - uses Tame.  Suggest using 'f' normally
    Echo  -x     Filenames or  Exclude:  May be used multiple times, * ? permitted
    Echo         Full Paths    If you use *.* files AND subdirectories are excluded
    Echo  -i     None          Incremental - backup only files with archive bit ON
    Echo  -c     None          Close window on completion of backup
    Echo  -r     None          Turn off automatic subdirectory recursion
    Echo  -t     None          Use RamDrive for temporary storage
    Echo  -l     None          Edit/update the backup log
    Echo  -h     None          Produces this help screen
    Echo  -a     none          Gives only the help screen for BKUP arguments
    Echo.
    Echo.
    GoTo Exit2

:Help
cls
Echo.
Echo BKUP.BAT - (c) 1993 by Graham R. Fisher, Round's Hole In The Wall BBS
Echo                        Route 1, Box 786, Boone, North Carolina  28607
Echo.
Echo.
Echo Backup Utility - uses PKZIP to compress for later move to tape or floppy
Echo.
Echo Syntax:  bkup [-i] [-t] [-c] [-d Drive] [-w mm:ss] [-s Source] Dest
Echo Syntax:  bkup [-i] [-t] [-c] [-x Excl] ... [-x Excl] [-d Drive]
Echo                          [-w mm:ss] [-s Source] Dest
Echo.
Echo    BKUP uses PKZIP to make backups of files.  For obvious reasons, backups
Echo should NOT go on the same drive as the source files!  If you're backing up
Echo to floppies and the resultant zip is too large use SPLIT to break your zip
Echo into floppy-sized pieces, then use "copy a + b + ... dest.zip" to restore.
Echo    BKUP recurses all subdirectories and stores all pathnames.  The archive
Echo attribute bit is turned off for every file backed up.  After you do a full
Echo backup use the -i switch to do incremental backups.   Only files that have
Echo been changed or are new since the last backup will be backed up.
Echo.
Echo    To restore a single backup, use the "-d" switch with PKUNZIP so it will
Echo restore the stored directory stucture.  To extract a single FILE, you must
Echo use the "-e" switch and the full stored pathname of the desired file.
Echo.
BatchMan CEcho c Press "C" to continue...
BatchMan getkey 'c'
cls
Echo.
Echo.
Echo    If no source is given BKUP backs up everything in the current directory
Echo and all subdirectories in it (and their subdirectories, etc.)  The minimum
Echo possible command is "BKUP DestFilename" for the current directory.
Echo.
Echo    Switches can come in ANY order.  The -x (exclude) switch may be used as
Echo many times as you desire, but...  If you have more then 3 or 4 excludes it
Echo will be a lot better to use a listfile (see PKZIP docs for more).
Echo    You may supply filenames, or you can use wildcards.  Normally you'd use
Echo *.* instead of a filename.  If you use "-x c:\util\data\*.*", all files in
Echo data and ALL SUBDIRECTORIES OF DATA will be excluded.  Nice...
Echo.
Echo    The "-w" switch causes BKUP to go to sleep for the specIfied  number of
Echo minutes and seconds before beginning the backup.  This ability is supplied
Echo via the use of PC Magazine's BATCHMAN.
Echo    If you use Quarterdeck's DesqView and use Tame, the "-n" switch calls a
Echo batch file that Sets Tame parameters to keep BKUP from slowing things down
Echo too much... I will supply the batch file to registered users (as support).
Echo    The "-c" switch is also for DesqView.   It causes the DV window that is
Echo running BKUP to be closed automatically on exit.
Echo.
BatchMan CEcho c Press "C" to continue...
BatchMan getkey 'c'
cls
Echo.
Echo.
Echo    A very simple logging facility is built in, and uses Tstamp, by Richard
Echo Wilkes (included for your convenience) for time/data stamps.  It writes to
Echo the logfile start and finish times, as well as all important switches (and
Echo their values).  It will also log the fact that an error has occured If the
Echo backup terminates abnormally.
Echo    Note that If you do an incremental backup on a drive/path that includes
Echo files that have had no changes at all, there is nothing to backup, and you
Echo WILL get an error termination.  The error is that you told PKZIP to zip up
Echo something and it couldn't find anything TO zip up!  This IS normal.
Echo.
Echo    Suggested use:  Create a batch file with multiple calls to BKUP and run
Echo it nightly.  I can supply a batch file that runs in 30-day cycles.  On day
Echo one it does a full backup, then an incremental backup the next 29 days.  I
Echo use it myself to ease backing up 4 gigs of data on 16 drives...
Echo.
Echo    BKUP is indeed "just" a batch file, but...  If you use it, I would like
Echo to hear from you.  Contributions of $5.00 or more with "register" you, and
Echo will entitle you to support and/or future versions, and will encourage me,
Echo making it worth my while to do create other useful goodies!
Echo.
BatchMan CEcho c Press "C" to continue...
BatchMan getkey 'c'
cls
Call BKUP -a
BatchMan CEcho c Press "C" to continue...
BatchMan getkey 'c'
cls
Echo.
Echo    Note that If you use DesqView, use of the -w and -c switches give you a
Echo convenient means of scheduling your backups for later.  -w pauses BKUP for
Echo the specIfied time, then does the backup.  When it is finished, BKUP exits
Echo and closes the window automatically!
Echo.
Echo    I hope you find BKUP to be a useful utility to have and use, and that I
Echo will hear from you!  If you do not feel it is worth $5, at least send me a
Echo card telling me your thoughts...
Echo                                          -  Graham Fisher
Echo.
BatchMan CEcho c Press "C" to continue...
BatchMan getkey 'c'
Echo.
Echo.
GoTo Exit2

:ExitLog
    If errorlevel 1 GoTo ErrorExit
    dir %Drive%\%Dest%.* >> %BUdrv%\backup\backup.log
    Tstamp "  $c " >> %BUdrv%\backup\backup.log
    Echo Back up of %Source% finished. >> %BUdrv%\backup\backup.log
    Echo. >> %BUdrv%\backup\backup.log
    GoTo Exit

:ErrorExit
    Echo   Backup failed - error detected or nothing to backup! >> %BUdrv%\backup\backup.log
    Echo. >> %BUdrv%\backup\backup.log

:Exit
Set Drive=
Set EXIT=
Set Incr=
Set Source=
Set Dest=
Set Skip=
Set Wait=
Set Recurse=
If %EXIT%" == "T" Exit
:Exit2
