{-----------------------------------------------------------------------|

 General filefilter for the FILES.RA and MESSAGES.RA files.
 This source is intended as a framework for programming sysops. (That is,
 the should know SOME pascal..;-)

 B.t.w. I kept it VERY simple. Make a backup of the file to process before
 you apply this filter!! USE AT YOUR OWN RISK!

 Donated to the public domain. Enjoy it in good healt..

 Author: Gerhard Hoogterp
 Fidonet: 2:283/1.2


|-----------------------------------------------------------------------}


Program RA_File_Filter;
Uses Dos;

{$I Struct.110}

{ To change this filter to other RA or record files just changes the }
{ following constants and types.                                     }

Const  UseFile   = 'FILES';
       Extention = '.RA';
Type   UseRecord = FilesRecord;

{ Other possibility:

Const  UseFile   = 'MESSAGES';
       Extention = '.RA';
Type   UseRecord = MESSAGERecord;

}

{ Some other constants }

Const ReadOnly           = $00;
      WriteOnly          = $01;
      ReadWrite          = $02;

      ShareCompatible    = $00;
      ShareDenyReadWrite = $10;
      ShareDenyWrite     = $20;
      ShareDenyRead      = $30;
      ShareDenyNone      = $40;

      Inheritance        = $80;


Var Inp,Out  : File of UseRecord;
    Rec      : UseRecord;
    Path     : ComStr;
    RecCount : Byte;

Procedure CompletePath(Var Path : ComStr);
Begin
Path:=FExpand(Path);
If (Path[Length(Path)]<>'\') And
   (Path[Length(Path)]<>':')
   Then Path:=Path+'\';
End;


Begin
WriteLn('General RA file filter for pascal programmers.');
WriteLn;
WriteLn('Usage: FileFilt [Path]');
WriteLn('If no path is given, the RA system directory is assumed!');

Path:=GetEnv('RA');   { Get the RA path }
If ParamCount>0
   Then Path:=ParamStr(1);
CompletePath(Path);   { and clean it up }

FileMode:= ReadOnly+ShareDenyNone;

Assign(Inp,Path+UseFile+Extention); { Open the file in question }
Reset(Inp);
If IoResult<>0
   Then Begin
        WriteLn('! Couldn''t open '+UseFile+Extention);
        Halt;
        End;

FileMode:=ReadWrite+ShareDenyReadWrite;

Assign(Out,Path+UseFile+'.$T$'); { Open a temp. file for output }
Rewrite(Out);
If IoResult<>0
   Then Begin
        WriteLn('! Couldn''t open tempfile '+UseFile+'.$T$');
        Close(Inp);
        Halt;
        End;


For RecCount:=1 To 200 Do    { Process the records }
 Begin
 Write(#13'Record: ',RecCount:3);
 Read(Inp,Rec);

 { Here you can process the record }
 With Rec Do
  Begin

  Attrib:=Attrib and $FE;  { Bit 0 -> false. No newfile scan }

  End;
 { And write the output }

 Write(Out,Rec);
 If IoResult<>0
    Then Begin
        WriteLn('! Problem writting '+UseFile+'.$T$');
        Close(Inp);
        Close(Out);
        Halt;
        End;
 End;

WriteLn;

{ Close the files }

Close(Out);
Close(Inp);

{ Erase the original file }

Erase(Inp);

{ and rename the new file }

Rename(Out,Path+UseFile+Extention);
WriteLn(' Ready...');

End.