{$A+,B-,D-,E-,F-,I-,L-,N-,O-,R-,S+,V-}
{$M 20000,0,0}
{ͻ
                                                                          
                    (c) CopyRight LiveSystems 1990, 1994                  
                                                                          
  Author    : Gerhard Hoogterp                                            
  FidoNet   : 2:282/100.5   2:283/7.33                                    
  BitNet    : GERHARD@LOIPON.WLINK.NL                                     
                                                                          
  SnailMail : Kremersmaten 108                                            
              7511 LC Enschede                                            
              The Netherlands                                             
                                                                          
         This module is part of the RADoor BBS doorwriters toolbox.       
                                                                          
 ͼ}
Program RASearch;
Uses DOS,
     CRT,

     UOsys,      { UserOn support                                }
     UserHook,   { Demo/default userhook procedures              }
     GlobInfo,   { the global record with all the nessecary info }
     DoorSys,    { Misc. Door routines.                          }
     Fossil,     { The fossil routines + Timing etc.             }
     Filter,     { The default output filter                     }
     LowLevel,   { The lowlevel stuff                            }

     RA,         { The RA init code                              }
     SuperBBS,   { The SBBS init code                            }
     QuickBBS,   { The QBBS init code                            }

     BBStypes;   { check for the used BBS                        }


Const  ProgramName    = 'Search';
       ProgramVersion = '1.3';
       LastUpdate     = '09 May 1992';

Var    Foss           : FossilObject;
       DoIt           : UserDoesObject;

{----------------------------------------------------------------------------|
 Start here your own procedures and functions
|----------------------------------------------------------------------------}

Type Str12     = String[12];

Var Path       : ComStr;
    Name       : Str12;
    Dir        : String[4];

    Drives     : String[20];
    DriveCount : Byte;
    Found      : Word;

    Dum        : Char;
    Lines      : Byte;
    Stop       : Boolean;


Procedure SearchDir(Dir : ComStr;FileSpec : Str12); { Recursive procedure }
Var Search : SearchRec;
Begin
CompletePath(Dir);
FindFirst(Dir+FileSpec,AnyFile,Search);
While (Not Stop) And (DosError=0) Do
 Begin
 If Not Foss.Carrier
    Then Exit;

 If (Search.Attr And Archive)=Archive
    Then Begin
         Foss.WriteLnF(Dir+Search.Name);
         Inc(Found);
         Inc(Lines);
         End;

 If (GlobalInfo.UseMoreYN) And
    (Lines=(GlobalInfo.ScreenLength-2))
    Then Begin
         Foss.WriteLnF('');
         Stop:=Foss.PressEnterOrStop;
         If Not Stop
            Then Begin
                 Foss.ClrScrF;
                 Foss.WriteLnF('^4^!'+Center('-=( Searching drive '+Drives[Drivecount]+': )=-')+'^0');
                 Foss.WriteLnF('');
                 Lines:=4;
                 End;
         End;
 FindNext(Search);
 End;

FindFirst(Dir+'*.*',Directory,Search);
While (Not Stop) And (DosError=0) Do
 Begin
 If Not Foss.Carrier
    Then Exit;

 If ((Search.Attr And Directory)=Directory) And
    (Search.Name[1]<> '.')
    Then SearchDir(Dir+Search.Name,FileSpec);
 FindNext(Search);
 End;
End;


{----------------------------------------------------------------------------|
 Start of main module
|----------------------------------------------------------------------------}
Begin

{ Clear the local screen and show the copyright notice. }

ClrScr;
WriteLn(ProgramName,' ',ProgramVersion,' (c) LiveSystems 1992,1993   ALL RIGHTS RESERVED,  NO GUARANTEES');
WriteLn('Written by G.Hoogterp. E-mail address 2:283/1.2 Last Revision '+LastUpdate);
WriteLn('Use SEARCH -? to see commandline parameter summary.');

If ExistParameter('?')  { Wana see the parameters? }
   Then Begin
        WriteLn('Usage: ');
        WriteLn;
        WriteLn(' SEARCH.EXE [-T:<TimeLimit>] [-N:*N] [-P:*P] [-NOS]');
        WriteLn;
        WriteLn(' -T:       Limit the time available in the door.');
        WriteLn(' -N:       Give nodenumber for multiline setups.');
        WriteLn(' -P:       Give ComPort to use.');
        WriteLn(' -NOS      Turn local sounds OFF for default.');
        WriteLn(' -DRIVES:  Which drives to search. F.e. -DRIVES:CDEF');
        Halt;
        End;

{----------------------------------------------------------------------------|
 Grab the BBS specific stuff into the GlobalInfo record
|----------------------------------------------------------------------------}

Case CurrentBBStype Of
 RA_BBS : InitRA;
 S_BBS  : InitSBBS;
 Q_BBS  : InitQBBS;
End;

{ Anounce which program is running.. }

LogIt('Started: '+ProgramName+' '+ProgramVersion+' under '+GlobalInfo.BBSName);

{ And tell the rest of the world too..;-) }

DoIt.Init('Is using LiveSystems File Search to find some files..');
DoIt.SetIt;

{ Ok, our own parameters... }

If ExistParameter('DRIVES:')
   Then Drives:=GrabParameter('DRIVES:')
   Else Begin
        LogIt('Hmpz.. No DRIVES specification!');
        Halt;
        End;

{----------------------------------------------------------------------------|
  Fossil initializations
|----------------------------------------------------------------------------}

With GlobalInfo Do
 Begin
 Foss.AssignF(ComPort-1,BaudRate);
 If Foss.Error<>0
    Then Begin
         WriteLn(#254' Couldn''t initialize fossil!');
         LogIt('Couldn''t init fossil!');
         Halt;
         End;

 Foss.InitTimer(                        { Init the timeout procedures              }
                GlobalInfo.Warnings,    { Warning before pushed back to the BBS    }
                GlobalInfo.TimeOutTime  { Timeout time before and between warnings }
                );


 Foss.InitOutputFilter(UsedFilter);
 Foss.InitInputFilter(FileCharSet);

 Foss.InitSysopKeys(SysopKeys);
 Foss.InitStatLine(StatusLine);

 InitUsedFilter(UseGraphics,UseAVATAR,LeftBracket,RightBracket,'^');
 End;

{ Language Strings }

PressEnterOrStopString := '^0Press ^[^1ENTER^0^] to continue, ^[^1S^0^] to Stop: ^2';
PressEnterString       := '^0Press ^[^1ENTER^0^] to continue: ^2';
Warning1String         := '^1^[You have only 2 minutes left!^]^0';
Warning2String         := '^1^[You have only 1 minute left!^]^0';
AttentionString        := 'HELLO???';
LockOutString          := '^1You''ve been locked out of the system! Don''t call back..';
HangUpString           := '^1The Sysop hungup the phone, call back an other time.';
TimeUpString           := '^1Sorry, you reached your daily timelimit. Hope to see you back an other time.';
UsedStopKey            := 'S';

{ Color table }

ColorTable[0]:=LightCyan;           { Normal text color            }
ColorTable[1]:=LightRed;            { Hotkey's and lines           }
ColorTable[2]:=White;               { Userinput and info highlight }
ColorTable[3]:=Yellow;              { Info                         }
ColorTable[4]:=(Blue Shl 4)+White;  { Statusline color             }
ColorTable[5]:=LightRed;            { Lines and frames             }
ColorTable[6]:=(Red Shl 4)+White;   { Inputfields                  }


{----------------------------------------------------------------------------|
  The main program body.
|----------------------------------------------------------------------------}

{ first the header }

Foss.ClrScrF;
Foss.WriteLnF('^4^!'+Center('-=( LiveSystems '+ProgramName+' '+ProgramVersion+' )=- ')+'^0');
Foss.WriteLnF('');

{ Ask for a file specification. }

Name:='';
Foss.WriteF('^0Give a FileSpec: ^6');
Foss.ReadLnF(Name,12);
Foss.WriteF('^0');

{ and if the spec isn't empty, search the drives... }

If Name<>''
   Then Begin
        LogIt('User Searches drive(s) '+Drives+' for '+Name);

        DriveCount:=1;
        Dum:=#00;

        Stop:=False;

        While (DriveCount<=Length(Drives)) And (Not Stop) Do
          Begin
          Lines:=4;
          Found:=0;

          { The FindFile header }

          Foss.ClrScrF;
          Foss.WriteLnF('^4^!'+Center('-=( Searching drive '+Drives[Drivecount]+': )=-')+'^0');
          Foss.WriteLnF('');
          SearchDir(Drives[DriveCount]+':\',Name);

          If Found=0
             Then Begin
                  Foss.WriteLnF('');
                  Foss.WriteLnF('^1'+Center('To bad.. Nothing found..')+'^0');
                  Inc(Lines,2);
                  End;

          While Lines <= GlobalInfo.ScreenLength Do
           Begin
           Foss.WriteLnF('');
           Inc(Lines);
           End;

          Stop:=Foss.PressEnterOrStop;
          Inc(DriveCount);
          End;

        End;

{----------------------------------------------------------------------------|
   Say thank you, and finalize the program.
|----------------------------------------------------------------------------}

Foss.ClrScrF;
Foss.WriteLnF('Thanks for using '+ProgramName+' '+ProgramVersion);
Delay(1000);

Case CurrentBBStype Of
 RA_BBS : If Not RAUpdateExitInfo
             Then LogIt('Couldn''t update the EXITINFO.BBS!');
 S_BBS  : If Not SBBSUpdateExitInfo
             Then LogIt('Couldn''t update the EXITINFO.BBS!');
 Q_BBS  : If Not QBBSUpdateExitInfo
             Then LogIt('Couldn''t update the EXITINFO.BBS!');
End;

DoIt.ClearIt; { Clear the UserDoes string }


LogIt('Stopped: '+ProgramName+' '+ProgramVersion);
Foss.CloseF;
End.
