{ͻ
                                                                          
                    (c) CopyRight LiveSystems 1990, 1994                  
                                                                          
  Author    : Gerhard Hoogterp                                            
  FidoNet   : 2:282/100.5   2:283/7.33                                    
  BitNet    : GERHARD@LOIPON.WLINK.NL                                     
                                                                          
  SnailMail : Kremersmaten 108                                            
              7511 LC Enschede                                            
              The Netherlands                                             
                                                                          
         This module is part of the RADoor BBS doorwriters toolbox.       
                                                                          
 ͼ}
{--------------------------------------------------------------------------|
 Description:

  This unit contains all the RA specific stuff. It's main purpose is to
  fill the GlobalInfo record. Doing things this way it's easier to make a
  door less system dependable. As long as you only use the information
  in GlobalInfo in your doors, it's easy to make versions for other BBSses
  or to add support for more than one BBS. (Detect in your mainprogram and
  call the right initprocedure!)

  If an other BBS doesn't support some information which is contained in the
  GlobalInfo record, it's up to YOU to provide usable values!

|--------------------------------------------------------------------------}
{$Define UseMultilanguage} { Turn multilang in logfunction on/off }

Unit RA;
Interface
Uses Dos,
     CRT,
{$IfDef UseMultiLanguage}
     Language, { MultiLanguage support, needed for Logging    }
{$EndIf}
     FileObj,  { Typed file handling object                   }
     Fossil,   { Fossil object, needed for online msgs.       }
     GlobInfo; { The globale info. Thisone needs to be filled }

Const  RABBS = 1; { This is a unike BBS tag to indentify the current  }
                  { BBS in the global info. Make tags for other BBSes }
                  { Also unike, at least for your own programs!       }



{--------------------------------------------------------------------------|
  All the RA Structures for RA 1.00
|--------------------------------------------------------------------------}

Type RAFlagType     = Array[1..4] of Byte;
     RATime         = String[5];
     RADate         = String[8];
     RALongDate     = String[9];
     RAVideoType    = (Auto, Short, Long);
     RAOrphanType   = (Ignore, Create, Kill);


Type  RACOMBINEDrecord = Array[1..25] of Byte;
      RANameString     = String[35];

Var RAPath : ComStr;


Type RANetAddress   = Record
                       Zone,
                       Net,
                       Node,
                       Point  : Word;
                      End;

     RAAskType      = (Yes, No, Ask);

     RALANGUAGErecord = Record
                          Name           : String[20];
                          Attribute      : Byte;
                          DefName,
                          MenuPath,
                          TextPath,
                          QuesPath       : String[60];
                          FreeSpace      : Array[1..200] of Byte;
                        End;

      RACONFIGrecord = Record
                         VersionID           : Word;
                         CommPort            : Byte;
                         Baud                : LongInt;
                         InitTries           : Byte;
                         InitStr,
                         BusyStr             : String[70];
                         InitResp,
                         BusyResp,
                         Connect300,
                         Connect1200,
                         Connect2400,
                         Connect4800,
                         Connect9600,
                         Connect19k,
                         Connect38k          : String[40];
                         AnswerPhone         : Boolean;
                         Ring,
                         AnswerStr           : String[20];
                         FlushBuffer         : Boolean;
                         ModemDelay          : Integer;

                         MinimumBaud,
                         GraphicsBaud,
                         TransferBaud        : Integer;
                         SlowBaudTimeStart,
                         SlowBaudTimeEnd,
                         DownloadTimeStart,
                         DownloadTimeEnd     : RATime;

                         PageStart           : Array[0..6] of RATime;
                         PageEnd             : Array[0..6] of RATime;



                     {}  FreeSpace1          : Array[1..70] of Byte;
                         PwdExpiry           : Word;

                         MenuPath,
                         TextPath,
                         AttachPath,
                         NodelistPath,
                         MsgBasePath,
                         SysPath,
                         ExternalEdCmd       : String[60];

                         Address             : Array[0..9] of RANetAddress;
                         SystemName          : String[30];

                         NewSecurity         : Word;
                         NewCredit           : Word;
                         NewFlags            : RAFlagType;

                         OriginLine          : String[60];
                         QuoteString         : String[15];
                         Sysop               : String[35];
                         LogFileName         : String[60];
                         FastLogon,
                         AllowSysRem,
                         MonoMode,
                         StrictPwdChecking,
                         DirectWrite,
                         SnowCheck           : Boolean;
                         CreditFactor        : Integer;

                         UserTimeOut,
                         LogonTime,
                         PasswordTries,
                         MaxPage,
                         PageLength          : Word;
                         CheckForMultiLogon,
                         ExcludeSysopFromList,
                         OneWordNames        : Boolean;
                         CheckMail           : RAAskType;
                         AskVoicePhone,
                         AskDataPhone,
                         DoFullMailCheck,
                         AllowFileShells,
                         FixUploadDates,
                         FreezeChat          : Boolean;
                         ANSI,                             { ANSI: Yes, no, or ask new users     }
                         ClearScreen,                      { Clear:        "                     }
                         MorePrompt          : RAAskType;    { More:         "                     }
                         UploadMsgs          : Boolean;
                         KillSent            : RAAskType;    { Kill/Sent     "                     }

                         CrashAskSec         : Word;       { Min sec# to ask 'Crash Mail ?'      }
                         CrashAskFlags       : RAFlagType;
                         CrashSec            : Word;       { Min sec# to always send crash mail. }
                         CrashFlags          : RAFlagType;
                         FAttachSec          : Word;       {        "    ask 'File Attach ?'     }
                         FAttachFlags        : RAFlagType;

                         NormFore,
                         NormBack,
                         StatFore,
                         StatBack,
                         HiBack,
                         HiFore,
                         WindFore,
                         WindBack,
                         ExitLocal,
                         Exit300,
                         Exit1200,
                         Exit2400,
                         Exit4800,
                         Exit9600,
                         Exit19k,
                         Exit38k             : Byte;

                         MultiLine           : Boolean;
                         MinPwdLen           : Byte;
                         MinUpSpace          : Word;
                         HotKeys             : RAAskType;
                         BorderFore,
                         BorderBack,
                         BarFore,
                         BarBack,
                         LogStyle,
                         MultiTasker,
                         PwdBoard            : Byte;
                         BufferSize          : Word;
                         FKeys               : Array[1..10] of String[60];

                         WhyPage             : Boolean;
                         LeaveMsg            : Byte;
                         ShowMissingFiles    : Boolean;
                     {}  FreeSpace2          : Array[1..11] of Byte;
                         AllowNetmailReplies : Boolean;
                         LogonPrompt         : String[40];
                         CheckNewFiles       : RAAskType;
                         ReplyHeader         : String[60];
                         BlankSecs           : byte;
                         ProtocolAttrib      : Array[1..6] of Byte;
                         ErrorFreeString     : String[15];
                         DefaultCombined     : RACOMBINEDrecord;
                         RenumThreshold      : Word;
                         LeftBracket,
                         RightBracket        : Char;
                         AskForHandle        : Boolean;
                         AskForBirthDate     : Boolean;

                         GroupMailSec        : Word;

                         ConfirmMsgDeletes   : Boolean;
                         FreeSpace3          : Array[1..163] of Byte;
                         NewUserGroup        : Byte;
                         AVATAR              : RAAskType;
                         BadPwdArea          : Byte;
                         Location            : String[40];
                         DoAfterAction       : Byte; {0 = wait for CR, > 0 = wait for x seconds}
                         FileLine            : String[40];
                         CRfore,
                         CRback              : Byte;
                         LangHdr             : String[40];
                         SendBreak           : Boolean;
                         ListPath            : String[60];
                         FullMsgView         : RAAskType;
                         EMSI_Enable         : RAAskType;
                         EMSI_NewUser        : Boolean;

                         EchoChar            : String[1];
                         Connect7200,
                         Connect12000,
                         Connect14400        : String[40];
                         Exit7200,
                         Exit12000,
                         Exit14400           : Byte;
                         ChatCommand         : String[60];
                         ExtEd               : RAAskType;
                         NewuserLanguage     : Byte;
                         LanguagePrompt      : String[40];
                         VideoMode           : RAVideoType;
                         AutoDetectANSI      : Boolean;
                         OffHook             : Boolean;
                         NewUserDateFormat   : Byte;
                         KeyboardPwd         : String[15];
                         CapLocation         : Boolean;
                         NewuserSub          : Byte;
                         PrinterName         : String[4];
                         HilitePromptFore,
                         HiLitePromptBack    : Byte;
                         InitStr2            : String[70];
                         AltJSwap            : Boolean;
                         SemPath             : String[60];
                         AutoChatCapture     : Boolean;

                         FutureExpansion : Array[1..97] of Byte;
                       End;

  RAUSERSXIrecord  = record
                       Handle         : String[35];
                       Comment        : String[80];
                       FirstDate      : RADate;
                       CombinedInfo   : RACOMBINEDrecord;
                       BirthDate,
                       SubDate        : RADate;
                       ScreenWidth,
{1.10}                 MsgArea,
                       FileArea,
                       Language,
                       DateFormat     : Byte;
                       ForwardTo      : String[35];
                       ExtraSpace     : Array[1..43] of Byte;
                     end;


       RAUsersRecord   = Record
                          Name          : RANameString;
                          Location      : String[25];
                          Password      : String[15];
                          DataPhone,
                          VoicePhone    : String[12];
                          LastTime      : RATime;
                          LastDate      : RADate;
                          Attribute     : Byte;
                          Flags         : RAFlagType;
                          Credit,
                          Pending       : Word;
                          MsgsPosted,
                          LastRead,
                          Security,
                          NoCalls,
                          Uploads,
                          Downloads,
                          UploadsK,
                          DownloadsK    : Word;
                          TodayK        : Word;
                          Elapsed       : Integer;
                          ScreenLength  : Word;
                          LastPwdChange,
                          Attribute2    : Byte;
                          Group         : Byte;
    { New 1.0 }           XIRecord      : Word;
                          ExtraSpace    : Array[1..3] of Byte;
                         End;

     RASysInfoRecord = Record
                        TotalCalls  : LongInt;
                        LastCaller  : RANameString;
                        ExtraSpace  : Array[1..128] of Byte;
                       End;

     RATimeLogRecord = Record
                        StartDate   : RADate;
                        BusyPerHour : Array[0..23] of Word;
                        BusyPerDay  : Array[0..6] of Word;
                       End;

     RAEventRecord    = Record
                         Status      : Byte; { 0=Deleted 1=Enabled 2=Disabled }
                         StartTime   : RATime;
                         ErrorLevel  : Byte;
                         Days        : Byte;
                         Forced      : Boolean;
                         LastTimeRun : RADate;
                        End;

     RAExitInfoRecord = Record
                         Baud            : Word;
                         SysInfo         : RASysInfoRecord;
                         TimeLogInfo     : RATimeLogRecord;
                         UserInfo        : RAUsersRecord;
                         EventInfo       : RAEventRecord;
                         NetMailEntered,
                         EchoMailEntered : Boolean;
                         LoginTime       : RATime;
                         LoginDate       : RADate;
                         TimeLimit       : Word;
                         LoginSec,
                         Credit          : LongInt;
                         UserRecord      : Integer;
                         ReadThru        : Word;
                         NumberPages     : Word;
                         DownloadLimit   : Word;
                         TimeOfCreation  : RATime;
                         LogOnPassword   : String[15];
                         WantChat        : Boolean;
  { New 1.0 }
                         DeductedTime    : Integer;
                         MenuStack       : Array[1..50] of String[8];
                         MenuStackPointer: Byte;
                         UserXIinfo      : RAUSERSXIrecord;
                         ErrorFreeConnect,
                         SysopNext       : Boolean;
                         EMSI_Session    : Boolean;        { These fields hold  }
                         EMSI_Crtdef,                      { data related to an }
                         EMSI_Protocols,                   { EMSI session       }
                         EMSI_Capabilities,
                         EMSI_Requests,
                         EMSI_Software   : String[40];
                         Hold_Attr1,
                         Hold_Attr2,
                         Hold_Len        : Byte;

                         ExtraSpace      : Array[1..100] of Byte;
                       End;


{--------------------------------------------------------------------------|
  Variables which contain the CONFIG.RA and the EXITINFO.BBS info. Note
  that I included RA in the variable name to avoid conflicts with the names
  of other BBS's their configuration files.
|--------------------------------------------------------------------------}

Var RAExitInfo  : RAExitInfoRecord;
    RAConfig    : RAConfigRecord;

{--------------------------------------------------------------------------|
  And the procedures to read and write the configuration info.

  InitRA should be called once at the start of your program to initialize
         your door for RemoteAccess.

  UpdateExitInfo
         Rewrites the EXITINFO.BBS Record. To avoid problems with newer
         version of RA, which probably add fields to this file, only
         as much bytes are read and written as the size of the record
         defined in this unit. As long as the file is upward compatible
         this should avoid conflicts.
         The function returns false if it wasn't able to write the info.

         The users TimeLimit and Security are always updated while writing,
         Other field you have to change for yourself.

|--------------------------------------------------------------------------}


Procedure InitRA;
Function RAUpdateExitInfo:Boolean;

Implementation
Uses LowLevel; { To avoid a circular reference error }

Const UseLog : Boolean = False; { Is set to TRUE as soon as a LogProcedure }
                                { is installed                             }

{$F+}
Procedure FroDoLogIt(LogLine  : MaxlogStr);
{$F-}

Var Log    : Text;
    temp   : Integer;
    Hour   : Word;
    Minute : Word;
    Second : Word;
    Dum    : Word;

Begin
If Not UseLog
   Then Exit;
{$IfDef UseMultiLanguage}
  LogLine:=ExpandString(LogLine);
{$EndIf}
GetTime(Hour,Minute,Second,Dum);
LogLine:= '> '+
          S(Hour,2)+':'+
          S(Minute,2)+':'+
          S(Second,2)+'  '+
          LogLine;
For Dum:=3 To 10 Do
 If LogLine[Dum]=' '
    Then LogLine[Dum]:='0';

FileMode:=ReadWrite+ShareDenyNone;
Assign(Log,GlobalInfo.LogFileName);
Append(Log);
If IoResult<>0
   Then Rewrite(Log);
WriteLn(Log,LogLine);
Close(Log);
If IoResult<>0
   Then Begin
        WriteLn(#254' Can''t LOG anymore !!!');
        UseLog:=False;
        End;
End;

Const Months : Array[1..12] Of String[3] =
       ('Jan','Feb','Mar','Apr','May','Jun',
        'Jul','Aug','Sep','Oct','Nov','Dec');

{$F+}
Procedure OpusLogIt(LogLine  : MaxlogStr);
{$F-}

Var Log    : Text;
    temp   : Integer;
    Hour   : Word;
    Minute : Word;
    Second : Word;
    Dum    : Word;
    Day    : Word;
    Month  : Word;

Begin
If Not UseLog
   Then Exit;
{$IfDef UseMultiLanguage}
  LogLine:=ExpandString(LogLine);
{$EndIf}
GetTime(Hour,Minute,Second,Dum);
GetDate(Dum,Month,Day,Dum);
LogLine:= '> '+
          S(Day,2)+'-'+
          Months[Month]+' '+
          S(Hour,2)+':'+
          S(Minute,2)+':'+
          S(Second,2)+' '+
          'RA'+S(GlobalInfo.Node,2)+' '+
          LogLine;

If LogLine[3]=' '
   Then LogLine[3]:='0';
If LogLine[21]=' '
   Then LogLine[21]:='0';


For Dum:=10 To 17 Do
 If LogLine[Dum]=' '
    Then LogLine[Dum]:='0';

FileMode:=ReadWrite+ShareDenyNone;
Assign(Log,GlobalInfo.LogFileName);
Append(Log);
If IoResult<>0
   Then Rewrite(Log);
WriteLn(Log,LogLine);
Close(Log);
If IoResult<>0
   Then Begin
        WriteLn(#254' Can''t LOG anymore !!!');
        UseLog:=False;
        End;
End;

{---- Language support ---------------------------------------------------}

Type LangID = String[3];

Function ReadRALanguage(Nr : Byte):LangID;
Var Lang    : FileObject;
    LangRec : RALanguageRecord;
    Dum     : String[10];
    FName   : String[8];

Begin
ReadRALanguage:='English';
If Nr=0
   Then Exit;
With Lang Do
 Begin
 Open(GlobalInfo.SystemPath+'LANGUAGE.RA',SizeOf(LangRec),ReadOnly+ShareDenyNone);
 GotoRecord(Nr-1);
 If IoError<>0
    Then GotoRecord(0);
 Read(LangRec);
 Close;
 If IoError<>0
    Then Exit;
 End;
FSplit(LangRec.DefName,Dum,FName,Dum);
If Length(Fname)>3
   Then FName[0]:=#3;
ReadRALanguage:=FName;
End;

{---- Read CONFIG record -------------------------------------------------}

Function ReadRAConfig:Boolean;
Var Conf : FileObject;
    Size : Word;
Begin
ReadRAConfig:=False;
FillChar(RAConfig,SizeOf(RAConfig),#00);

Conf.Open('CONFIG.RA',1,ReadOnly+ShareDenyNone);
If Conf.Error<>0
   Then Begin
        Conf.Open(RAPath+'CONFIG.RA',1,ReadOnly+ShareDenyNone);
        If Conf.Error<>0
           Then Exit;
        End;
Size:=SizeOf(RAConfig);
Conf.ReadBuffer(RAConfig,Size);
Conf.Close;


With GlobalInfo Do
 Begin
 BBStag  := RABBS;
 BBSName := 'RemoteAccess 1.xx';

 OnlineStatus:=Normal;
 SystemStatus:=S_OK;

 LogfileName   := RAConfig.LogFileName;
 LogType       := RAConfig.LogStyle;

 Case LogType Of
  1 : LogIt := FrodoLogIt;
  0 : LogIt := OpusLogIt;
 End; {Case}

 UseLog        := True;
 TimeOutTime   := RAConfig.UserTimeout;
 Warnings      := 2; { My constate! }

 UserFilePath  := RAConfig.MsgBasePath;
 CompletePath(UserFilePath);

 CommonDir:=RaConfig.SemPath;
 If CommonDir=''
    Then CommonDir:=RAConfig.SysPath;
 CompletePath(CommonDir);

 LeftBracket   := RAConfig.LeftBracket;
 RightBracket  := RAConfig.RightBracket;

 SysopName     := RAConfig.SysOp;
 SystemName    := RAConfig.SystemName;
 SystemLocation:= RAConfig.Location;

 LocalMono     := RAConfig.MonoMode;

 If ExistParameter('P:')
    Then ComPort:=Str2Nr(GrabParameter('P:'))
    Else ComPort := RAConfig.CommPort;

 MultiLine     := RAConfig.MultiLine;
 End; {With}

{---- To make sure the major paths are all nice and complete... ---------}

CompletePath(RAConfig.MenuPath);
CompletePath(RAConfig.TextPath);
CompletePath(RAConfig.AttachPath);
CompletePath(RAConfig.NodelistPath);
CompletePath(RAConfig.MsgBasePath);
CompletePath(RAConfig.SysPath);
CompletePath(RAConfig.SemPath);
CompletePath(RAConfig.ListPath);

ReadRAConfig  := True;
End;



{---- ExitInfo.bbs procedures -----------------------------------------}

Function RAUpdateExitInfo:Boolean;
Var Info : FileObject;
    Size : Word;
Begin
RAUpdateExitInfo:=False;

If GlobalInfo.MultiLine
   Then Info.Open('EXITINFO.BBS',1,ReadWrite+ShareDenyNone)
   Else Info.Open(GlobalInfo.SystemPath+'EXITINFO.BBS',1,ReadWrite+ShareDenyNone);

If Info.Error <> 0
   Then Exit;

Size:=SizeOf(RAExitInfo);

RAExitInfo.UserInfo.Security:=GlobalInfo.UserSecurity;


Inc(
     RAExitInfo.UserInfo.Elapsed,
     Integer(RAExitInfo.TimeLimit-GlobalInfo.MinRemaining)
   );



Info.GotoRecord(0);
Info.WriteBuffer(RAExitInfo,Size);
Info.Close;

RAUpdateExitInfo:=Info.Error=0;
End;

Procedure RABirthDay(Var D : RADate;Var Age: Byte);
Var Year,Month,Day : Word;
    Now            : DateTime;
    Dum            : Word;
Begin
With Now Do
 GetDAte(Year,Month,Day,Dum);
Month:=Str2Nr(Copy(D,1,2));
Day:=Str2Nr(Copy(D,4,2));
Year:=Str2Nr(Copy(D,7,2))+1900;
If (Month*Year*Day=0)
   Then Begin
        Age:=0;
        D:='UnKnown';
        Exit;
        End;
Age:=Now.Year-Year-1;
If (Now.Month>Month) Or
   ((Month=Now.Month) And (Now.Day>=Day))
   Then Inc(Age);
D:=SF(Day,2)+'-'+SF(Month,2)+'-'+SF(Year-1900,2);
End;


Function ReadExitInfo:Boolean;
Var Info : FileObject;
    Size : Word;
Begin
ReadExitInfo:=False;
FillChar(RAExitInfo,SizeOf(RAExitInfo),#00);

If GlobalInfo.MultiLine
   Then Info.Open('EXITINFO.BBS',1,ReadOnly+ShareDenyNone)
   Else Info.Open(GlobalInfo.SystemPath+'EXITINFO.BBS',1,ReadOnly+ShareDenyNone);

If Info.Error <> 0
   Then Exit;

Size:=SizeOf(RAExitInfo);
Info.ReadBuffer(RAExitInfo,Size);
Info.Close;

With GlobalInfo Do
 Begin

 ScreenWidth  := RAExitInfo.UserXiInfo.ScreenWidth;
 If ScreenWidth=0
    Then ScreenWidth:=80;

 UserName     := RAExitInfo.UserInfo.Name;
 UserHandle   := RAExitInfo.UserXIInfo.Handle;
 If UserHandle=''
    Then UserHandle:=UserName;
 UserLocation := RAExitInfo.UserInfo.Location;
 UserSecurity := RAExitInfo.UserInfo.Security;

 UserBirthDay := RAExitInfo.UserXIInfo.BirthDate;
 RABirthDay(UserBirthDay,UserAge);
 UserGroup := RAExitInfo.UserInfo.Group;


 ScreenLength := RAExitInfo.UserInfo.ScreenLength;
 UseGraphics  := (RAExitInfo.UserInfo.Attribute  And $08 ) = $08;
 UseAVATAR    := (RAExitInfo.UserInfo.Attribute2 And $02 ) = $02;
 UseMoreYN    := (RAExitInfo.UserInfo.Attribute  And $04 ) = $04;
 UseClrScr    := (RAExitInfo.UserInfo.Attribute  And $02 ) = $02;
 UseQuietMode := (RAExitInfo.UserInfo.Attribute  And $80 ) = $80;
 BaudRate     := RAExitInfo.Baud;
 MinRemaining := RAExitInfo.TimeLimit;
 TimeLimit    := RAExitInfo.TimeLimit;
 End; {With}

FillChar(IEMSIInfo,SizeOf(IEMSIInfo),#00);
With RAExitInfo, IEMSIInfo Do
 Begin
 Session        := EMSI_Session;
 CRTDef         := EMSI_Crtdef;
 Protocols      := EMSI_Protocols;
 Capabilities   := EMSI_Capabilities;
 Requests       := EMSI_Requests;
 Software       := EMSI_Software;

 Attr1          := Hold_Attr1;    { The original values! Not the IEMSI values }
 Attr2          := Hold_Attr2;
 Len            := Hold_Len;
 End;

ReadExitInfo:= True;
End;



{--------------------------------------------------------------------------|
  INITRA:

  Read the RA configuration files (CONFIG.RA and EXITINFO.BBS) and fill
  and check for the standard commandline parameters.

  -T:<Time>     Maximal time in this door, overrules the EXITINFO.BBS setting
                The time has to be given in minutes. Mostly here for
                compatability with RAdoor 2.3
  -N:<Node>     Node number, there's no other way under RA. Defaults to node 1
  -P:<CommPort> Overrules the CONFIG.RA Comport setting. Usefull for multiline
                Systems.
  -NOS          Turns off local noise for default.

  Further the GlobalInfo variables SystemPath and HomeDir are filled:

  SystemPath    Path to the RA system directory. The environment variable
                RA= has to be there.

  HomeDir       The directory from where the door was fired up. I usual
                use this directory to look for auxilary files. The homedir
                is found by stripping the filename of ParamStr(0). The user
                can ALWAYS overrule this value by setting an environment
                variable <PROGNAME> with an other path. PROGNAME is the REAL
                name of the program (the EXE file) minus the path and the
                extention!

|--------------------------------------------------------------------------}



Procedure InitRA;

Var ProgName : String[8];
    Dum      : String[4];
    TTime    : Word;
Begin
FillChar(GlobalInfo,SizeOf(GlobalInfo),#00);
RAPath:=GetEnv('RA');
CompletePath(RAPath);
GlobalInfo.SystemPath:=RAPath;


FSplit(ParamStr(0),GlobalInfo.HomeDir,ProgName,Dum);
If GetEnv(ProgName)<>''
   Then GlobalInfo.HomeDir:=GetEnv(ProgName);
If GlobalInfo.HomeDir<>''
   Then CompletePath(GlobalInfo.HomeDir);


GlobalInfo.Node:=Str2Nr(GrabParameter('N:'));
If GlobalInfo.Node=0
   Then GlobalInfo.Node:=1;

If Not ReadRAConfig
   Then Begin
        WriteLn(#254' Couldn''t read CONFIG.RA!');
        Halt;
        End;

If Not ReadExitInfo
   Then Begin
        WriteLn(#254' Couldn''t read EXITINFO.BBS!');
        Halt;
        End;

If ExistParameter('T:')
   Then Begin
        TTime:=Str2Nr(GrabParameter('T:'));
        If TTime<=GlobalInfo.MinRemaining
           Then GlobalInfo.MinRemaining:=TTime;
        End;

GlobalInfo.Language:=ReadRALanguage(RAExitinfo.UserXIinfo.Language);

GlobalInfo.LocalNoise:=Not ExistParameter('NOS');
End;
End.


