{ͻ
                                                                          
                    (c) CopyRight LiveSystems 1990, 1994                  
                                                                          
  Author    : Gerhard Hoogterp                                            
  FidoNet   : 2:282/100.5   2:283/7.33                                    
  BitNet    : GERHARD@LOIPON.WLINK.NL                                     
                                                                          
  SnailMail : Kremersmaten 108                                            
              7511 LC Enschede                                            
              The Netherlands                                             
                                                                          
         This module is part of the RADoor BBS doorwriters toolbox.       
                                                                          
 ͼ}
{---------------------------------------------------------------------------|

 Description:

 This unit contains the global information variables which is ment as a
 mailbox between the BBS program specific information and the ToolBox.
 The idea is that if you want to make your door capable of supporting
 more than one BBS program, or an other BBS program all together, you
 simply write a unit which reads the BBS specific configuration files
 and which stuffs it's info into the variables in this unit.. If more
 than one BBS is to be supported, YOU detect the BBStype and call the
 correct Init procedure which initializes the variables here.

 RA.TPU is the included Init unit for RemoteAccess.

 If you want to use BBS specific information, you can, but you have to
 handle it yourself.. All the other units in this toolbox only access
 the GlobalInfo record, so it should be easy to port this toolbox to
 other BBS types....

 I tried to include all the fields which virtualy all BBSses have available
 in some way.

See the documentation on more specific info on the variables here, and
what they are used for.

|---------------------------------------------------------------------------}


Unit GlobInfo;
Interface
Uses DOS;

Type  NameString   = String[35];
      StatusType   = (Normal,WarnOnLeaving,HangUpLine,LockOutUser);
      SysStatus    = (S_Ok,S_Warning1,S_Warning2,S_TimeUp);

      MaxLogStr    = String[69];
      LogItType    = Procedure (LogLine : MaxLogStr);


Type IEMSIRec = { All the IEMSI info is stuffed here so you can easily use }
                { it in your programs                                      }
       Record
         Session    : Boolean;        { These fields hold  }
         Crtdef,                      { data related to an }
         Protocols,                   { EMSI session       }
         Capabilities,
         Requests,
         Software   : String[40];
         Attr1,
         Attr2,
         Len        : Byte;
       End;


Type GlobalInfoType =
       Record
         { BBSType information }

         BBSTag          : Word;       { Which BBS type }
         BBSName         : NameString; { The name of the BBS program }

         OnlineStatus    : StatusType; { Mailbox between sysop keys and }
                                       { Fossil unit                    }
         SystemStatus    : SysStatus;  { TimeOut status                 }

         { Global SYSTEM information }

         SystemPath      : ComStr;     { Path to the System directory      }
         HomeDir         : ComStr;     { Home directory of the door        }
         UserFilePath    : ComStr;     { Path to the userfile directory    }
         LogFileName     : ComStr;     { Name and path of the logfile      }
         CommonDir       : ComStr;     { Dir for Onlinemsgs and such       }

         Node            : Byte;       { Current node                      }
         ComPort         : Word;       { Used comm port                    }
         BaudRate        : LongInt;    { Current baudrate                  }

         MultiLine       : Boolean;    { Is a multiline system?            }
         DesqView        : Boolean;    { Desqview used?                    }
         LogType         : Byte;       { Type of logfile                   }

         MinRemaining    : Integer;    { Daily time left                   }
         TimeLimit       : Word;       { Maximal time left in door         }
         TimeOutTime     : Word;       { Time for user timeout             }
         Warnings        : Word;       { Number of warnings                }

         LeftBracket     : Char;       { Left bracket = [                  }
         RightBracket    : Char;       { Right bracket = ]                 }

         { SysOp information }

         SysopName       : NameString; { Name of the SysOp                 }
         SystemName      : NameString; { Name of the BBS                   }
         SystemLocation  : NameString; { Location of the BBS               }

         LocalMono       : Boolean;    { Use colors on local screen?       }
         LocalNoise      : Boolean;    { Should sysop hear noise too       }

         { User Information }

         UserName        : NameString; { Name of the current user          }
         UserLocation    : NameString; { Location of the current user      }
         UserHandle      : NameString; { Handle of the current user        }
         UserSecurity    : Word;       { The users security level          }
         UserSex         : Boolean;    { The users Sex                     }
         UserBirthDay    : String[8];  { The birthday                      }
         UserAge         : Byte;       { The age                           }
         UserGroup       : Byte;       { The group                         }
         Language        : String[8];  { The selected language             }

         ScreenLength    : Word;       { Lines on the screen               }
         ScreenWidth     : Word;       { Characters on a line              }
         UseGraphics     : Boolean;    { Use ANSI?                         }
         UseAVATAR       : Boolean;    { Use AVATAR?                       }
         UseMoreYN       : Boolean;    { Use More Y/N?                     }
         UseClrScr       : Boolean;    { Send screen clearing codes?       }
         UseQuietMode    : Boolean;    { Accept online-messages?           }

         IEMSI           : IEMSIrec;   { All the IEMSI info                }
       End;


Var GlobalInfo  : GlobalInfoType;      { Global info record                }
    LogIt       : LogItType;           { Used Logfile procedure            }

Implementation

Begin
FillChar(GlobalInfo,SizeOf(GlobalInfo),#00);
End.
