{ͻ
                                                                          
                    (c) CopyRight LiveSystems 1990, 1994                  
                                                                          
  Author    : Gerhard Hoogterp                                            
  FidoNet   : 2:282/100.5   2:283/7.33                                    
  BitNet    : GERHARD@LOIPON.WLINK.NL                                     
                                                                          
  SnailMail : Kremersmaten 108                                            
              7511 LC Enschede                                            
              The Netherlands                                             
                                                                          
         This module is part of the RADoor BBS doorwriters toolbox.       
                                                                          
 ͼ}

Unit Alone;
Interface
Uses Dos,
     CRT,
     FileObj,
     GlobInfo;    { The globale info. Thisone needs to be filled      }

Const  NoBBS = 3; { This is a unike BBS tag to indentify the current  }
                  { BBS in the global info. Make tags for other BBSes }
                  { Also unike, at least for your own programs!       }


Procedure InitNoBBS;
Function NoBBSUpdateExitInfo:Boolean;

Implementation
Uses LowLevel; { To avoid a circular reference error }

Const UseLog : Boolean = False; { Is set to TRUE as soon as a LogProcedure }
                                { is installed                             }


Var   NoPath : ComStr;

{$F+}
Procedure FroDoLogIt(LogLine  : MaxlogStr);
{$F-}

Var Log    : Text;
    temp   : Integer;
    Hour   : Word;
    Minute : Word;
    Second : Word;
    Dum    : Word;

Begin
If Not UseLog
   Then Exit;
GetTime(Hour,Minute,Second,Dum);
LogLine:= '> '+
          S(Hour,2)+':'+
          S(Minute,2)+':'+
          S(Second,2)+'  '+
          LogLine;
For Dum:=3 To 10 Do
 If LogLine[Dum]=' '
    Then LogLine[Dum]:='0';

FileMode:=ReadWrite+ShareDenyNone;
Assign(Log,GlobalInfo.LogFileName);
Append(Log);
If IoResult<>0
   Then Rewrite(Log);
WriteLn(Log,LogLine);
Close(Log);
If IoResult<>0
   Then Begin
        WriteLn(#254' Can''t LOG anymore !!!');
        UseLog:=False;
        End;
End;

{---- Read CONFIG record -------------------------------------------------}

Function ReadConfig:Boolean;
Var Conf : FileObject;
    Size : Word;
Begin
ReadConfig:=False;

With GlobalInfo Do
 Begin
 BBStag  := NoBBS;
 BBSName := 'StandAlone';

 OnlineStatus:=Normal;
 SystemStatus:=S_OK;

 LogfileName   := 'NoBBS.LOG';
 LogType       := 1;
 LogIt := FrodoLogIt;

 UseLog        := True;
 TimeOutTime   := 24*60;
 Warnings      := 2; { My constate! }

 UserFilePath  := '';

 CommonDir     := '';

 LeftBracket   := '(';
 RightBracket  := ')';

 SysopName     := 'Stand Alone';
 SystemName    := 'NoBBS';
 SystemLocation:= 'Here';

 LocalMono     := False;

 ComPort       := 0;

 MultiLine     := True;
 End; {With}

ReadConfig  := True;
End;

{---- ExitInfo.bbs procedures -----------------------------------------}


Function AskName:NameString;
Var Temp : NameString;
    Stop : Boolean;
    Key  : Char;
    Ext  : Boolean;
Begin
Temp:='';
Repeat
 Stop:=False;
 Repeat
  If KeyPressed
     Then Begin
          Key:=Readkey;
          If Key=#00
             Then Key:=ReadKey
             Else Ext:=False;
          If Not Ext
             Then Stop:=Key in ['A'..'Z','a'..'z',#8,#13,'''',' ',#27];
          End;
 Until Stop;

 Case UpCase(Key) Of
  'A'..'Z',
  '-',
  '''' : Begin
         If (Length(Temp)=0) Or
            (Temp[Length(Temp)]=' ')
            Then Key:=UpCase(Key)
            Else Key:=Chr(Ord(Upcase(Key))+32);
         Temp:=Temp+Key;
         End;
  ' '  : Temp:=Temp+' ';
  #08  : Begin
         Dec(Temp[0]);
         Write(#8' ');
         End;
  #13  : Begin
         AskName:=Temp;
         Exit;
         End;
  #27  : Begin
         Temp:='';
         AskName:='';
         Exit;
         End;
End; {Case}
Write(Key);
Until False;
End;

Function ReadExitInfo:Boolean;
Var C: Byte;
Begin
ReadExitInfo:=False;

With GlobalInfo Do
 Begin

 ScreenWidth  := 80;

 If Not ExistParameter('NAME:')
    Then Begin
         TextAttr:=$0F;
         ClrScr;
         TextAttr:=$1F;
         Write(Center('-=( Standalone operation )=-'));
         ClrEol;
         TextAttr:=$0B;
         WriteLn;
         WriteLn;
         Write('Please enter your name: ');
         TextAttr:=$0F;
         UserName:=AskName;
         End
    Else Begin
         UserName:=GrabParameter('NAME:');
         For C:=1 To Length(UserName) Do
          If UserName[C]='_'
             Then UserName[C]:=' ';
         UserName:=FormatLine(UserName);
         End;

 If UserName=''
    Then Halt;

 LogIt(UserName+' on-line at '+TimeStamp);

 SysOpName    := UserName;
 UserHandle   := UserName;
 UserLocation := 'Somewhere here';
 UserSecurity := $FFFF;

 UserBirthDay := '00/00/00';
 UserAge      := 00;
 UserGroup    := 00;


 ScreenLength := 24;
 UseGraphics  := True;
 UseAVATAR    := True;
 UseMoreYN    := True;
 UseClrScr    := True;
 UseQuietMode := False;
 BaudRate     := 0;
 MinRemaining := $600;
 TimeLimit    := $600;
 End; {With}

ReadExitInfo:= True;
End;



{--------------------------------------------------------------------------|
  -T:<Time>     Maximal time in this door, overrules the EXITINFO.BBS setting
                The time has to be given in minutes. Mostly here for
                compatability with RAdoor 2.3
  -N:<Node>     Node number, there's no other way under RA. Defaults to node 1
  -P:<CommPort> Overrules the CONFIG.RA Comport setting. Usefull for multiline
                Systems.
  -NOS          Turns off local noise for default.

  Further the GlobalInfo variables SystemPath and HomeDir are filled:

  HomeDir       The directory from where the door was fired up. I usual
                use this directory to look for auxilary files. The homedir
                is found by stripping the filename of ParamStr(0). The user
                can ALWAYS overrule this value by setting an environment
                variable <PROGNAME> with an other path. PROGNAME is the REAL
                name of the program (the EXE file) minus the path and the
                extention!

|--------------------------------------------------------------------------}



Procedure InitNoBBS;

Var ProgName : String[8];
    Dum      : String[4];
    TTime    : Word;

Begin
FillChar(GlobalInfo,SizeOf(GlobalInfo),#00);
NoPath:=GetEnv('NoBBS');
CompletePath(NoPath);
GlobalInfo.SystemPath:=NoPath;

FSplit(ParamStr(0),GlobalInfo.HomeDir,ProgName,Dum);
If GetEnv(ProgName)<>''
   Then GlobalInfo.HomeDir:=GetEnv(ProgName);
If GlobalInfo.HomeDir<>''
   Then CompletePath(GlobalInfo.HomeDir);

GlobalInfo.Node:=Str2Nr(GrabParameter('N:'));
If GlobalInfo.Node=0
   Then GlobalInfo.Node:=1;

If Not ReadConfig
   Then ;

If Not ReadExitInfo
   Then ;

If ExistParameter('L:')
   Then GlobalInfo.Language:=GrabParameter('L:')
   Else GlobalInfo.Language:='ENG';
End;


Function NoBBSUpdateExitInfo:Boolean;
Begin

LogIt('User finished program.'#10#13);
NoBBSUpdateExitInfo:=True;
End;


Begin
End.
