{$A+,B-,D+,E-,F-,I-,L+,N-,O-,R-,S+,V-}
{$M 10000,0,64000}
{ͻ
                                                                          
                    (c) CopyRight LiveSystems 1990, 1994                  
                                                                          
  Author    : Gerhard Hoogterp                                            
  FidoNet   : 2:282/100.5   2:283/7.33                                    
  BitNet    : GERHARD@LOIPON.WLINK.NL                                     
                                                                          
  SnailMail : Kremersmaten 108                                            
              7511 LC Enschede                                            
              The Netherlands                                             
                                                                          
         This module is part of the RADoor BBS doorwriters toolbox.       
                                                                          
 ͼ}

Program EditorDemo; { How to use the online editor }
Uses LowLevel,
     GlobInfo,
     UserHook,
     Fossil,
     Filter,
     RA,
     BBSedit;  {*}

Var Body  : BodyType;      { The textbuffer           }
    Lines : Byte;          { The number of lines used }
    Foss  : FossilObject;  { And a fossil object      }

Begin

      { Read all the BBS dependend info for RA }

InitRA;

      { Initialize the door }

With GlobalInfo Do
 Begin
 Foss.AssignF(ComPort-1,BaudRate);   { Init the fossil }
 If Foss.Error<>0
    Then Begin
         WriteLn(#254' Couldn''t initialize fossil!');
         LogIt('Couldn''t init fossil!');
         Halt;
         End;

 Foss.InitTimer(    { Init the timeout procedures              }
                3,  { Warning before pushed back to the BBS    }
                3   { Timeout time before and between warnings }
                );


 Foss.InitOutputFilter(UsedFilter); { Set the output filter            }
 Foss.InitInputFilter(FileCharSet); { Set the input filter for ReadLnF }

 Foss.InitSysopKeys(SysopKeys);     { Set the SYSOP keys procedure     }
 Foss.InitStatLine(StatusLine);     { Set the statusline procedure     }

     { Initialize the output filter using the info in the GlobalInfo record}

 InitUsedFilter(UseGraphics,UseAVATAR,LeftBracket,RightBracket,'^');
 End;


     { Initialize the colortable, I use only these colors in ALL my programs}

ColorTable[0]:=LightCyan;           { Normal text color            }
ColorTable[1]:=LightRed;            { Hotkey's and lines           }
ColorTable[2]:=White;               { Userinput and info highlight }
ColorTable[3]:=Yellow;              { Info                         }
ColorTable[4]:=(Blue Shl 4)+White;  { Statusline color             }

     { Initialize the Fossil strings }

PressENTERString:='^0Press ^[^1ENTER^0^] to continue:';

     { Initialize the EDITOR strings. }

StatLine   := '^4^!'+Center('-=( Type your text now, use an empty line to finish )=-')+'^0';
MenuLine   := '   ^0^[^1L^0^]ist      ^0^[^1C^0^]ontinue      ^[^1S^0^]ave      ^[^1A^0^]bort';
YourChoice := '   ^0Your choice: ^2';
Counter    := '^1@^ 2] ^0';
MenuKeys   := 'ALCS';

{----------------------------------------------------------------------------|
  The mainbody of the DOOR goes here.
|----------------------------------------------------------------------------}

New(Body);
If Body=Nil
   Then Begin
        Foss.WriteLnF('^1 Not enough memory!!^0');
        Foss.CloseF;
        Exit;
        End;

FillChar(Body^,SizeOf(Body^),#00);

    { You can add text, quote from a message and such.. }

Lines:=2;
Body^[0]:='* This is the BBSeditor demo:';
Body^[1]:='';

LineEditor(Foss,Body,Lines,30);
Foss.WriteLnF('');
If Lines=0
   Then Foss.WriteLnF('Text aborted...')
   Else Foss.WriteLnF('Text saved...');

    { Dispose the Editor buffer and free memory }

Dispose(Body);

    { Close the fossil and leave the demo }

Foss.CloseF;
End.
