{A+,B-,D-,E-,F-,I-,L-,N-,O-,R-,S+,V-}
{$M 30000,5000,5000}
{NOTE: This demo eats raw stack for breakfast! Keep it BIG...}
{ͻ
                                                                          
                    (c) CopyRight LiveSystems 1990, 1994                  
                                                                          
  Author    : Gerhard Hoogterp                                            
  FidoNet   : 2:282/100.5   2:283/7.33                                    
  BitNet    : GERHARD@LOIPON.WLINK.NL                                     
                                                                          
  SnailMail : Kremersmaten 108                                            
              7511 LC Enschede                                            
              The Netherlands                                             
                                                                          
         This module is part of the RADoor BBS doorwriters toolbox.       
                                                                          
 ͼ}
Program RASearchk;
Uses DOS,
     CRT,
     BBSTypes,   { BBS detection routine                         }
     UserHook,   { Demo/default userhook procedures              }
     Language,   { The multilanguage support                     }
     MLFilter,   { The default Multilanguage output filter       }
     LowLevel,   { The lowlevel stuff                            }
     DoorSys,    { Misc. Door routines.                          }
     GlobInfo,   { the global record with all the nessecary info }
     RA,         { The RA init code                              }
     SuperBBS,   { The SBBS init Code                            }
     QuickBBS,   { the QBBS init Code                            }
     Fossil;     { The fossil routines + Timing. This is the     }
                 {  body of the door!                            }

{----------------------------------------------------------------------------|
  The name and the version of the program together with the FossilObject
  variable which every door needs.
|----------------------------------------------------------------------------}


Const  ProgramName    = 'RA-Search';
       ProgramVersion = '2.0';
       LastUpdate     = '09 Oct 1991';
       ProgName       = 'RASEARCH';

Var Foss       : FossilObject;
    Slang      : String[3];


{----------------------------------------------------------------------------|
 Start here your own variables, procedures and functions.
|----------------------------------------------------------------------------}

Type Str12     = String[12];

Var Path       : ComStr;
    Name       : Str12;
    Dir        : String[4];

    Drives     : String[20];
    DriveCount : Byte;

    Dum        : Char;
    Lines      : Byte;
    Stop       : Boolean;


Procedure SearchDir(Dir : ComStr;FileSpec : Str12);
Var Search : SearchRec;
Begin
CompletePath(Dir);
FindFirst(Dir+FileSpec,AnyFile,Search);
While (Not Stop) And (DosError=0) Do
 Begin
 If Not Foss.Carrier
    Then Exit;

 If (Search.Attr And Archive)=Archive
    Then Begin
         Foss.WriteLnF(Dir+Search.Name);
         Inc(Lines);
         End;

 If (GlobalInfo.UseMoreYN) And
    (Lines=(GlobalInfo.ScreenLength-2))
    Then Begin
         Foss.WriteLnF('');
         Stop:=Foss.PressEnterOrStop;
         If Not Stop
            Then Begin
                 Foss.ClrScrF;
                 Foss.WriteLnF('^4^!'+Center(ExpandString(']100]102'+Drives[Drivecount]+']103]101'))+'^0');
                 Foss.WriteLnF('');
                 Lines:=4;
                 End;
         End;
 FindNext(Search);
 End;

FindFirst(Dir+'*.*',Directory,Search);
While (Not Stop) And (DosError=0) Do
 Begin
 If Not Foss.Carrier
    Then Exit;

 If ((Search.Attr And Directory)=Directory) And
    (Search.Name[1]<> '.')
    Then SearchDir(Dir+Search.Name,FileSpec);
 FindNext(Search);
 End;
End;

{----------------------------------------------------------------------------|
 Start of main module
|----------------------------------------------------------------------------}
Begin

WriteLn(ProgramName,' ',ProgramVersion,' (c) LiveSystems 1990,1991  ALL RIGHTS RESERVED, NO GUARANTEES');
WriteLn('Written by G.Hoogterp. E-mail address 2:283/1.2 Last Revision '+LastUpdate);
WriteLn('Use <FileName> -? to see commandline parameter summary.');

If ExistParameter('?')
   Then Begin
        WriteLn('Usage: ');
        WriteLn;
        WriteLn(' <PATH>RASEARCH.EXE [-T:<TimeLimit>] [-N:*N] [-P:*P] [-NOS]');
        WriteLn('                    -DRIVES:<DriveChars>');
        WriteLn;
        WriteLn(' -T:      Limit the time available in the door.');
        WriteLn(' -N:      Give nodenumber for multiline setups.');
        WriteLn(' -P:      Give ComPort to use.');
        WriteLn(' -NOS     Turn local sounds OFF for default.');
        WriteLn(' -DRIVES: Specify the drives to search. Only the chars!');
        WriteLn('          f.e. -DRIVES:CDE');
        Halt;
        End;

{ The parameters mentioned here are read in the RA.PAS unit as they are more
  or less RA dependend and the result has to be stuffed into the global info
  record. }

{----------------------------------------------------------------------------|
 Grab the BBS specific stuff into the GlobalInfo record
|----------------------------------------------------------------------------}

Case CurrentBBStype Of
 RA_BBS : InitRA;
 S_BBS  : InitSBBS;
 Q_BBS  : InitQBBS;
End;

{----------------------------------------------------------------------------|
 Check for the language info..
|----------------------------------------------------------------------------}

Slang:=GlobalInfo.Language;

If Not ExistFile(GlobalInfo.HomeDir+ProgName+'.'+Slang)
   Then Begin
        If Not ExistFile(GlobalInfo.HomeDir+ProgName+'.ENG')
           Then Begin
                LogIt('Couldn''t find language file..');
                WriteLn(#254' Couldn''t find language file..');
                Halt;
                End
           Else Slang:='ENG';
        End;


{----------------------------------------------------------------------------|
 And let the LOGfile know who's talking.
|----------------------------------------------------------------------------}

LogIt('Started: '+ProgramName+' '+ProgramVersion+' under '+GlobalInfo.BBSName);

{----------------------------------------------------------------------------|
  Initialize the userhooks, Timeout detection etc.
|----------------------------------------------------------------------------}

With GlobalInfo Do
 Begin
 Foss.AssignF(ComPort-1,BaudRate);   { Inti the fossil }
 If Foss.Error<>0
    Then Begin
         WriteLn(#254' Couldn''t initialize fossil!');
         LogIt('Couldn''t init fossil!');
         Halt;
         End;

 Foss.InitTimer(    { Init the timeout procedures              }
                GlobalInfo.Warnings,   { Warning before pushed back to the BBS    }
                GlobalInfo.TimeOutTime { Timeout time before and between warnings }
                );


 Foss.InitOutputFilter(UsedFilter); { Set the output filter            }
 Foss.InitInputFilter(FileCharSet);  { Set the input filter for ReadLnF }

 Foss.InitSysopKeys(SysopKeys);     { Set the SYSOP keys procedure     }
 Foss.InitStatLine(StatusLine);     { Set the statusline procedure     }

 { Initialize the output filter using the info in the GlobalInfo record}

 InitUsedFilter(UseGraphics,UseAVATAR,GlobalInfo.HomeDir+ProgName+'.'+Slang,'^');
 End;


{ Copy the colors as defined in the language support. I Use a move since the
  two array's aren't defined using the same TYPE definition }

Move(Specials.Colors,ColorTable,10);

PressEnterString       := ']001';
PressEnterOrStopString := ']002';
Warning1String         := ']004';
Warning2String         := ']005';
AttentionString        := ']006';
LockOutString          := ']007';
HangUpString           := ']008';
TimeUpString           := ']009';
UsedStopKey            := Specials.StopDef;

{----------------------------------------------------------------------------|
  The mainbody of the DOOR goes here.
|----------------------------------------------------------------------------}

Drives:=UpStr(GrabParameter('DRIVES:'));

Foss.ClrScrF;
Foss.WriteLnF('^4^!'+
              Center(']100LiveSystems '+
              ProgramName+' '+
              ProgramVersion+']101')+
              '^0');
Foss.WriteLnF('');

Name:='';
Foss.WriteF(']104');
Foss.ReadLnF(Name,12);
If Name<>''
   Then Begin
        LogIt('User Searches drive(s) '+Drives+' for '+Name);

        DriveCount:=1;
        Dum:=#00;

        Stop:=False;

        While (DriveCount<=Length(Drives)) And (Not Stop) Do
          Begin
          Lines:=4;
          Foss.ClrScrF;
          Foss.WriteLnF('^4^!'+Center(ExpandString(']100]102'+Drives[Drivecount]+']103]101'))+'^0');
          Foss.WriteLnF('');
          SearchDir(Drives[DriveCount]+':\',Name);

          Foss.WriteLnF('');
          Foss.PressEnter;
          Inc(DriveCount);
          End;
          End;

{----------------------------------------------------------------------------|
  Finalize the DOOR and say a nice thank you to the user for spending his
  online time and money on your door..
|----------------------------------------------------------------------------}

Case GlobalInfo.BBSTag Of
 RABBS : If Not RAUpdateExitInfo
            Then LogIt('Couldn''t update the EXITINFO.BBS!');
 SBBS  : If Not SBBSUpdateExitInfo
            Then LogIt('Couldn''t update the EXITINFO.BBS!');
 QBBS  : If Not QBBSUpdateExitInfo
            Then LogIt('Couldn''t update the EXITINFO.BBS!');

End;

Foss.ClrScrF;  { Clear the screen }
Foss.WriteLnF(']010'+ProgramName+'.');

{----------------------------------------------------------------------------|
  Tell the LogFile that we're finished. Gives the fossil some extra time
  to get the ThankYou out of it's mouth....
|----------------------------------------------------------------------------}

LogIt('Stopped: '+ProgramName+' '+ProgramVersion);

{----------------------------------------------------------------------------|
 And close the fossil again..
|----------------------------------------------------------------------------}

Foss.CloseF;
End.

{----------------------------------------------------------------------------|
   And that's it! That's all.. I can't make things simpler..
   Oh well, actualy I could, but not without giving up flexability and
   usability.....
|----------------------------------------------------------------------------}
