Program Example;
{ A generic import program example for DCTList v0.10                        }
{ The program simply halts when an error is encountered.  It's not very     }
{ elegant, but then the purpose of this source is to demonstrate how to use }
{ the given tools.  You would want to add in code to tell the user why the  }
{ program failed.                                                           }

Uses DCTBLObj;

Var BBS    : ^BBSObject;     { BBS object       }
    ThemeF,                  { THEMES picklist  }
    SystemF: ^PickObject;    { SYSTEMS picklist }
    Brd    : BBSRec;         { BBS record       }
    F      : Text;           { The input file   }
    DatDir : String;         { Data directory   }
    X      : Word;           { Dummy variable   }
    Ret    : Boolean;        { Dummy variable   }

Begin
  { Open input file }
  Assign(F, 'INPUT.DAT');
  {$I-} Reset(F); {$I+}
  If (IOResult <> 0) Then Halt;

  { Initialise variables }
  If (ParamCount <> 1) Then { Data dir is the current dir }
    DatDir := ''
  Else                      { Cmd-line parameter 1 is the data dir }
    DatDir := ParamStr(1);
  If (DatDir <> '') And (DatDir[Length(DatDir)] <> '\') Then
    DatDir := DatDir + '\'; { Add trailing backslash }

  New(BBS);
  BBS^.Init(DatDir, Ret);
  If Not Ret Then Halt;

  New(ThemeF);
  ThemeF^.Init(DatDir + 'THEMES', ThemePckLen);
  New(SystemF);
  SystemF^.Init(DatDir + 'SYSTEMS', SystemPckLen);

  { Now add all the records }
  While Not Eof(F) Do Begin
    FillChar(Brd, SizeOf(Brd), 0);

    { Add in your input routines here and assign them to the fields in }
    { the Brd variable.                                                }

    If ((Not BBS^.PhoneExists(Brd.Phone)) And
        (Not BBS^.NameExists(Brd.Name))) Then
      BBS^.Add(Brd, X, Ret);
  End;

  { And clean up }
  SystemF^.Done;
  Dispose(SystemF);
  ThemeF^.Done;
  Dispose(ThemeF);
  BBS^.Done;
  Dispose(BBS);
  Close(F);
End.
