(*
** Prime request processor for Frontdoor structure file
**
** Copyright (c) 1993 Hans Siemons, Prime Productions; All rights reserved.
** Copyright (c) 1993 Marco Miltenburg.
**
**
** Last revision (dd/mm/yy) : 06-12-93
**
** [...]
** This information is not necessarily final and is subject to change at any
** given time without further notice
** [...]
*)

(*
** General notes:
** date format used everywhere is the UNIXdate format.
** CRC's over strings are on the text only (not the size). 'A'..'Z' are
** casted to 'a'..'z'. (international characters are not taken in
** considiration!
**
** CRC's over AKA's, are simply CRC's over the '8' bytes.
**
** The CRC's are the standard CRC32's, used by PKZip and ZModem.
**
** If you do not have any library to calculate them, use the CRC32 routines
** from RADUMISC.TPU (included with RADU)
*)

(*
** FILEBASE.RP contains the database to the filebase. The request processor
** only takes this file, and the magic filename database in consideration
** when a node requests something.
**
** Duplicate files in different groups in no problem. RP will never send the
** same file twice.
*)

Type FIdx = record                                            { FILEBASE.RP }
             FileName : String[12]; { filename }
             size     : Longint;    { filesize }
             date     : Longint;    { filedate }
             dir      : Longint;    { pointer to directory }
             pwdcrc   : Longint;    { crc-32 over password,-1=no password }
             group    : char;       { group of file }
           end;

(*
** Descriptions are placed in DESCRIPT.RP, and is a file of character. It just
** contains the pure text.
*)

     DescInfoRecord=record                                 { descinfo.rp }
              FileName : Longint;                 { crc-32 over filename }
              desc     : Longint;               { pointer to description }
              Descs    : Integer;                { length of description }
            end;

(*
** Magic names database
** This database is searched in first. If a file has a "magic hit", it can
** never have a "file hit" anymore.
**
** For magic names that represent more then one file, a record is added
** per file. The request processor itselve handles it correctly.
*)
     Midx = record                                               { MAGIC.RP }
              Magicname,            { crc-32 over magic name }
              Pwdcrc,               { crc-32 over password,-1=no password }
              FileName : Longint;   { pointer to filelist }
              size,                 { filesize }
              date     : Longint;   { filedate }
              Group    : Char;      { group of file }
            end;

(*
** FileName (Midx) and dir (Fidx) point a in straight ascii text file called
** "textbase.rp". If RP hits on a magic name, it extracts from "textbase.rp"
** the actual filename. If RP hits on a filename, it extracts the directory
** from it.
*)

(*
** REQUESTD.RP contains information about what a node already requested,
** and is used to setup "requestlimits" per day.
**
** There can be more then one record from the same node, since FDRPR
** stores a record per "request session".
*)

     Requested=record                                        { REQUESTD.RP }
                 NodeCrc : Longint;                      {crc-32 over node#}
                 FileID : Longint;
                 KBrequested,
                 NRrequested,
                 TIMErequested : Longint;
                 RequestDate : Longint;        { date of request, unixdate }
                 Recovertime : Integer;              { recovertime of node }
               end;

(*
** Nodefile.RP  contains the node database, and lists the AKA, level,
** access groups.
** There is no particular sorting order in this file.
*)

     Noderecord=record                                        { nodefile.rp }
                  Zone,
                  Net,
                  Node,
                  Point : word;
                  Name : String[40];
                  Level : word;
                  groups : longint; { bit 0='a', bit 1='b' }
                  Deleted : boolean;
                  DenyRequest : boolean;
                  TimeToRecover : Integer;
                  crc : longint;
                  reserved: array[1..65] of char;
                end;

Const MyRev=1;

type PathStr=String[78];

     timeslottype=record
                    start,        { minutes since 00:00 }
                    stop : longint;
                  end;

     groupsetup=record
                  Name : string[20];   { group name }
                  Paths : PathStr;
                  Magics : PathStr;
                  Passwords : PathStr;   { file of passwords }
                  minbaud : Longint;
                  StopMatch : Boolean;
                  LimitedTime : boolean;    { limit hours ;-)) }
                  days : Byte; { sunday=bit 0, all=bit 7 }
                  timeslot : timeslottype;
                  FreeKB,
                  FreeTime,
                  FreeMatch : boolean;
                  CDrom : Boolean;
                  reserved : array[1..128] of byte;
                end;
     groupsetupar=array[1..26] of groupsetup;

{ RP reads like this:

  read record,
  level lower or requel to then "userlevel" : read it
  baudrate lower or equel to to then "userbaudrate" : read it

  This file is sorted on level and baudrate, where level is the primary key
}

     LimitRecord=record                                      { limits.rp }
                   level : word;
                   Baudrate : longint;
                   Days : byte;
                   LimitedTime : boolean;
                   Timeslot : timeslottype;
                   MaxMatchPT,   { pt=per time slot }
                   MaxTimePT,
                   MaxKBPT,
                   MaxMatchPS,   { ps=per session }
                   MaxTimePS,
                   MaxKBPS : word;
                 end;

     ULnodelimittype=record      { unlistednode limit type }
        Groups : Longint;
        Level : word;
        Recovertime : Integer;
      end;

     SendMessageWithRecord=record
        Path,
        textfile : PathStr;
      end;

     CtlRecord=record                                        { setup.rpr }
                 Signature : Longint;       { must contain <R><P><R><#0> }
                 Revision : word;                      { must be <myrev> }
                 default : noderecord;              { default noderecord }
                 nlsecure,      { not listed in database, secure session }
                 nlunsecure,   { not listed in databse, unsecure session }
                 nlnodelist : ULnodelimittype;
                        { not listed in database, not listed in nodelist }

                 groups : groupsetupar;
                 Editor : PathStr;                     { external editor }
                 About : PathStr; {tekst file send when requesting about }
                 LogFile : PathStr;     { logfile. Empty=use frodo's log }
                 CompLogFile : PathStr; { RPcomp logfile, empty use "logfile" }
                 SystemPath : PathStr;     { Empty=use RP.EXE's home dir }
                 WorkDir : PathStr;                         { for cd-rom }
                 NodelistLookup : boolean;         { search in nodelist? }
                 Pointslisted : boolean;     { listed.point also listed? }
                 Nodelistpath : PathStr;              { path to nodelist }
                 IndexExtension : String[3];           { index extension }
               end;
