(*
** Support unit to build a descriptiom compiler!
**
** Copyright (c) 1993,94 Hans Siemons, Prime Productions; All rights reserved.
**
** This unit may be used freely to build description compilers, or other
** supporting programs for RP.
** For other purposes, this unit may only be used by registered RP users.
**
** This unit uses routines from RADU, the Remote Access Door Unit.
** This is a shareware unit.
**
**
** I am aware that when using buffering techniques, things would be speeded
** up quite a bit. That is not the goal of this unit. It's goal is to provide
** easy routines to build a RP description database.
**
**
** Description of procedures:
**
** Procedure OpenFiles(App:boolean);
**
** Opens the file description database. If app is true, the new descriptions
** will be appended to the end. You are advised to add a commandline switch
** whether the new descriptions should be appended.
**
**
** Procedure CloseFiles;
**
** Closes the file description database
**
**
** Procedure AddToDescBase;
**
** Add filename in FNAME, and description in Txt to the database.
**
**
** Function DoFilesBBS(pth,pthfbbs:String):Boolean;
**
** Scan files.bbs in pthfbbs, for files in pth. If pth is the same as pthfbbs
** RPdesc will put every description in the description database. If wildcards
** are used in Files.BBS, RPdesc will expand those.
** If pth and pthbbs are not the same, RPdesc will only include descriptions
** of files that actually exist on disk.
** Ie, if you have one master files.bbs for many directory's (cd-rom),
** call DoFilesBBS with the actual path to the files, and the path to the
** files.bbs. Do this for every directory!
*)

unit rpdesc;

interface

Uses Msgbase,                   { from RADU }
     RPctl,
     dos,
     miscradu;

{$I rpstruct.inc}

Const DescBase='descript.rp';
      DeInBase='descinfo.rp';
      DescBasePos:Longint=0;

Var fd : file;
    fi : file of descinforecord;

    fname : String[255];

    txt : PMsgTxt;

Type CharSet=set of char;

Procedure OpenFiles(App:boolean);
Procedure CloseFiles;
Procedure AddToDescBase;
Function DoFilesBBS(pth        : String;   { Path to files }
                    pthfbbs    : String;   { Path to files.bbs }
                    descpos    : Byte;     { position of description (14) }
                    StripParam : Boolean;  { Strip /.. parameters? (maximus )}
                    MreLineDes : Charset;  { More lines in desc }
                    CommentChr : Charset  { Comment characters }
                   ):Boolean;

implementation

Var
    di : DescInfoRecord;


Procedure OpenFiles;
var s:String;
begin
  s:=readctlfile;
  if s<>'' then
    begin
      Writeln ('ERROR: ',s);
      halt;
    end;
  assign(fd,exepath+'descript.rp');
  filemode:=readwritemode+denyall;
  if app then {$I-} reset(fd,1); {$I+}

  if (ioresult<>0) or not app then
    begin
      rewrite(fd,1);
      app:=false;
    end;

  assign(fi,exepath+'descinfo.rp');
  if app then {$I-} reset(fi); {$I+}
  if not app or (ioresult<>0) then
    begin
      rewrite(fi);
      if app then
        begin
          app:=false;
          rewrite(fd,1);
        end;
    end;
  if app then descbasepos:=filesize(fd);
end;

Procedure CloseFiles;
begin
  close(fd);
  close(fi);
end;

Procedure AddToDescBase;
var numwritten : word;
begin
  if txt^.txtline^='' then exit;
  di.desc:=descbasepos;
    While Txt<>NIL do
    Begin
      BlockWrite (Fd,Txt^.TxtLine^[1],Length(Txt^.TxtLine^));
      inc(descbasepos,Length(Txt^.TxtLine^));
      Txt:=Txt^.TxtNext;
    End;  { While }
  di.descs:=descbasepos-di.desc;
  di.filename:=jamcrc32(fname[1],length(fname),-1);
  write(fi,di);
end;

Function DoFilesBBS;
var ft : text;
    mfname : string;
    busywithfile:Boolean;
    s:String;

Procedure Addit;
var sr:searchrec;
begin
  if (pth<>pthfbbs) or (pos('?',mfname)+pos('*',mfname)>0) then
  begin
    findfirst(pth+mfname,anyfile,sr);
    while doserror=0 do
    begin
      fname:=pth+sr.name;
      AddToDescbase;
      findnext(sr);
    end;
  end else
    begin
      fname:=pth+mfname;
      AddToDescBase;
    end;
  TxtDispose(txt);
end;

begin
  pth:=forceback(supcase(pth));
  pthfbbs:=forceback(supcase(pthfbbs));
  filemode:=readmode+denywrite;
  assignFMtext(ft,pthfbbs+'FILES.BBS');
  {$I-}
  reset(ft);
  {$I+}
  if ioresult<>0 then
    begin
      DoFilesBBS:=false;
      exit;
    end;
  DoFilesBBS:=true;
  busywithfile:=false;

  while not eof(ft) do
    begin
      readln(ft,s);
      if busywithfile and (s[1] in mrelinedes) then
        begin
          txtaddline(txt,trim(copy(s,2,255)));
        end else
      if busywithfile then
        begin
          addit;
        end;
      if (s<>'') and not ((s[1] in commentchr) or (s[1] in mrelinedes)) then
        begin { new file }
          mfname:=trim(copy(s,1,12));
          s:=trimleft(copy(s,descpos,255));
          if stripparam and (s[1]='/') then
            begin
              if pos(' ',s)>0 then delete(s,1,pos(' ',s)) else s:='';
              s:=trimleft(s);
            end;

          txt:=txtnew(copy(s,descpos,255));
          busywithfile:=true;
        end;
    end;
    if busywithfile then
      begin
        AddIt;
      end;
  Close(ft);
end;

end.
