(*
** Support unit to build a descriptiom compiler! Use to read the control file!
**
** Copyright (c) 1993,94 Hans Siemons, Prime Productions; All rights reserved.
**
** This unit may be used freely to build description compilers, or other
** supporting programs for RP.
** For other purposes, this unit may only be used by registered RP users.
**
** This unit uses routines from RADU, the Remote Access Door Unit.
** This is a shareware unit.
*)

Unit RpCtl;

interface
{$I rpstruct.inc}

var Ctl : CtlRecord;
    exePath : String;

Function ReadCtlFile:String;
Procedure FixFileName(var filename:String);

implementation

Uses MiscRADU,Dos;

Const CtlNotFoundMsg='Ctl file not found!';
      CtlError='Error in Ctl file! Create a new one!';
      SetupFile='SETUP.RP';

Procedure FixFileName(var filename:String);
begin
  if pos('\',filename)+pos('/',filename)+pos(':',filename)=0 then
    filename:=exepath+filename;
end;

Function ReadCtlFile:String;
var
  P: PathStr;
  D: DirStr;
  N: NameStr;
  E: ExtStr;

  f : file;
  numread : word;

begin
  FillCHar(ctl,sizeof(ctl),#0);
  p:=fexpand(paramstr(0));
  FSplit(P, D, N, E);
  ExePath:=d;
  assign(f,ExePath+setupfile);
  filemode:=$20;
  {$I-} reset(f,1); {$I+}
  if ioresult<>0 then
  begin
    getdir(0,ExePath);
    ExePath:=ForceBack(ExePath);
    assign(f,setupfile);
    {$I-} reset(f,1); {$I+}
  end;
  if ioresult<>0 then
    begin
      ReadCtlFile:=CtlNotFoundMsg;
      exit;
    end;
  blockread(f,ctl,sizeof(ctl),numread);
  close(f);
  if (numread<>sizeof(ctl)) or (ctl.signature<>$00525052) then
    begin
      ReadCtlFile:=CtlError;
      exit;
    end;

  if Ctl.Systempath<>'' then ExePath:=ForceBack(Ctl.Systempath);
  ReadCtlFile:='';
end;

end.
