PROGRAM Ok2Pop;
{ͻ}
{ Converts Binkley style OK-file to PoP         Last changed: 31.03.93  SA }
{                                                                          }
{                         (C) Copyright 1989-93 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{ This source can be distributed freely, as long as it is done in a        }
{ lawfull and friendly manner.                                             }
{ͼ}

USES OpString,PoPTypes;

VAR
  f: File of TOkFile;
  t: Text;
  s: String;
  Stat : Byte;
  Err  : Integer;
  OkFileRec : TOkFile;

BEGIN
  WriteLn('Ok-file to Portal of Power v'+ver) ;
  WriteLn('Copyright (C) 1991-93 by The Portal Team') ;
  WriteLn;
  IF ParamCount>=1 THEN
  BEGIN
    Assign(f, 'PORTAL.OKF'); Reset(f);
    IF IOResult<>0 THEN ReWrite(f);
    Seek(f,FileSize(f));
    Assign(t,ParamStr(1)) ; Reset(t) ;
    IF ParamCount=2 THEN Val(ParamStr(2),Stat,Err) ELSE Stat:=0;
    IF Stat>2 THEN Stat:=2;
    WHILE Not Eof(t) DO
    BEGIN
      ReadLn(t,s) ;
      IF (s<>'') And (Copy(s,1,1)<>';') THEN
      BEGIN
        WriteLn(s);
        FillChar(OkFileRec,SizeOf(OkFileRec),0);
        IF Copy(s,1,1)='@' THEN
        BEGIN
          OkFileRec.MagicName:=StUpCase(Copy(s,2,Pos(' ',s)-2));
          s:=Copy(s,Pos(' ',s)+1,Length(s)-Pos(' ',s));
          WHILE (s<>'') AND (s[1]=' ') DO
            Delete(s,1,1);
        END;
        IF Pos('!',s)>0 THEN
        BEGIN
          OkFileRec.Password:=StUpCase(Copy(s,Pos('!',s)+1,Length(s)-Pos('!',s)));
          s:=Copy(s,1,Pos('!',s)-2);
        END;
        OkFileRec.FilePath:=StUpCase(s);
        OkFilerec.NodeStat:=TNodeStat(Stat);
        Write(f,OkFileRec);
      END;
    END;
    Close(f);
  END ELSE
  BEGIN
    WriteLn('  USE: Ok2Pop <Ok-FileName> [Stat]');
    WriteLn;
    WriteLn('       Stat=0,1,2  (Default=0)');
    WriteLn;
  END;
END.
