PROGRAM Add2Ok;
{$I-}
{ͻ}
{ Adds missing paths to PORTAL.OKF              Last changed: 12.03.99  MR }
{                                                                          }
{                         (C) Copyright 1989-93 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{                         (C) Copyright 1997-99 by                         }
{            [on the modifications of the original source code]            }
{                      Marcus Roeckrath                                    }
{                      Fido: 2:2449/523                                    }
{                      E-Mail: marcus.roeckrath@gmx.de                     }
{                                                                          }
{ This source can be distributed freely, as long as it is done in a        }
{ lawfull and friendly manner.                                             }
{ͼ}

USES Dos, Utilitys, Crt;

TYPE DosPathStr = String[79];

     TNodeStat = (nsUnknown, nsKnown, nsPassword);

     TFreeArea = (faNoWay,       { Not a free area                           }
                  faIfAccess,    { If file within limits, send it but don't  }
                                 { add it to limits (same limits after file) }
                  faTotally);    { Totally free - only check time to next    }
                                 { NoRequest event                           }

     POkFile = ^TOkFile;
     TOkFile = RECORD
       NodeStat  : TNodeStat;    { Nodestat:                                 }
       MagicName : STRING[20];   { Magic name, if any                        }
       FilePath  : DosPathStr;   { Path and filespec.                        }
       Password  : STRING[10];   { Password for area                         }
       Level,
       Keys      : BYTE;
       FreeArea  : TFreeArea;
       TaskNumber: BYTE;
       Filler    : ARRAY[1..11] of BYTE;
     END;

VAR I, J        : BYTE;
    OkFileRec   : TOkFile;
    OkFile      : File Of TOkFile;
    Access      : TFreeArea;
    Level, Keys : BYTE;
    NodeStat    : TNodeStat;
    Temp        : WORD;
    Error       : Integer;
    UpParam     : STRING;
    KeysStr     : STRING;
    TempStr     : STRING;
    Global      : BOOLEAN;

PROCEDURE ShowHelp;
  BEGIN
    WriteLn;
    WriteLn('Add2Ok adds missings paths to the PORTAL.OKF file. In addition');
    Writeln('to the original version from the portal team this modified version');
    Writeln('adds also subdirs of a directory and gives you the possibility');
    Writeln('to change the default values for Level, Keys, Access and Nodestatus.');
    Writeln;
    WriteLn('  USAGE: Add2Ok </L:n> </K:bbbbbbbb> </A:Access> </N:Nodestatus> <Path>');
    WriteLn('         /L:n - Level from 0 to 255');
    Writeln('         /K:bbbbbbbb - Keys binary value in Portal (reverse) order');
    Writeln('         /A:Access - Access = one of (NoWay, IfAccess, Totally)');
    Writeln('         /N:Nodestatus - Nodestatus = one of (All, Known, Password)');
    Writeln('         Default values:');
    Writeln('           Level: 0; Keys: 00000000; Access: NoWay; Nodestatus: All');
    Writeln('         Example:');
    Writeln('           Add2Ok /L:200 path1 /K:00000100 /N:Password path2');
  END;

PROCEDURE ScanPath(Direc : PathStr);
  VAR Sr         : SearchRec;
      Found, All : BOOLEAN;
      Skip       : BOOLEAN;
      DosErr     : INTEGER;
      PathName   : PathStr;
      Ch         : CHAR;
      Temp       : STRING;
  BEGIN
    All := False;
    Skip := False;
    IF Direc[Length(Direc)] <> '\' THEN Direc := Direc + '\';
    FindFirst(Direc+'*.*', Directory, Sr);
    DosErr := DosError;
    WHILE DosErr = 0 DO BEGIN
      IF (Copy(Sr.name,1,1)<>'.') And ((Sr.Attr And Directory)=Directory)
      THEN BEGIN
        PathName := UpString(Direc) + Sr.Name + '\';
        Temp := PathName + FillString(' ', 75 - Length(PathName));
        Write(Temp,#13);
        Seek(OkFile , 0);
        Found := False;
        WHILE Not Eof(OkFile) And Not Found DO BEGIN
          Read(OkFile, OkFileRec);
          Found := (Copy(OkFileRec.FilePath, 1, Length(PathName))=PathName);
        END;
        IF Not Found THEN BEGIN
          IF Not All AND Not Global AND Not Skip THEN BEGIN
            Write('Add: ',PathName,'*.*  (Y/N/A/G/S/Q) ');
            Ch := UpCase(ReadKey);
            WriteLn(ch);
              IF Ch = 'Q' THEN BEGIN
                Close(OkFile);
                Halt;
              END;
              IF Ch = 'S' THEN BEGIN
                All := False;
                Global := False;
                Skip := True;
              END;
              IF Ch = 'A' THEN BEGIN
                All := True;
                Skip := False;
                Ch := 'Y';
              END;
              IF Ch = 'G' THEN BEGIN
                Global := True;
                Skip := False;
                Ch := 'Y';
              END;
          END
          ELSE BEGIN
            IF Not Skip THEN Ch := 'Y' ELSE Ch := 'N';
          END;
          IF Ch = 'Y' THEN BEGIN
            FillChar(OkFileRec, SizeOf(OkFileRec), 0);
            OkFileRec.FilePath:=PathName+'*.*';
            OkFileRec.NodeStat := NodeStat;
            OkFileRec.Level := Level;
            OkFileRec.Keys := Keys;
            OkFileRec.FreeArea := Access;
            Seek(OkFile, FileSize(OkFile));
            Write(OkFile, OkFileRec);
          END;
        END;
        ScanPath(PathName);
      END;
      FindNext(Sr);
      DosErr := DosError;
    END;
  END;

BEGIN
  WriteLn('Add2Ok V. 2.1, (C) 1992-93 by The Portal Team');
  Writeln('               Modified 1997-99 by Marcus Roeckrath');
  IF ParamCount = 0 THEN
    ShowHelp
  ELSE BEGIN
    Assign(OkFile, 'PORTAL.OKF');
    FileMode := $42;
    Reset(OkFile);
{   IF IOResult <> 0 THEN ReWrite(OkFile);}
    IF IOResult = 0 THEN BEGIN
      Writeln;
      Writeln('Y=Yes, N=No, A=add this directory and all others on the same directory level');
      Writeln('G=add all following paths on all directory levels');
      Writeln('S=skip this directory and all others on the same directory level');
      Writeln('Q=Quit');
      Writeln;
      Level := 0;
      Keys := 0;
      Access := faNoWay;
      NodeStat := nsUnknown;
      Global := False;
      FOR I := 1 TO ParamCount DO BEGIN
        UpParam := UpString(ParamStr(I));
        IF Copy(UpParam, 1, 3) = '/L:' THEN BEGIN
          Val(Copy(UpParam, 4, Length(UpParam) - 3), Temp, Error);
          IF (Temp >= 0) AND (Temp <= 255) THEN Level := Temp AND 255;
        END
        ELSE BEGIN
          IF Copy(UpParam, 1, 3) = '/K:' THEN BEGIN
            IF Length(UpParam) = 11 THEN BEGIN
              KeysStr := '';
              FOR J := 4 TO 11 DO BEGIN
                IF (UpParam[J] = '0') OR (UpParam[J] = '1') THEN BEGIN
                  KeysStr := UpParam[J] + KeysStr;
                END;
              END;
              IF Length(KeysStr) = 8 THEN BEGIN
                KeysStr := ChangeBaseOfNumber(KeysStr, 2, 10);
                Val(KeysStr, Keys, Error);
              END;
            END;
          END
          ELSE BEGIN
            IF Copy(UpParam, 1, 3) = '/A:' THEN BEGIN
              TempStr := Copy(UpParam, 4, Length(UpParam) - 3);
              IF TempStr = 'NOWAY' THEN Access := faNoWay ELSE
                IF TempStr = 'IFACCESS' THEN Access := faIfAccess ELSE
                  IF TempStr = 'TOTALLY' THEN Access := faTotally;
            END
            ELSE BEGIN
              IF Copy(UpParam, 1, 3) = '/N:' THEN BEGIN
                TempStr := Copy(UpParam, 4, Length(UpParam) - 3);
                IF TempStr = 'ALL' THEN NodeStat := nsUnknown ELSE
                  IF TempStr = 'KNOWN' THEN NodeStat := nsKnown ELSE
                    IF TempStr = 'PASSWORD' THEN NodeStat := nsPassword;
              END
              ELSE BEGIN
                WriteLn;
                ScanPath(UpParam);
                Write(FillString(' ',78));
              END;
            END;
          END;
        END;
      END;
      Close(OKFile);
    END
    ELSE BEGIN
      WriteLn;
      WriteLn('PORTAL.OKF not found in current directory.');
      ShowHelp;
    END;
  END;
  WriteLn;
END.
