UNIT ScrBlank;
{ͻ}
{ Screen blank/unblank                          Last changed: 28.04.96  SA }
{                                                                          }
{                         (C) Copyright 1989-96 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{ This source may not be given to anybody, without the written permission  }
{ from The Portal Team.                                                    }
{ͼ}
{$I POPDEFS.INC}

INTERFACE

USES Use32;

VAR
  BlankKbdFlags: Byte;

PROCEDURE TurnScreen(On: Boolean);
PROCEDURE MoveClock;

IMPLEMENTATION

USES OpCrt, OpDate, OpWindow, OpFrame, ApTimer,
{$IFDEF OS2}
     VpUtils,
{$ENDIF}
     Globals, Util, MTask;

VAR
  CursorXY, CursorSL : Word;
  ClockWin, BlankWin : WindowPtr;
  LastTic  : LongInt;

  PROCEDURE MoveClock;
  VAR
    X, Y : Word;
  BEGIN
{$IFDEF OS2}
    IF (ClockWin<>NIL) AND ((GetTimemSec-LastTic)>=1000) OR (GetTimemSec<LastTic) THEN
    BEGIN
      IF (GetTimemSec-LastTic)>=10000 THEN
{$ELSE}
    IF (ClockWin<>NIL) AND ((BiosTics^-LastTic)>=18) OR (BiosTics^<LastTic) THEN
    BEGIN
      IF (BiosTics^-LastTic)>=182 THEN
{$ENDIF}
      BEGIN
        X:=Random(ScreenWidth-23); Y:=Random(ScreenHeight-7);
        ClockWin^.AdjustWindow(x,y,x+20,y+2);
{$IFDEF OS2}
        LastTic:=GetTimemSec;
{$ELSE}
        LastTic:=BiosTics^;
{$ENDIF}
      END;
      ClockWin^.wFastText(TodayString('dd nnn yy')+'  '+CurrentTimeString('hh:mm:ss'),2,2);
    END;
  END;

  PROCEDURE TurnScreen(On: Boolean);
  VAR
    p : Word;
    Offset, i : Byte;
    t : EventTimer;
  BEGIN
    IF (Cfg.Screen.HardwareBlank) And (Multitasker=0) THEN
    BEGIN
      IF CurrentDisplay IN [EGA, VGA] THEN
      BEGIN
        i:=Port[$03ba];
        i:=Port[$03da];
        IF On THEN Port[$03c0]:=$20 ELSE Port[$03c0]:=$00;
      END ELSE
      BEGIN
        IF CurrentDisplay=MonoHerc THEN p:=$03B8 ELSE p:=$03D8;
        IF On THEN i:=$29 ELSE i:=$21;
        Port[p]:=i;
      END;
    END ELSE
    BEGIN
      IF Not On THEN
      BEGIN
        IF Not ScreenBlanked THEN
        BEGIN
          GetCursorState(CursorXY, CursorSL);
          New(BlankWin, Init(1, 1, ScreenWidth, ScreenHeight));
          BlankWin^.SetCursor(cuHidden);
          BlankWin^.Draw;
          IF NOT Cfg.Screen.HardwareBlank OR ((Multitasker>0) AND Cfg.Screen.HardwareBlank) THEN
          BEGIN
            Randomize;
            Offset:=(ScreenWidth-80) DIV 2;
            New(ClockWin, InitCustom(29+Offset,10,49+Offset,12, Cfg.Color[2],wBordered+wClear+wSaveContents));
            ClockWin^.wFrame.AddHeader(' Portal of Power ', heTC);
            ClockWin^.wFrame.AddShadow(shBR, shOverWrite);
            IF Cfg.Screen.ExplodingWin THEN ClockWin^.EnableExplosions(10);
            ClockWin^.Draw;
            ClockWin^.wFastText(TodayString('dd nnn yy')+'  '+CurrentTimeString('hh:mm:ss'),2,2);
          END;
{$IFDEF OS2}
          LastTic:=GetTimemSec;
{$ELSE}
          LastTic:=BiosTics^;
{$ENDIF}
        END;
      END ELSE
      BEGIN
        IF ScreenBlanked THEN
        BEGIN
          IF ClockWin<>NIL THEN
          BEGIN
            ClockWin^.EraseHidden;
            Dispose(ClockWin, Done);
            ClockWin:=NIL;
          END;
          BlankWin^.EraseHidden; Dispose(BlankWin, Done);
          RestoreCursorState(CursorXY, CursorSL);
        END;
      END;
    END;
    ScreenBlanked:=NOT On;
    NewTimerSecs(ScreenBlank, Cfg.Screen.BlankTime);
    IF NOT On THEN
    BEGIN
      NewTimerSecs(t, 10);
      WHILE (KbdFlags AND $08<>0) AND NOT TimerExpired(t) DO
        GiveUpTime;
    END;
    BlankKbdFlags:=KbdFlags;
  END;

BEGIN
  BlankKbdFlags:=KbdFlags;
  ClockWin:=NIL;
END.

