UNIT RBrowser;
{ͻ}
{ File record browser                           Last changed: 02.03.97  SA }
{                                                                          }
{                         (C) Copyright 1989-97 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{ This source may not be given to anybody, without the written permission  }
{ from The Portal Team.                                                    }
{ͼ}
{$I POPDEFS.INC}

INTERFACE

USES Use32, PoPTypes, NetFile;

CONST
  Allowed : Byte = $ff;

TYPE
  GetStrFuncType = FUNCTION(VAR Buffer; VAR f: TNetFile): String;
  EditProcType   = PROCEDURE(VAR Buffer; VAR Changed: Boolean; RecNum,MaxRec: LongInt);
  InitBufType    = PROCEDURE(VAR Buffer);
  IsGreaterFunc  = FUNCTION(VAR B1,B2): Boolean;
  GetRecFunc     = PROCEDURE(VAR f: TNetFile; VAR Buffer; RecNum: LongInt; K,W: Boolean);
  PutRecFunc     = PROCEDURE(VAR f: TNetFile; VAR Buffer; RecNum: LongInt);

VAR
  GetARec : GetRecFunc;
  PutARec : PutRecFunc;

PROCEDURE DefGetRec(VAR f: TNetFile; VAR Buffer; RecNum: LongInt; K,W: Boolean);
PROCEDURE DefPutRec(VAR f: TNetFile; VAR Buffer; RecNum: LongInt);

PROCEDURE BrowseRecords(VAR f: TNetFile;
                        VAR Buffer;
                        VAR ExitCode: Word;
                        CONST Head,
                              RowString: S80;
                        GSP: GetStrFuncType;
                        EP : EditProcType;
                        IB : InitBufType;
                        IG : IsGreaterFunc);

IMPLEMENTATION

USES Dos, OpCrt, OpWindow, OpString, OpKey, OpRoot,
     OproUtil, Keyboard, Input, Globals, Util, Display;

  PROCEDURE DefGetRec(VAR f: TNetFile; VAR Buffer; RecNum: LongInt; K,W: Boolean);
  BEGIN
    f.GetRec(Buffer, RecNum, K, W);
  END;

  PROCEDURE DefPutRec(VAR f: TNetFile; VAR Buffer; RecNum: LongInt);
  BEGIN
    f.PutRec(Buffer, RecNum);
  END;


  PROCEDURE BrowseRecords;
  LABEL
    EditBuffer;
  VAR
    HelpWin, MainWin,
    ScrollWin, Win   : WindowPtr;
    y, ymax : Byte;
    OldRecNum,RecNum : LongInt;
    Found,Changed, TheEnd  : Boolean;
    FindStr, OutputName    : PathStr;
    PrintFile : PBufTextFile;
    WaitWin   : PWait;

    PROCEDURE WriteLine(RecNum: LongInt; y: Byte; Rvs: Boolean);
    VAR
      s    : String;
      Color: Byte;
    BEGIN
      IF f.FileSize>0 THEN
      BEGIN
        GetARec(f,Buffer,RecNum,NoKeep,NoWait);
        IF f.IoResult=107 THEN
          s:='* * * * * * * * * * *  R E C O R D   I S   L O C K E D  * * * * * * * * * * *'
        ELSE
          s:=GSP(Buffer, f);
      END ELSE
        s:='* * * * * * * * * *  N O   R E C O R D S   I N   F I L E  * * * * * * * * * *' ;
      IF Rvs THEN Color:=Cfg.Color[3].BlockColor ELSE Color:=Cfg.Color[3].TextColor;
      ScrollWin^.wFastWrite(' '+Pad(s,77),y,1,Color);
    END;

    PROCEDURE WritePage(StartRecNum: LongInt);
    VAR
      y : Byte;
    BEGIN
      y:=1;
      WHILE (StartRecNum<f.FileSize) And (y<=ymax) DO
      BEGIN
        WriteLine(StartRecNum,y,False) ;
        Inc(y); Inc(StartRecNum);
      END;
      IF y<=ymax THEN
        FOR y:=y TO ymax DO
          ScrollWin^.wFastText(CharStr(' ',78),y,1);
    END;

    PROCEDURE SortRecords;
    CONST
      Faktor = 1.3;
    VAR
      i, Gab    : LONGINT;
      b1,b2     : Pointer;
      Sorteret  : BOOLEAN;
    BEGIN
      New(WaitWin, Init(ScreenHeight DIV 2, 3, 'Sorting records'));
      GetMem(b1,f.RecSize);
      GetMem(b2,f.RecSize);

      Gab:=f.FileSize ; Sorteret:=False;
      while (Gab>1) or not Sorteret do
      begin
        Gab:=Trunc(Gab/Faktor);
        if Gab<1 then Gab:=1;
        Sorteret:=True;
        I:=0;
        while I<f.FileSize-Gab do
        begin
          WaitWin^.Animate;
          GetARec(f,b1^,i,NetFile.Keep,Wait);
          GetARec(f,b2^,i+Gab,NetFile.Keep,Wait);
          IF IG(b1^, b2^) THEN
          BEGIN
            PutARec(f,b2^,i); PutARec(f,b1^,i+Gab);
            Sorteret:=False;
          END ELSE
          BEGIN
            f.UnLock(i);
            f.UnLock(i+Gab);
          END;
          Inc(i);
        end;
      end;
      FreeMem(b2,f.RecSize);
      FreeMem(b1,f.RecSize);
      Dispose(WaitWin, Done);
    END;

    PROCEDURE MakeHelpWin;
    VAR
      s : s80;
    BEGIN
      MyWin(HelpWin,1,ScreenHeight-1,80,ScreenHeight,3,'',False);
      WITH HelpWin^, Cfg.Color[3] DO
      BEGIN
        s:='F1=Help        F2=';
        IF (Allowed AND 1)<>0 THEN s:=s+'Delete      ' ELSE s:=s+CharStr(' ',12);
        s:=s+'F3=';
        IF (Allowed AND 2)<>0 THEN s:=s+'Print       ' ELSE s:=s+CharStr(' ',12);
        s:=s+'F4=';
        IF (Allowed AND 4)<>0 THEN s:=s+'Create      ' ELSE s:=s+CharStr(' ',12);
        s:=s+'F5=';
        IF (Allowed AND 8)<>0 THEN s:=s+'Find' ;
        wFastText(s,1,2);

        s:='F6=';
        IF (Allowed AND 16)<>0 THEN s:=s+'Copy entry  ' ELSE s:=s+CharStr(' ',12);
        s:=s+'F7=';
        IF (Allowed AND 32)<>0 THEN s:=s+'Sort        ' ELSE s:=s+CharStr(' ',12);
        s:=s+'F8=            F9=            F0=';
        wFastText(s,2,2);
      END;
    END;

    PROCEDURE EditTheBuffer;
    BEGIN
      Topic:=0;
      EP(Buffer, Changed, RecNum, f.FileSize);
      Topic:=63;
    END;

  BEGIN
    MakeHelpWin;
    MyWin(MainWin,1,2,80,ScreenHeight-2,3,Head,False);
    MainWin^.wFastText(' '+Pad(RowString,77),1,1);
    MyWin(ScrollWin,2,4,79,ScreenHeight-3,3,'',False);
    ymax:=ScreenHeight-6;
    WritePage(0);
    y:=1; RecNum:=0; TheEnd:=False; FindStr:=''; Topic:=63; OutputName:='';
    REPEAT
      WriteLine(RecNum,y,True);
      REPEAT UNTIL PoPKeyPressed ;
      WriteLine(RecNum,y,False);
      CASE PoPReadKeyWord OF
        Esc     : TheEnd:=True;
        Enter   : BEGIN
                    IF f.FileSize=0 THEN
                      IB(Buffer)
                    ELSE
                      GetARec(f, Buffer, RecNum, NetFile.Keep, NoWait);
                    IF f.IOResult=0 THEN
                    BEGIN
                      MyWin(Win, 1, ScreenHeight-1, 80, ScreenHeight, 2, '', False);
                      WITH Win^, Cfg.Color[2] DO
                      BEGIN
                        wFastText('F1=Help',1,2);
                      END;

                      EditTheBuffer;

                      KillWindow(Win);

                      IF Changed THEN
                        PutARec(f,Buffer,RecNum)
                      ELSE
                        IF f.FileSize>0 THEN f.UnLock(RecNum);
                    END;
                    MainWin^.Select;
                    ScrollWin^.Select;
                  END;
        Down    : IF RecNum<f.FileSize-1 THEN
                  BEGIN
                    Inc(RecNum); Inc(y);
                    IF y>ymax THEN
                    BEGIN
                      y:=ymax;
                      ScrollWin^.ScrollVert(1);
                    END;
                  END;
        Up      : IF RecNum>0 THEN
                  BEGIN
                    Dec(RecNum); Dec(y);
                    IF y<1 THEN
                    BEGIN
                      y:=1;
                      ScrollWin^.ScrollVert(-1);
                    END;
                  END;
        PgDn    : BEGIN
                    IF RecNum+ymax>=f.FileSize THEN
                    BEGIN
                      IF f.FileSize>0 THEN RecNum:=f.FileSize-1 ELSE RecNum:=0;
                      IF RecNum<ymax THEN y:=RecNum+1 ELSE y:=ymax;
                    END ELSE
                    BEGIN
                      Inc(RecNum,ymax);
                    END;
                    WritePage(RecNum-y+1);
                  END;
        PgUp    : BEGIN
                    IF RecNum<ymax+y THEN
                    BEGIN
                      RecNum:=0;
                      y:=1;
                    END ELSE
                    BEGIN
                      Dec(RecNum,ymax);
                    END;
                    WritePage(RecNum-y+1);
                  END;
        Home    : BEGIN
                    RecNum:=0; y:=1;
                    WritePage(RecNum);
                  END;
        EndKey  : BEGIN
                    IF f.FileSize>0 then RecNum:=f.FileSize-1 else RecNum:=0;
                    IF RecNum<ymax THEN y:=RecNum+1 ELSE y:=ymax;
                    WritePage(RecNum-y+1);
                  END;
        Del,
        F2      : IF (Allowed AND 1)<>0 THEN
                  BEGIN
                    IF (f.FileSize>0) And (Confirm('Delete current record?','N',10)) THEN
                    BEGIN
                      New(WaitWin, Init(ScreenHeight DIV 2, 3, 'Reordering records'));
                      f.Seek(RecNum) ;
                      WHILE f.FilePos<f.FileSize-1 DO
                      BEGIN
                        WaitWin^.Animate;
                        GetARec(f, Buffer, f.FilePos+1, NoKeep, Wait);
                        PutARec(f, Buffer, f.FilePos-2);
                      END;
                      f.Seek(f.FileSize-1);
                      f.Truncate;
                      Dispose(WaitWin, Done);
                      IF RecNum>=f.FileSize THEN
                      BEGIN
                        Dec(RecNum);
                        IF y>1 THEN Dec(y);
                      END;
                      WritePage(RecNum-y+1);
                    END;
                  END;
        F3      : IF (Allowed AND 2)<>0 THEN
                  BEGIN
                    IF (f.FileSize>0) And
                       InputString(10,12,80,44,3,'Print','Print to : ',OutputName) And (OutputName<>'') THEN
                    BEGIN
                      New(PrintFile, Init(OutputName,SCreate,2048));
                      IF PrintFile<>NIL THEN
                      BEGIN
                        FOR OldRecNum:=0 TO f.FileSize-1 DO
                        BEGIN
                          GetARec(f,Buffer,OldRecNum,NoKeep,Wait);
                          PrintFile^.WriteLn(GSP(Buffer, f));
                        END;
                        Dispose(PrintFile, Done);
                      END;
                    END;
                  END;
        Ins,
        F4      : IF (Allowed AND 4)<>0 THEN
                  BEGIN
                    IB(Buffer);
EditBuffer:
                    OldRecNum:=RecNum;
                    RecNum:=f.FileSize;
                    EditTheBuffer;
                    IF Changed THEN
                    BEGIN
                      PutARec(f,Buffer,RecNum);
                      IF RecNum<ymax THEN y:=RecNum+1 ELSE y:=ymax;
                    END ELSE
                      RecNum:=OldRecNum;
                    MainWin^.Select;
                    ScrollWin^.Select;
                    WritePage(RecNum-y+1);
                  END;
        F5      : IF (Allowed AND 8)<>0 THEN
                  BEGIN
                    IF (RecNum=0) Or (RecNum=f.FileSize-1) Or (FindStr='') THEN
                    BEGIN
                      Found:=InputString(10,12,80,44,3,'Find','String to find : ',FindStr);
                    END ELSE
                      Found:=True;
                    IF Found THEN
                    BEGIN
                      OldRecNum:=RecNum;
                      Found:=False;
                      IF RecNum=f.FileSize-1 THEN RecNum:=0 ELSE Inc(RecNum);
                      WHILE (RecNum<f.FileSize) And Not (Found) DO
                      BEGIN
                        GetARec(f,Buffer,RecNum,NoKeep,NoWait);
                        Found:=Pos(StUpCase(FindStr),StUpCase(GSP(Buffer, f)))<>0;
                        IF NOT Found THEN Inc(RecNum);
                      END;
                      IF Found THEN
                      BEGIN
                        y:=1;
                        WritePage(RecNum-y+1);
                      END ELSE
                      BEGIN
                        RecNum:=OldRecNum;
                        FindStr:='';
                      END;
                    END;
                  END;
        F6      : IF ((Allowed AND 16)<>0) AND (f.FileSize>0) THEN
                  BEGIN
                    GetARec(f,Buffer,RecNum,NoKeep,Wait);
                    GOTO EditBuffer;
                  END;
        F7      : IF (Allowed AND 32)<>0 THEN
                  BEGIN
                    SortRecords;
                    RecNum:=0; y:=1;
                    WritePage(RecNum);
                  END;
      END;
    UNTIL TheEnd;
    KillWindow(ScrollWin);
    KillWindow(MainWin);
    KillWindow(HelpWin);
    Allowed:=$ff;
  END;

BEGIN
  GetARec:=DefGetRec;
  PutARec:=DefPutRec;
END.
