UNIT PFix;
{ͻ}
{ PortalFix, File and MessageArea del/add       Last changed: 02.03.97  SA }
{                                                                          }
{                         (C) Copyright 1989-97 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{ This source may not be given to anybody, without the written permission  }
{ from The Portal Team.                                                    }
{ͼ}
{$I POPDEFS.INC}

INTERFACE

USES Use32;

PROCEDURE ScanNetMail;

IMPLEMENTATION

USES Dos, OpRoot, OpString, OpWindow, OpDate, OpDos,
     MailUtil, OpusMsg, OproUtil, Globals, StrUtil, FileUtil, LogFile,
     Send2Utl, NetFile, InterCom, PoPTypes, Util, OutUtil;

TYPE
  LineFuncType=FUNCTION(VAR Adr; CONST Ext:S3):STRING;

FUNCTION FWDLineFunc(VAR Adr; CONST Ext:S3): STRING; far;
BEGIN
  WITH TFileFwd(Adr) DO
  BEGIN
    FWDLineFunc:=CPad(PortalFixName,21)+ReplaceStr(Description,'XXXXXXXX.XXX');
  END;
END;

FUNCTION AREALineFunc(VAR Adr; CONST Ext:S3):STRING; far;
BEGIN
  WITH TMsgArea(Adr) DO
  BEGIN
    AREALineFunc:=CPad(EchoNames[1],33)+Description;
  END;
END;

FUNCTION TICKLineFunc(VAR Adr; CONST Ext:S3):STRING; far;
BEGIN
  WITH TTickArea(Adr) DO
  BEGIN
    TICKLineFunc:=CPad(AreaName,21)+CPad(GroupName,21)+HumanName;
  END;
END;

PROCEDURE ScanNetMail;
VAR
  pwd,KeyWord:S20;
  f:FILE;
  ListsAdded,SaveNodes,ListTicks,ListFiles, ListAreas:BOOLEAN;
  test,msgsize,x,i : WORD;
  l                : LongInt;
  nt,p:POINTER;
  Temp:WindowPtr;
  h,h2:MsgHdrType;
  n : TNodeInfo;
  s : STRING;
  ReplyMsg : PBufTextFile;
  Ch : Char;
  Adr,Dest : TFidoAddress;
  ta: TTickArea;
  fw: TFileFwd;
  em: TMsgArea;

  PROCEDURE AddFile(CONST Name: S40;           (* Navn der skal addes     *)
                    CONST Ext: S3;             (* Extension p filen      *)
                    VAR Buf;                   (* Recorden der skal lses *)
                    VAR NameAdr:S20;           (* Adr. p navnet i record *)
                    VAR GroupAdr:S20;          (* Adr. p group name i rec*)
                    Size:WORD;                 (* Record size             *)
                    VAR SendToAdr1,
                        SendToAdr2:SendToType; (* Adr. p sendto i record *)
                    VAR KAdr:BYTE;             (* Adr. p keys i record   *)
                    VAR LAdr:BYTE);            (* Adr. p level i record  *)
  VAR
    STab1,STab2:SendToTabType;
    found,ok:BOOLEAN;
    i,i2:BYTE;
    f : TNetFile;
  BEGIN
    ok:=FALSE;
    IF NOT f.Open(StartPath+'PORTAL.'+Ext,Size,False) THEN Exit;
    Found:=FALSE;
    WHILE NOT f.EOF DO
    BEGIN
      f.Read(Buf,Keep,Wait);
      IF ((StUpCase(NameAdr)=name) OR (StUpCase(GroupAdr)=name)) AND
         (n.keys AND KAdr=KAdr) AND (LAdr<=n.level) THEN
      BEGIN
        found:=True;
        ok:=True;
        ReadSendTo(SendToAdr2,STab2,i2);
        ok:=NOT IsSendingTo(Adr,STab2,i2);
        IF ok THEN
        BEGIN
          ReadSendTo(SendToAdr1,STab1,i);
          ok:=AddToSendTo(Adr,STab1,i);
          SortSendToTab(STab1,i);
          WriteSendTo(STab1,SendToAdr1,i);
        END;
        IF ok THEN
        BEGIN
          f.PutRec(Buf,f.FilePos-1);
          AddLog('!','PORTALFIX: Node ('+Address2Str(Adr)+') has asked to be sent "'+nameadr+'"');
          ReplyMsg^.WriteLn('You will receive all new "'+nameadr+'"-files in the future.');
        END ELSE
        BEGIN
          f.UnLock(f.FilePos-1);
          ReplyMsg^.WriteLn('You are already receiving "'+nameadr+'".');
        END;
      END ELSE f.UnLock(f.FilePos-1);
    END;
    IF NOT Found THEN
    BEGIN
      ReplyMsg^.WriteLn('"'+name+'" not found, please ask for a list of areas...');
    END;
    f.Close;
  END;

  PROCEDURE leaveFile(CONST name:S20;                  (* Navn der skal fjernes   *)
                      CONST Ext:S3;                    (* Extension p filen      *)
                      VAR Buf;                   (* Recorden der skal lses *)
                      VAR NameAdr:S20;           (* Adr. p navnet i record *)
                      VAR GroupAdr:S20;          (* Adr. p Group i record  *)
                      CONST Size:WORD;           (* Record size             *)
                      VAR SendToAdr1,
                          SendToAdr2:SendToType);(* Adr. p sendto i record *)
  VAR
    STab1,STab2:SendToTabType;
    found,ok:BOOLEAN;
    i,i2:BYTE;
    f : TNetFile;
  BEGIN
    IF NOT f.Open(StartPath+'PORTAL.'+Ext,Size,False) THEN Exit;
    WHILE NOT f.EoF DO
    BEGIN
      ok:=FALSE;
      f.Read(Buf,Keep,Wait);
      Found:=(StUpCase(NameAdr)=name) OR (StUpCase(GroupAdr)=name);
      IF Found THEN
      BEGIN
        ReadSendTo(SendToAdr1,STab1,i);
        ReadSendTo(SendToAdr2,STab2,i2);
        ok:=RemoveFromSendTo(Adr,STab1,i);
        SortSendToTab(STab1,i);
        WriteSendTo(STab1,SendToAdr1,i);
        IF NOT ok AND (addr(STab1)<>addr(STab2)) THEN
        BEGIN
          ok:=RemoveFromSendTo(Adr,STab2,i2);
          SortSendToTab(STab2,i2);
          WriteSendTo(STab2,SendToAdr2,i2);
        END;
        IF ok THEN
        BEGIN
          f.PutRec(Buf,f.FilePos-1);
          ReplyMsg^.WriteLn('You will NO LONGER receive "'+nameadr+'"-files');
          AddLog('!','PORTALFIX: Node ('+Address2Str(Adr)+') has asked NOT to be sent "'+nameadr+'"');
        END ELSE
        BEGIN
          ReplyMsg^.WriteLn('You were NOT receiving "'+nameadr+'" anyway.');
          f.UnLock(f.FilePos-1);
        END;
      END ELSE
        f.UnLock(f.FilePos-1);
    END;
    f.Close;
  END;

  PROCEDURE AddAreaList(CONST Title:S20; CONST Header:S70; CONST Ext:S3;
                        CONST Size:WORD; VAR Buf; VAR NameAdr:S20;
                        LineFunc:LineFuncType; VAR KAdr:BYTE;
                        VAR LAdr:BYTE; VAR Rec1, Rec2:SendToType);
  VAR
    f : TNetFile;
    Tab1,Tab2:SendToTabType;

    FUNCTION IsHere:BOOLEAN;
    VAR
      n1,n2:BYTE;
    BEGIN
      ReadSendTo(Rec1,Tab1,n1);
      ReadSendTo(Rec2,Tab2,n2);
      IsHere:=IsSendingTo(Adr,Tab1,n1) OR IsSendingTo(Adr,Tab2,n2);
    END;

  BEGIN
    IF f.Open(StartPath+'PORTAL.'+Ext,Size,False) THEN
    BEGIN
      ListsAdded:=True;
      ReplyMsg^.WriteLn('List of available '+Title+'-files to get from this system:');
      ReplyMsg^.WriteLn(' '+Header);
      ReplyMsg^.WriteLn(CharStr('-',76));
      WHILE NOT f.EOF DO
      BEGIN
        f.Read(Buf,NoKeep,Wait);
        IF (NameAdr<>'') AND (n.keys AND KAdr=KAdr) AND (LAdr<=n.level) THEN
          ReplyMsg^.WriteLn(CHR(32+10*BYTE(IsHere))+LineFunc(Buf,Ext));
      END;
      f.Close;
      ReplyMsg^.WriteLn(CharStr('-',76)+#13#10#13#10);
    END;
  END;

  PROCEDURE CheckRepost;
  VAR
    found, repost:BOOLEAN;
    j,PointNumber:INTEGER;
    Ch : Char;

    PROCEDURE ForwardAttachedFiles;
    VAR
      Name : PathStr;
      Adr  : TFidoAddress;
      SType: Byte;
    BEGIN
      IF (PointNumber=0) AND (NOT ((h.destnet=cfg.Addresses[Cfg.MainAdrNum].net) AND
         (h.destnode=cfg.Addresses[Cfg.MainAdrNum].node))) THEN
      BEGIN
        ASM
          and h.Attribute, Not MsgFile
        END;
        IF ExistFile(cfg.Inbound[nsUnknown]+JustFileName(AsciiZ2Str(h.Subject,72))) THEN
          Name:=cfg.Inbound[nsUnknown]+JustFileName(AsciiZ2Str(h.Subject,72))
        ELSE
          IF ExistFile(cfg.Inbound[nsknown]+JustFileName(AsciiZ2Str(h.Subject,72))) THEN
            Name:=cfg.Inbound[nsKnown]+JustFileName(AsciiZ2Str(h.Subject,72))
          ELSE
            Name:=cfg.Inbound[nsPassword]+JustFileName(AsciiZ2Str(h.Subject,72));
        Adr.Zone:=Cfg.Addresses[Cfg.MainAdrNum].Zone;
        Adr.Net:=h.DestNet;
        Adr.Node:=h.DestNode;
        Adr.Point:=PointNumber;

        IF Cfg.MailScanner.KillFWDFiles THEN SType:=STDelete ELSE SType:=STNothing;
        SendAFile(Name, Adr, 'H', SType);
        Repost:=True;
      END;
    END;

  BEGIN
    repost:=FALSE;
    Found:=FALSE;
    IF (h.destnet=cfg.Addresses[Cfg.MainAdrNum].net) AND (h.destnode=cfg.Addresses[Cfg.MainAdrNum].node) AND
       (cfg.Addresses[Cfg.MainAdrNum].point=0) THEN
    BEGIN
      s:='';
      j:=-1;
      Found:=FALSE;
      REPEAT
        INC(j);
        ch:=CT0(p^)[j];
        IF ch<>#10 THEN s:=s+ch;
        IF s[Length(s)]=#13 THEN
          IF (COPY(s,1,6)=#1'TOPT ') OR (COPY(s,1,6)=#1'*2PT ') THEN found:=True ELSE s:='';
      UNTIL found OR (j>=l-1);
      IF found AND Cfg.MailScanner.ForwardMail THEN
      BEGIN
        h.destpoint:=0;
        ASM
          and h.Attribute, Not MsgSent
        END;
        h.destnet:=cfg.pointnet;
        s:=COPY(s,7,5);
        DEC(s[0]);
        VAL(s,PointNumber,j);
        h.DestNode:=PointNumber;
        IF j=0 THEN repost:=True;
      END;
    END;
    IF (h.Attribute AND MsgFile)<>0 THEN ForwardAttachedFiles;
    IF Repost THEN
    BEGIN
      IF Cfg.MailScanner.StripCrash THEN
      ASM
        and h.Attribute, Not MsgCrash
      END;
      IF Cfg.MailScanner.SaveFWDMail THEN
      ASM
        and h.Attribute, Not MsgKill
      END ELSE
      ASM
        or h.Attribute, MsgKill
      END;
      ASM
        or h.Attribute, MsgLocal
      END;
      s:='Reposting msg. #'+Long2Str(i);
      Temp^.WFASTWRITE(s,2,2,Cfg.Color[3].TextColor);
      s:=s+' to: '+AsciiZ2Str(h.touser,36);
      AddLog('#', s);
      s:=#1+'Via PoP v'+ver+' ('+Address2Str(Cfg.Addresses[Cfg.MainAdrNum])+') '+
         DateToDateString('dd/mm-yyyy',ToDay)+' '+
         CurrentTimeString('hh:mm')+#13+#10+#0;
      GetMem(nt,l+Length(s));
      MOVE(p^,nt^,l);
      MOVE(s[1],BT0(nt^)[l],Length(s));
      WriteMsg(cfg.MailScanner.NetMailDir,i,h,l+Length(s),nt);
      FreeMem(nt,l+Length(s));
      Temp^.WFASTWRITE(CharStr(' ',22),2,2,Cfg.Color[3].TextColor);
    END;
  END;

  PROCEDURE ChangePwd(CONST s:S20; VAR As:S20; CONST Title:S20);
  BEGIN
    IF s<>'' THEN
    BEGIN
      as:=s;
      addlog('*','PORTALFIX: Node '+Address2Str(Adr)+' : '+Title+' password changed');
      ReplyMsg^.WriteLn('Your '+Title+' password has been changed.');
      SaveNodes:=True;
    END;
  END;

BEGIN
{$IFNDEF PoPLite}
  FIllChar(Call, SizeOf(Call), 0);
  IF Not SetInterCom(ICScanNetMail,Call,False) OR NOT ChkDir(Cfg.MailScanner.NetMailDir) THEN Exit;
  MyWin(Temp,20,8,60,11,2,'Scanning Matrix',True);
  FOR i:=1 TO GetHighestMsg(Cfg.MailScanner.NetMailDir) DO
  BEGIN
    ListAreas:=False;
    ListFiles:=False;
    ListTicks:=False;
    SaveNodes:=False;
    IF ReadMsg(Cfg.MailScanner.NetMailDir,i,h,l,p) THEN
    BEGIN
      Temp^.WFastText('Scanning message #'+Long2Str(i),1,2);
      IF cfg.mailscanner.stripcrash THEN
      BEGIN
        IF ((h.orignet<>cfg.Addresses[Cfg.MainAdrNum].net) OR (h.orignode<>cfg.Addresses[Cfg.MainAdrNum].node)) AND
           ((h.Attribute AND MsgCrash)<>0) THEN
        BEGIN
          ASM
            and h.Attribute, not (MsgCrash+MsgLocal)
          END;
          WriteMsg(cfg.MailScanner.NetMailDir,i,h,l,p);
        END;
      END;
      CheckRepost;
      IF (StUpCase(Trim(AsciiZ2Str(h.touser,36)))='PORTALFIX') AND ((h.Attribute AND MsgRead)=0) THEN
      BEGIN
        Temp^.WFastText('Processing message #'+Long2Str(i),2,2);
        FindMsgAdr(h,p,l,Adr,Dest);
        IF IsOurAddress(Dest) THEN
        BEGIN
          IF FindNodeInfo(n,Adr) THEN
          BEGIN
            pwd:=StUpCase(AsciiZ2Str(h.Subject,72));
            IF n.areafixpwd=pwd THEN
            BEGIN
              x:=$FFFF;
              New(ReplyMsg, Init(StartPath+'PORTAL.$$1', SCreate, 2048));
              IF ReplyMsg<>NIL THEN
              BEGIN
                ReplyMsg^.WriteLn(KludgeLines(Cfg.Addresses[Cfg.MainAdrNum],Adr));
                REPEAT
                  s:='';
                  REPEAT
                    INC(x);
                    ch:=CT0(p^)[x];
                    IF (ch<>#10) AND (ch<>#13) AND (ch<>#$8D) THEN s:=s+ch;
                  UNTIL (x>=l-1) OR (ch=#13) OR (ch=#$8D);
                  s:=TrimSpaces(s);
                  IF (s<>'') AND (s[1]<>#0) AND (s[1]<>^A) AND (COPY(s,1,2)<>'--') THEN
                  BEGIN
                    s:=StUpCase(s);
                    ch:=s[1];
                    CASE ch OF
                      '-' : LeaveFile(COPY(s,2,255),'ARE',em,em.EchoNames[1],em.EchoNames[1],SizeOf(em),em.SendTo,em.SendOnly);
                      '+' : AddFile(COPY(s,2,255),'ARE',em,em.EchoNames[1],em.EchoNames[1],SizeOf(em),
                                    em.SendTo,em.SendOnly,em.keys,em.level);
                      ELSE
                      BEGIN
                        s:=s+' ';
                        replace(s,'  ',' ',0);
                        KeyWord:=COPY(s,1,POS(' ',s)-1);
                        DELETE(s,1,LENGTH(KeyWord)+1);
                        s:=Trim(s);
                        IF KeyWord='TICK' THEN
                          AddFile(s,'TIC',ta,ta.areaname,ta.groupname,SizeOf(ta),ta.SendTo,ta.GetFrom,ta.keys,ta.level)
                        ELSE
                        IF KeyWord='NOTICK' THEN
                          LeaveFile(s,'TIC',ta,ta.areaname,ta.groupname,SizeOf(ta),ta.SendTo,ta.GetFrom)
                        ELSE
                        IF KeyWord='FILE' THEN
                          AddFile(s,'FWD',fw,fw.portalfixname,fw.portalfixname,SizeOf(fw),fw.SendTo,fw.SendTo,fw.keys,fw.level)
                        ELSE
                        IF KeyWord='NOFILE' THEN
                          LeaveFile(s,'FWD',fw,fw.portalfixname,fw.portalfixname,SizeOf(fw),fw.SendTo,fw.SendTo) ELSE
                        IF KeyWord='PASSWORD' THEN ChangePwd(s,n.AreaFixPwd,'PortalFix') ELSE
                        IF KeyWord='TICKPASSWORD' THEN ChangePwd(s,n.TickPassWord,'Tick') ELSE
                        IF KeyWord='SESSIONPASSWORD' THEN ChangePwd(s,n.SessionPwd,'Session') ELSE
                        IF KeyWord='FORWARDLETTER' THEN
                        BEGIN
                          n.SendFwdLetter:=True;
                          ReplyMsg^.WriteLn('You will be notified of forwarded files');
                          SaveNodes:=True;
                        END ELSE
                        IF KeyWord='NOFORWARDLETTER' THEN
                        BEGIN
                          n.SendFwdLetter:=FALSE;
                          ReplyMsg^.WriteLn('You will *NOT* be notified of forwarded files any more');
                          SaveNodes:=True;
                        END ELSE
                        IF KeyWord='TICKS' THEN ListTicks:=True ELSE
                          IF KeyWord='AREAS' THEN ListAreas:=True ELSE
                            IF KeyWord='FILES' THEN ListFiles:=True ELSE
                            BEGIN
                              ReplyMsg^.WriteLn('Unknown command "'+KeyWord+'"');
                            END;
                      END;
                    END;
                  END;
                UNTIL (ch=#0) AND (x>=l-1);
                ListsAdded:=FALSE;
                IF ListFiles THEN AddAreaList('FORWARD','File name            Description','FWD',
                  SizeOf(fw),fw,fw.PortalFixName,FWDLineFunc,fw.keys,fw.level,fw.sendto,fw.sendto);
                IF ListAreas THEN AddAreaList('MAIL','Area name                        Description','ARE',
                  SizeOf(em),em,em.EchoNames[1],AREALineFunc,em.keys,em.level,em.sendto,em.sendonly);
                IF ListTicks THEN AddAreaList('TICK','File name            Group                Description','TIC',
                  SizeOf(ta),ta,ta.AreaName,TICKLineFunc,ta.keys,ta.level,ta.sendto,ta.getfrom);
                IF ListsAdded THEN
                BEGIN
                  ReplyMsg^.WriteLn('');
                  ReplyMsg^.WriteLn('NOTE: an "*" in front of the area name, means you are connected to it.');
                  ReplyMsg^.WriteLn('');
                END;
                Dispose(ReplyMsg, Done);
              END ELSE
                AddLog('!','Not enough memory to create reply message');
              IF SaveNodes THEN PutNodeInfo(n);

              FreeMemCheck(p,l);

              Assign(f,StartPath+'PORTAL.$$1'); FileMode:=ShareRead+ShareDenyW;
              Reset(f,1);
              IF IOResult=0 THEN
              BEGIN
                MsgSize:=FileSize(f)+1;
                IF GetMemCheck(p,msgsize) THEN
                BEGIN
                  FillChar(p^,msgsize,0);
                  BlockRead(f,p^,FileSize(f),test);
                  FillChar(h2,SizeOf(h2),0);
                  Move(h.fromuser,h2.touser,36);
                  Move(h.touser,h2.fromuser,36);
                  h2.orignet:=cfg.Addresses[Cfg.MainAdrNum].net;
                  h2.orignode:=cfg.Addresses[Cfg.MainAdrNum].node;
                  h2.destnode:=h.orignode;
                  h2.destnet:=h.orignet;
                  h2.attribute:=MsgKill+MsgLocal;
                  SetTimeStamp(h2);
                  WriteMsg(cfg.mailscanner.netmaildir,GetHighestMsg(cfg.mailscanner.NetMailDir)+1,h2,MsgSize-1,p);
                  FreeMem(p,msgsize);
                END;
                Close(f);
                DeleteFile(StartPath+'PORTAL.$$1');
              END;
            END ELSE
              AddLog('!','PORTALFIX: Node '+Address2Str(Adr)+': specified invalid password "'+pwd+'"');
          END ELSE
            AddLog('!','PORTALFIX: Node '+Address2Str(Adr)+' tried to use PORTALFIX');
          ASM
            or h.Attribute, MsgRead
          END;
        END;
        ASSIGN(f,Cfg.MailScanner.NetMailDir+Long2Str(i)+'.MSG'); FileMode:=ShareRW+ShareDenyRW;
        RESET(f,1);
        BLOCKWRITE(f,h,SizeOf(h),x);
        CLOSE(f);
        Temp^.WFastWrite(CharStr(' ',28),2,2,Cfg.Color[2].TextColor);
      END;
      IF p<>NIL THEN FreeMemCheck(p,l);
    END;
  END;
  SetInterCom(ICIdle,Call,False);
  KillWindow(Temp);
{$ENDIF}
END;

END.
