UNIT MemStat;
{ͻ}
{ Information about the system                  Last changed: 25.06.96  SA }
{                                                                          }
{                         (C) Copyright 1989-96 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{ This source may not be given to anybody, without the written permission  }
{ from The Portal Team.                                                    }
{ͼ}
{$I POPDEFS.INC}

INTERFACE

PROCEDURE MemoryStatus;

IMPLEMENTATION

USES Use32,
{$IFNDEF NoOverlay}
  Overlay,
{$ENDIF}
{$IFDEF DPMI}
  Dpmi,
{$ENDIF}
{$IFDEF StackCheck}
  OpStack,
{$ENDIF}
  OpCrt, OpWindow, OpString, ApTimer,
  Ovrlay, PopTypes, OproUtil, Com, Globals, MTask;

{$IFDEF DPMI}
  FUNCTION ProcessorTypes(Processor: Byte): S10;
  BEGIN
    CASE Processor OF
      2  : ProcessorTypes:='80286';
      3  : ProcessorTypes:='80386';
      4  : ProcessorTypes:='80486';
      ELSE ProcessorTypes:='Type '+Long2Str(Processor);
    END;
  END;
{$ENDIF}

  FUNCTION OverlayBufLoc: S10;
  BEGIN
    CASE OverlayLocation OF
      XMS  : OverlayBufLoc:='XMS';
      EMS  : OverlayBufLoc:='EMS';
      Disk : OverlayBufLoc:='Disk';
      ELSE   OverlayBufLoc:='????';
    END;
  END;

{
  DisplayType = (MonoHerc, CGA, MCGA, EGA, VGA, PGC);
  HercCardType = (HercNone, HercPlain, HercPlus, HercInColor);
}
  FUNCTION ScrType(Display: DisplayType): S10;
  BEGIN
    CASE Display OF
      MonoHerc : CASE WhichHerc OF
                   HercNone    : ScrType:='Unknown';
                   HercPlain   : ScrType:='Hercules';
                   HercPlus    : ScrType:='Hercules+';
                   HercInColor : ScrType:='InColor';
                 END;
      CGA      : ScrType:='CGA';
      MCGA     : ScrType:='MCGA';
      EGA      : ScrType:='EGA';
      VGA      : ScrType:='VGA';
      PGC      : ScrType:='PGC';
    END;
  END;

  PROCEDURE MemoryStatus;
  TYPE
    LiAry = Array[1..12] of LongInt;
  VAR
    MemWin : WindowPtr;
    t      : EventTimer;
{$IFDEF DPMI}
    i        : Byte;
    DPMIInfo : DPMIInfoRec;
    MIR      : MemInfoRec;
{$ENDIF}
{$IFDEF StackCheck}
    StackUsage : Word;
    HeapUsage : LongInt;
    FreeUsage : Word;
    MemUsage : LongInt;
{$ENDIF}
  BEGIN
    MyWin(MemWin,1,2,80,ScreenHeight,3,'System Information',False);
    WITH MemWin^ DO
    BEGIN
      wFastText('Largest free block   :',2,2);
      wFastWrite(LongIntForm('###.###.###',MaxAvail),2,27,Cfg.Color[3].FieldColor);
      wFastText('Total free heap      :',3,2);
      wFastWrite(LongIntForm('###.###.###',MemAvail),3,27,Cfg.Color[3].FieldColor);
{$IFDEF Alpha}
  {$IFNDEF NoOverlay}
      wFastText('Start total free     :',4,2);
      wFastWrite(LongIntForm('###.###.###',StartMemAvail),4,27,Cfg.Color[3].FieldColor);
  {$ENDIF}
{$ENDIF}
      wFastText('Multitasker          :',5,2);
      wFastWrite(LeftPad(MultiName(MultiTasker),11),5,27,Cfg.Color[3].FieldColor);

{$IFNDEF NoOverlay}
      wFastText('Overlay buffer       :',7,2);
      wFastWrite(LongIntForm('###.###.###',OvrGetBuf),7,27,Cfg.Color[3].FieldColor);
      wFastText('Overlay load count   :',8,2);
      wFastWrite(LongIntForm('###.###.###',OvrLoadCount),8,27,Cfg.Color[3].FieldColor);
      wFastText('Overlay trap count   :',9,2);
      wFastWrite(LongIntForm('###.###.###',OvrTrapCount),9,27,Cfg.Color[3].FieldColor);
      wFastText('Probation area size  :',10,2);
      wFastWrite(LongIntForm('###.###.###',OvrGetRetry),10,27,Cfg.Color[3].FieldColor);
      wFastText('Overlay buffer loc.  :',11,2);
      wFastWrite(LeftPad(OverlayBufLoc,11),11,27,Cfg.Color[3].FieldColor);
{$ENDIF}
{$IFDEF StackCheck}
      CalcStackUsage(StackUsage, HeapUsage, FreeUsage, MemUsage);
      wFastText('Stack usage          :',13,2);
      wFastWrite(LongIntForm('###.###.###',StackUsage),13,27,Cfg.Color[3].FieldColor);
      wFastText('Heap usage           :',14,2);
      wFastWrite(LongIntForm('###.###.###',HeapUsage{$IFNDEF NoOverlay}-OvrGetBuf{$ENDIF}),14,27,Cfg.Color[3].FieldColor);
      wFastText('Memory usage         :',15,2);
      wFastWrite(LongIntForm('###.###.###',MemUsage),15,27,Cfg.Color[3].FieldColor);
{$ENDIF}

      wFastText('Screen type          :',2,41);
      wFastWrite(LeftPad(ScrType(CurrentDisplay),11),2,66,Cfg.Color[3].FieldColor);
      wFastText('Screen dimensions    :',3,41);
      wFastWrite(LeftPad(Long2Str(ScreenWidth)+'x'+Long2Str(ScreenHeight),11),3,66,Cfg.Color[3].FieldColor);
      wFastText('Video segment        :',4,41);
      wFastWrite(LeftPad('$'+HexW(VideoSegment),11),4,66,Cfg.Color[3].FieldColor);

{$IFDEF DPMI}
      GetDPMIInfo(DPMIInfo);
      wFastText('DPMI version         :',10,41);
      wFastText('Processor            :',11,41);
      WITH DPMIInfo DO
      BEGIN
        wFastWrite(LeftPad(Long2Str(MajorVersion)+'.'+Long2Str(MinorVersion),11),10,66,Cfg.Color[3].FieldColor);
        wFastWrite(LeftPad(ProcessorTypes(Processor),11),11,66,Cfg.Color[3].FieldColor);
      END;

      GetDPMIMemInfo(MIR);
      wFastText('Largest free block   :',13,41);
      wFastText('Max unlocked pages   :',14,41);
      wFastText('Max locked pages     :',15,41);
      wFastText('Linear Addr. pages   :',16,41);
      wFastText('Total unlocked pages :',17,41);
      wFastText('Total free pages     :',18,41);
      wFastText('Total phys. pages    :',19,41);
      wFastText('Free linear pages    :',20,41);
      wFastText('Page size            :',21,41);
      FOR i:=1 TO 9 DO
        IF LiAry(MIR)[i]<>-1 THEN
          wFastWrite(LongIntForm('###.###.###', LiAry(MIR)[i]),12+i,66,Cfg.Color[3].FieldColor)
        ELSE
          wFastWrite('N/A',12+i,74,Cfg.Color[3].FieldColor);
{$ENDIF}
    END;
    NewTimerSecs(t, 60);
    REPEAT
      GiveUpTime;
    UNTIL KeyPressed OR ComPort^.KeyPressed OR TimerExpired(t);
    KillWindow(MemWin);
  END;

END.

