UNIT FuncReq;
{ͻ}
{ Function request engine                       Last changed: 28.04.96  SA }
{                                                                          }
{                         (C) Copyright 1989-96 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{ This source may not be given to anybody, without the written permission  }
{ from The Portal Team.                                                    }
{ͼ}
{$I POPDEFS.INC}

INTERFACE

USES Use32;

PROCEDURE ParseRequest;

IMPLEMENTATION

USES Dos, OpDate, OpDos, OpString, OpRoot,
     StrUtil, Globals, FileUtil, MailUtil, Util, Config, LogFile, OutUtil,
     NetFile, OproUtil, PoPTypes;

CONST
  days:S31='   SUN MON TUE WED THU FRI SAT SUN';

PROCEDURE execute_command(s: string);
VAR
  EventFile : TNetFile;
  Event : TEvent;
  i,test,Zone:INTEGER;
  f1,keyword,p1,p2:string;
  evt:s8;
  Adr : TFidoAddress;

  PROCEDURE DO_macro(CONST name: s10);
  VAR
    f : TBufTextFile;
    s : String;
  BEGIN
    IF NOT f.Init(Name+'.PFM', SOpenRead, 512) THEN
    BEGIN
      AddLog('!','The MACRO '+name+' could not be found');
    END ELSE
    BEGIN
      AddLog('!','Macro '+name+' Begin');
      while NOT f.eof DO
      BEGIN
        f.ReadLn(s);
        execute_command(s);
      END;
      f.Done;
      addlog('!','Macro '+name+' End');
    END;
  END;

BEGIN
  s:=StUpCase(s);
  KeyWord:=NextWord(' ',s);
  IF keyword<>'' THEN
  BEGIN
    IF keyword='DELETE' THEN
    BEGIN
      IF DeleteFile(s) THEN addlog('!',StUpCase(s)+' Deleted') ELSE addlog('!',StUpCase(s)+' NOT deleted');
    END ELSE
      IF (keyword='MOVE') OR (keyword='COPY') THEN
      BEGIN
        f1:=NextWord(' ',s);
        IF copyfile(f1,s,False,(KeyWord='MOVE'))=0 THEN
          IF (Keyword='MOVE') THEN addlog('!', StUpCase(f1)+' Moved to '+s) ELSE
            AddLog('!', StUpCase(f1)+' copied to '+s);
      END ELSE
        IF keyword='SEND' THEN
        BEGIN
          p1:=NextWord(' ',s);
          p2:=NextWord(' ',s);
          IF NOT GetAdressFromStr(p2,Adr) THEN
          BEGIN
            Adr:=Call;
            p2:=Address2Str(Call);
          END;
          IF ExistFile(p1) THEN
          BEGIN
            addlog('!','Sent '+StUpCase(p1)+' to '+p2);
            SendAFile(p1,Adr,'H',STNothing);
          END ELSE
            addlog('!','Could NOT find '+StUpCase(p1)+' for '+p2);
        END ELSE
          IF keyword='POLL' THEN
          BEGIN
            p1:=NextWord(' ',s);
            p2:=COPY(NextWord(' ',s),1,1);
            IF NOT (p2[1] IN ['C','I','N','D']) THEN p2:='C';
            IF GetAdressFromStr(p1,Adr) THEN
            BEGIN
              addlog('!','Poll requested for '+s);
              MakeAPoll(Adr,p2[1]);
            END;
          END ELSE
            IF keyword='DOS' THEN
            BEGIN
              addlog('!','Executing '+StUpCase(s));
              ExecDos(s,TRUE,NoExecDosProc);
            END ELSE
              IF keyword='SHUTDOWN' THEN
              BEGIN
                addlog('!','Shutting down '+cfg.system);
                FinishPortal;
                Halt;
              END ELSE
                IF keyword='EVENT' THEN
                BEGIN
                  evt:=NextWord(' ',s);
                  VAL(evt,i,test);
                  IF (test=0) AND (i>0) THEN
                  BEGIN
                    EventFile.Open(StartPath+PoPEventFileName,SizeOf(TEvent),TRUE);
                    EventFile.GetRec(Event,i-1,Keep,Wait);
                    WITH Event DO
                    BEGIN
                      REPEAT
                        p2:=NextWord(' ',s);
                        IF p2='ENABLE' THEN
                        BEGIN
                          Active:=Active OR 1;
                          addlog('!','Enabling event #'+evt);
                        END ELSE
                          IF p2='DISABLE' THEN
                          BEGIN
                            Active:=Active AND 254;
                            addlog('!','Disabling event #'+evt);
                          END ELSE
                            IF p2='START' THEN
                            BEGIN
                              p1:=NextWord(' ',s);
                              Start:=TimeStringToTime('HH:MM',p1);
                              addlog('!','Setting event #'+evt+' to start at '+p1);
                            END ELSE
                              IF (p2='RUN') OR (p2='NORUN') THEN
                              BEGIN
                                p1:=NextWord(' ',s);
                                IF p1='ALL' THEN
                                BEGIN
                                  test:=127;
                                END ELSE
                                BEGIN
                                  test:=POS(p1,days) DIV 4;
                                  IF test>0 THEN
                                  BEGIN
                                    DEC(test);
                                    zone:=1 SHL test;
                                  END;
                                END;
                                IF p2='RUN' THEN
                                BEGIN
                                  Active:=Active OR zone;
                                  addlog('!','Setting event #'+evt+' to run on '+p1);
                                END ELSE
                                BEGIN
                                  Active:=Active AND (255-zone);
                                  addlog('!','Setting event #'+evt+' NOT to run on '+p1);
                                END;
                              END;
                              IF p2='MAXBAD' THEN
                              BEGIN
                                p1:=NextWord(' ',s);
                                VAL(p1,zone,test);
                                IF test=0 THEN
                                BEGIN
                                  addlog('!','Changing Max. bad of event #'+evt+' to '+p1);
                                  Tries.Bad:=zone;
                                END ELSE
                                  addlog('!','Invalid number "'+p1+'"');
                              END ELSE
                                IF p2='MAXNO' THEN
                                BEGIN
                                  p1:=NextWord(' ',s);
                                  VAL(p1,zone,test);
                                  IF test=0 THEN
                                  BEGIN
                                    addlog('!','Changing Max. No connect of event #'+evt+' to '+p1);
                                    Tries.Busy:=zone;
                                  END ELSE
                                    addlog('!','Invalid number "'+p1+'"');
                                END ELSE
                                  IF p2='POLLEXIT' THEN
                                  BEGIN
                                    p1:=NextWord(' ',s);
                                    VAL(p1,zone,test);
                                    IF test=0 THEN
                                    BEGIN
                                      addlog('!','Changing Pollexit of event #'+evt+' to '+p1);
                                      PollExit:=zone;
                                    END ELSE
                                      addlog('!','Invalid number "'+p1+'"');
                                  END ELSE
                                    IF p2='MAILEXIT' THEN
                                    BEGIN
                                      p1:=NextWord(' ',s);
                                      VAL(p1,zone,test);
                                      IF test=0 THEN
                                      BEGIN
                                        addlog('!','Changing Mailexit of event #'+evt+' to '+p1);
                                        MailExit:=zone;
                                      END ELSE
                                        addlog('!','Invalid number "'+p1+'"');
                                    END;
                      UNTIL s='';
                    END;
                    EventFile.PutRec(Event,i-1);
                    EventFile.Close;
                  END ELSE
                    addlog('!','Invalid event number "'+p1+'"');
                END ELSE
                  IF keyword='MACRO' THEN
                  BEGIN
                    DO_macro(s);
                  END ELSE
                  BEGIN
                    addlog('!','Unknown command "'+keyword+'"');
      END;
      SaveConfiguration;
  END;
END;

PROCEDURE ParseRequest;
LABEL
  Slut;
VAR
  f : PBufTextFile;
  s : STRING;
  pwdchecked:BOOLEAN;
  sr:SearchRec;
BEGIN
{$IFNDEF PoPLite}
  FindFirst(Cfg.Inbound[GlobNodeStat]+'*.PFR',AnyFile,sr);
  WHILE DOSERROR=0 DO
  BEGIN
    AddLog('!','Processing function request file "'+Sr.Name+'"');
    IF Cfg.FuncReqPwd<>'' THEN
    BEGIN
      PwdChecked:=FALSE;
      New(f, Init(Cfg.Inbound[GlobNodeStat]+Sr.Name, SOpenRead+ShareDenyW, 1024));
      IF f<>NIL THEN
      BEGIN
        WHILE NOT f^.EOF DO
        BEGIN
          f^.ReadLn(s);
          s:=s+' ';
          Replace(s,'  ',' ',0);
          IF NOT PwdChecked THEN
          BEGIN
            PwdChecked:=TRUE;
            IF StUpCase(NextWord(' ',s))='PASSWORD' THEN
            BEGIN
              s:=NextWord(' ',s);
              IF StUpCase(s)<>Cfg.FuncReqPwd THEN
              BEGIN
                AddLog('!','Invalid password "'+s+'"');
                GOTO Slut;
              END;
            END;
          END ELSE
            IF COPY(s,1,1)<>^A THEN Execute_Command(s);
        END;
  Slut:
        Dispose(f, Done);
        AddLog('!','Finished processing "'+sr.name+'"');
      END ELSE
        AddLog('!', 'Not enough memory to open: '+Sr.Name);
    END;
    DeleteFile(Cfg.Inbound[GlobNodeStat]+Sr.Name);
    FindNext(sr);
  END;
  FindClose(sr);
{$ENDIF}
END;

END.
