UNIT Fax;
{ͻ}
{ Fax receive routine                           Last changed: 26.06.96  SA }
{                                                                          }
{                      Original code by: Bo Bendtsen                       }
{                         (C) Copyright 1989-96 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{ This source may not be given to anybody, without the written permission  }
{ from The Portal Team.                                                    }
{ͼ}
{$I POPDEFS.INC}

INTERFACE

USES Use32;

PROCEDURE GetFax;

IMPLEMENTATION

Uses
  Dos,OpCrt, OpRoot, OpFrame, OpWindow, OpString, ApTimer,
  FaxConv,
  PoPTypes, Globals, LogFile, Util, StrUtil, FileUtil, OproUtil, Com, Modem;

TYPE
  PFaxWindow = ^TFaxWindow;
  TFaxWindow = OBJECT(StackWindow)
    CONSTRUCTOR Init;

    PROCEDURE ShowRemoteID(CONST s: S80);
    PROCEDURE ShowParameters(CONST s: S80);
    PROCEDURE ShowPage(Page: Word);
    PROCEDURE ShowCurrentByte(CurByte: LongInt);
    PROCEDURE ShowMessage(CONST s: S80);
  END;

  CONSTRUCTOR TFaxWindow.Init;
  BEGIN
    INHERITED InitCustom(15,10,65,16,Cfg.Color[2],wBordered+wClear);
    SetCursor(cuHidden);
    WFrame.AddHeader(' Fax receive progress ',heTC);
    IF Cfg.Screen.ExplodingWin THEN EnableExplosions(10);
    wFrame.AddShadow(shBR, shSeeThru);
    Draw;
    wFastText('Remote ID  :',2,2);
    wFastText('Parameters :',3,2);
    wFastText('Page       :',4,2);
    wFastText('Transfrd   :',5,2);
    wFastText('Last msg.  :',6,2);
    ShowPage(0);
  END;

  PROCEDURE TFaxWindow.ShowRemoteID(CONST s: S80);
  BEGIN
    wFastText(CPad(Trim(s), 35), 2, 15);
    AddLog('*', 'Remote ID: '+Trim(s));
  END;

  PROCEDURE TFaxWindow.ShowParameters(CONST s: S80);
  BEGIN
    wFastText(CPad(Trim(s), 35), 3, 15);
    AddLog('*', 'Parameters: '+Trim(s));
  END;

  PROCEDURE TFaxWindow.ShowPage(Page: Word);
  BEGIN
    wFastText(LongIntForm('#####', Page), 4, 15);
    ShowCurrentByte(0);
  END;

  PROCEDURE TFaxWindow.ShowCurrentByte(CurByte: LongInt);
  BEGIN
    wFastText(LongIntForm('#.###.###', CurByte), 5, 15);
  END;

  PROCEDURE TFaxWindow.ShowMessage(CONST s: S80);
  BEGIN
    wFastText(CPad(Trim(s), 35), 6, 15);
  END;

  PROCEDURE GetFax;
  Var
    Ch          : Char;
    LastIn      : String;
    Page        : Word;
    InCode      : Boolean;
    x1,x2,x3,
    x4,x5       : Word;
    FaxInDir,
    Filename    : PathStr;
    Info        : SearchRec;
    OutFile     : BufIdStreamPtr;
    FaxWin      : PFaxWindow;
    t           : EventTimer;
    CurByte     : LongInt;
  BEGIN
    IF ComPort^.GetBaudRate<19200 THEN ComPort^.SetBaudRate(19200);
    GetDate(x2, x3, x1, x4); GetTime(x2, x3, x4, x5);
    FaxInDir:=ForceExtension(Copy(Cfg.Inbound[nsUnknown], 1, Length(Cfg.Inbound[nsUnknown])-1), 'FAX')+'\';
    MakeFullDir(FaxInDir);
    FileName:=FaxInDir+ToChar(x1)+ToChar(x2)+ToChar(x3);
    LastIn:='';
    Page:=0;
    New(FaxWin, Init);
    NewTimerSecs(T, 30);
    REPEAT
      IF ComPort^.KeyPressed THEN
      BEGIN
        LastIn:=Trim(ModemReadStr);

{ IF LastIn<>'' THEN addlog('!', '>>'+LastIn+'<<'); }

        IF Pos('+FTSI: ',LastIn)<>0 THEN
        BEGIN
          Delete(LastIn, 1, 6);
          FaxWin^.ShowRemoteID(Trim(LastIn));
          NewTimerSecs(T, 10);
        END;

        IF Pos('+FET: ',LastIn)<>0 THEN
        BEGIN
          IF Pos('2', LastIn)>0 THEN
          BEGIN
            FaxWin^.ShowMessage('End of fax');
            NewTimer(t, 0);
          END;
          IF Pos('0', LastIn)>0 THEN
          BEGIN
            FaxWin^.ShowMessage('New page, same doc.');
            NewTimerSecs(T, 10);
          END;
        END;

        IF Pos('+FDCS: ',LastIn)<>0 THEN
        BEGIN
          Delete(LastIn, 1, 7);
          FaxWin^.ShowParameters(LastIn);
          NewTimerSecs(T, 10);
        END;

        IF Pos('OK',LastIn)<>0 THEN
        BEGIN
          LastIn:='';
          Pause(30);
          FaxWin^.ShowMessage('Sending page go code');
          NewTimerSecs(T, 10);
          ComPort^.WriteStr('AT+FDR'#13);
          REPEAT
            IF ComPort^.KeyPressed THEN
            BEGIN
              LastIn:=ModemReadStr;
              IF Pos('CONNECT',LastIn)<>0 THEN
              BEGIN
                LastIn:='';
                Inc(Page);
                FaxWin^.ShowPage(Page);
                FaxWin^.ShowMessage(FileName+ToChar(Page)+'.FAX');
                New(OutFile, Init(FileName+ToChar(Page)+'.FAX', SCreate, Max64k(MaxAvail-2048)));
                Delay(200);
                ComPort^.WriteByte(18, True);
                NewTimerSecs(T, 10);
                InCode:=False;
                CurByte:=0;
                REPEAT
                  IF ComPort^.KeyPressed THEN
                  BEGIN
                    Inc(CurByte);
                    IF (CurByte MOD 128)=0 THEN FaxWin^.ShowCurrentByte(CurByte);
                    Ch:=Char(ComPort^.ReadByte);
                    LastIn:=LastIn+Ch;
                    IF Length(LastIn)>10 THEN Delete(LastIn, 1, 1);
                    NewTimerSecs(T, 5);
                    IF InCode THEN
                    BEGIN
                      IF Ch=#$10 THEN
                        OutFile^.Write(Ch, 1)   { $10$10 = $10 }
                      ELSE
                        IF Ch=#$1A THEN             { $10$1A = $10$10 }
                        BEGIN
                          Ch:=#$10;
                          OutFile^.Write(Ch, 1);
                          OutFile^.Write(Ch, 1);
                        END;
                      InCode:=False;
                    END ELSE
                    BEGIN
                      IF Ch=#$10 THEN InCode:=True ELSE OutFile^.Write(Ch, 1);
                    END;
                  END;
                UNTIL (TimerExpired(t)) or (Pos('+FPTS',LastIn)<>0);
                IF TimerExpired(t) THEN
                  FaxWin^.ShowMessage('Timeout')
                ELSE
                  FaxWin^.ShowMessage('End of page');
                Dispose(OutFile, Done);
              END;
            END;
          UNTIL (TimerExpired(t)) or (Pos('+FPTS',LastIn)<>0);
        END;
        LastIn:='';
      END;
    UNTIL (TimerExpired(t));
    Dispose(FaxWin, Done);
    AddLog('*', Long2Str(Page)+' fax pages received');

    FindFirst(Filename+'??.FAX', Archive, Info);
    IF DosError=0 THEN MakeModemBusy;
    WHILE DosError=0 DO
    BEGIN
      FaxToPcx(FaxInDir+Info.Name);
      DeleteFile(FaxInDir+Info.name);
      FindNext(Info);
    END;
    FindClose(Info);
  END;

END.
