REM Sample batch file for switching between ISDN and analogue
REM Portal task using the Ring Analyzer feature. Please read the
REM Ring Analyzer configuration file PORTAL.RAC for more informations.

REM The sample batch files for this feature assumes that the drivers for
REM each task are loaded only if there are needed. You can load them
REM permantly also in which case you have to comment out all unload
REM statements in both batch files. But this is not the best way
REM to do it because the drivers will use a lot of your memory but
REM only one of the drivers is used at one time.

REM BBSRAC.BAT is the according sample batch for starting the bbs.
REM Read the explanations in this file very carefully.

@ECHO OFF

:PRESTART
  IF %1"==Analog" GOTO LoadADF
 REM Load your CAPI driver.
  E:\FOSSIL\EEHCAPI2 /L
 REM Load CFos.
  E:\FOSSIL\CFOSN i -c3 -b256 -w7
  GOTO START
:LoadADF
 REM Load Fossil driver for analogue modem.
  LH E:\FOSSIL\ADF COM3 2E0 12 115200 8192 8192 8
  LH E:\FOSSIL\ADF WATCH 120
  LH E:\FOSSIL\ADF WATCH ON

:START
  E:
  CD \PORTAL
  IF %1"==Analog" GOTO StartAnalog
 REM Start Portal with ISDN configuration file PORTAL.CFI.
  PORTAL PORTAL.CFI
  GOTO ProcessErrorLevel
:StartAnalog
 REM Start Portal with analogue configuration file PORTAL.CFA.
  PORTAL -S PORTAL.CFA

:ProcessErrorLevel
REM Ŀ
REM  ERRORLEVELs 249 to 255 are predefined for error-reporting             
REM 

  IF ERRORLEVEL 255 GOTO SELFTESTERROR
  IF ERRORLEVEL 254 GOTO MEMERROR
  IF ERRORLEVEL 253 GOTO MODEMERROR
  IF ERRORLEVEL 252 GOTO OVRERROR
  IF ERRORLEVEL 251 GOTO FOSSILERROR
  IF ERRORLEVEL 250 GOTO LOGERROR
  IF ERRORLEVEL 249 GOTO CPUERROR

REM Ŀ
REM  ERRORLEVELs 200 to 248 are suitable for userdefined errorlevels       
REM 



REM Ŀ
REM  ERRORLEVEL for switching between analogue and ISDN task and starting  
REM  your BBS.                                                             
REM 

  IF ERRORLEVEL 3 GOTO START
 REM Assuming errorlevel 2 is defined for bbs.
  IF ERRORLEVEL 2 GOTO BBS
 REM Assuming errorlevel 1 is defined for analog callers in PORTAL.RAC.
  IF ERRORLEVEL 1 GOTO PORTANALOG
  IF ERRORLEVEL 0 GOTO END
  REM ** This is equal to 'GOTO END'

REM Ŀ
REM  Here follows the routine for starting the BBS                         
REM 

:BBS
  BBSBATCH

  REM ** Please note that by keeping the BBS-batch as the first, the exe-
  REM ** cutions speed of this batchfile is enhanced.
  REM ** The BBSBATCH.BAT File Is Written By Portal, And Are Connected To
  REM ** SPAWNBBS.BAT
  REM ** Your SPAWNBBS.BAT File MUST Start This BatchFile When Finished.
  REM ** Therefore There Is No Need For The 'GOTO START' Here.
  REM ** Refer To Enclosed SPAWNBBS.BAT For An Example.

  REM If a caller is going to your bbs you have to unload the ISDN
  REM and fossil drivers in SPAWNBBS.BAT before calling PORTAL.BAT again.
  REM Look at BBSRAC.BAT for a sample file according to this batch file.


REM Ŀ
REM  Here follows the routine for starting the analogue task               
REM 

:PORTANALOG
 REM Unload ISDN drivers.
  E:\FOSSIL\CFOSN D
  E:\FOSSIL\EEHCAPI2 /D
  E:\PORTAL\POP.BAT Analog


REM Ŀ
REM  Here the Errormessages follows:                                       
REM 

:SELFTESTERROR
GOTO END

:MEMERROR
  ECHO Memory Allocation Error - Please Check Your System.
GOTO END

:MODEMERROR
  ECHO Error Initializing Modem - Please Check Your Modem, Cabling
  ECHO And Your Portal Port And Speed Configuration.
GOTO END

:OVRERROR
  ECHO Error Initializing Overlay Manager - Please Check You System
GOTO END

:FOSSILERROR
  ECHO No Fossil Loaded - Please Check Your System.
GOTO END

:LOGERROR
  ECHO Error Opening LogFile - Please Check Your System.
GOTO END

:CPUERROR
  ECHO 80286 or higher CPU needed to run Portal.
GOTO END

REM Ŀ
REM  This is the end of this batch-file, DO NOT REMOVE THIS LABEL          
REM 

:END
  IF %1"==Analog" GOTO ReStartISDN

  GOTO STOP

:ReStartISDN
 REM Unload analogue fossil driver.
  LH E:\FOSSIL\ADF UNLOAD
  E:\PORTAL\POP.BAT

:STOP
 REM Unload ISDN drivers.
  E:\FOSSIL\CFOSN D
  E:\FOSSIL\EEHCAPI2 /D
