/*---------------------------------------------------------------------------*
 *
 *                               BinkleyTerm
 *
 *              (C) Copyright 1987-96, Bit Bucket Software Co.
 *     For license and contact information see /doc/orig_260/license.260.
 *
 *           This version was modified by the BinkleyTerm XE Team.
 *        For contact information see /doc/team.lst and /doc/join.us.
 *  For a complete list of changes see /doc/xe_user.doc and /doc/xe_hist.doc.
 *
 * Filename    : $Source: E:/cvs/btxe/src/dos/xr5toxr6.c,v $
 * Revision    : $Revision: 1.3 $
 * Tagname     : $Name: XH6 $
 * Last updated: $Date: 1999/02/27 01:16:33 $
 * State       : $State: Exp $
 * Orig. Author: Alex Woick 2:244/1351
 *
 * Description : converts DOS-created pre-XR6 callhist.all file to XR6 format
 *
 *---------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

typedef unsigned short word;
typedef unsigned char byte;

typedef struct _ADDRESS
{
  word Zone;
  word Net;
  word Node;
  word Point;
  char *Domain;
}
ADDR, *ADDRP;

#include "history.h"

int
main (int argc, char **argv)
{
  CALLHIST rec;
  FILE *f;
  long l = 0;

  printf ("Converter for XR5 DOS history file to XR6 format, by Alex Woick 2:244/1351\n\n");
  if (argc != 2)
  {
    printf ("Usage  : XR5TOXR6 btxe_history_file\n"
            "Example: XR5TOXR6 P:\\BTXE\\TASK\\CALLHIST.ALL\n\n"
            "  WARNING: DO NOT CALL THIS PROGRAM TWICE ON THE SAME CALLHIST.ALL FILE\n"
            "           OR ON A CALLHIST.ALL THAT WAS CREATED AND WRITTEN BY THE\n"
            "           OS/2 or WIN-NT VERSION OF BT-XE!! IT IS ONLY FOR THE HISTORY\n"
            "           FILE THAT WAS GENERATED BY THE XR5 DOS VERSION.\n\n"
            "  WARNING 2: Make a backup of the history file before the conversion\n");
    return 1;
  }

  f = fopen (argv[1], "rb+");
  if (!f)
  {
    printf ("Failed to open input file %s\n", argv[1]);
    return 2;
  }

  fseek (f, l, SEEK_SET);
  while (fread (&rec, sizeof (rec), 1, f))
  {
    if (rec.calltype == CT_MAILER)
    {
      printf ("\r%6ld '%s'                     ", l, rec.h.m.name);
      memmove (((char *) (&rec)) + 193 + 13, ((char *) (&rec)) + 189 + 13, sizeof (rec) - 193 - 13);
      rec.h.m.filesout = (rec.h.m.filesin >> 16) & 0x0000ffffL;
      rec.h.m.filesin = rec.h.m.filesin & 0x0000ffffL;
      fseek (f, l * sizeof (rec), SEEK_SET);
      fwrite (&rec, sizeof (rec), 1, f);
      fflush (f);
    }
    ++l;
  }

  fclose (f);
  printf ("Done.\n");
  return 0;
}

/*
   16bit 32bit
   0        0  char name[40];
   40      40  char system[40];
   80      80  char location[40];
   120    120  char phone[25];
   145    145  char mailer[40];
   185    185  int filesin,filesout;
   189    193  long bytesin,bytesout;
   197    201  long cpsin,cpsout,cpsall;
   209    213  long cost;
   213    217  long speed;
   217    221  ADDR address;
   229    233  byte passworded;
   230    234  byte success;
 */

/* $Id: xr5toxr6.c,v 1.3 1999/02/27 01:16:33 mr Exp $ */
