/*---------------------------------------------------------------------------*
 *
 *                               BinkleyTerm
 *
 *              (C) Copyright 1987-96, Bit Bucket Software Co.
 *     For license and contact information see /doc/orig_260/license.260.
 *
 *           This version was modified by the BinkleyTerm XE Team.
 *        For contact information see /doc/team.lst and /doc/join.us.
 *  For a complete list of changes see /doc/xe_user.doc and /doc/xe_hist.doc.
 *
 * Filename    : $Source: E:/cvs/btxe/src/b_flofil.c,v $
 * Revision    : $Revision: 1.11 $
 * Tagname     : $Name: XH6 $
 * Last updated: $Date: 1999/09/30 17:50:08 $
 * State       : $State: Exp $
 *
 * Description : BinkleyTerm .FLO file Processor
 *
 *---------------------------------------------------------------------------*/

/* Include this file before any other includes or defines! */

#include "includes.h"

/* ------------------------------------------------------------------------ */
/* do_FLOfile (send files listed in .FLO files)                             */
/*   returns TRUE (1) for good xfer, FALSE (0) for bad                      */
/* ------------------------------------------------------------------------ */

int
do_FLOfile (char *ext_flags, int (*callback) (char *))
{
  FILE *fp;
  char fname[PATHLEN];
  char s[PATHLEN], *s2;
  char *sptr;
  char *HoldName;
  char **filelist = NULL;
  struct S_PKTh *notify;
  int c;
  int rc;                       /* MR 970505 */
  int i, j = 0;
  struct stat buf;
  ULONG filecount = 0, cl;
  NODESTRUC *qnode;
  struct FILEINFO dta;
  long current, last_start;

  /* ---------------------- */
  /* Private directory code */
  /* ---------------------- */
  qnode = QueryNodeStruct (&called_addr, 0);
  if (qnode)
    if (qnode->ExtraDir && !(caller && qnode->ExtraDirHold))
    {
      filelist = (char **) malloc (sizeof (char *));

      if (filelist)
      {
        /* -------------------------------------- */
        /* First we build a list of files to send */
        /* -------------------------------------- */
        filelist[0] = NULL;
        s2 = (char *) malloc (strlen (qnode->ExtraDir) + 10);
        strcpy (s2, qnode->ExtraDir);
        strcat (s2, MATCHALL);
        status_line (":Sending files from private dir first: %s", s2);
        i = dfind (&dta, s2, 0);
        filecount = 0;

        while (!i)
        {
          if (!(dta.attr & FA_SUBDIR))
          {
            if (dta.name[0] != '.')
              filelist = (char **) realloc (filelist, sizeof (char *) * (filecount + 2));

            filelist[filecount] = ctl_string (dta.name);
            filelist[++filecount] = NULL;
          }

          i = dfind (&dta, s2, 1);
        };

        dfind (&dta, s2, 2);
        free (s2);

        /* ------------------------------------------------------ */
        /* Create notification message for receiver, if required. */
        /* ------------------------------------------------------ */

        if (filecount && qnode->ExtraDirNotify)
        {
          ADDR ouraka;
          char pw[8];

          cl = 0;
          ouraka.Zone = alias[0].Zone;
          ouraka.Net = alias[0].Net;
          ouraka.Node = alias[0].Node;
          ouraka.Point = alias[0].Point;
          n_getpassword (&called_addr);
          memset (pw, 0, sizeof (pw));
          memmove (pw, newnodedes.Password, 8);
          status_line (" Using password: %s", pw);
          notify = CreateMSGinPKT (qnode->ExtraDir, ouraka, called_addr,
                                 "Binkley-XE", ouraka, "Sysop", called_addr,
                                   "Files sent to your system", MSG_PRIVATE | MSG_LOCAL, "", pw, NULL);
          if (notify)
          {
            char *st;

            WriteToPKT (notify, "The following files are stored in your private directory so they\r");
            WriteToPKT (notify, "will be sent along with this message. Note that they will be\r");
            WriteToPKT (notify, "deleted as soon as they are transmitted.\r\r");
            WriteToPKT (notify, "List follows:\r");
            WriteToPKT (notify, "-------------\r");
            cl = 0;
            while (cl < filecount)
              WriteToPKT (notify, "%s\r", filelist[cl++]);
            WriteToPKT (notify, "\rThis is an automessage generated by Binkley-XE, no reply is\r");
            WriteToPKT (notify, "required.\r");
            st = ctl_string (notify->pktname);
            ClosePKT (notify);
            j = (*callback) (st);  /* TE011097 */
            if (j == NOTHING_SENT || j == CANNOT_SEND)
              status_line ("Warning: Couldn't send notification message");
            CLEAR_IOERR ();
            unlink (st);
            free (st);
          }
        }

        /* ------------------------------------------------------ */
        /* Now we send all the files in the list, killing them in */
        /* the process                                            */
        /* ------------------------------------------------------ */

        cl = 0;
        while (cl < filecount)
        {
          strcpy (s, qnode->ExtraDir);
          strcat (s, filelist[cl]);

          /* status_line (":File: %s Attrib: %d (%d)",s,
           *              dta.attr, dta.attr & FA_SUBDIR); */

          j = (*callback) (s);
          if (j == NOTHING_SENT || j == CANNOT_SEND)
            break;

          CLEAR_IOERR ();
          unlink (s);
          status_line (MSG_TXT (M_UNLINKING_MSG), s);
          free (filelist[cl]);
          cl++;
        }

        free (filelist);
      }                         /* filelist!=NULL */
    }

  HoldName = HoldAreaNameMunge (&called_addr);

  /* -------------------------------------------------------------------- */
  /* Send files listed in ?LO files (attached files)                      */
  /* -------------------------------------------------------------------- */

  for (c = 0; c < (int) strlen (ext_flags); c++)
  {
#ifndef JACK_DECKER
    if ((caller && !SendHoldIfCaller) && (ext_flags[c] == 'h'))  /* VRP 990824 */
      continue;
#endif

    sprintf (fname, "%s%s.%clo",
             HoldName, Hex_Addr_Str (&called_addr), ext_flags[c]);

    if (!unix_stat (fname, &buf))
    {
      forcebttaskcheck ();

      if (bttask)
        return TRUE;

      if (fsent && SyncHydraSession)
        return TRUE;

      // MR/TJW 970505 changed DENY_NONE -> DENY_WRITE
      if ((fp = share_fopen (fname, read_binary_plus, DENY_WRITE)) == NULL)
      {
        got_error (MSG_TXT (M_OPEN_MSG), fname);
        continue;
      }

      current = 0L;
      while (!feof (fp))
      {
        s[0] = 0;
        last_start = current;
        fgets (s, PATHLEN - 1, fp);

        forcebttaskcheck ();

        if (bttask)
          continue;

        if (fsent && SyncHydraSession)
          continue;

        sptr = s;

        for (i = 0; sptr[i]; i++)
          if (sptr[i] <= ' ')
            sptr[i] = 0;

        current = ftell (fp);

        if (sptr[0] == TRUNC_AFTER)
        {
          sptr++;
          i = TRUNC_AFTER;
        }
        else if (sptr[0] == SHOW_DELETE_AFTER)
        {
          sptr++;
          i = SHOW_DELETE_AFTER;
        }
        else
          i = NOTHING_AFTER;

        if ((!sptr[0]) || (sptr[0] == ';'))
          continue;

        if (sptr[0] != FILE_ALREADY_SENT)
        {
          if (unix_stat (sptr, &buf))  /* file exist? */
          {
            got_error (MSG_TXT (M_FIND_MSG), sptr);
            continue;
          }
          else if (!buf.st_size)
            continue;           /* 0 length? */

          j = (*callback) (sptr);
          if (j == NOTHING_SENT || j == CANNOT_SEND)
          {
            fclose (fp);
            return FALSE;
          }

          /* -------------------------------------------- */
          /* File was sent or skipped.  Flag file name    */
          /* -------------------------------------------- */

          fseek (fp, last_start, SEEK_SET);
          putc (FILE_ALREADY_SENT, fp);  /* flag it */
          fflush (fp);
          rewind (fp);          /* clear any eof flags */
          fseek (fp, current, SEEK_SET);

          if (j == FILE_SKIPPED)  /* if filetransfer skipped */
            continue;           /* don't delete/truncate   */

          /* update fsent *AFTER* "FILE_SKIPPED" (r.hoerner) */
          fsent++;

          if (i == TRUNC_AFTER)
          {
            FILE *ftmp;

            CLEAR_IOERR ();
            ftmp = fopen (sptr, write_binary);
            fclose (ftmp);
            status_line (MSG_TXT (M_TRUNC_MSG), sptr);
          }
          else if (i == SHOW_DELETE_AFTER)
          {
            CLEAR_IOERR ();
            unlink (sptr);
            status_line (MSG_TXT (M_UNLINKING_MSG), sptr);
          }
          else if (i == DELETE_AFTER)
          {
            CLEAR_IOERR ();
            unlink (sptr);
          }
        }
      }

      fclose (fp);

      forcebttaskcheck ();
      if (bttask)
        return TRUE;

      if (!(fsent && SyncHydraSession))
      {
        rc = unlink (fname);
        if (rc)                 /* MR 970505 added for debug */
          status_line (MSG_TXT (M_FAILED_CLEAR_FLAG), fname);
      }
    }
  }

  return TRUE;
}

/* $Id: b_flofil.c,v 1.11 1999/09/30 17:50:08 ceh Exp $ */
