/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*  (C) Copyright 1987-91, Bit Bucket Software Co., a Delaware Corporation. */
/*                                                                          */
/*                                                                          */
/*                Function definitions used in BinkleyTerm                  */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.250.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:491/0                          */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* Unattended mode command keys */

#define F_UN_BASE          0xfe00            /* Base of unattended mode fns */
#define F_UN_ANSWER        (F_UN_BASE+0x00)  /* Send answer string to modem */
#define F_UN_REINITMODEM   (F_UN_BASE+0x01)  /* User wants to reinit modem  */
#define F_UN_CALLRIGHTNOW  (F_UN_BASE+0x02)  /* Call next eligible node now */
#define F_UN_POLLBOSS      (F_UN_BASE+0x03)  /* Poll the bossnode           */
#define F_UN_POLLNODE      (F_UN_BASE+0x04)  /* Poll a specified node       */

#define F_UN_TERMINALMODE  (F_UN_BASE+0x10)  /* Exit mailer, enter terminal */
#define F_UN_MSGEDITOR     (F_UN_BASE+0x11)  /* Spawn user's editor         */
#define F_UN_EXITBINK      (F_UN_BASE+0x12)  /* Exit BinkleyTerm            */

#define F_UN_FUNKEY1       (F_UN_BASE+0x21)  /* Exit with errorlevel 10     */
#define F_UN_FUNKEY2       (F_UN_BASE+0x22)  /* Exit with errorlevel 20     */
#define F_UN_FUNKEY3       (F_UN_BASE+0x23)  /* Exit with errorlevel 30     */
#define F_UN_FUNKEY4       (F_UN_BASE+0x24)  /* Exit with errorlevel 40     */
#define F_UN_FUNKEY5       (F_UN_BASE+0x25)  /* Exit with errorlevel 50     */
#define F_UN_FUNKEY6       (F_UN_BASE+0x26)  /* Exit with errorlevel 60     */
#define F_UN_FUNKEY7       (F_UN_BASE+0x27)  /* Exit with errorlevel 70     */
#define F_UN_FUNKEY8       (F_UN_BASE+0x28)  /* Exit with errorlevel 80     */
#define F_UN_FUNKEY9       (F_UN_BASE+0x29)  /* Exit with errorlevel 90     */
#define F_UN_FUNKEY10      (F_UN_BASE+0x2a)  /* Exit with errorlevel 100    */

#define F_UN_SHELL         (F_UN_BASE+0x30)  /* Shell to OS command line    */
#define F_UN_SHELL1        (F_UN_BASE+0x31)  /* Spawn user-command 1        */
#define F_UN_SHELL2        (F_UN_BASE+0x32)  /* Spawn user-command 2        */
#define F_UN_SHELL3        (F_UN_BASE+0x33)  /* Spawn user-command 3        */
#define F_UN_SHELL4        (F_UN_BASE+0x34)  /* Spawn user-command 4        */
#define F_UN_SHELL5        (F_UN_BASE+0x35)  /* Spawn user-command 5        */
#define F_UN_SHELL6        (F_UN_BASE+0x36)  /* Spawn user-command 6        */
#define F_UN_SHELL7        (F_UN_BASE+0x37)  /* Spawn user-command 7        */
#define F_UN_SHELL8        (F_UN_BASE+0x38)  /* Spawn user-command 8        */
#define F_UN_SHELL9        (F_UN_BASE+0x39)  /* Spawn user-command 9        */

#define F_UN_GETFILE       (F_UN_BASE+0x40)  /* Get a file from somebody    */
#define F_UN_SENDFILE      (F_UN_BASE+0x41)  /* Send a file to somebody     */
#define F_UN_KILLNODESMAIL (F_UN_BASE+0x42)  /* Kill all mail to somebody   */

#define F_UN_HELPSCREEN    (F_UN_BASE+0x50)  /* Bring up mailer helpscreen  */
#define F_UN_BLANKSCREEN   (F_UN_BASE+0x51)  /* Force the screen to blank   */
#define F_UN_REPAINTSCREEN (F_UN_BASE+0x52)  /* Repaint the hosed screen    */

#define F_UN_CLEARHIST     (F_UN_BASE+0x60)  /* Reset Today-At-A-Glance     */
#define F_UN_RESTARTEVENTS (F_UN_BASE+0x61)  /* Restart nonforced events    */
#define F_UN_QUITTHISEVENT (F_UN_BASE+0x62)  /* End this event now          */

#define F_PEND_DNAR        (F_UN_BASE+0x70)  /* Scroll Pending down 1 line  */
#define F_PEND_UPAR        (F_UN_BASE+0x71)  /* Scroll Pending up 1 line    */
#define F_PEND_PGDN        (F_UN_BASE+0x72)  /* Scroll Pending down 4 lines */
#define F_PEND_PGUP        (F_UN_BASE+0x73)  /* Scroll Pending up 4 lines   */
#define F_PEND_HOME        (F_UN_BASE+0x74)  /* Scroll Pending to top       */
#define F_PEND_END         (F_UN_BASE+0x75)  /* Scroll Pending to bottom    */

/* Terminal mode command keys */

#define F_TERM_BASE        0xfd00            /* Base for all term mode fns  */
#define F_TERM_SETBAUD     (F_TERM_BASE+0x00)/* Set baudrate on this port   */
#define F_TERM_COMMCONFIG  (F_TERM_BASE+0x01)/* Set data and stop bits      */
#define F_TERM_DOBREAK     (F_TERM_BASE+0x02)/* Toggle break on/off         */
#define F_TERM_CHANGEPORT  (F_TERM_BASE+0x03)/* Change the port we're using */

#define F_TERM_REINITMODEM (F_TERM_BASE+0x10)/* Send init string to modem   */
#define F_TERM_HANGUP      (F_TERM_BASE+0x11)/* Drop DTR to hang up modem   */

#define F_TERM_DIALOUT     (F_TERM_BASE+0x20)/* Dial a specified number     */
#define F_TERM_DIALGROUP   (F_TERM_BASE+0x21)/* Dial a hunt group           */
#define F_TERM_POLLBOSS    (F_TERM_BASE+0x22)/* Poll the bossnode           */
#define F_TERM_POLLNODE    (F_TERM_BASE+0x23)/* Poll a specified node       */

#define F_TERM_DOWNLOAD    (F_TERM_BASE+0x30)/* Download a file from remote */
#define F_TERM_UPLOAD      (F_TERM_BASE+0x31)/* Upload a file to remote     */
#define F_TERM_CAPTUREFILE (F_TERM_BASE+0x32)/* Open/close text capture file*/
#define F_TERM_GATEWAYMODE (F_TERM_BASE+0x33)/* Don't map keyboard          */

#define F_TERM_MACRO1      (F_TERM_BASE+0x41)/* Transmit user string 1      */
#define F_TERM_MACRO2      (F_TERM_BASE+0x42)/* Transmit user string 2      */
#define F_TERM_MACRO3      (F_TERM_BASE+0x43)/* Transmit user string 3      */
#define F_TERM_MACRO4      (F_TERM_BASE+0x44)/* Transmit user string 4      */
#define F_TERM_MACRO5      (F_TERM_BASE+0x45)/* Transmit user string 5      */
#define F_TERM_MACRO6      (F_TERM_BASE+0x46)/* Transmit user string 6      */
#define F_TERM_MACRO7      (F_TERM_BASE+0x47)/* Transmit user string 7      */
#define F_TERM_MACRO8      (F_TERM_BASE+0x48)/* Transmit user string 8      */
#define F_TERM_MACRO9      (F_TERM_BASE+0x49)/* Transmit user string 9      */

#define F_TERM_CLEARSCREEN (F_TERM_BASE+0x50)/* Erase the messy screen      */
#define F_TERM_HELPSCREEN  (F_TERM_BASE+0x51)/* Bring up terminal helpscreen*/
#define F_TERM_VERSION     (F_TERM_BASE+0x52)/* Display Bink version        */

#define F_TERM_MAILERMODE  (F_TERM_BASE+0x60)/* Exit terminal, enter mailer */
#define F_TERM_EXITBINK    (F_TERM_BASE+0x61)/* Exit BinkleyTerm            */
#define F_TERM_SHELL       (F_TERM_BASE+0x62)/* Shell to OS command line    */
