/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*  (C) Copyright 1987-91, Bit Bucket Software Co., a Delaware Corporation. */
/*                                                                          */
/*                                                                          */
/*            This module was originally written by Bob Hartman             */
/*                                                                          */
/*                                                                          */
/*                  BinkleyTerm Initial Fullscreen Setup                    */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.250.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:491/0                          */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* Include this file before any other includes or defines! */

#include "includes.h"

#ifndef MILQ
#define WHOLEWIN
#endif

#ifdef MILQ
#define MENU_ENABLED
#if defined (MENU_ENABLED) || defined (MILQ)
#define RESOURCE_ENABLED
#endif
#endif

extern VIOMODEINFO vfos_mode;
void MilqMassageWnd( REGIONP Win, int Color );

#ifdef MILQ
int PASCAL color_enum( HWND hWnd,
                       DWORD lParam ) {
  WinSetAttr( hWnd, (int)lParam, FALSE );
  return TRUE;
  }

HWND MilqDlgCreate( REGIONP  Win,
                    char    *Nm,
                    DLGPROC *dlgfunc,
                    int      Color ) {
  Win->hWnd = CreateDialog( MilqueRsrc, Nm, MilqueMailerWnd, dlgfunc );
  MilqMassageWnd( Win, Color );
  return Win->hWnd;
  }

void MilqMassageWnd( REGIONP Win,
                     int     Color ) {
  int                   Bgd = WHITE;
  HWND                  hMenu;

  hMenu = GetSystemMenu( Win->hWnd, FALSE );
  DeleteMenu( hMenu, SC_CLOSE, MF_BYCOMMAND );
  AppendMenu( hMenu, MF_ENABLED, SC_SIZE, "~Size" );
  GetWindowRect( Win->hWnd, &Win->MilqSave.OrgRect );
  if ( !UseWinColors ) {
    if ( Color ) {
      WinSetAttr( Win->hWnd, Color, FALSE );
      EnumChildWindows( Win->hWnd, color_enum, (long)Color );
      }                                /* end of if ( Color )         */
    }                                  /* end of if ( !UseWinColors ) */
  SetFocus( Win->hWnd );
  }
#endif

void b_sbinit () {
#ifdef MILQ
   char                 Buf[81];
#endif

   register int         r;
   char                *savep;

#ifdef MILQ
   KbMapSet( &UnattendedKeyFncHdr );
   WinInit();
   MDIInitialize();
   MilqueClassRegister();
   WinUseSysColors (MilqueRootWnd, TRUE);
   OrgVidInfo.VidMode = VidGetMode();
   WinUseMonoMap( TRUE );

   MilqueRsrc = OpenResourceFile((PSTR) PRDCT_PRFX);

   /* Fetch the ega status and toggle if needed */

   UseWinColors = GetPrivateProfileInt( "Milque", "UseWinColors", 0, "Milque.Ini" );
   node_Pwd_Enable = GetPrivateProfileInt( "Milque", "PWD", 0, "Milque.Ini" );
#ifdef NEW_BIG_SCREEN
   switch ( VidQueryAdapterType() ) {
     case CGA:
     case MDA:
       break;
     default:
       if ( GetPrivateProfileInt( "Milque", "EGA", 0, "Milque.Ini" ) ) {
         ToggleEGA();
         MilqueVidInfo.EGAState = TRUE;
         }
       break;
     }
#endif

   if ( !( MilqueMailerAccel = LoadAccelerators( MilqueRsrc,
                                                 (LPSTR)"MailerAccel" ) ) ) {
     MessageBox( MilqueRootWnd,
                 (PSTR)"Cannot load Mailer Accelerators",
                 (PSTR)"Fatal Error",
                 MB_OK );
     exit(1);
     }
   MilqueActvAccel = MilqueMailerAccel;
   if ( !( MilqueTrmnlAccel = LoadAccelerators( MilqueRsrc,
                                                (LPSTR)"TrmnlAccel" ) ) ) {
     MessageBox( MilqueRootWnd,
                 (PSTR)"Cannot load Terminal Accelerators",
                 (PSTR)"Fatal Error",
                 MB_OK );
     exit(1);
     }
   if ( !( MilqueMailerMnu = LoadMenu( MilqueRsrc, (LPSTR)"MailerMenu" ) ) ) {
     MessageBox( MilqueRootWnd,
                 (PSTR)"Cannot load the menu",
                 (PSTR)"Fatal Error",
                 MB_OK);
     exit(1);
     }

   randomize();
   MilqueMailerWnd = CreateWindow( (PSTR)"Normal",       /* class */
                                   (PSTR)"BTMewel",      /* title */
                                   WIN_HAS_BORDER   |
                                     WIN_MINMAXBOX  |
                                     WIN_MOVEBOX    |
                                     WIN_SIZEBOX    |
                                     WIN_SYSMENU    |
                                     WIN_TITLEBAR   |
                                     WS_CLIP        |
                                     WS_MAXIMIZEBOX |
                                     WS_MINIMIZEBOX,
                                   0,0,            /* x,y,width,height */
                                   GetSystemMetrics(SM_CXSCREEN),
                                   GetSystemMetrics(SM_CYSCREEN),
                                   MilqueRootWnd,   /* hParent */
                                   MilqueMailerMnu,  /* hMenu */
                                   0,              /* hInst */
                                   0L);           /* lpParam */
   MilqueActvWnd = MilqueMailerWnd;
   WinSetWinProc( MilqueMailerWnd, MailerWndPrc );
#endif

   savep = calloc (1, 4096);
   for (r = 0; r < 132; r++)
      {
      blanks[r * 2] = ' ';
      blanks[r * 2 + 1] = 7;
      }

   vfossil_init ();
   if (vfos_mode.col < 80)
      vfos_mode.col = 80;
   if (vfos_mode.row < 23)
      vfos_mode.row = 23;

#ifndef MILQ
   SB_ROWS = vfos_mode.row - 1;
   SB_COLS = vfos_mode.col;
#else
   SB_ROWS = GetSystemMetrics( SM_CYSCREEN ) - 1;
   SB_COLS = GetSystemMetrics( SM_CXSCREEN );
#endif

   SB_COLS_M_1 = SB_COLS - 1;
   SB_ROWS_M_1 = SB_ROWS - 1;
   SB_ROWS_M_2 = SB_ROWS - 2;
   SB_ROW_STATUS = SB_ROWS -  15;

   screen_clear ();
   sb_init ();
   free (savep);

   wholewin = (REGIONP) sb_new (0, 0, SB_ROWS, SB_COLS);
   settingswin = (REGIONP) sb_new (1, 1, 7, 22);
   historywin = (REGIONP) sb_new (1, 23, 7, 23);
   holdwin = (REGIONP) sb_new (1, 46, 7, SB_COLS - 47);
   callwin = (REGIONP) sb_new  (8, 1, SB_ROWS -  13, SB_COLS - 2);
   filewin = (REGIONP) sb_new (SB_ROWS - 5, 1, 4, SB_COLS - 2);

#ifdef MILQ
   nodewin = (REGIONP) sb_new (1, 23, 7, 23);
   CurWinSet( callwin );
   MilqDlgCreate( callwin, "Call", CallDlgPrc, colors.call );
   MilqDlgCreate( filewin, "File", FileDlgPrc, colors.file );
   MilqDlgCreate( historywin, "History", HistoryDlgPrc, colors.history );
                                       /* These should be message sends to */
                                       /* the dialog box rather than functions */
   MilqDlgCreate( holdwin, "Hold", HoldDlgPrc, colors.hold );
   MilqDlgCreate( nodewin, "NodeDtl", NodeDtlDlgPrc, colors.settings );
   MilqDlgCreate( settingswin, "Settings", SettingsDlgPrc, colors.settings );
   NextWnd = history_hWnd;
#endif

   sb_fill (wholewin, ' ', colors.background);
   sb_fill (settingswin, ' ', colors.settings);
   sb_fill (historywin, ' ', colors.history);
   sb_fill (holdwin, ' ', colors.hold);
   sb_fill (callwin, ' ', colors.call);
   sb_fill (filewin, ' ', colors.file);

   sb_box (settingswin, boxtype, colors.settings);
   sb_box (historywin, boxtype, colors.history);
   sb_box (holdwin, boxtype, colors.hold);
   sb_box (callwin, boxtype, colors.call);
   sb_box (filewin, boxtype, colors.file);

   sb_caption (settingswin, MSG_TXT(M_CURRENT_SETTINGS));
   sb_caption (historywin, MSG_TXT(M_TODAY_GLANCE));
   sb_caption (holdwin, MSG_TXT(M_PENDING_OUTBOUND));
   sb_caption (callwin, MSG_TXT(M_RECENT_ACTIVITY));
   sb_caption (filewin, MSG_TXT(M_TRANSFER_STATUS));

#ifdef MILQ
/* These are to set up the references to the specific controls for each
 * data item displayed on the screen. Rather than computing and recomputing
 * these buggers, we compute 'em once. God help us when we begin closing
 * windows.
 */

  history_BBS     = GetDlgItem( history_hWnd,  GD_BBS );
  history_Cost    = GetDlgItem( history_hWnd,  GD_COST );
  history_Fl      = GetDlgItem( history_hWnd,  GD_FL );
  history_Last    = GetDlgItem( history_hWnd,  GD_LAST );
  history_Out     = GetDlgItem( history_hWnd,  GD_OUT );
  hold_Addr       = GetDlgItem( hold_hWnd,     GD_ADDR );
  hold_Hdr        = GetDlgItem( hold_hWnd,     GD_HDR );
  hold_Init       = GetDlgItem( hold_hWnd,     GD_INIT );
  hold_Poll       = GetDlgItem( hold_hWnd,     GD_POLL );
/*
 * Thinking about eliminating these. Actually, this whole approach sort
 * of sucks.
 */
  node_Addr       = GetDlgItem( node_hWnd,     GD_ADDR );
  node_Baud       = GetDlgItem( node_hWnd,     GD_BAUD );
  node_Elapsed    = GetDlgItem( node_hWnd,     GD_DUR );
  node_Flags16    = GetDlgItem( node_hWnd,     GD_FLG16 );
  node_Hub        = GetDlgItem( node_hWnd,     GD_HUB );
  node_Loc        = GetDlgItem( node_hWnd,     GD_LOC );
  node_Mdm        = GetDlgItem( node_hWnd,     GD_MDM );
  node_Nm         = GetDlgItem( node_hWnd,     GD_NM );
  node_Phn        = GetDlgItem( node_hWnd,     GD_PHN );
  node_Pwd        = GetDlgItem( node_hWnd,     GD_PWD );
  node_Rate       = GetDlgItem( node_hWnd,     GD_RATE );
  node_Sysop      = GetDlgItem( node_hWnd,     GD_SYSOP );
/*
 * These we do often enough and in time critical enough situations that we
 * will continue to do it this way.
 */
  settings_DtTm   = GetDlgItem( settings_hWnd, GD_DTTM );
  settings_Evt    = GetDlgItem( settings_hWnd, GD_EVT );
  settings_Free   = GetDlgItem( settings_hWnd, GD_LST );
  settings_MTask  = GetDlgItem( settings_hWnd, GD_MTASK );
  settings_Port   = GetDlgItem( settings_hWnd, GD_PORT );
  settings_Status = GetDlgItem( settings_hWnd, GD_STATUS );
#endif

   FlLnModeSet( FILE_LN_1, 0 );
   FlLnModeSet( FILE_LN_2, 0 );
   SendMessage( hold_hWnd, WM_COMMAND, GD_MODE, 0L );
   SendMessage( hold_hWnd, WM_COMMAND, GD_CLR, 0L );

   sb_move (hold_hWnd, 3, 7);
   sb_puts (hold_Init, MSG_TXT(M_INITIALIZING_SYSTEM));

#ifdef WHOLEWIN
   sb_move (wholewin, 0, 1);
   (void) sprintf (junk, MSG_TXT(M_NODE_COLON), Full_Addr_Str (&my_addr));
   sb_puts (wholewin, junk);
   sb_move (wholewin, 0, SB_COLS - 1 - (int) strlen (system_name));
   sb_puts (wholewin, system_name);
#endif

#ifdef MILQ
#ifndef WHOLEWIN
   (void) sprintf (Buf, MSG_TXT(M_NODE_COLON), Full_Addr_Str (&my_addr));
   SetWindowText (MilqueMailerWnd, Buf);
#endif
#endif

   bottom_line ();

#ifndef MILQ
   sb_move (settingswin, SET_EVNT_ROW, 2);
   sb_puts (settingswin, MSG_TXT(M_EVENT_COLON));
   sb_move (settingswin, SET_PORT_ROW, 2);
   sb_puts (settingswin, MSG_TXT(M_PORT_COLON));
   sb_move (settingswin, SET_STAT_ROW, 2);
   sb_puts (settingswin, MSG_TXT(M_STATUS_INIT));
#endif

   do_today ();

#ifndef MILQ
   settingswin->sr0 = settingswin->r0 + 1;
   settingswin->sr1 = settingswin->r1 - 1;
   settingswin->sc0 = settingswin->c0 + 1;
   settingswin->sc1 = settingswin->c1 - 1;

   historywin->sr0 = historywin->r0 + 1;
   historywin->sr1 = historywin->r1 - 1;
   historywin->sc0 = historywin->c0 + 1;
   historywin->sc1 = historywin->c1 - 1;

   holdwin->sr0 = holdwin->r0 + 1;
   holdwin->sr1 = holdwin->r1 - 1;
   holdwin->sc0 = holdwin->c0 + 1;
   holdwin->sc1 = holdwin->c1 - 1;

   callwin->sr0 = callwin->r0 + 1;
   callwin->sr1 = callwin->r1 - 1;
   callwin->sc0 = callwin->c0 + 1;
   callwin->sc1 = callwin->c1 - 1;

   filewin->sr0 = filewin->r0 + 1;
   filewin->sr1 = filewin->r1 - 1;
   filewin->sc0 = filewin->c0 + 1;
   filewin->sc1 = filewin->c1 - 1;
#endif

#ifdef MILQ
   MilqueScrLoad();

   if ( MilqueVidInfo.EGAState ) {
     switch ( VidQueryAdapterType() ) {
       case CGA:
       case MDA:
         break;
       default:
         if ( 25 == GetSystemMetrics( SM_CYSCREEN ) ) {
           ToggleEGA();
           }
         break;
       }
     }

   MilqueMailerActvWnd = GetFocus();
#endif
}

