/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*  (C) Copyright 1987-91, Bit Bucket Software Co., a Delaware Corporation. */
/*                                                                          */
/*                                                                          */
/*             Screen Buffer Initialization for BinkleyTerm                 */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.250.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:491/0                          */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*                                                                          */
/*   This module is derived from code developed by Augie Hansen in his      */
/*   book "Proficient C" published by Microsoft Press.  Mr. Hansen was      */
/*   kind enough to give us verbal permission to use his routines, and      */
/*   Bob, Vince and Alan (and all our full screen users) are grateful.      */
/*   If you decide to use this code in some package you are doing, give     */
/*   some thought to going out and buying the book. He deserves that.       */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* Include this file before any other includes or defines! */

#include "includes.h"

BUFFER Sbuf;                                     /* control information */
CELLP Scrnbuf;                                   /* screen buffer array */

#define WHITEBLANK (7 << 8) | ' '

void sb_init ()
{
   int i, j;
   CELLP c;
   char q[20];

#ifndef MILQ
   Scrnbuf = (CELLP) calloc ((unsigned) SB_ROWS * (unsigned) SB_COLS, sizeof (CELL));
#endif

   Sbuf.bp = (CELLP) Scrnbuf;

   Sbuf.row = Sbuf.col = 0;
   Sbuf.lcol = (int *) calloc ((unsigned) SB_COLS, sizeof (int ));
   Sbuf.rcol = (int *) calloc ((unsigned) SB_ROWS, sizeof (int ));
   (void) sprintf (q, "-%d.%ds", SB_COLS - 16, SB_COLS - 16);
   (void) strcpy (&stat_str[19], q);
   (void) sprintf (q, "-%d.%ds", SB_COLS - 22, SB_COLS - 22);
   (void) strcpy (&script_line[19], q);

#ifndef MILQ
   if ((Scrnbuf == NULL) ||
       (Sbuf.lcol == NULL) ||
       (Sbuf.rcol == NULL))
      {
      if (Scrnbuf != NULL) {
         free(Scrnbuf);
         Scrnbuf = NULL;
         }
      if (Sbuf.lcol != NULL) {
         free(Sbuf.lcol);
         Sbuf.lcol = NULL;
         }
      if (Sbuf.rcol != NULL) {
         free(Sbuf.rcol);
         Sbuf.rcol = NULL;
         }

      SB_ROWS = 23;
      SB_COLS = 80;

      Scrnbuf = (CELLP) calloc ((unsigned) SB_ROWS * (unsigned) SB_COLS, sizeof (CELL));
      Sbuf.bp = (CELLP) Scrnbuf;

      Sbuf.row = Sbuf.col = 0;
      Sbuf.lcol = (int *) calloc ((unsigned) SB_COLS, sizeof (int ));
      Sbuf.rcol = (int *) calloc ((unsigned) SB_ROWS, sizeof (int ));
      (void) sprintf (q, "-%d.%ds", SB_COLS - 16, SB_COLS - 16);
      (void) strcpy (&stat_str[19], q);
      (void) sprintf (q, "-%d.%ds", SB_COLS - 22, SB_COLS - 22);
      (void) strcpy (&script_line[19], q);
      }
#endif

   for (i = 0; i < (int)SB_ROWS; i++)
      {
      Sbuf.lcol[i] = SB_COLS;
      Sbuf.rcol[i] = 0;
      }

   Sbuf.flags = 0;

#ifndef MILQ
   c = Scrnbuf;
   for (i = 0; i < (int)SB_ROWS; i++)
      for (j = 0; j < (int)SB_COLS; j++)
         {
         (*c).cap = WHITEBLANK;
         ++c;
         }
#endif

   return;
}

