;
;This is an information file that the sio2k set of drivers use to
;identify PCI serial cards.  This file, and its structure may change, so do
;not depent on it staying the same.  You may add additional cards (lines)
;to the file if you feel capable.
;
;The first item in a line must be a quoted (" ") string.  You can use
;either single quote marks (' ') or double quote marks (" ").  The quoted
;string is a descripition of the board.  The description need NOT be exact
;as it is NOT used in the board identification process.  The quoted string
;is only used for log file entries etc.
;
;The second group of items are in the form HexNumber=NexNumber, called
;conditions.  The HexNumber on the left of the equal (=) sign is an index
;into the PCI boards configuration data, often called an offset.  The
;HexNumber to the right of the equal sign is the value that must exist in
;the PCI board's configuration data at the given offset.  There can be up
;to 5 condition pairs, and I believe at least two are needed to correctly
;identify a PCI card.
;
;Following the (up to 5) condition pairs, is the UART1=HexNumber item. 
;The UART1=HexNumber is ALWAYS REQUIRED.  This item specifies the offset in
;the PCI board's configuration data that contains the I/O address of the
;first uart on the board.  If your PCI card only has one uart, no futher
;data is needed on that line.  Note that for reason unknown to me, PCI
;card manufactures often add one the the uarts base address.  For example a
;base address of 8400 will show up as 8401. Sio2k (really uart.sys) takes
;care of this problem by always turning off the low three bits in the uart's
;base I/O address.  This is valid because the base address of a uart MUST
;always be a multiple of 8.
;
;For PCI boards that contain more than one uart, the next item is the
;UART2= item.  The UART2= item has two possible forms.  The first form
;is exactly the same as the UART1= item.  That is, the HexNumber to the
;right of the equal sign specifies the offset of the I/O address for the
;second uart.  The SECOND form of the UART2= item is UART2=+HexNumber. 
;In the second form the plus sign (+) preceeds the HexNumber.  The plus
;sign identifies the HexNumber as being an increment and NOT an offset. 
;When an increment is used, the I/O address of all the uarts on the board
;are relative to the I/O address given in the UART1= item.  For example, it
;one specifies UART2=+8, then 8 would be added to the I/O address of the
;first uart to obtain the I/O address of the second (and all other) uarts. 
;If a PCI card has more than two uarts, then UART2= MUST specify an
;incremental value.
;
;Finally, you can use single plus signs to specify the number of additional
;uarts the board has.  For example + + (two pluses separated by a space)
;means the board contains a third and fourth uart.  Four pluses separated
;by spaces (+ + + +) would mean the board has a total of 6 uarts on the
;board.  The double plus (++), being two plus signs without a space between
;them means that the drivers are to probe for the number of uarts.  The
;double plus is useful for boards that have identical PCI configuration
;information, but may have a different number of uarts.  YOU CANNOT USE
;BOTH SINGLE AND DOUBLE PLUSES IN THE SAME LINE.
;
;If you DO NOT have the information for your PCI card, or if you are unable
;to create the line like those below, then CONTACT THE BOARD MANUFACTURER
;FOR HELP. Send them a copy of this file, they WILL understand it.  I have
;included ALL the boards that I have information about in this file, so I
;cannot help you with different boards.

"CTI Blue Heat" 00=11b0 2c=12c4 uart1=14 uart2=+8 ++
"GTEK JetPort" 00=10b5 2e=a001 uart1=18 uart2=1c
"GTEK JetPort" 00=10b5 2e=c001 uart1=1c uart2=+8 ++
"VScom 200S" 00=10b5 02=1103 uart1=18 uart2=1c
"VScom 210S" 00=10b5 02=1078 uart1=18 uart2=1c
"VScom 400S" 00=10b5 02=1077 uart1=18 uart2=+8 + +
"VScom 800S" 00=10b5 02=1076 uart1=18 uart2=+8 ++
"VScom 100L" 00=14D2 02=8010 uart1=14
"VScom 110L" 00=14D2 02=8011 uart1=14
"VScom 200L" 00=14D2 02=8020 uart1=14 uart2=18
"VScom 210L" 00=14D2 02=8021 uart1=14 uart2=18
"VScom 100H" 00=14D2 02=a001 uart1=10
"VScom 200H" 00=14D2 02=a005 uart1=10 uart2=+8
"VScom 400H" 00=14D2 02=a003 uart1=10 uart2=+8 + +
"VScom 800HF1" 00=14D2 02=a004 uart1=10 uart2=+8 + +
"SIIG 2P1S PCI 550" 00=131f 02=2040 uart1=10
"SIIG 2P1S PCI 650" 00=131f 02=2041 uart1=10
"SIIG 2P1S PCI 850" 00=131f 02=2042 uart1=10
"SIIG Cyber Serial PCI 550" 00=131f 02=2000 uart1=10
"SIIG Cyber Serial PCI 650" 00=131f 02=2001 uart1=10
"SIIG Cyber Serial PCI 850" 00=131f 02=2002 uart1=10
"SIIG Cyber I/O PCI 550" 00=131f 02=2010 uart1=10
"SIIG Cyber I/O PCI 650" 00=131f 02=2011 uart1=10
"SIIG Cyber I/O PCI 850" 00=131f 02=2012 uart1=10
"SIIG Cyber Serial Dual PCI 550" 00=131f 02=2030 uart1=10 uart2=14
"SIIG Cyber Serial Dual PCI 650" 00=131f 02=2031 uart1=10 uart2=14
"SIIG Cyber Serial Dual PCI 850" 00=131f 02=2032 uart1=10 uart2=14
"SIIG Cyber 2S1P PCI 550" 00=131f 02=2060 uart1=10 uart2=14
"SIIG Cyber 2S1P PCI 650" 00=131f 02=2061 uart1=10 uart2=14
"SIIG Cyber 2S1P PCI 850" 00=131f 02=2062 uart1=10 uart2=14
"SIIG Cyber 4S PCI 550" 00=131f 02=2050 uart1=10 uart2=14 uart3=18 uart4=1c
"SIIG Cyber 4S PCI 650" 00=131f 02=2051 uart1=10 uart2=14 uart3=18 uart4=1c
"SIIG Cyber 4S PCI 850" 00=131f 02=2052 uart1=10 uart2=14 uart3=18 uart4=1c
