/*--------------------------------------------------------------------------*/
/*               The Opus Computer-Based Conversation System                */
/*       (c) Copyright 1986, Wynn Wagner III, All Rights Reserved           */
/*--------------------------------------------------------------------------*/


/*--------------------------------------------------------------------------*/
/* NOTE: The following is a sample only.  It is intended to point you in    */
/*       a general direction.  It is probably not usable code As Is.        */
/*--------------------------------------------------------------------------*/


#include <stdio.h>
#include "com.h"

#define begin    {
#define end      }



#define SENDBYTE(c)  {while(!(_Com_(0x0b,c)));}

extern int timer(int);    /* <- you have to write it (int==10ths of a sec.) */
extern int TIMED_READ(int); /* <- your routine,too. Return char;INT is sec. */

int max_baud = 2400;
int com_port = COM1;


/*--------------------------------------------------------------------------*/
/* OCOM_BAUD                                                                */
/*--------------------------------------------------------------------------*/
void ocom_baud(baud)
   int baud;
   begin
      register int i;

     	switch( baud )
         begin
            case  300   : i = BAUD_300;   break;
            case 1200   : i = BAUD_1200;  break;
            case 2400   : i = BAUD_2400;  break;
            case 4800   : i = BAUD_4800;  break;
            case 9600   : i = BAUD_9600;  break;
            case 19200  : i = BAUD_19200; break;
            default     : fprintf(stderr,"Bizarre baud rate");
                          exit(1);
         end /* switch */

      MDM_ENABLE(i);

   end /* ocom_baud */
   


/*--------------------------------------------------------------------------*/
/* OCOM_INSTALL                                                             */
/*--------------------------------------------------------------------------*/
void ocom_install()
   begin

      if (MDM_INSTALL(com_port)!=0x1954)
		   begin
      		fprintf(stderr,"\nOpus!comm isn't responding.\n");
      		exit(1);
         end

      ocom_baud(max_baud);

   end /* ocom_install */



/*--------------------------------------------------------------------------*/
/* SEND CMD (no echo to console)                                            */
/*--------------------------------------------------------------------------*/
void mdm_sendcmd( value )
   char *value;
   begin
      register int i;

      XON_DISABLE();

      for (i=0; value[i]; i++)
         if (value[i]=='|')     /* signal to send a carraige return */
            begin
               SENDBYTE('\r');
               timer(5);
            end
         else if (value[i]=='~') timer(18); /* pause for a half second */
         else
            begin
               SENDBYTE(value[i]);
               timer(1);
            end

      timer(1);
      XON_ENABLE();

   end /* send command to modem */


/*--------------------------------------------------------------------------*/
/* OCOM_INIT                                                                */
/*--------------------------------------------------------------------------*/
void ocom_init()
   begin
      register int tries;


      for(tries=0; tries<5; tries++)
         begin

            CLEAR_OUTBOUND();
            DTR_ON();
            timer(1);

            ocom_baud(max_baud);

            CLEAR_INBOUND();
            CLEAR_OUTBOUND();

            XON_ENABLE();

            mdm_sendcmd("|ATQ0E0H0M0V1S0=1X6|"); /* send USR2400 init */

            c = TIMED_READ(5);   /* give modem 5 seconds to respond */
            if (c==0x0d) return; /* if modem responds with <cr>, it's OK! */

            fprintf(stderr,"Trouble setting up modem");
            DTR_OFF();
            MDM_DISABLE();
            if (MDM_INSTALL(ctl.com_port)!=0x1954)
               begin
                  fprintf(stderr,"\nOpus!comm isn't responding.\n");
                  exit(2);
               end
         end

      exit(2);
   	
   end /* ocom_init */


void main()
   begin

   	ocom_install();
      ocom_init();

      /*
      .
      .
      .
      .
      .
      */

      MDM_DISABLE();
   end


/* END OF FILE: com_src.c */

