/*--------------------------------------------------------------------------*/
/*               The Opus Computer-Based Conversation System                */
/*                          Opus!Comm definitions                           */
/*--------------------------------------------------------------------------*/
#define COM1            0
#define COM2            1

#define COM1_BASE       0x3f8
#define COM2_BASE       0x2f8

#define COM1_IMR	      0x10
#define COM2_IMR	      0x08

#define PASS_THRU_PORT  0x238

#define BITS_7          0x02
#define BITS_8          0x03
#define STOP_1	         0x00
#define STOP_2	         0x04
#define NO_PARITY       0x00
#define ODD_PARITY      0x08
#define EVEN_PARITY     0x18

#define BAUD_110        0x000
#define BAUD_150        0x020
#define BAUD_300        0x040
#define BAUD_600        0x060
#define BAUD_1200       0x080
#define BAUD_2400       0x0A0
#define BAUD_4800       0x0C0
#define BAUD_9600       0x0E0
#define BAUD_19200      0x100
#define BAUD_38400      0x120

/* Bit definitions for the Line Status Register */

#define DATA_READY	 	0x0100
#define OVERRUN_ERR	 	0x0200
#define PARITY_ERR	 	0x0400
#define FRAMING_ERR	 	0x0800
#define BREAK_INT		 	0x1000
#define TX_HOLD_EMPTY 	0x2000
#define TX_SHIFT_EMPTY	0x4000

/* Bit definitions for the Modem Status Register */

#define DELTA_CTS			0x01
#define DELTA_DSR			0x02
#define TRAIL_EDGE_RI	0x04
#define DELTA_CD			0x08
#define CTS					0x10
#define DSR					0x20
#define RI					0x40
#define DCD					0x80

/* Bit definitions for the driver flags */

#define USE_XON			0x01
#define USE_CTS			0x02
#define USE_DSR			0x04

#define BRK                1
#define MDM                2


/*--------------------------------------------------------------------------*/
/* MACROS that call the routines in COM_ASM                                 */
/*--------------------------------------------------------------------------*/

#define MDM_ENABLE(b)      (_Com_(0x00,b|NO_PARITY|STOP_1|BITS_8))

#define MODEM_IN()         (_Com_(0x02)&0x00ff)

#define CARRIER            (_Com_(0x03)&DCD)
#define CHAR_AVAIL()       (_Com_(0x03)&DATA_READY)
#define OUT_EMPTY()        (_Com_(0x03)&TX_HOLD_EMPTY)

#define MDM_DISABLE()      (_Com_(0x05,BAUD_2400|NO_PARITY|STOP_1|BITS_8))

#define DTR_OFF()          (_Com_(0x06,0))
#define DTR_ON()           (_Com_(0x06,1))

#define CLEAR_OUTBOUND()   (_Com_(0x09))
#define CLEAR_INBOUND()    (_Com_(0x0a))

#define Com_Tx_NW(c)       (_Com_(0x0b,c))
#define PEEKBYTE()         (_Com_(0x0c))

#define PAUSE_REQUEST()    (_Com_(0x0f,USE_XON)&USE_XON)
#define XON_ENABLE()       (_Com_(0x0f,USE_XON))
#define XON_DISABLE()      (_Com_(0x0f,0))

#define RECVD_BREAK()      (_Com_(0x10,BRK)&BRK)
#define BRK_ENABLE()       (_Com_(0x10,BRK))
#define BRK_DISABLE()      (_Com_(0x10,0))

#define MDM_INSTALL(p)     (_Cominit(p))

#define OUT_FULL()         (0)      /* stay tuned */

#define KEYPRESS()         (_kpress())
#define READKB()           _readkb()
#define READSCAN()         _rdscan()

/*--------------------------------------------------------------------------*/
/*                                                                          */
/* A no-stall ReadByte routine might look like this:                        */
/*                                                                          */
/*    int READBYTE()                                                        */
/*       begin                                                              */
/*          return( CHAR_AVAIL() ? MODEM_IN() : (-1) );                     */
/*       end                                                                */
/*                                                                          */
/*--------------------------------------------------------------------------*/


/* END OF FILE: com.h */

