/**************************************************************************
  Lottery will be an In Game Module for War Zone.  A player will have
  an opportunity to choose 5 numbers, and matches will return 5 gems.
  The player will be able to play upto 5 times, but he'll have to pay
  20 gold pieces per play.  War Zone is a produce of Bob Wilkinson
  and DesertWare Software & Consulting.  Lottery IGM for War Zone is
  a product of Bob Wilkinson and DesertWare Software & Consulting.
  All Rights Reserved.
*************************************************************************/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <ctype.h>
#include <dos.h>
#include <doorutil.h>
#include <structs.h>
#include "lottery.h"

#ifndef _TCB_H
#include <tcb.h>
#endif

/**********************************************************************
  The following structure is the player record used in War Zone.
  All In Game Modules written for War Zone, if they are going to
  allow players to gain/lose any of their game items must include
  this structure, or nothing will work right.
**********************************************************************/

struct player {
		  char handle[32];
		  char name[32];
		  int armor;
		  int weapon;
		  int level;
		  int hp;
		  int mhp;
		  long exp;
		  int gem;
		  int alive;
		  int numfights;
		  int playfights;
		  int robbank;
		  long gold_in_hand;
		  unsigned long gold_in_bank;
		  int hasroom;
		  int minstral;
		  int bplay;
        int beenDancing;
		  int month;
		  int day;
		  int year;
} play;

struct player *gmptr = &play;

/***********************************************************************
  This structure is the players record in the lottery module.  It
  will record the player's name as used in War Zone, and keep track
  of the number of spins he has played today.
***********************************************************************/

struct lottery_player {
		  char name[32];
		  int spins;
} lot_play;


extern struct acct_rec far *myacct;
extern struct user_rec far *myuser;

FILE *fp;
char ch[256];

/**********************************************************************
  When the In Game Module is launched from within War Zone the
  following command line parameters are passed to the module:
  argv[1] is the path to the In Game Module's directory.
  argv[2] is the path & file name to War Zone's player.dat file.
  argv[3] is the players door_id in War Zone.  argv[4] is the
  player's name used in War Zone.  It is important to remember that
  the name the player is using in War Zone may not be the same
  handle he uses on the BBS.
***********************************************************************/

main(int argc, char *argv[]) {

		  init();  // all Falken doors have to start with a call to init()

		  if(check_it(argv[1], argv[4]) == 0) {
					 close_it(argv[3]);
		  } else {
					 if(load_rec(argv[2], argv[4])) {
								play_game();
								finish(argv[1], argv[2], argv[4]);
								close_it(argv[3]);
					 } else {
								close_it(argv[3]);
					 }
		  }

		  return;
}

/**********************************************************************
	The following function will determine the number of records in a
	file.  The name of the file (including the path) is passed in the
	char *fname parameter, the size of the structure is passed in the
	int sz parameter.
**********************************************************************/

int num_records(char *fname, int sz) {
		  int x;
		  long n;

		  fp = fopen(fname, "rb");
		  if(!fp) {
					 x = 0;
		  } else {
					 fseek(fp, 0, 2);
					 n = ftell(fp);
					 fclose(fp);
					 x = n / sz;
		  }

		  return x;
}

/******************************************************************
	This funciton will check to see if this is a new day in here.
	If so, all the records in Lottery's player.dat file will be set
	to zero spins.  If it's not a new day, this player's record
	will be checked to see if he has any spins left.  If not he'll
	be escorted back to main menu, and back to War Zone!
******************************************************************/

int check_it(char *fname, char *pname) {
		  char qp[60], qo[60];
		  struct dosdate_t dt;
		  int j, s, x, day, k;

		  strcpy(qp, fname);
		  strcat(qp, "date.stp");
		  strcpy(qo, fname);
		  strcat(qo, "player.dat");
		  _dos_getdate(&dt);
		  fp = fopen(qp, "rb");
		  x = 1;
		  k = 0;
		  if(!fp) {
					 fp = fopen(qp, "wb");
					 fprintf(fp, "%d", dt.day);
					 fclose(fp);
		  } else {
					 fscanf(fp, "%d", &day);
					 fclose(fp);
					 s = num_records(qo, sizeof(lot_play));
					 if(day == dt.day) {
								
								for(j = 0; j < s; j++) {
										  fp = fopen(qo, "rb");
										  fseek(fp, j * sizeof(lot_play), 0);
										  fread(&lot_play, sizeof(lot_play), 1, fp);
										  fclose(fp);
										  if(stricmp(pname, lot_play.name) == 0) {
													 if(lot_play.spins >= 5) {
																if((myuser->u_ansi) > 0) {
																		  qprintf("\r\r\033[0;1;34mYou have played the lottery enough today!\033[0m\r\r");
																} else {
																		  qprintf("\r\rYou have played the lottery enough today!\r\r");
																}
																x = 0;
													 }
													 k = 1;
													 j = s;
													 return x;
										  }
								}
					 } else {
								fp = fopen(qp, "wb");
								fprintf(fp, "%d", dt.day);
								fclose(fp);
								for(j = 0; j < s; j++) {
										  fp = fopen(qo, "r+b");
										  fseek(fp, j * sizeof(lot_play), 0);
										  fread(&lot_play, sizeof(lot_play), 1, fp);
										  fclose(fp),
										  lot_play.spins = 0;
										  fp = fopen(qo, "r+b");
										  fseek(fp, j * sizeof(lot_play), 0);
										  fwrite(&lot_play, sizeof(lot_play), 1, fp);
										  fclose(fp);
								}
								for(j = 0; j < s; j++) {
									fp = fopen(qo, "rb");
									fseek(fp, j * sizeof(lot_play), 0);
									fread(&lot_play, sizeof(lot_play), 1, fp);
									fclose(fp);
									if(stricmp(lot_play.name, pname) == 0) {
										k = 1;
										j = s;
										return x;
									}
								}
					 }
		  }
		  // if we get to here, we've got a new player here!
			strcpy(lot_play.name, pname);
			lot_play.spins = 0;
			fp = fopen(qo, "ab");
			fwrite(&lot_play, sizeof(lot_play), 1, fp);
			fclose(fp);


		  return x;
}

/*********************************************************************
	We want to make sure we got the right player record loaded into
	memory from the War Zone player.dat file.  This function will
	verify, and load the right record.  And if for some reason this
	guy got here without creating a record (should be no way for that
	to happen ... but!) Lottery will exit.
*********************************************************************/

int load_rec(char *recfile, char *pname) {
		  int j, s, x;
		  char qp[50];

		  x = 0;
		  s = num_records(recfile, sizeof(play));
		  if(!s) {
					 if((myuser->u_ansi) > 0) {
								qprintf("\r\033[0;1;31mError opening \033[33mWar Zone Player Record \033[31mfile");
					 } else {
								qprintf("\rError opening War Zone Player Record file!");
					 }
		  /*******************************************************************
				In Falken's door programmer packages the call to delay is
				delay(int numticks).  However, it uses Falken's control of the
				system timer, where each tick is equal to a number of seconds.
				Borland also uses a delay ... delay(int x) ... where x is the
				number of milliseconds to pause program functioning.  To avoid
				the conflict I changed the function call in Falken door porgram-
				mer package to Delay(int numticks).
		  *******************************************************************/
					 Delay(2);
		  } else {
					 hog();
					 for(j = 0; j < s; j++) {
								fp = fopen(recfile, "rb");
								fseek(fp, j * sizeof(play), 0);
								fread(&play, sizeof(play), 1, fp);
								fclose(fp);
								if(stricmp(gmptr->name, pname) == 0) {
		  /******************************************************************
				We've got the right player record loaded into memory.  So set
				x to non-zero, and j = s.  That let's us get out of the loop
				and get back to playing the game!
		  ******************************************************************/
										  x = 1;
										  j = s;
								}
					 }
					 nohog();
		  }

		  return x;
}

/***********************************************************************
	This next function is the main game function.  It should be fairly
	self-explanitory ... emphasis on the should <g>.  Basically this
	function works as a switch function.  The user will select one of
	four options.  Three are actually playing the game, which he can do
	as long as he has not reached the maximum spins allowed.
***********************************************************************/

void play_game() {
	int done;
	long wager;

	done = 0;
	/*****************************************************************
		Start a loop that will run until one of two things happens.
		Either the player enters 'Q' to exit the game, or he uses
		up his five turns.
	*****************************************************************/
	while(!done) {
		if(lot_play.spins >= 5){
			if(myuser->u_ansi) {
				qprintf("\r\r\033[0;1;34mYou've had your limit of spins \033[35m%s\033[0m\r", gmptr->name);
			} else {
				qprintf("\r\rYou've had you limit of spins %s", gmptr->name);
			}
			Delay(2);
			 return;
		}
		if(myuser->u_ansi) {
			qprintf("\r\r\033[15C\033[1;34mPlay  \033[33m[\033[31mS\033[33m] \033[34mSmall Stakes\r\033[21C\033[33m[\033[31mM\033[33m] \033[34mMedium Stakes\r\033[21C\033[33m[\033[31mL\033[33m] \033[34mLarge Stakes\r\033[21C\033[33m[\033[31mQ\033[33m] \033[34mQuit\r\r\033[15C\033[37m> \033[0m");
		}
		if(!myuser->u_ansi) {
			qprintf("\r\r               Play  [S] Small Stakes\r                     [M] Medium Stakes\r                     [L] Large Stakes\r                     [Q] Quit\r\r               > ");
		}
		qgets(ch, 2);
		if(tolower(ch[0]) == 's' || toupper(ch[0]) == 'S') {
			if(myuser->u_ansi) {
				qprintf("\r\r\033[1;36mSome guy wearing a food stained tee-shirt, smelling like he hasn't\rshowered in a few weeks or so comes over and introduces himself as\r\033[35mClyde\033[36m.  Clyde lets loose with some brown colored stuff\rthrough his lips towards what once upon a time was probably a\rspitoon, but you wouldn't want to wager on that!");
				qprintf("\r\r\033[35mClyde \033[32msays, \033[33m\"\033[32mOk, kid here's the deal.  You pick any\r\033[31m7 \033[32mnumbers from \033[31m1 \033[32mto \033[31m100\033[32m.  If any of your numbers match any of\rmy numbers, I'll pay you your wager for each match.\033[33m\"");
				qprintf("\r\r\033[37mHoping like hell that, no matter what else happens in this pit of slime,\ryou don't end up wearing some of that brown drool on \033[35mClyde's\r\033[37mwhiskered chin, you reach into your money pouch and hand him\rhow much of your hard earned money? > \033[0m");
			} else {
				qprintf("\r\rSome guy wearing a food stained tee-shirt, smelling like he hasn't\rshowered in a few weeks or so comes over and introduces himself as\rClyde.  Clyde lets loose with some brown colored stuff\rthrough his lips towards what once upon a time was probably a\rspitoon, but you wouldn't want to wager on that!");
				qprintf("\r\rClyde says, \"Ok, kid here's the deal.  You pick any\r7 numbers from 1 to 100.  If any of your numbers match any of\rmy numbers, I'll pay you your wager for each match.\"");
				qprintf("\r\rHoping like hell that, no matter what else happens in this pit of slime,\ryou don't end up wearing some of that brown drool on Clyde's\rwhiskered chin, you reach into your money pouch and hand him\rhow much of your hard earned money? > ");
			}
			qgets(ch, 14);
			if(!strlen(ch)) {
				if(myuser->u_ansi) {
					qprintf("\r\r\033[33mhrummmph! \033[35mClyde \033[32mmutters c'mon back kid when ya gots some guts\033[33m!\033[0m");
				} else {
					qprintf("\r\rhrummmph! Clyde mutters c'mon back kid when ya gots some guts!");
				}
			} else {
				wager = atol(ch);
				if(wager > gmptr->gold_in_hand) {
					if(myuser->u_ansi) {
						qprintf("\r\r\033[0;1;35mClyde \033[36mhollers \033[33m\"\033[34mKid you're really beginning to make\rme mad.  When you get ready to make a legitimate wager c'mon back.\033[33m\"\r\033[36mOf course you barely hear him, trying to avoid the brown juice!");
					} else {
						qprintf("\r\rClyde hollers \"Kid you're really beginning to make\rme mad.  When you get ready to make a legitimate wager c'mon back.\"\rOf course you barely hear him, trying to avoid the brown juice!");
					}
					Delay(2);
				} else {
					go_game(7, 1, wager);
					ch[0] = '\0';
				}
			}
		}
		if(tolower(ch[0]) == 'm' || toupper(ch[0]) == 'M') {
			ch[0] = '\0';
			if(myuser->u_ansi) {
				qprintf("\r\r\033[0;1;36mWalking in from the bright sunshine, it takes several minutes for your eyes\rto adjust to the smokey darkness.  Suddenly appearing before you as if an\rapparition is a young lady wearing a long black dress studded with pearls.");
				qprintf("\r\r\033[32mShe introduces herself as \033[35mVenus\033[32m.  Moving gracefully around a\rvelvet covered table \033[35mVenus \033[32msays \033[33m\"\033[37mAt this table\ryou select 4 numbers from \033[31m1 \033[37mto \033[31m100\033[37m.  For each match\rI'll pay you twice your wager.");
				qprintf("\r\rHow much are you willing to give me ... er wager\033[33m\" > \033[0m");
			} else {
				qprintf("\r\rWalking in from the bright sunshine, it takes several minutes for your eyes\rto adjust to the smokey darkness.  Suddenly appearing before you as if an\rapparition is a young lady wearing a long black dress studded with pearls.");
				qprintf("\r\rShe introduces herself as Venus.  Moving gracefully around a\rvelvet covered table Venus says \"At this table\ryou select 4 numbers from 1 to 100.  For each match\rI'll pay you twice your wager.");
				qprintf("\r\rHow much are you willing to give me ... er wager\" > ");
			}
			qgets(ch, 10);
			if(!strlen(ch)) {
				if(myuser->u_ansi) {
					qprintf("\r\r\033[0;1;35mVenus \033[34mlooks as if an ice cube had been put down the front of her\rdress.  She lets out a screach, and says \033[33m\"\033[36mI thought you were\ra sporting person.  I guess I was wrong.  Come back when you get some\rcourage!\033[33m\"\033[0m\r");
				} else {
					qprintf("\r\rVenus looks as if an ice cube had been put down the front of her\rdress.  She lets out a screach, and says \"I thought you were\ra sporting person.  I guess I was wrong.  Come back when you get some\rcourage!\"\r");
				}
				Delay(2);
			} else {
				wager = atol(ch);
				if(wager > gmptr->gold_in_hand) {
					if(myuser->u_ansi) {
						qprintf("\r\r\033[0;1;35mVenus \033[36mwalks away from the table, and says \033[33m\"\033[32mWhen you get\rready to make a real wager come on back\033[33m\"\r\033[0m");
					} else {
						qprintf("\r\rVenus walks away from the table and says \"When you get\rready to make a real wager come on back.\r");
					}
					Delay(2);
				} else {
					go_game(5, 2, wager);
					ch[0] = '\0';
				}
			}
		}
		if(tolower(ch[0]) == 'l' || toupper(ch[0]) == 'L') {
			ch[0] = '\0';
			if(myuser->u_ansi) {
				qprintf("\r\r\033[0;1;36mPushing your way through the crowd you come face to face with a handsome\rfellow wearing a freshly pressed evening tuxedo.  He smiles broadly and\rintroduces himself as \033[35mValient\033[36m.");
				qprintf("\r\r\033[32mHe says \033[33m\"\033[37mYou must have a lot of courage to enter this room!  You'll\rget a chance to match \033[31m2 \033[37mnumbers between \033[31m1 \033[37mand \033[31m100\033[37m.");
				qprintf("\rFor each number you get right you'll receive \033[31m5 \033[37mtimes your wager.\033[33m\"\r\r\033[33mYour wager > \033[0m");
			} else {
				qprintf("\r\rPushing your way through the crowd you come face to face with a handsome\rfellow wearing a freshly pressed evening tuxedo.  He smiles broadly and\rintroduces himself as Valient.");
				qprintf("\r\rHe says \"You must have a lot of courage to enter this room!  You'll\rget a chance to match 2 numbers between 1 and 100.");
				qprintf("\rFor each number you get right you'll receive 5 times your wager.\"\r\rYour wager > ");
			}
			qgets(ch, 10);
			if(!strlen(ch)) {
				if(myuser->u_ansi) {
					qprintf("\r\r\033[0;1;34mLooking as if he can't believe his ears, \033[35mValient \033[34mgrowls\r\033[33m\"\033[37mCome back when you're ready to quit wasting my time.\033[33m\"\r\033[0m");
				} else {
					qprintf("\r\rLooking as if he can't believe his ears, Valient growls\r\"Come back when you're ready to quit wasting my time.\"\r");
				}
				Delay(2);
			} else {
				wager = atol(ch);
				if(wager > gmptr->gold_in_hand) {
					if(myuser->u_ansi) {
						qprintf("\r\r\033[0;1;35mValient \033[32msnaps, \033[33m\"\033[36mDo I look like a fool?  You haven't got that much money!\rCome back when you're ready to be real.\033[33m\"\r\033[0m");
					} else {
						qprintf("\r\rValient snaps, \"Do I look like a fool?  You haven't got that much money!\rCome Back when you're ready to be real.\"\r");
					}
					Delay(2);
				} else {
					go_game(2, 5, wager);
					ch[0] = '\0';
				}
			}
		}
		if(tolower(ch[0]) == 'q' || toupper(ch[0]) == 'Q') {
			done = 1;
		}
	}

	return;
}

/*********************************************************************
	The workhorse of the game module.  It gets the guesses from the
	player, and loads them into an integer array.  It uses random
	selection to load another integer array.  For each match the player
	is paid according to his selection made in the above function.
*********************************************************************/

void go_game(int x, int y, long wg) {
	struct dostime_t dt;
	int j, i, match;
	int r[7], hr[7];


	for(j = 0; j < x; j++) {
		ch[0] = '\0';
		if(myuser->u_ansi) {
			qprintf("\r\r\033[0;1;33mEnter number \033[31m%d  \033[0m", j + 1);
		} else {
			qprintf("\r\rEnter number %d  ", j + 1);
		}
		qgets(ch, 4);
		hr[j] = atoi(ch);
	}
	if(myuser->u_ansi) {
		qprintf("\r\r\033[0;1;35mPlease wait while I check for a match!");
	} else {
		qprintf("\r\rPlease wait while I check for a match!");
	}
	for(j = 0; j < x; j++) {
		_dos_gettime(&dt);
		srand(dt.hsecond);
		r[j] = rand() % 100;
		Delay(1);
	}
	match = 0;
	for(j = 0; j < x; j++) {
		for(i = 0; i < x; i++) {
			if(r[i] == hr[j]) {
				match++;
			}
		}
	}
	if(!match) {
		if(myuser->u_ansi) {
			qprintf("\r\r\033[0;1;36mNo matches. You lose your \033[31m%ld \033[36mwager\033[0m", wg);
		} else {
			qprintf("\r\rNo matches.  You lose your %ld wager.", wg);
		}
		gmptr->gold_in_hand -= wg;
		Delay(2);
	} else {
		if(myuser->u_ansi) {
			qprintf("\r\r\033[0;1;33mYou've struck paydirt! \033[31m%d \033[32mmatches for \033[31m%ld \033[32mwinnings!", match, match * y * wg);
		} else {
			qprintf("\r\rYou've struck paydirt! %d matches for %ld winnings!", match, match * y * wg);
		}
		gmptr->gold_in_hand += match * y * wg;
		Delay(2);
	}

	lot_play.spins++;
	return;
}

/***********************************************************************
	This function is winding down the player's turn in the module.
	It writes the player's record back to War Zone player.dat file.
	And writes the palyer's record in the lottery player.dat file.
***********************************************************************/

void finish(char *path, char *fname, char *pname) {
	struct player py;
	struct lottery_player lp;
	char qi[50];
	int j, s;

	s = num_records(fname, sizeof(play));
	hog();
	for(j = 0; j < s; j++) {
		fp = fopen(fname, "rb");
		fseek(fp, j * sizeof(py), 0);
		fread(&py, sizeof(py), 1, fp);
		fclose(fp);
		if(stricmp(lot_play.name, py.name) == 0) {
			fp = fopen(fname, "r+b");
			fseek(fp, j * sizeof(play), 0);
			fwrite(&play, sizeof(play), 1, fp);
			fclose(fp);
			j = s;
		}
	}
	nohog();

	strcpy(qi, path);
	strcat(qi, "player.dat");
	s = num_records(qi, sizeof(lp));
	for(j = 0; j < s; j++) {
		fp = fopen(qi, "rb");
		fseek(fp, j * sizeof(lp), 0);
		fread(&lp, sizeof(lp), 1, fp);
		fclose(fp);
		if(stricmp(lp.name, lot_play.name) == 0) {
			fp = fopen(qi, "r+b");
			fseek(fp, j * sizeof(lp), 0);
			fwrite(&lot_play, sizeof(lot_play), 1, fp);
			fclose(fp);
			j = s;
		}
	}

	return;
}

/*********************************************************************
	This function copies the players door_id from War Zone, and wakes
	him up in the War Zone main module.
*********************************************************************/

void close_it(char *id) {
	strcpy(myuser->doors_id, id);
	wakeup(user[who].u_doortcb);
}
