{----------------------------------------------------------------------------

 READWRLD.PAS

 Demonstrates how to read Sage's world files (SWORLD.DAT and SMAP.DAT), then
 display the template screen and map screens which were read from those files.

 Contains 4 procedures: ReadWorld, ReadMap, DisplayTemplate and DisplayMap.

----------------------------------------------------------------------------}

{$I-}

Program ReadWrld;

Uses Crt, { For GOTOXY and TEXTATTR }
     Dos; { For FSEARCH }

{$I SWORLD.REC}
{$I SMAP.REC}
{$I HOTSPOTS.LL}
{$I MINDEX.LL}

Var Templateinf : Templaterec;  { Template and World info }
    Mapinf      : Maprec;       { World map info }

    WorldPath   : String;       { Path to the world (with trailing "\") }

{--------------------------------------------------------[ Read World ]-----
 Reads the world and template info, and the map indexes. The map indexes are
 a linked list containing the file position in SMAP.DAT, and visibility of
 every map screen in the world.
 ---------------------------------------------------------------------------}

Function ReadWorld : Boolean;      { true if the world read okay }

Var wf              : File;        { SWORLD.DAT }
    tempMapIndexrec : MapIndexRec; { Map Index record }
    bytesread       : Word;        { Used to detect file errors }

Begin

 ReadWorld := False;

 { Open SWORLD.DAT }

 Assign(wf, WorldPath + 'SWORLD.DAT');
 Reset(wf, 1);

 { Read in the World and Template info }

 BlockRead(wf, TemplateInf, sizeof(Templateinf), bytesread);

 { Exit if there was an error }

 If ioresult > 0 then Begin
                        Close(wf);
                        If IOResult > 0 then ;
                        Exit;
                      End;

 { Now read in the map indexes. These are a linked list containing the file
   position in SMAP.DAT, and visibility of every map screen in the world. }

 Empty_Maps_List;  { Clear out any map indexes currently in memory }

 { Read every map index and add it to the linked list }
 While not Eof(wf) do
 Begin
   BlockRead(wf, tempMapIndexrec, sizeof(tempMapIndexrec), bytesread);
   If bytesread = sizeof(tempMapIndexrec) then Add_MapIndex_Rec(tempMapIndexrec);
 End;

 Close(wf); { Close SWORLD.DAT }

 ReadWorld := True; { SWORLD.DAT read okay! }

End;

{----------------------------------------------------------[ Read Map ]-----
 Read one map screen and it's hotspots.
 ---------------------------------------------------------------------------}

Function ReadMap(mapnum : word)  { The number of the map screen }
                     : Boolean;  { True if map screen read okay }

Var mapf         : file;         { SMAP.DAT }
    temprec      : mapindexrec;  { Used to get the map index in memory }

    w,                           { Counter }
    bytesread    : word;         { Used to detect file errors }

    temp_HS_rec  : Hotspot;      { Used in the hotspots linked list }

Begin

 ReadMap := False;

 { Exit if the map screen doesn't exist }
 If (not Get_Map_Record(mapnum, temprec)) then Exit;

 { Open SMAP.DAT }

 Assign(mapf, WorldPath + 'SMAP.DAT');
 Reset(mapf, 1);

 { Seek to the file position of the map screen in SMAP.DAT
   (retrieved from the map index linked list by Get_Map_record) }
 Seek(mapf, temprec.filepos);

 { Read the map screen }
 BlockRead(mapf, Mapinf, sizeof(Mapinf));

 { Now read the hotspots. You know how many hotspots to read from
   MAPINF.MAPHOTSPOTS read by the last command }

 Empty_HS_List; { Clear out any hotspots currently in memory }

 { Read each hotpot and add it to the linked list }
 For w := 1 to MapInf.MapHotSpots do
 Begin
   BlockRead (mapf, temp_HS_rec, sizeof(temp_hs_rec), bytesread);
   If (bytesread = sizeof(temp_hs_rec)) then Add_HS_rec(temp_hs_rec);
 End;

 Close(mapf); { Close SMAP.DAT }

 ReadMap := True;  { Map screen read okay! }

End;

{----------------------------------------------------[ Display Template ]---
 Displays the template screen, if needed.
 ---------------------------------------------------------------------------}

Procedure DisplayTemplate;

Var x, y : Byte;  { Counters }

Begin

 { Worldmgr decides whether or not the template needs to be displayed and
   stores it in TEMPLATEINF for later referral when displaying the template.
   (if it's all black or the map window takes up the whole screen, there's
   no point displaying it) }
 If not templateinf.AlwaysDisplayTemplate then Exit;

 { Display it }

 Gotoxy(1, 1);
 For y := 1 to 20 do
 For x := 1 to 80 do
 Begin
   Textattr := TemplateInf.TemplatePosInf[x, y].Attribute;
   Write(TemplateInf.TemplatePosInf[x, y].Character);
 End;

End;

{-------------------------------------------------------[ Display Map ]-----
 Displays the map screen.
 ---------------------------------------------------------------------------}

Procedure DisplayMap;

Var x, y : Byte;  { Counters }

Begin

 For y := templateInf.MapWindow_y1 to templateInf.MapWindow_y2 do
 Begin

   Gotoxy(templateInf.MapWindow_x1, y);

   For x := templateInf.MapWindow_x1 to templateInf.MapWindow_x2 do
   Begin
     textattr := MapInf.MapPosInf[x, y].Attribute;
     Write(MapInf.MapPosInf[x, y].Character);
   End;

 End;

End;


{---------------------------------------------------------------------------}
Begin

 WorldPath := ParamStr(1);

 If fSearch(WorldPath + 'SWORLD.DAT', '') = '' then Begin Writeln('Could not find ', WorldPath + 'SWORLD.DAT'); Halt(1); End;
 If fSearch(WorldPath + 'SMAP.DAT'  , '') = '' then Begin Writeln('Could not find ', WorldPath + 'SMAP.DAT'  ); Halt(2); End;

 If not ReadWorld then
 Begin
   Writeln('Could not load world');
   Halt(3);
 End;

 If not ReadMap(7080) then
 Begin
   Writeln('Could not read Map 7080.');
   Halt(4);
 End;

 { Clear out the Map Index and Hotspot linked lists from memory }
 Empty_Maps_List;
 Empty_HS_List;

 DisplayTemplate;
 DisplayMap;

End.
