{

 READPLAY.PAS

   Reads the entire PLAYER.DAT file and displays the Alias and Real name of
   all players.

}

Uses Crt,    { For TEXTATTR }
     Dos;    { For FSEARCH }

{$I PLAYER.REC}

Var WorldPath : String;   { Path to world (with trailing backslash "\") }
    Result,               { What Readplayers returns after reading the file }
    TotalPlayers : Byte;  { Total players in PLAYER.DAT }

{-------------------------------------------------------[ Read Player ]-----
 Reads every player in the PLAYER.DAT file and displays their name.
----------------------------------------------------------------------------}
Function ReadPlayers : Byte;

Var PlayerFile : File of PLAYER_Record;   { PLAYER.DAT }
    PlayerData : PLAYER_Record;           { Player record variable }

    CurrentRecord : Byte;                 { Counter }

Begin

 ReadPlayers := 1; { No PLAYER.DAT exists or no players in file }

 If fSearch(WorldPath + 'PLAYER.DAT', '') = '' then Exit;

 { Open PLAYER.DAT }
 Assign(PlayerFile, WorldPath + 'PLAYER.DAT');
 Reset(PlayerFile);

 { Error reading PLAYER.DAT }
 If (filesize(PlayerFile) = 0)
 or (IOResult > 0) then
 Begin
   ReadPlayers := 2; { Error reading PLAYER.DAT }
   Close(PlayerFile);
   if ioresult > 0 then;
   Exit;
 End;

 TotalPlayers := filesize(Playerfile);
 CurrentRecord := 0;

 Writeln('Reading ', WorldPath, 'PLAYER.DAT ..');

 { Read the entire file }
 While not Eof(PlayerFile) do
 Begin

   Inc(CurrentRecord);

   Read  ( PlayerFile, PlayerData );  { Read one record }

   If PlayerData.Deleted then textattr := 7   { Grey if deleted }
                         else textattr := 15; { White if not deleted }

   Writeln(Currentrecord, '. ',
           PlayerData.Alias, ' (',
           PlayerData.Name, ')'); { Write their details to screen }

 End;

 Close(PlayerFile); { Close PLAYER.DAT }

 If ioresult = 0 then ReadPlayers := 0   { Everything read okay! }
                 else ReadPlayers := 2;  { Error reading file }

End;

{---------------------------------------------------------------------------}
Begin

 { Get the world path from the command line }
 WorldPath := ParamStr(1);

 { Attempt to read the file }
 Result := Readplayers;

 { Display the results of READPLAYERS }
 Case Result of

  0: Writeln('Total Players: ', totalplayers);
  1: Writeln('File not found: ', WorldPath, 'PLAYER.DAT or no players in file');
  2: Writeln('Error reading ', WorldPath, 'PLAYER.DAT');

 End;

 { Terminate the program }
 Halt(Result);

End.
