{

 MINDEX.LL

   A "map index" is a record containing the map number, file position in
   SMAP.DAT and visibility of a map screen. There is one map index in
   SWORLD.DAT for every map screen in a world.

   Linked list containing map indexes for every map screen in the currently
   loaded world. Included into programs which need to read all map indexes
   into a linked list.

}

Type

  { The linked list }

  Map_ListPtr = ^Map_List;
  Map_List    = Record
                  Index  : MapIndexRec;
                  next   : Map_listPtr;
                End;

Var Map_Head,               { The first map index in the linked list }
    Map_Last : Map_listPtr; { The last  map index in the linked list }
    Total_Map_recs : Word;  { A counter of map indexes loaded }

{---------------------------------------------------------[ Empty List ]-----
 Clears out every map index from memory.
----------------------------------------------------------------------------}
Procedure Empty_Maps_List;
var hold, p  : Map_ListPtr;

begin

   p := Map_Head;
   while p <> nil do
   Begin
     Hold := p;
     p := p^.next;
     Dispose(Hold);
     dec(total_Map_recs);
   End;
   Map_Head := nil;
   Map_Last := nil;

End;

{--------------------------------------------------------[ Get Record ]-----
 Searches the list for a particular map index.
 Returns TRUE if the map index was found, false if not.
 If the map index is found, it's loaded into REC.
----------------------------------------------------------------------------}
Function Get_Map_Record(Num : Word; Var Rec : MapIndexRec) : Boolean;
Var p : Map_listPtr;
Begin

 Get_Map_Record := False;

 p := Map_Head;

 while p <> nil do
 Begin
   If (p^.Index.MapNumber = Num) then
   Begin
     rec := p^.index;
     Get_Map_Record := True;
     Exit;
   End;
   p := p^.next;
 End;

End;

{-----------------------------------------------------[ Change Record ]-----
 Changes a particular map index that's already in the list
----------------------------------------------------------------------------}
Procedure ChangeMapRec(num : Word; rec : mapindexrec);
Var p : Map_ListPtr;
Begin

 p := map_Head;
 while p <> nil do
 Begin

   If  (p^.index.Mapnumber = num) then
   Begin
     p^.index := rec;
     Exit;
   End;

   p := p^.next;

 End;

End;


{-----------------------------------------------------------[ Add Map ]-----
 Adds a map index to the list
----------------------------------------------------------------------------}
Procedure Add_MapIndex_Rec(index: mapindexrec);
Var curr : Map_ListPtr;

begin

  If (maxavail < SizeOf(Map_List)) then Exit;

  new(curr);

  If Map_Head = nil then
  Begin
    Map_Head := curr;
    Map_Last := curr;
  End;

  Map_Last^.next  := curr;
  Map_Last        := curr;

  Map_Last^.index := index;
  Map_Last^.next  := nil;

  Inc(total_map_recs);

End;
