{

 HOTSPOTS.LL

   Linked list containing every hotspot in the currently loaded map screen.
   Included into programs which need to read hotpots into a linked list.

}

Type

  { The linked list }

  HS_ListPtr  = ^HS_List;
  HS_List     = Record
                  Index  : Hotspot;
                  next   : HS_ListPtr;
                End;

Var HS_Head,                  { The first hotspot in the linked list }
    HS_Last : HS_ListPtr;     { The last  hotspot in the linked list }
    total_HS_recs : Integer;  { A counter of hotspots loaded }

{---------------------------------------------------------[ Empty List ]-----
 Clears out every hotspot from memory.
----------------------------------------------------------------------------}
Procedure Empty_HS_List;
var hold, p  : HS_ListPtr;

begin

  p := HS_Head;

  While p <> nil do
  Begin
    hold := p;
    p := p^.next;
    dispose(hold);
    dec(total_HS_recs);
  End;

  HS_Head := nil;
  HS_Last := nil;

End;

{---------------------------------------------------------[ Get Record ]-----
 Searches the list for a particular hotspot.
 Returns TRUE if the hotspot was found, false if not.
 If the hotspot is found, it's loaded into REC.
----------------------------------------------------------------------------}
Function Get_HS_Record(x, y : byte; Var Rec : Hotspot) : Boolean;
Var p : HS_ListPtr;
Begin

 Get_HS_Record := False;

 p := HS_Head;

 while p <> nil do
 Begin
   If (p^.Index.x = x)
   and(p^.Index.y = y) then
   Begin
     rec := p^.index;
     Get_HS_Record := True;
     Exit;
   End;

   p := p^.next;

 End;

End;

{---------------------------------------------------------------[ Add ]-----
 Adds a hotspot to the list
----------------------------------------------------------------------------}
Procedure Add_HS_Rec(Indexrec : Hotspot);
Var temp, curr : HS_ListPtr;

begin

  If (maxavail < SizeOf(HS_List)) then Exit;

  new(curr);
  If HS_Head = nil then HS_Head := curr;
  HS_Last^.next := curr;
  HS_Last       := curr;

  curr^.index   := indexrec;
  curr^.next    := nil;

  Inc(total_HS_recs);

End;
