Unit StrIO;                         {Standard string IO}

INTERFACE

Function Up(S: String): String;       {Return uppercase version of string}
Function LowCase(Ch: Char): Char;     {Lowercase version of UpCase}
Function Low(S: String): String;      {Return lowercase version of string}
Function Cont(St,S: String): Boolean; {If St occures in S then True}
Function Right(S: String; B: Byte):   {Returns all chars right of char B}
String;
Function Left(S: String; B: Byte):    {Returns all chars left of char B}
String;
Function Mid(S: String; B,E: Byte):   {Returns all chars in between B and E}
String;
Function Midv(S: String; B,E: Byte):  {Same as above, except returns the}
Byte;                                 {value of the string (byte)}
Function Space(B: Byte): String;      {Returns a string composed of B spaces}
Function L0(W: Word): String;         {Adds a zero if one digit}
Function Cent(S: String; C: Byte):    {Adds leading spaces in S to center it}
String;                               {in C amount of space}
Procedure Get(Var S: String; Len: Byte; Lock: Boolean);
                                      {Gets a string (S), of length Len.}
                                      {If Lock then it has to be Len chars}
                                      {long.}
IMPLEMENTATION
Uses Crt,CC;

Function Up(S: String): String;
Var I: Byte;
begin
  for i := 1 to Length(s) do s[i] := UpCase(s[i]); Up:=S;
end;

Function LowCase(Ch: Char): Char;
begin
  If (Ch>#64) And (Ch<#91) Then Ch:=Chr(Ord(Ch)+32);
  LowCase:=Ch;
end;

Function Low(S: String): String;
Var I: Byte;
begin
  For I:=1 to Length(s) do s[i] := LowCase(s[i]); Low:=S;
end;

Function Cont(St,S: String): Boolean;
Var I: Byte;
    N: Byte;
begin
  If Pos(St,S)<>0 Then Cont:=True Else Cont:=False;
end;

Function Right(S: String; B: Byte): String;
Var I: Byte;
    T: String;
begin
  T:='';
  For I:=B to Length(S) Do T:=T+S[I];
  Right:=T;
end;

Function Left(S: String; B: Byte): String;
Var I: Byte;
    T: String;
begin
  T:='';
  For I:=1 to B Do T:=T+S[I];
  Left:=T;
end;

Function Mid(S: String; B,E: Byte): String;
Var I: Byte;
    T: String;
begin
  T:='';
  For I:=B to E do T:=T+S[I];
  Mid:=T;
end;

Function Midv(S: String; B,E: Byte): Byte;
Var I,O: Integer;
begin
  S:=Mid(S,B,E);
  Val(S,O,I);
  MidV:=O;
end;

Function Space(B: Byte): String;
Var I: Byte;
    T: String;
begin T:=''; For I:=1 to B do T:=T+#32; Space:=T; end;

Function L0(W: Word): String;
Var S: String; begin Str(W,S); If Length(S)<2 Then S:='0'+S; L0:=S; end;

Function Cent(S: String; C:Byte): String;
begin
  S:=Space((C Div 2)-(Length(S) Div 2))+S;
  Cent:=S;
end;

Procedure Get(Var S: String; Len: Byte; Lock: Boolean);
Var l,Cl: Byte;
    I: Byte Absolute S;
    Q: Boolean;
    T: String;
    ch: char;
    OC: Boolean;
    X,Y: Byte;
    Insert: Boolean;
begin
  Q:=False; Cl:=I+1; OC:=CStatus;
  X:=WhereX; Y:=WhereY;
  Write(S);
  Cursor(On);
  While Not(Q) do
  begin
    Cursor(On);
    Ch:=Readkey;
    Cursor(Off);
    Case Ch Of
      #0: begin
        Ch:=Readkey;
        Case Ch Of
          'G': begin
            Cl:=1;
            GotoXY(X+Cl-1,Y);
          end;
          'O': begin
            Cl:=I+1;
            GotoXY(X+Cl-1,Y);
            end;
          'K': If Cl>1 Then
          begin
            Dec(Cl);
            GotoXY(X+Cl-1,Y);
          end;
          'M': If Cl<I+1 Then
          begin
            Inc(Cl);
            GotoXY(X+Cl-1,Y);
          end;
          'S': If (I>0) And (Cl<I+1) Then
          begin
            T:='';
            For l:=1 to cl-1 Do T:=T+S[l];
            For l:=cl+1 to I do T:=T+S[l];
            S:=T;
            GotoXY(X,Y);
            Write(S,' ');
            GotoXY(X+Cl-1,Y);
          end;
          'R': If (I<Len) And (Cl<I+1) Then
          begin
            T:='';
            For l:=1 to cl-1 do T:=T+S[l];
            T:=T+' ';
            For l:=cl to I do T:=T+S[l];
            S:=T;
            GotoXY(X,Y);
            Write(S);
            GotoXY(X+Cl-1,Y);
          end;
        end;
      end;
      #8: If (I>0) And (Cl>1) Then
      begin
        If Cl>I Then
        begin
          GotoXY(X+Cl-2,Y);
          Write(' ');
          T:='';
          For l:=1 to I-1 Do t:=T+s[l];
          S:=T;
          GotoXY(X+I,Y);
          Dec(Cl);
        end else
        begin
          Dec(Cl);
          T:='';
          For l:=1 to cl-1 Do T:=T+S[l];
          For l:=cl+1 to I do T:=T+S[l];
          S:=T;
          GotoXY(X,Y);
          Write(S,' ');
          GotoXY(X+Cl-1,Y);
        end;
      end;
      #13: If (Not Lock) Or ((Lock) And (I=Len)) Then Q:=True;
      #31..#255: If I<Len Then
      begin
        If Cl>I Then begin S:=S+ch; Inc(Cl); end else
        begin
          S[Cl]:=Ch;
          Inc(Cl);
        end;
        Write(ch);
      end;
    end;
  end;
  Cursor(OC);
end;

end.
