Unit SF;

INTERFACE

Type ConfigRec = Record
       TypeNum: Byte;
       TypeName: String[8];
       TypeFName: String[12];
       Path: String[79];
       SysOp,
       BBSName: String[40];
       SSecLev: Word;
       Fossil: Boolean;
     end;

Var C: ConfigRec;
    F: File of ConfigRec;
    SysOp,
    BBSName: String[40];
    IsSysOp,
    Local: Boolean;
    Video: Byte;
    UserName: String[80];
    ComPort: Word;
    SecLev: Byte;
    TimeOff: LongInt;
    BeforeOff,
    EndProc: Pointer;
    Config: Boolean;
    PauseStr: String;
    ContStr: String;

Function CurTime: Longint;
Function LogOff: Boolean;
Function MKeypressed: Boolean;
Function MReadkey: Char;
Function TimeLeft: Longint;
Function GetF: Byte;
Function GetB: Byte;
Procedure SetF(C: Byte);
Procedure SetB(C: Byte);
Procedure SColor(F,B: Byte);
Procedure MWrite(St: String);
Procedure MWriteln(St: String);
Procedure MRead(Var N: String; Len: Byte);
Procedure MReadln(Var S: String);
Procedure MReadS(Var S: ShortInt);
Procedure MReadI(Var I: Integer);
Procedure MReadL(Var L: Longint);
Procedure MReadB(Var B: Byte);
Procedure MReadW(Var W: Word);
Procedure MReadR(Var R: Real);
Procedure MGotoXY(X,Y: Byte);
Procedure MClrScr;
Procedure Pause;
Function Continue: Byte;
Procedure View(N: String; Paus: Boolean);
Procedure LoadConfig(ConfigFileName: String);

IMPLEMENTATION

Uses Crt, Dos, SFCom, SFANSI, SFAvatar;

Function GetF: Byte;
begin
  GetF:=(TextAttr MOD 16)+(TextAttr DIV 128)*16;
end;

Function GetB: Byte;
begin
  GetB:=(TextAttr DIV 16);
end;

Function Exist(FileName: PathStr): Boolean;
Var TF: File;
begin
  Assign(TF,FileName);
  {$I-} Reset(TF); {$I+}
  If IOResult<>0 Then Exist:=False else
  begin
    Exist:=True;
    Close(TF);
  end;
end;

Function Curtime: LongInt;
Var H,M,S,HS: Word;
begin
  GetTime(H,M,S,HS);
  CurTime:=(H*60)+M;
end;

Function TimeLeft: LongInt;
Var L,I: LongInt;
begin
  I:=CurTime;
  L:=TimeOff-I;
  TimeLeft:=L;
end;

Function LogOff: Boolean;
begin
  If ((Not Local) And (Not Com_Carrier)) Or (TimeLeft<1) Then LogOff:=True Else LogOff:=False;
end;

Procedure ComWrite(St: String);
Var X: Byte;
begin
  If LogOff Then Halt(0);
  If Not(Local) Then For X:=1 to Length(st) Do Com_Tx(St[X]);
end;

Procedure MWrite(St: String);
Var X: Byte;
begin
  If LogOff Then Halt(0);
  For X:=1 to Length(st) Do
  begin
    If Not(Local) Then Com_Tx(St[X]);
    Case Video Of
      0: Write(St[X]);
      1: Ans_Write_Ch(St[X]);
      2: Ava_Write_Ch(St[X]);
    end;
  end;
end;

Procedure MWriteln(St: String); begin MWrite(St+^M^J); end;

Procedure SColor(F,B: Byte);
Var Blink: Boolean;
    HiI: Boolean;
    Fore: Byte;
    Back: Byte;
    CBlink: Boolean;
    CHiI: Boolean;
    CFore: Byte;
    CBack: Byte;
    Out: String;
begin
  If Video=0 Then Exit;
  Fore:=GetF;
  If Fore>15 Then
  begin
    Fore:=Fore-16;
    Blink:=True;
  end else Blink:=False;
  If Fore>7 Then
  begin
    Fore:=Fore-8;
    HiI:=True;
  end else HiI:=False;
  Back:=GetB;
  CFore:=F; CBack:=B;
  If CFore>15 Then
  begin
    CFore:=CFore-16;
    CBlink:=True;
  end else CBlink:=False;
  If CFore>7 Then
  begin
    CFore:=CFore-8;
    CHiI:=True;
  end else CHiI:=False;
  Case Video Of
    0: {Do Nothing, TTY, Blah!};
    1: begin
      Out:=^['[';
      If (Blink) And (Not CBlink) Then
      begin
        Out:=Out+'0;';
        Blink:=False;
        HiI:=False;
        Fore:=7;
        Back:=0;
      end;
      If (CBlink) And (Not Blink) Then Out:=Out+'6;';
      If (HiI) And (Not CHiI) Then Out:=Out+'2;';
      If (CHiI) And (Not HiI) Then Out:=Out+'1;';
      If (Fore<>CFore) Then
      Case CFore Of
        0: Out:=Out+'30;';
        1: Out:=Out+'35;';
        2: Out:=Out+'32;';
        3: Out:=Out+'36;';
        4: Out:=Out+'31;';
        5: Out:=Out+'34;';
        6: Out:=Out+'33;';
        7: Out:=Out+'37;';
      end;
      If (Back<>CBack) Then
      Case CBack Of
        0: Out:=Out+'40;';
        1: Out:=Out+'45;';
        2: Out:=Out+'42;';
        3: Out:=Out+'46;';
        4: Out:=Out+'41;';
        5: Out:=Out+'44;';
        6: Out:=Out+'43;';
        7: Out:=Out+'47;';
      end;
      If Length(Out)>2 Then
      begin
        Delete(Out,Length(Out),1);
        Out:=Out+'m';
        If Out=^['[0m' Then Out:=^['[m';
        If (F=7) And (B=0) Then Out:=^['[m';
      end else Out:='';
    end;
    2: begin
      If Blink Then CBack:=CBack+8;
      If HiI Then CFore:=CFore+8;
      Out:=^V^A+Chr(CBack*16+CFore);
    end;
  end;
  MWrite(Out);
end;

Procedure SetF(C: Byte);
begin
  SColor(C,GetB);
end;

Procedure SetB(C: Byte);
begin
  SColor(GetF,C);
end;

Procedure MRead(Var N: String; Len: Byte);
Var l,Cl: Byte;
    S: String;
    I: Byte Absolute S;
    Q: Boolean;
    T: String;
    ch: char;
    OC,Lock: Boolean;
    X,Y: Byte;
    Insert: Boolean;
begin
  If Logoff Then Halt(0);
  Q:=False; Lock:=False;
  X:=WhereX; Y:=WhereY; S:=N; Cl:=I+1;
  MWrite(S);
  While Not(Q) do
  begin
    Ch:=MReadkey;
    Case Ch Of
      ^@: begin
        Ch:=MReadkey;
        Case Ch Of
          'G': begin
            Cl:=1;
            MGotoXY(X+Cl-1,Y);
          end;
          'O': begin
            Cl:=I+1;
            MGotoXY(X+Cl-1,Y);
            end;
          'K': If Cl>1 Then
          begin
            Dec(Cl);
            MGotoXY(X+Cl-1,Y);
          end;
          'M': If Cl<I+1 Then
          begin
            Inc(Cl);
            MGotoXY(X+Cl-1,Y);
          end;
          'S': If (I>0) And (Cl<I+1) Then
          begin
            T:='';
            For l:=1 to cl-1 Do T:=T+S[l];
            For l:=cl+1 to I do T:=T+S[l];
            S:=T;
            MGotoXY(X,Y);
            MWrite(S+' ');
            MGotoXY(X+Cl-1,Y);
          end;
          'R': If (I<Len) And (Cl<I+1) Then
          begin
            T:='';
            For l:=1 to cl-1 do T:=T+S[l];
            T:=T+' ';
            For l:=cl to I do T:=T+S[l];
            S:=T;
            MGotoXY(X,Y);
            MWrite(S);
            MGotoXY(X+Cl-1,Y);
          end;
        end;
      end;
      ^H: If (I>0) And (Cl>1) Then
      begin
        If Cl>I Then
        begin
          MGotoXY(X+Cl-2,Y);
          MWrite(' ');
          T:='';
          For l:=1 to I-1 Do t:=T+s[l];
          S:=T;
          MGotoXY(X+I,Y);
          Dec(Cl);
        end else
        begin
          Dec(Cl);
          T:='';
          For l:=1 to cl-1 Do T:=T+S[l];
          For l:=cl+1 to I do T:=T+S[l];
          S:=T;
          MGotoXY(X,Y);
          MWrite(S+' ');
          MGotoXY(X+Cl-1,Y);
        end;
      end;
      ^M: If (Not Lock) Or ((Lock) And (I=Len)) Then Q:=True;
      #32..#255: If I<Len Then
      begin
        If Cl>I Then begin S:=S+ch; Inc(Cl); end else
        begin
          S[Cl]:=Ch;
          Inc(Cl);
        end;
        MWrite(ch);
      end;
    end;
  end;
  N:=S;
end;

Procedure MReadln(Var S: String); begin MRead(S,255); end;

Procedure GetNum(Var N: String; Len: Byte);
Var l,Cl: Byte;
    S: String;
    I: Byte Absolute S;
    Q: Boolean;
    T: String;
    ch: char;
    OC,Lock: Boolean;
    X,Y: Byte;
    Insert: Boolean;
begin
  If Logoff Then Halt(0); S:=N;
  Q:=False; Cl:=I+1; Lock:=False;
  X:=WhereX; Y:=WhereY;
  MWrite(S);
  While Not(Q) do
  begin
    Ch:=MReadkey;
    Case Ch Of
      ^@: begin
        Ch:=MReadkey;
        Case Ch Of
          'G': begin
            Cl:=1;
            MGotoXY(X+Cl-1,Y);
          end;
          'O': begin
            Cl:=I+1;
            MGotoXY(X+Cl-1,Y);
            end;
          'K': If Cl>1 Then
          begin
            Dec(Cl);
            MGotoXY(X+Cl-1,Y);
          end;
          'M': If Cl<I+1 Then
          begin
            Inc(Cl);
            MGotoXY(X+Cl-1,Y);
          end;
          'S': If (I>0) And (Cl<I+1) Then
          begin
            T:='';
            For l:=1 to cl-1 Do T:=T+S[l];
            For l:=cl+1 to I do T:=T+S[l];
            S:=T;
            MGotoXY(X,Y);
            MWrite(S+' ');
            MGotoXY(X+Cl-1,Y);
          end;
          'R': If (I<Len) And (Cl<I+1) Then
          begin
            T:='';
            For l:=1 to cl-1 do T:=T+S[l];
            T:=T+' ';
            For l:=cl to I do T:=T+S[l];
            S:=T;
            MGotoXY(X,Y);
            MWrite(S);
            MGotoXY(X+Cl-1,Y);
          end;
        end;
      end;
      ^H: If (I>0) And (Cl>1) Then
      begin
        If Cl>I Then
        begin
          MGotoXY(X+Cl-2,Y);
          MWrite(' ');
          T:='';
          For l:=1 to I-1 Do t:=T+s[l];
          S:=T;
          MGotoXY(X+I,Y);
          Dec(Cl);
        end else
        begin
          Dec(Cl);
          T:='';
          For l:=1 to cl-1 Do T:=T+S[l];
          For l:=cl+1 to I do T:=T+S[l];
          S:=T;
          MGotoXY(X,Y);
          MWrite(S+' ');
          MGotoXY(X+Cl-1,Y);
        end;
      end;
      ^M: If (Not Lock) Or ((Lock) And (I=Len)) Then Q:=True;
      '0'..'9','-': If I<Len Then
      begin
        If Cl>I Then begin S:=S+ch; Inc(Cl); end else
        begin
          S[Cl]:=Ch;
          Inc(Cl);
        end;
        MWrite(ch);
      end;
    end;
  end;
  N:=S;
end;

Procedure MReadS(Var S: ShortInt);
Var I: Integer;
    S2: String;
begin
  GetNum(S2,4);
  Val(S2,S,I);
end;

Procedure MReadI(Var I: Integer);
Var I2: Integer;
    S: String;
begin
  GetNum(S,6);
  Val(S,I,I2);
end;

Procedure MReadL(Var L: LongInt);
Var I: Integer;
    S: String;
begin
  GetNum(S,11);
  Val(S,L,I);
end;

Procedure MReadB(Var B: Byte);
Var I: Integer;
    S: String;
begin
  GetNum(S,3);
  Val(S,B,I);
end;

Procedure MReadW(Var W: Word);
Var I: Integer;
    S: String;
begin
  GetNum(S,5);
  Val(S,W,I);
end;

Procedure MReadR(Var R: Real);
Var I: Integer;
    S: String;
begin
  GetNum(S,5);
  Val(S,R,I);
end;

Function MKeypressed: Boolean;
begin
  If ((Not Local) And (Not Com_Rx_Empty)) Or (Keypressed) Then MKeypressed:=True Else MKeypressed:=False;
end;

Function MReadkey: Char;
begin
  Repeat If LogOff Then Halt(0); Until MKeypressed;
  If Keypressed Then MReadkey:=Readkey Else MReadkey:=Com_Rx;
end;

Procedure MGotoXY(X,Y: Byte);
Var Xs,Ys: String;
begin
  Case Video Of
    0: {TTY, do nothing, blah!};
    1: begin
      Str(X,Xs); Str(Y,Ys);
      MWrite(^['['+Ys+';'+Xs+'H');
    end;
    2: MWrite(^V^H+Chr(Y)+Chr(X));
  end;
end;

Procedure MClrscr;
begin
  Case Video Of
    0: {ACK, no video mode, blargh!};
    1: MWrite(^['[2J');
    2: MWrite(^L);
  end;
end;

Procedure Pause;
Var I: Byte;
    C: Char;
begin
  MWrite(PauseStr);
  C:=MReadkey;
  For I:=1 to Length(PauseStr) Do MWrite(^H#32^H);
end;

Function Continue: Byte;
Var C: Char;
    I: Byte;
begin
  MWrite(ContStr);
  Repeat C:=MReadkey; Until C in ['C','S','N',^[,^M,#32];
  Case C Of
    'C',^M,#32: Continue:=0;
    'N': Continue:=1;
    'S',^[: Continue:=2;
  end;
  For I:=1 to Length(ContStr) Do MWrite(^H#32^H);
end;

Procedure View(N: String; Paus: Boolean);
Var S: String;
    I,z: Byte;
    K: Word;
    Buf: Array[1..10240] of Char;
    R: Word;
    V: File;
    Ch: Char;
begin
  S:=''; I:=1;
  Assign(V,N);
  {$I-} Reset(V,1); {$I+}
  If IoResult<>0 Then
  begin
    MWriteln('ERROR: File '+N+' not found.');
    Exit;
  end;
  I:=0; Z:=0;
  BlockRead(V,Buf,10240,R);
  While R<>0 Do
  begin
    For K:=1 to R Do
    begin
      If (Not InAvatar) Then inc(Z);
      If (Not InAvatar) And ((buf[K]=#10) Or (Z=80)) Then begin Z:=0; Inc(I); end;
      MWrite(Buf[K]);
      If ((I=24) Or (MKeypressed)) And (Paus) Then
      Case Continue Of
        1: Paus:=False;
        2: begin
          Close(V);
          Exit;
        end;
      end;
    end;
    BlockRead(V,Buf,10240,R);
  end;
  Close(V);
end;

Procedure LoadConfig(ConfigFileName: String);
Var St: String;
    I: Integer;
    W: Word;
    L: LongInt;
    D: Text;

Procedure Sp2Zr(var S: String);
begin
  while Pos(' ', s) > 0 do
    s[Pos(' ', s)] := '0';
end;

procedure rmp(var s: string);
Var st: String;
    I: Byte;
begin
  St:='';
  If Pos('.',s)>0 then
  For I:=1 to (Pos('.',s)-1) do st:=St+s[i];
  s:=st;
end;

begin
  If not(config) then
  begin
    If not(Exist(ConfigFileName)) then
    begin
      Writeln('[> ERROR: Config file not found.');
      Writeln('[> Exiting...');
      Halt(1);
    end;
    Assign(F,ConfigFileName);
    Reset(F);
    Read(F,C);
    Close(F);
    Assign(D,C.Path+C.TypeFName);
    {$I-} Reset(D); {$I+}
    If IOResult<>0 then
    begin
      Writeln('[> ERROR: '+C.TypeFName+' not found in');
      Writeln('[> path "'+C.Path+'"!');
      Halt(1);
    end;
    Case C.TypeNum of
      1: begin
        Readln(D,St);
        Val(St[4],ComPort,I);
        If ComPort=0 Then Local:=True else local:=False;
        For I:=2 to 9 do Readln(d,st);
        REadln(D,UserName);
        For I:=11 to 14 do Readln(d,St);
        Readln(D,SecLev);
        For I:=16 to 17 do REadln(d,st);
        Readln(D,L); TimeOff:=CurTime+L;
        Readln(D,St);
        Readln(D,st);
        If St='GR' Then Video:=1 else Video:=0;
      end;
      2: begin
        Readln(D, St);
        Readln(D, UserName);
        Readln(D, St);
        Readln(D, SecLev);
        REadln(D,St);
        Readln(D,st); If St='Y' then Video:=1 else Video:=0;
        Readln(D,L); TimeOff:=CurTime+L;
        For I:=8 to 11 do readln(d,st);
        Readln(D,ComPort);
        REadln(D,st); If St='0' Then Local:=True else Local:=False;
        For I:=14 to 16 do Readln(d,st);
        Readln(d,C.BBSName);
        Readln(D,C.Sysop);
      end;
      3: begin
        Readln(D,st);
        Readln(D,UserName);
        For I:=3 to 4 do Readln(d,st);
        Readln(D,Comport);
        If Comport=0 then local:=true else local:=false;
        readln(d,l); timeoff:=curtime+1;
        For i:=7 to 8 do Readln(d,st);
        readln(D,st);
        if st='TRUE' then Video:=1 else Video:=0;
        readln(d,seclev);
      end;
      4: begin
        Readln(d,c.bbsname);
        REadln(d,st);
        readln(d,c.sysop);
        c.Sysop:=st+' '+C.sysop;
        readln(d,st);
        val(st[4],comport,i);
        if comport=0 then local:=true else local:=false;
        for I:=5 to 6 do REadln(d,st);
        readln(d,username);
        readln(d,st); username:=username+' '+st;
        readln(d,st);
        readln(d,st); if st='1' then Video:=1 else video:=0;
        readln(d,seclev);
        readln(d,l);
        Timeoff:=curtime+l;
      end;
      5: begin
        Readln(d,st);
        readln(d,username);
        for i:=3 to 10 do readln(d,st);
        readln(d,seclev);
        for i:=12 to 13 do readln(d,st);
        readln(d,st);
        if st='1' then Video:=1 else Video:=0;
        readln(d,st);
        if st='1' then local:=false else local:=true;
        readln(d,st);
        sp2zr(st);
        rmp(st);
        val(st,l,i);
        l:=trunc(l div 60);
        timeoff:=curtime+l;
        for i:=17 to 20 do readln(d,st);
        readln(d,comport);
        readln(d,c.bbsname);
        readln(d,c.sysop);
      end;
      6,7: begin
        Readln(d,username);
        for I:=2 to 3 do readln(d,st);
        readln(d,seclev);
        readln(d,l);
        timeoff:=curtime+l;
        readln(d,st);
        if st='COLOR' then Video:=1 else Video:=0;
        for i:=7 to 27 do readln(d,st);
        readln(d,st);
        if st='REMOTE' then local:=false else local:=true;
        readln(d,st);
        val(st[4],comport,I);
      end;
    end;
    close(D);
    If not(local) then com_install(comport,w,c.fossil);
    config:=true;
    If C.SSecLev<=SecLev Then IsSysop:=True else IsSysop:=False;
    Sysop:=C.Sysop;
    BBSName:=C.BBSName;
  end;
end;

begin
  TextAttr:=7;
  Write('Silver Flame/Mark 2 v1.0: Setting Defaults...');
  PauseStr:='Press any key when ready...';
  ContStr:='[C]ontinue, [S]top, [N]on-stop: ';
  Config:=False;
  Video:=0;
  Config:=False;
  Writeln('Silver Flame/Mark 2 v1.0: Silver Flame Loaded');
end.
