Unit OMenu;

INTERFACE

Type Location=Record
       Tx,Ty,
       Bx,By: Byte;
     end;
     Colors=Record
       BorderFore,
       BorderBack,
       OptFore,
       OptBack,
       HelpFore,
       HelpBack,
       BarFore,
       BarBack: Byte;
     end;
     FMenu= Object
       Loc: Location;
       Color: Colors;
       NumCmds: Byte;
       Box: Byte;
       Bar: Boolean;
       Center: Boolean;
       HelpLine: Byte;
       HLTX,HLBX: Byte;
       CmdNm: Array[1..50] of String[60];
       Help: Array[1..50] of String[70];
       Cmd: Byte;

       Procedure Menu;
     end;

Const BoxType: Array [1..8,1..8] Of Char =
                     (('','','','','','','',''), {Ŀ}
                                                         {A}
                                                         {}
                      ('','','','','','','',''), {ͻ}
                                                         {A}
                                                         {ͼ}
                      ('','','','','','','',''), {͸}
                                                         {A}
                                                         {;}
                      ('','','','','','','',''), {ķ}
                                                         {A}
                                                         {Ľ}
                      ('','','','','','','',''), {}
                                                         {A}
                                                         {}
                      ('','','','','','','',''), {}
                                                         {A}
                                                         {}
                      ('','','','','','','',''), {͸}
                                                         {A}
                                                         {}
                      ('','','','','','','',''));{ķ}
                                                         {A}
                                                         {ͼ}

IMPLEMENTATION
Uses Crt,Scrn;

Procedure FMenu.Menu;
Type IRec=Record
       N: String[60];
       I: Byte;
     end;
     KRec=Record
       N: Byte;
       I: Byte;
     end;
Var Screen: ScreenObj; {Screen Info}
    I: Byte; {Temp Var}
    Items: Array[1..50] of IRec; {Menu Items}
    ItemNum: Byte; {Number of menu items}
    Keys: Array[1..50] of KRec; {ASCII key codes}
    KeyNum: Byte; {Number of keypress items}
    Exts: Array[1..50] of KRec; {#0+ASCII key codes}
    ExtNum: Byte; {Number of scan code key items}
    Longest: Byte; {The number of the longest menu item}
    Int: Integer; {Temp Var}
    vx: Array[1..2] of Byte;
    wx: Word Absolute vx;

 Procedure BC;
 begin TextColor(Color.BorderFore); TextBackground(Color.BorderBack); end;

 Procedure OC;
 begin TextColor(Color.OptFore); TextBackground(Color.OptBack); end;

 Procedure HC;
 begin TextColor(Color.HelpFore); TextBackground(Color.HelpBack); end;

 Procedure SC;
 begin TextColor(Color.BarFore); TextBackground(Color.BarBack); end;

begin
  {*** Initialization ***}
  ItemNum:=0; KeyNum:=0; ExtNum:=0;
  {Separate menu items from key stroke checks}
  For I:=1 to NumCmds Do
    Case CmdNm[I,1] of
      '`': begin
        Inc(KeyNum);
        Delete(CmdNm[I],1,1);
        Val(CmdNm[I],Keys[KeyNum].N,Int);
        Insert('`',CmdNm[I],1);
        Keys[KeyNum].I:=I;
      end;
      '~': begin
        Inc(ExtNum);
        Delete(CmdNm[I],1,1);
        Val(CmdNm[I],Exts[ExtNum].N,Int);
        Insert('~',CmdNm[I],1);
        Exts[ExtNum].I:=I;
      end;
      else begin
        Inc(ItemNum);
        Items[ItemNum].N:=CmdNm[I];
        Items[ItemNum].I:=I;
      end;
    end;
  If ItemNum=0 Then Exit; {If there are no menu items, then don't try to run}
  Screen.Save; {Save all the screen information}
  If Cmd>ItemNum Then Cmd:=1; {If the default item is not an item, fix it}
  If Loc.Bx=0 Then {If border width not set, then set it to the length of}
  begin            {the longest command.}
    For I:=1 to ItemNum Do If Length(Items[I].N)>Loc.Bx Then Loc.Bx:=Length(Items[I].N);
    If Box<>0 Then Inc(Loc.Bx,4); {If there's a border, make room for it}
    Inc(Loc.Bx,Loc.Tx);
    Center:=False; {Automatically centered}
  end;

  {*** Draw Border ***}
  If Box<>0 Then
  begin
    BC; {Change to border colors}
    GotoXY(Loc.Tx,Loc.Ty);
    Write(BoxType[Box,5]);
    For I:=Loc.Tx+1 to Loc.Bx-1 Do Write(BoxType[Box,6]);
    Write(BoxType[Box,7]);
    For I:=Loc.Ty+1 to Loc.By-1 Do
    begin
      GotoXY(Loc.Tx,I);
      Write(BoxType[Box,1]);
      GotoXY(Loc.Bx,I);
      Write(BoxType[Box,8]);
    end;
    GotoXY(Loc.Tx,Loc.By);
    Write(BoxType[Box,2]);
    For I:=Loc.Tx+1 to Loc.Bx-1 Do Write(BoxType[Box,3]);
    Write(BoxType[Box,4]);
    Inc(Loc.Tx);
    Dec(Loc.Bx);
    Inc(Loc.Ty);
    Dec(Loc.By);
  end;
  Longest:=0; Int:=0;
  For I:=1 to ItemNum Do If Length(Items[I].N)>Int Then begin Int:=Length(Items[I].N); Longest:=I; end;
  If Center Then {If Menu is to be centered on the largest item, then}
    Loc.Tx:=((Loc.Tx-1)-Loc.Bx)  {make new left hand margin to do so.}
            DIV 2 - Int DIV 2;

  {*** Display Menu Items ***}
  OC;
  Window(Loc.Tx,Loc.Ty,Loc.Bx,Loc.By);
  Clrscr;
  If Box<>0 Then Window(Loc.Tx+1,Loc.Ty,Loc.Bx,Loc.By);
  For I:=1 to ItemNum Do
  begin
    GotoXY(1,I);
    Write(Items[I].N);
  end;

  {*** Keypress Loop ***}
  Repeat
    {Display Selection Bar}
    SC;
    GotoXY(1,Cmd);
    Write(Items[Cmd].N);
    If Bar Then For I:=1 to Length(Items[Longest].N)-Length(Items[Cmd].N) Do Write(' ');
    {Display Help About Current Selection}
    If HelpLine<>0 Then
    begin
      HC;
      Window(HLTX,Helpline,HLBX,Helpline);
      Clrscr;
      For I:=1 to ( ((HLBX-HLTX-1) DIV 2) - Length(Help[Items[Cmd].I]) DIV 2) Do Write(' ');
      Write(Help[Cmd]);
      If Box<>0 Then Window(Loc.Tx+1,Loc.ty,Loc.Bx-1,Loc.By) else Window(Loc.Tx,Loc.Ty,Loc.Bx,Loc.By);
    end;
    {Proccess Keystroke}
    I:=Ord(Readkey);
      {First check for constant key strokes (up, down, and enter)}
    Case I Of
      13: begin {Selection has been chosen}
        Screen.Plot; {Restore the screen}
        Exit;
      end;
      0: begin
        I:=Ord(Readkey);
        If I In [72,80] Then
        begin
          OC;
          GotoXY(1,Cmd);
          Write(Items[Cmd].N);
          If Bar Then For Int:=1 to Length(Items[Longest].N)-Length(Items[Cmd].N) Do Write(' ');
        end;
        Case I Of
          72: Dec(Cmd);
          80: Inc(Cmd);
          else For Int:=1 to ExtNum Do If Exts[Int].N=I Then
          begin
            Cmd:=Exts[Int].I;
            Screen.Plot;
            Exit;
          end;
        end;
        If Cmd=0 Then Cmd:=ItemNum;
        If Cmd>ItemNum Then Cmd:=1;
      end;
      else For Int:=1 to KeyNum Do If Keys[Int].N=I Then
      begin
        Cmd:=Keys[Int].I;
        Screen.Plot;
        Exit;
      end;
    end;
  Until I<>I;
end;

end.