Unit Boxes;

INTERFACE

Procedure DrawBox(Tx,Ty,Bx,By,BxType,BFore,BBack,CBack: Byte);
                                      {Draw a box with Tx,Ty as the top}
                                      {left hand corner, and Bx,By as the}
                                      {bottom right. Bxtype is the boxtype,}
                                      {BFore is the border foreground,}
                                      {BBack is the border background,}
                                      {CBack is the center background}
Procedure Nfo(S: String; BoxFore, TxtFore, Back, BxType: Byte);
                                      {Write a dialog box in the middle of}
                                      {screen, with S as the text and wait}
                                      {for a keypress.  Background Back,  }
                                      {Box foreground BoxFore, text}
                                      {foreground TxtFore, BoxType BxType}
{}                                                                         {}
Procedure Dialog(S: String; Var RS: String; Len,BoxFore,TxtFore,EntFore,Back,BxType: Byte);
Procedure Dialog2(S: String; Var RS: String; Len,BoxFore,TxtFore,EntFore,Back,BxType: Byte);
{}                                                                         {}
{Create a dialog box in the middle of the screen, print S, then read a
 maximum of len chars.  The color of the box is boxfore, the text, textfor,
 the data entered, entfore, the background, back, and the box type is Bxtype.
 RS is the string that the user entered.
 Dialog2 is a version that has one line for S, and anouther for them to type}
{Box types:}
Const None   = 1;
      Single = 2;
      Double = 3;
      Block  = 4;

{Box defs:}
Const Line: Array [0..8,1..8] Of Char =
                     ((' ',' ',' ',' ',' ',' ',' ',' '), {   }
                                                         { A }
                                                         {   }
                      ('','','','','','','',''), {Ŀ}
                                                         {A}
                                                         {}
                      ('','','','','','','',''), {ͻ}
                                                         {A}
                                                         {ͼ}
                      ('','','','','','','',''), {͸}
                                                         {A}
                                                         {;}
                      ('','','','','','','',''), {ķ}
                                                         {A}
                                                         {Ľ}
                      ('','','','','','','',''), {}
                                                         {A}
                                                         {}
                      ('','','','','','','',''), {}
                                                         {A}
                                                         {}
                      ('','','','','','','',''), {͸}
                                                         {A}
                                                         {}
                      ('','','','','','','',''));{ķ}
                                                         {A}
                                                         {ͼ}
IMPLEMENTATION
Uses Crt,StrIO,Scrn;

Procedure DrawBox(Tx,Ty,Bx,By,BxType,BFore,BBack,CBack: Byte);
Var I,Attr: Byte;
    Max,Min: Word;
begin
  Max:=WindMax; Min:=WindMin; Attr:=TextAttr;
  Window(Tx,Ty,Bx,By);
  If CBack>7 Then TextColor(Blink);
  TextBackground(CBack);
  Clrscr; Window(1,1,80,25);
  If BBack>7 Then TextColor(BFore+Blink) Else TextColor(BFore);
  TextBackground(BBack);
  GotoXY(Tx,Ty);
  Write(Line[BxType,5]);
  For I:=Tx+1 to Bx-1 Do Write(Line[BxType,6]);
  Write(Line[BxType,7]);
  For I:=Ty+1 to By-1 Do
  begin
    GotoXY(Tx,I); Write(Line[BxType,1]);
    GotoXY(Bx,I); Write(Line[BxType,8]);
  end;
  GotoXY(Tx,By);
  Write(Line[BxType,2]);
  For I:=Tx+1 to Bx-1 Do Write(Line[BxType,3]);
  Write(Line[BxType,4]);
  WindMax:=Max; WindMin:=Min; TextAttr:=Attr;
end;


Procedure Nfo(S: String; BoxFore,TxtFore,Back,BxType:Byte);
Var Len,Tx,Bx,I: Byte;
    Ch: Char;
    Screen: ScreenObj;
begin
  Screen.Save;
  Len:=Length(S);
  Window(1,1,80,25);
  Tx:=(40 - Len div 2)-2;
  Bx:=40+(Len-Len div 2)+2;
  Screen.Save;
  DrawBox(Tx,11,Bx,13,BxType,BoxFore,Back,Back);
  TextBackground(Back);
  TextColor(TxtFore);
  GotoXY(Tx+2,12);
  Write(S);
  Ch:=ReadKey;
  Screen.Plot;
end;

Procedure Dialog(S: String; Var RS: String; Len,BoxFore,TxtFore,EntFore,Back,BxType: Byte);
Var SLen,Tx,Bx,I: Byte;
    Ch: Char;
    Screen: ScreenObj;
begin
  Screen.Save;
  SLen:=Length(S)+Len;
  Tx:=(40 - SLen div 2)-2;
  Bx:=40+(SLen-SLen div 2)+2;
  DrawBox(Tx,11,Bx,13,BxType,BoxFore,Back,Back);
  Window(1,1,80,25);
  TextBackground(Back);
  TextColor(TxtFore);
  GotoXY(Tx+2,12);
  Write(S);
  TextColor(EntFore);
  Get(RS,Len,False);
  Screen.Plot;
end;

Procedure Dialog2(S: String; Var RS: String; Len,BoxFore,TxtFore,EntFore,Back,BxType: Byte);
Var SLen,Tx,Bx,I: Byte;
    Ch: Char;
    Screen: ScreenObj;
begin
  Screen.Save;
  If Length(S)>Len Then SLen:=Length(S) Else SLen:=Len;
  Tx:=(40 - SLen div 2)-2;
  Bx:=40+(SLen-SLen div 2)+2;
  DrawBox(Tx,11,Bx,14,BxType,BoxFore,Back,Back);
  Window(1,1,80,25);
  TextBackground(Back);
  TextColor(TxtFore);
  GotoXY(Tx+2,12);
  Write(S);
  GotoXY(Tx+2,13);
  TextColor(EntFore);
  Get(RS,Len,False);
  Screen.Plot;
end;

end.