{ RA LOST CARRIER CHECK,By Martin Woods}

{ this program analyses RA.LOG and finds out who's losing
  carrier and then send a message to them warning them not
  to do so.
  Requires RALCC.MSG as a message to import with %Ffrom_name
  as the first line.And you will need Mark May's Library MKMS106.LZH }

uses Dos,MKFile, MKString, MKMsgAbs, MKOpen, MKGlobT, MKDos,crt;

const
 MonthStr: Array[1..12] of String[3] = ('Jan', 'Feb', 'Mar', 'Apr',
                                        'May', 'Jun', 'Jul', 'Aug',
                                        'Sep', 'Oct', 'Nov', 'Dec');
 DayStr: Array[0..6] of String[3] = ('Sun', 'Mon', 'Tue', 'Wed',
                                     'Thu', 'Fri', 'Sat');
var
LogFile: Text;
LogLine, UserName,Logpath,SysPath: String;
Time: String[8];
Date: String[13];
Garbage: String[2];
LDT, LastDT: Longint;
UserDT, DT: DateTime;
Error, Sec100 : Word;
DataFile: File;
DataLog: Text;
LastDate: String[13];
CurrDir: PathStr;
Temp: String[5];
  {Mark May's toolkit units,variables below}
  Msg: AbsMsgPtr;                      {Pointer to msg object}
  MsgAreaId: String[128];              {Message Area Id to post msg in}
  MsgFrom: String[50];                 {Author of the message}
  MsgTo: String[50];                   {Who the message is to}
  MsgSubj: String[100];                {Subject of the message}
  OrigAddr: AddrType;                  {Fido-style originating address}
  DestAddr: AddrType;                  {Fido-style destination address}
  MsgFileName: String;                 {File name with message text}
  WildName: String;                    {Search file name given for msg text}
  MsgType: MsgMailType;                {Type of msg to be written}
  Priv: Boolean;                       {Is message private}
  Del: Boolean;                        {Erase msg text file afterwards}
  DoEcho: Boolean;                     {Set to be echoed flag}
  TxtSearch: FindObj;                  {wildcard processor}

Procedure show_help;
Begin
If (ParamCount = 0) or (ParamStr(1) = '/?') Then
  Begin
  textattr:=$07;
  clrscr;
  writeln;
  textcolor(10);
  WriteLn('     RA Lost Carrier Check Version 1.0,Copyright 1996 Martin Woods');
  writeln;
  textcolor(14);
  WriteLn('           Proper syntax is:');
  textcolor(11);
  writeln;
  WriteLn('           RALCC [MsgAreaId]');
  writeln;
  WriteLn('           Squish MsgAreaId Example = SC:\Max\Msg\Muffin');
  WriteLn('           Hudson MsgAreaId Example = H042C:\RA\MsgBase');
  WriteLn('           *.Msg  MsgAreaId Example = FC:\Mail');
  WriteLn('           Jam    MsgAreaId Example = JC:\Jam\General');
  writeln;
  textcolor(15);
  writeln('           IE: RALCC JC:\JAM\LOCAL');
  textattr:=$07;
{  clrscr;}
  Halt(1);
  End;
 end;

 Procedure InitMsgValues;               {initial message values to defaults}
  Begin
  MsgAreaId := Upper(ParamStr(1));
  MsgTo :=UserName;
  MsgSubj := '"Carrier Lost on '+Date+' at '+Time+'"';
  WildName := 'Ralcc.Msg';
  MsgType := mmtNormal; {Local}
  DoEcho := False;
  Priv := True;
  Del := False;   {Don't delete your RALCC.TXT File!}
  FillChar(OrigAddr, SizeOf(OrigAddr), #0); {don't really need these two}
  FillChar(DestAddr, SizeOf(DestAddr), #0); {for local messages         }
  End;


Procedure ProcessMsgFile;              {Process text from message file}
  Var
    TF: TFile;                         {Use TFile object for ease of use}
    TmpStr: String;

  Begin
  TF.Init;
  If TF.OpenTextFile(MsgFileName) Then
    Begin
    If OpenMsgArea(Msg, MsgAreaId) Then
      Begin
      Msg^.StartNewMsg;
      TmpStr := TF.GetString;
      While TF.StringFound Do
        Begin
        If Length(TmpStr) > 0 Then
          Begin
          Case TmpStr[1] of
            '%': Begin
                 Case UpCase(TmpStr[2]) Of
                   'F': MsgFrom := Copy(TmpStr, 3, 50);

                   Else
                     Begin
                     Msg^.DoStringLn(TmpStr);
                     End;
                   End;
                 End;
            #1:  Begin
                 Msg^.DoKludgeLn(TmpStr);
                 End;
            Else
              Begin
              Msg^.DoStringLn(TmpStr);
              End;
            End;
          End
        Else
          Begin
          Msg^.DoStringLn('');
          End;
        TmpStr := TF.GetString;
        End;
      Msg^.SetFrom(Proper(MsgFrom));
      Msg^.SetTo(Proper(MsgTo));
      Msg^.SetSubj(MsgSubj);
      Msg^.SetPriv(Priv);
      Msg^.SetDate(DateStr(GetDosDate));
      Msg^.SetTime(TimeStr(GetDosDate));
      Msg^.SetLocal(True);
      Msg^.SetEcho(DoEcho);
      Msg^.SetOrig(OrigAddr);
      Msg^.SetDest(DestAddr);
      If Msg^.WriteMsg <> 0 Then
        WriteLn('Error saving message')
      Else
        Assign(dataLog,'RALCC.LOG');     {create a file for the sysop}
    {$I-}
        Append(dataLog);
    {$I+}
         If IoResult <> 0  Then
         ReWrite(dataLog);

  write(datalog,dateStr(GetDosDate),' ',timestr(getdosdate));
  WriteLn(dataLog,' Message Written to '+Username+'  Subject - Lost Carrier');
  textcolor(14);
  writeln('RA Lost Carrier Check ');  {and let'm know on the screen}
  textcolor(11);
  writeln('Sending Message to '+Username+'  Subject - Lost Carrier');
    close(dataLog);
     textcolor(7);
      If CloseMsgArea(Msg) Then;
      End
    Else
      WriteLn('Unable to open msg base: ', MsgAreaId);
    If TF.CloseTextFile Then;
    End
  Else
    WriteLn('Unable to open msg text file: ', MsgFileName);
  TF.Done;
  If Del Then
    Begin
    If EraseFile(MsgFileName) Then
      WriteLn(MsgFileName, ' erased');
    End;
  End;

Function FixPath(Path : String): String;
    Begin
    If Path[Length(Path)] <> '\' Then
        Path := Path+'\';
     FixPath := Path;
    End;

function NewInfo(Line: String): Boolean;
begin
 NewInfo := (LogLine<>'') and (LogLine[1]='-');
end;

function LostCarrier(Line: String): Boolean;
begin
 LostCarrier := Pos('Lost carrier', Line)<>0;
end;

function UserOnline(Line: String): Boolean;
begin
 UserOnline := Pos('on-line', Line)<>0;
end;

label Examine, WaitOnline;

 Begin {ok let's go}

 If (ParamCount < 1) or (ParamStr(1) = '/?') Then show_help
  else
 FillChar(UserDT, SizeOf(UserDT), 0);
 textcolor(14);
{ clrscr;}
 WriteLn('RA Lost Carrier Check v1.0,  Copyright (C) Oct 1996 Martin Woods');
 textattr:=$07;
 Assign(DataFile, 'RALCC.DAT');
 {$I-}
 Reset(DataFile);
 {$I+}
 if IOResult<>0 then
  begin
   with DT do
    begin
     Year := 1980; { Scan all RA log entries if run first time }
     Month := 1;
     Day := 1;
    end;
   Rewrite(DataFile);
  end else
  begin
   GetFTime(DataFile, LastDT);
   with DT do
    begin
     GetTime(Hour, Min, Sec, Sec100);
     GetDate(Year, Month, Day, Sec100);
    end;
  end;
 PackTime(DT, LDT);
 SetFTime(DataFile, LDT);
 UnpackTime(LastDT, DT);
 Close(DataFile);

       SysPath := GetEnv('RA');
       SysPath := Fixpath(SysPath);
       LogPath := SysPath + 'RA.LOG';

   {$I-}
   Assign(LogFile,LogPath);
   Reset(LogFile);
   {$I+}
       If IOresult <> 0 then Begin
          WriteLn(' Error Reading ',LogPath);
          WriteLn(' Exiting with Errorlevel 1');
          Halt(1);
       End;

 while not eof(LogFile) do
  begin
   repeat
    ReadLn(LogFile, LogLine);
   until NewInfo(LogLine) or eof(LogFile);
Examine:
   if NewInfo(LogLine) then
    Date := Copy(LogLine, 13, 13);
WaitOnline:
   repeat
    ReadLn(LogFile, LogLine);
   until UserOnline(LogLine) or NewInfo(LogLine);
   while not (UserOnline(LogLine) or eof(LogFile)) do
    ReadLn(LogFile, LogLine);
   if UserOnline(LogLine) then
    begin
     Time := Copy(LogLine, 3, 8);
     UserName := Copy(LogLine, 13, Pos(' on-line', LogLine)-13);
     repeat
      ReadLn(LogFile, LogLine);
      if (Pos('Did not enter a full name', LogLine)<>0) or
         (Pos('Name not in user file', LogLine)<>0) then goto WaitOnline;
     until NewInfo(LogLine) or eof(LogFile) or LostCarrier(LogLine);
     if (LostCarrier(LogLine)) then
      begin
       with UserDT do
        begin
         Temp := Copy(Date, 5, 2);
         Val(Temp, Day, Error);
         Temp := Copy(Date, 8, 3);
         for Error := 1 to 12 do
          if Temp = MonthStr[Error] then Month := Error;
         Temp := Copy(Date, 12, 2);
         Val(Temp, Year, Error);
         Inc(Year, 1900);
        end;
       if (UserDT.Year>=DT.Year) and (UserDT.Month>=DT.Month) and
          (UserDT.Day>=DT.Day) then
        begin
         InitMsgValues;
         TxtSearch.Init;
         TxtSearch.FFirst(WildName);
       While TxtSearch.Found Do
  Begin
        MsgFileName := TxtSearch.GetFullPath;
        ProcessMsgFile;
        TxtSearch.FNext;
      End;
       TxtSearch.Done;
     textcolor(7);
   end;
      end else
     if NewInfo(LogLine) then goto Examine;
    end;
  end;
 Close(LogFile);
textcolor(7);
end.
