 {This unit for RA type popup windows with the title offset}

unit swin2;

interface
uses crt;

procedure PopWindow(x1,y1,x2,y2,TitleFG,TitleBG,BorderFG,BorderBG: byte;Title:string);
procedure CloseWindow;
Procedure Shadow(X1, Y1, X2, Y2: Byte);
procedure Drawshadowbox(x1,y1,x2,y2,FG,BG: byte);
Procedure SaveScreen;
Procedure RestoreScreen;
procedure sh;
procedure sn;
procedure shh;
procedure snn;
procedure sb;
procedure Init_XTable;
procedure Shine(sx,sy,ex,ey:integer;c:byte);
const
 color: boolean = true;

type

 windowtype = record
               x1,x2,y1,y2: byte;
               scrsave: array[1..4096] of byte;
              end;
 scrarray= array[0..3999] of byte;
 scrptr= ^scrarray;
AScreen = Array[1..4000] of Byte;
const
 screenbase: word =$B800;
 MaxRow=25;MaxColumn=80;
var
 Screen: scrarray Absolute $B800:$0;
 numwindows: byte;
 ws: array[1..3] of windowtype;
 scr1,scr2,scr3: scrptr;
 P : ^AScreen;    {Pointer to the Array}
 Scr : AScreen;
Buffer:array[1..MaxRow] of byte;
    XTable:array[1..MaxRow] of shortint;

procedure textcolor(i: byte);
procedure textbackground(i: byte);

implementation

procedure Init_XTable;
var cnt:byte;
begin for cnt:=0 to MaxRow-1 do XTable[cnt+1]:=-cnt; end;

procedure Shine(sx,sy,ex,ey:integer;c:byte);
var x,y:integer;
    num,cnt:word;
begin
 cnt:=0;
 for x:=sx to ex+ey-sy do
 begin
  for y:=sy to ey do
   if (XTable[y-sy+1]+x > sx-1) and (XTable[y-sy+1]+x < ex+1) then
   begin
    num:=(y-1)*160+(XTable[y-sy+1]+(x-1))*2+1;
    Buffer[y]:=mem[$b800:num];                    {save background attr.}
    mem[$b800:num]:=c+Buffer[y] and 240;          {highlight the spot}
   end;
  asm                                             {retrace}
   mov dx,3dah;
   @r1: in al,dx; test al,8; jnz @r1
   @r2: in al,dx; test al,8; jz @r2
  end;
 for y:=sy to ey do
  if (XTable[y-sy+1]+x > sx-1) and (XTable[y-sy+1]+x < ex+1) then
  begin                                           {restore background attr.}
   mem[$b800:(y-1)*160+(XTable[y-sy+1]+(x-1))*2+1]:=Buffer[y];
  end;
 end;
end;


Procedure Shadow(X1, Y1, X2, Y2: Byte);
Var
  Equip: Byte Absolute $40:$10;
  Vert, Height, offset: Integer;

begin
  if (Equip and 48) = 48 then Exit;

  For Vert := (Y1+1) to (Y2+1) do
    For Height := (X2+1) to (X2+2) do
      begin
        offset := (Vert - 1) * 160 + (Height-1) * 2 + 1;
        Screen[offset] := 8;
      end;
  Vert := Y2 + 1;
  For Height := (X1+2) to (X2+2) do
    begin
      offset := (Vert-1) * 160 + (Height-1) * 2 + 1;
      Screen[offset] := 8;
    end;
end;

procedure Textcolor(i: byte);
begin;
 if color then crt.textcolor(i) else begin;
  case i of
    0: crt.textcolor(0);
    7: crt.textcolor(7);
   11..15: crt.textcolor(15);
  end;
 end;
end;

procedure TextBackGround(i: byte);
begin;
 if color then crt.textbackground(i) else begin;
  case i of
   0..6: crt.textbackground(0);
   7: crt.textbackground(7);
  end;
 end;
end;

Function Center(X1, X2: Byte; S: String): Byte;
Var
  L, Max: Integer;
begin                           { This Function is used to center     }
  Max := (X2 - (X1+3));{ div 2;   { a String between two X coordinates. }
  L := Length(S);
  if Odd(L) then Inc(L);
  Center := X1 + (Max) - (L - 3);
end;
Function CharS(Len:Byte; C: Char): String;
Var
  S: String;
begin                       { This Function returns a String of }
  FillChar(S, Len+1, C);    { Length Len and of Chars C.        }
  S[0] := Chr(Len);
  CharS := S;
end;

Procedure SaveScreen;
begin
  P := Ptr($B800,$0); {Point to video memory}
  Move(P^,Scr,4000);  {Move the screen into the Array}
end;

Procedure RestoreScreen;
begin
  Move(Scr,MEm[$B800 : 0], 4000); {Move the saved screen to video mem}
end;

procedure PopWindow(x1,y1,x2,y2,TitleFG,TitleBG,BorderFG,BorderBG: byte;Title:string);
 var
 x,y: byte;
 S:string;
begin;
 window(1,1,80,25);
 textcolor(BorderFG);
 textbackground(BorderBG);
 X := X2 - (X1-1);      { find box width  }
 Y := Y2 - (Y1-1);      { find box height }
 S := Concat('', CharS(X-2, ''), '');
 gotoxy(x1,y1);
 write(S);
 GotoXY(Center(X1, X2, Title), Y1);
 textcolor(TitleFG);
 textbackground(TitleBG);
 write(Title);
 textcolor(BorderFG);
 textbackground(BorderBG);
 gotoxy(x1,y2);
 for x:=x1+1 to x2 do write('');
 for y:=y1+1 to y2-1 do begin;
  gotoxy(x1,y);
  write('');
  gotoxy(x2,y);
  write('');
 end;
 gotoxy(x1,y2);
 write('');
 gotoxy(x2,y2);
 write('');
 inc(numwindows);
 ws[numwindows].x1:=lo(windmin)+1;
 ws[numwindows].x2:=lo(windmax)+1;
 ws[numwindows].y1:=hi(windmin)+1;
 ws[numwindows].y2:=hi(windmax)+1;
 move(mem[screenbase:0000],ws[numwindows].scrsave,4096);
{ window(1,1,80,25);}
 Shadow(X1, Y1, X2, Y2);
 window(x1+1,y1+1,x2-1,y2-1);
end;
procedure Drawbox(x1,y1,x2,y2,FG,BG: byte);
var
 x,y: byte;
begin;
 textcolor(FG);
 textbackground(BG);
 gotoxy(x1,y1);
 for x:=x1+1 to x2 do write('');
 gotoxy(x1,y2);
 for x:=x1+1 to x2 do write('');
 for y:=y1+1 to y2-1 do begin;
  gotoxy(x1,y);
  write('');
  gotoxy(x2,y);
  write('');
 end;
 gotoxy(x1,y1);
 write('');
 gotoxy(x2,y1);
 write('');
 gotoxy(x1,y2);
 write('');
 gotoxy(x2,y2);
 write('');
end;
procedure Drawshadowbox(x1,y1,x2,y2,FG,BG: byte);
begin;
drawbox(x1,y1,x2,y2,FG,BG);
shadow(x1,y1,x2,y2);
end;

procedure CloseWindow;
begin;
 move(ws[numwindows].scrsave,mem[screenbase:0000],4096);
 window(ws[numwindows].x1,ws[numwindows].y1,ws[numwindows].x2,ws[numwindows].y2);
 dec(numwindows);
end;

procedure sh;
begin;
 if color then begin;
  textcolor(blue);
  textbackground(7);
 end else begin;
  textcolor(0);
  textbackground(7);
 end;
end;

procedure sn;
begin;
 textcolor(white);
 textbackground(blue);
end;
procedure sb;
begin;
 textcolor(7);
 textbackground(0);
end;
procedure shh;
begin;
 textcolor(1);
 textbackground(7);
end;

procedure snn;
begin;
 textcolor(3);
 textbackground(0);
end;

end.