(*
ERAL 1.01

This is a program to demonstrate the format of a Remote Access 1.11
language file by displaying the contents.

Author: P.H.Rankin Hansen (Ping.)
Released as Public Domain on February 24h, 1992.

The format is roughly like this:
N             Word       - Number of strings
Offset1       Word       - Modified Offset to string 1
Offset2       Word       - Modified Offset to string 2
..
..
OffsetN       Word       - Modified Offset to string N
String1       Record
                ColorMark : Byte; (0 if default, else new attribute
                Chars     : Array of Char;
              End;
String2 ......

If the last char of the array if $FF, then the string is a prompt
and the characters until the first space are the keys RA should
consider valid. Theese characters, the space and the $FF are not
displayed.

I called the offsets above for modified. The modification is quite
simple to handle. Simply subtract the high byte from the modified
offset to obtain the unmodified offset. I have a hunch that 'N'
should be as a sort of version number as well as a counter - time
will show.
*)
Program Eral;
Uses Crt;
Var
  Arr            : Array[0..$7FFF] Of Byte; { 32 k should be enough }
  WArr           : Array[0..$3FFF] Of Word Absolute Arr;
  Entries        : Word Absolute Arr;
  Offset, p, i, k, Next: Word;
  SaveAttr       : Byte;
  f              : File;
  lf             : Text;
  LstNam         : String;
  Ln             : Integer;
  Ch             : Char;
  St             : String;
  StLen          : Byte absolute St;

Begin                             {Main}
  Ln:=0;
  If ParamCount = 0 Then
    Assign(f,'c:\ra\ENGLISH.RAL')
  Else
    Assign(f,ParamStr(1));
    LstNam:=Copy(ParamStr(1),1,Pos('.',ParamStr(1)));
    LstNam:=LstNam+'LST';
  Assign(Lf,LStNam);
  Rewrite(Lf);
  Reset(f,1);
  writeln(Lf,'RALDUMP 1.0 - Remote Access Language File Text Dump');
  writeln(Lf,'FREEWARE! - (C)Copyright 1993, Rand Nowell - RaLin Enterprises');
  writeln(Lf);
  writeln(Lf,'Prpt  Select ');
  writeln(Lf,'Num.  Keys        Prompt Text ');
  writeln(Lf,'--------------------------------------------------------------------------');
  { Read the language file into memory - note size of array }
  BlockRead(f,Arr, SizeOf(Arr), k);
  Close(f);
  TextAttr := 7;
  ClrScr;
  { Offset to 'title' }
  Next := 2 * Entries + 2;
  i := 0;
  Repeat
    { Offset to string }
    Offset := Next;
    Inc(i);
    { Offset to next string }
    If i <> Entries then
      Next := WArr[i] - Hi(WArr[i])
    Else
      Next := k;
    { Marker begin }
    Inc(ln);
    write(Lf,Ln-1:3);
    TextAttr := 14; Write('>');
    { Set color attributes }
    If i = 1 Then
      TextAttr := White
    Else Begin
      If Arr[Offset] = 0 then { use default color }
        TextAttr := 7
      Else { Set new color }
        TextAttr := Arr[Offset];
      Inc(Offset);
    End;
    { Test for prompt }
    If Arr[Pred(Next)] = $FF then
    Begin
      SaveAttr := TextAttr;
      TextAttr := 7;

        write(Lf,' [ ');
      While Arr[Offset] <> Ord(' ') do
      Begin
        Write(Chr(Arr[Offset]));
        write(Lf,Chr(Arr[Offset]));
        Inc(Offset);
      End;
      Inc(Offset);
      TextAttr := 14;
      Write('|');
      Write(Lf,' ]');
      TextAttr := SaveAttr;
    End;
    { Build String }
    St[0] := #0;
    While (Offset < Next) Do
    Begin
      Inc(StLen);
      St[StLen] := Chr(Arr[Offset]);
      Inc(Offset);
    End;
    { Display string }
    Write(St);
  {  writeln(Lf,Ln:3,' '+St);}
     if Length(St)=0 then
     writeln(Lf,'  <<<  Not Defined, or Pro Version Prompt >>>')
     else
     writeln(Lf,' '+St);
  {  inc(Ln); }
    { Marker end }
    TextAttr := 14;
    Write('<');
    TextAttr := 7;
    If WhereX <> 1 Then WriteLn;
  Until i = Entries;
   Close(Lf);
End.

