{$M 8192,0,0}

{  RA2PAS - Convert PAGE.RA to Turbo Pascal source code }

Program RA2PAS;

Uses
  DOS;

Const
   Version = '1.0';

var
  OutFile,
  PageFile : Text;
  OutFileName,
  PageFileName : String;

  PageLength : LongInt;

  ToneLn,
  WaitLn  : integer;
  ToneS   : integer;

  Tmp,
  TmpS    : String;

  Buffer  : char;

function Get_Word(st:string; num:integer):string;
var
   i,a : integer;
   tmp : string[15];
begin
   tmp := '';
   i := 0;
   a := 0;
   if num = 1 then
     begin                        { if first word wanted }
       repeat;
         inc(i);
         if st[i] <> #32 then
           tmp := tmp + st[i];
       until (st[i] = #32) or (i = ord(st[0]));
     end
   else
     begin
       repeat;
         inc(i);                  { if any others wanted }
         if st[i] = #32 then
           inc(a);
       until (a = num-1) or (i = ord(st[0]));
       repeat;
         inc(i);
         if st[i] in [#33..#94,#97..#126] then
           tmp := tmp + st[i];
       until (st[i] = #32) or (i = ord(st[0]));
     end;
   Get_Word := tmp;
end;

function Del_Space(st:string; fb:integer):string;
var
   i,a,x : integer;
   tmp : string[15];
begin                                { fb = 0....del leading  }
   tmp := st;                        { fb = 1....del trailing }
   i := 1;                           { fb = 2....do both      }
   if (fb = 0) or (fb = 2) then
     begin
       while st[i] = #32 do
         begin
           inc(i);
         end;
     tmp := copy(st,i,ord(st[0]));
     end;
   if (fb = 1) or (fb = 2) then
     begin
       a := ord(tmp[0]);
       while tmp[a] = #32 do
         begin
           dec(a);
         end;
       tmp := copy(tmp,1,a);
     end;
   Del_Space := tmp;
end;

{  procedure No_Space - Removes all double spaces from St  }

procedure no_space(var st:string);
  var x,y,z : integer;
  begin
    for x:=1 to length(st) do
    begin
      If (St[x]=#32) and (st[x+1]=#32) then
        delete(St,x,1);
    end;
  end;


Function FileExist(FileName:String):Boolean;
Var F : File;
Begin
  {$I-}
  Assign(F,FileName);
  Reset(F);
  Close(F);
  {$I+}
  FileExist:=(IOResult = 0) and (FileName <> '');
End;

Function StUpCase(st:string):string;  { converts string (St) to uppercase }
  var x : byte;
  Begin
    StUpCase:='';  StUpCase[0]:=#0;
    StUpCase[0]:=St[0];
    for x:=1 to length(st) do StUpCase[x]:=UpCase(St[x]);
  end;

Function Str2Int(st:string):integer;  { converts string (St) to integer }
  var x, z : integer;
  begin
    Val(St,X,Z);
    Str2Int:=x;
  end;

Procedure OutError(Fn:string);
  Begin
    Writeln;  Writeln;
    Writeln('Error:  Cannot create ',StUpCase(Fn),'!');
    halt;
  End;

Procedure ConvertIt (PlayFile : String);
Begin
  TmpS := '';
  Write ('Scanning '+StUpCase(PlayFile)+' to '+StUpCase(OutFilename)+'...');
  Assign (PageFile, PlayFile);
  {$I-} Reset (PageFile); {$I+}
  Assign (OutFile, OutFilename);
  {$I-} Rewrite(OutFile); {$I+}
  If IOResult <> 0 then outerror(outfilename);
  Writeln(outfile,'{  Created using RA2PAS version 1.0  }');
  writeln(outfile);
  Writeln(outfile,'Program SoundFile;');
  Writeln(outfile);
  Writeln(outfile,'Uses CRT;');
  Writeln(outfile);
  Writeln(outfile,'Begin');
  Writeln(outfile,'  Writeln;');
  Writeln(outfile,'  Writeln(''Playing RA SoundFile created using RA2PAS'');');
  Writeln(outfile,'  Writeln;');
    while Not Eof (PageFile) Do
    Begin
      Readln (PageFile, TmpS);
      If TmpS[1] = ';' then ;      { do nothing }
      TmpS := StUpCase (TmpS);      { uppercase the string }
      no_space(tmps);
      Tmp := Get_Word(TmpS,1);
      If Tmp = 'TONE' then
        begin
          ToneS := Str2Int (Get_Word(Tmps, 2));
          ToneLn:= Str2Int (Get_Word(Tmps, 3));
          ToneLn := ToneLn * 10;
          PageLength:=PageLength+ToneLn;
          Writeln(outfile,'  Sound (',ToneS,');');
          Writeln(outfile,'  Delay (',ToneLn,');');
          Writeln(outfile,'  NoSound;');
        end;
      If Tmp = 'WAIT' then
        Begin
          WaitLn := Str2Int (Get_Word(TmpS, 2));
          WaitLn := WaitLn * 10;
          PageLength:=PageLength+WaitLn;
          Writeln(outfile,'  Delay (',WaitLn,');');
        End;
    End;
    Writeln(outfile,'  Writeln(''Done!'');');
    Writeln(outfile,'End.');
    Writeln('Done!');
    Writeln;
    {$I-} Reset (PageFile); {$I+}
  {$I-} Close (PageFile); {$I+}
  {$I-} Close (outfile); {$I+}
End;

Procedure Stop (FileName : String);
Begin
  Writeln ('Error: '+StUpCase(Filename)+' does not exist!');
  halt;
End;

Begin
  Assign (Input,'');
  Assign (Output,'');
  Rewrite (Input);
  Rewrite (Output);
  Writeln;
  Writeln ('RA2PAS ');
  Writeln ('RemoteAccess (pagefile) to TurboPascal (sourcecode)');
  Writeln;
  If ParamCount < 2 then
   Begin
     Writeln ('Usage: RA2PAS <page filename> <destination file>');
     Halt;
   End;

   PageFileName := ParamStr(1);
   OutFileName  := ParamStr(2);

   PageLength:=0;

   If FileExist (PageFileName) then
     ConvertIt (PageFileName)
   Else
     Stop(PageFileName);
end.

