Uses Crt;

Type

  FILESrecord    = record
                     Name           : String[30];
                     Attrib         : Byte;
                     FilePath       : String[40];
                     FreeSpace      : Array[1..41] of Byte;
                     Security       : Word;
                     Flags          : Array[1..4] of Byte;
                     PrivateSecurity: Word;
                     PrivateFlags   : Array[1..4] of Byte;
                   end;

Var
  FILES                    : Array[1..200] of FILESrecord;
  InFile, OutFile, OldFile : File of FILESrecord;
  X                        : Word;
  streg                    : String[80];
  Txt                      : Text;

Function BlankAfter(Txt : String; Lgd : Byte): String;
Begin
  Txt:=Copy(Txt,1,Lgd);
  While Length(Txt)<Lgd Do Txt:=Txt+' ';
  BlankAfter:=Txt;
End;

Function StIntRight(Tal: LongInt; Felt: Byte): String;
Var
  Streng         : String;
Begin
  Str(Tal: Felt, Streng);
  If Length(Streng) > Felt Then Streng:='*'+
    Copy(Streng,Length(Streng)-Felt+2,Length(Streng));
  StIntRight:=Streng;
End;

Procedure FilesRaTxt(Tekst : String);
Begin
  If Tekst<>'' Then WriteLn(Txt,Tekst);
  WriteLn(Txt,Streg);
  WriteLn(Txt,'  #  RemoteAccess area               FilePath                        Sec. ');
  WriteLn(Txt,Streg);
  For x:=1 to 200 Do
  If (Files[x].Name<>'') Or (Files[x].filepath<>'') Then
    WriteLn(Txt,StIntRight(x,3)+'  '+BlankAfter(Files[x].name,30)+'  '+
                Copy(BlankAfter(Files[x].filepath,40),1,30)+'  '+StIntRight(FILES[x].security,5));
  WriteLn(Txt,streg);
  WriteLn(Txt);
End;

Function StrToInt(S: String) : LongInt;
Var
  Kode : Integer;
  i    : LongInt;
Begin
  If Length(S) = 0 Then StrToInt := 0 Else Begin
    Val(S,i,Kode);
    If Kode = 0 Then StrToInt := i Else StrToInt := 0;
  End;
End;

Procedure MoveAreas(s,st,m : String);
Var  start, stop, moveto : Word;
Begin
  Start:=StrToInt(s);
  Stop:=StrToInt(st);
  MoveTo:=StrToInt(m);
  If (Start < 1) or (Start > 200) or (Stop < 1) or (Stop > 200) or
     (MoveTo < 1) or (MoveTo > 200) Then
  Begin
    WriteLn('Start, Stop and MoveTo must be in the range of 1-200');
    Halt(1);
  End;
  If Stop < Start Then
  Begin
    WriteLn('Stop must be => than Start');
    Halt(1);
  End;
  WriteLn(#10'Moving areas ',start,'-',stop,' to areas ',moveto,'-',moveto+stop-start);
  For x:=Start to Stop Do
  Begin
    Move(FILES[x],FILES[MoveTo+x-Start],Sizeof(FILES[x]));
    Fillchar(FILES[x],sizeof(FILES[x]),0);
  End;
  Assign(OutFile,'FILES.NEW');
  Rewrite(OutFile);
  For x:=1 to 200 Do Write(OutFile,FILES[x]);
  Close(OutFile);
  Assign(OldFile,'FILES.OLD');
  {$I-}
  Erase(OldFile);
  {$I+}
  x:=IOResult;
  Rename(InFile,'FILES.OLD');
  Rename(OutFile,'FILES.RA');
End;

Begin
  Streg:='';
  TextAttr:=15;
  ClrScr;
  TextAttr:=7*16;
  WriteLn(Streg);
  WriteLn('       MOVEAREAS for FILES.RA (RemoteAccess) version 1.00             ');
  WriteLn('                    Thanks for using one of my tools                         ');
  WriteLn(Streg);
  TextAttr:=15;
  FillChar(Files,Sizeof(Files),0);
  Assign(InFile, 'FILES.RA');
  Reset(InFile);
  For x:=1 to 200 Do Read(InFile,FILES[x]);
  Close(InFile);
  Assign(Txt,'FILESRA.TXT');
  Rewrite(Txt);
  WriteLn(#10#10'FILESRA.TXT has been made in current directory');
  If paramcount <> 3 Then
  Begin
    WriteLn(#10#10#13'Syntax is:  MOVEAREA Start Stop MoveTo');
    WriteLn('            MOVEAREA 20 30 100   <- Move areas 20-30 to 100-110');
    WriteLn('            DONT use overlapping 20 30 25, use instead 20 30 180 & 180 190 25');
    WriteLn('            or change the sourcekode to you needs');
    readln;
    FilesRaTxt('');
  End
  Else Begin
    FilesRaTxt('Before Moving any areas');
    MoveAreas(ParamStr(1), ParamStr(2), ParamStr(3));
    FilesRaTxt('After Moving areas');
  End;
  Close(Txt);

End.