unit shell2;

interface
uses crt;
procedure Popbox(x1,y1,x2,y2,fore,Back: byte);
procedure box(x1,y1,x2,y2,fore,back: byte);
procedure CloseBox;
Procedure SaveScreen;
Procedure RestoreScreen;
procedure Cursoron;
procedure Cursoroff;
procedure bar;
procedure nobar;
procedure ok_button(x1,y1: byte);
procedure blip;
procedure wbar;
procedure cleanup;
type
 windowtype = record
               x1,x2,y1,y2: byte;
               scrsave: array[1..4096] of byte;
              end;
 scrarray= array[0..3999] of byte;
 scrptr= ^scrarray;
 AScreen = Array[1..4000] of Byte; {for the savescreen/restorescreen}
const
 screenbase: word =$B800;
var
 Screen: scrarray Absolute $B800:$0;
 numwindows: byte;
 ws: array[1..3] of windowtype;
 scr1,scr2,scr3: scrptr;
 cursorpos: integer;
 P : ^AScreen;    {Pointer to the Array}
 Scr : AScreen;
CursorType : word;
implementation

Procedure SetBlinkEGAVGA(BlinkOn : boolean); assembler;
{ Enables/disables bright background colors on EGA/VGA adapters }
Asm
  mov bl,BlinkOn
  mov ax,1003h { BIOS function to enable/disable blinking }
  int 10h
End; { SetBlinkEGAVGA }

Procedure SetBlinkCGAMDA(BlinkOn : boolean); assembler;
{ Enables/disables 16 background colors on EGA/VGA adapters }
Asm
  mov dx,03D8h { default=CGA }
{$IFDEF VER70} mov ax,Seg0040 {$ELSE} mov ax,0040h {$ENDIF}
  mov es,ax
  cmp byte ptr [es:0049h],07h   { mono mode? }
  jne @@1
  mov dx,03B8h { so its MDA }
@@1:
  mov ax,word ptr [es:0065h]
  or  BlinkOn,False
  jz  @@2
  or  ax,20h
  jmp @@3
@@2:
  and ax,0DFh
@@3:
  out dx,ax
End; { SetBlinkCGAMDA }

Function EGAInstalled : boolean; assembler;
Asm
  mov ax,1200h
  mov bx,0010h
  xor cx,cx
  int 10h
  xor al,al { mov al,False }
  or  cx,0
  jz  @noega
  inc al { al gets True }
@noega:
End; { EGAInstalled }

procedure wbar;
Begin
  if EGAInstalled then
    SetBlinkEGAVGA(False) else SetBlinkCGAMDA(False);
  TextAttr := 15 + 9 shl 4;
end;
procedure box(x1,y1,x2,y2,fore,back: byte);
var
 x,y: byte;
begin;
 textbackground(back);
 textcolor(fore);
 gotoxy(x1,y1);
 for x:=x1+1 to x2 do write('');
 gotoxy(x1,y2);
 for x:=x1+1 to x2 do write('');
 for y:=y1+1 to y2-1 do begin;
  gotoxy(x1,y);
  write('');
  gotoxy(x2,y);
  write('');
 end;
 gotoxy(x1,y1);
 write('');
 gotoxy(x2,y1);
 write('');
 gotoxy(x1,y2);
 write('');
 gotoxy(x2,y2);
 write('');

end;
procedure blip;
begin;
nosound;
sound(6000);
delay(10);
nosound;
end;

procedure Cursoroff; assembler;

    asm
        mov ah, 03h
        mov bh, 00h
        int 10h
        mov CursorType, cx
        mov ah, 01h
        mov cx, 65535
        int 10h
    end;

procedure Cursoron; assembler;

    asm
        mov ah, 01h
        mov cx, CursorType
        int 10h
    end;

Procedure SaveScreen;
begin
  P := Ptr($B800,$0); {Point to video memory}
  Move(P^,Scr,4000);  {Move the screen into the Array}
end;

Procedure RestoreScreen;
begin
  Move(Scr,MEm[$B800 : 0], 4000); {Move the saved screen to video mem}
end;


procedure Popbox(x1,y1,x2,y2,fore,back: byte);
var
 x,y: byte;
begin;
 inc(numwindows);
 ws[numwindows].x1:=lo(windmin)+1;
 ws[numwindows].x2:=lo(windmax)+1;
 ws[numwindows].y1:=hi(windmin)+1;
 ws[numwindows].y2:=hi(windmax)+1;
 move(mem[screenbase:0000],ws[numwindows].scrsave,4096);
 window(1,1,80,25);
 box(x1,y1,x2,y2,fore,back);
 window(x1+1,y1+1,x2-1,y2-1);
end;

procedure CloseBox;

begin;
 move(ws[numwindows].scrsave,mem[screenbase:0000],4096);
 window(ws[numwindows].x1,ws[numwindows].y1,ws[numwindows].x2,ws[numwindows].y2);
 dec(numwindows);
end;
procedure bar;
begin;
 textcolor(15);
 textbackground(1);
end;

procedure nobar;
begin;
 textcolor(15);
 textbackground(0);
end;

procedure ok_button(x1,y1: byte);
var
 x,y,y2: byte;
begin;
textcolor(15);
textbackground(2);
gotoxy(x1,y1);
write('   OK   ');
 textcolor(0);
textbackground(7);
 write('');
  gotoxy(x1+1,y2+2);
  write('');

end;
procedure cleanup;
begin;
if EGAInstalled then
    SetBlinkEGAVGA(True) else SetBlinkCGAMDA(True);
  TextAttr := LightGray;
  end;
end.